
/*
 * Example terminal client for the yacas Computer Algebra library.
 * It is heavily tailored to Unix (Linux), but you should be able
 * to easily make a version that links with libyacas.a and provides
 * an interface for a different platform.
 * The platform-dependent parts are readline.cpp (which maintains
 * a history for keyed-in expressions on the command line), and
 * the directories it looks in for input files.
 */

#include <stdio.h>
#include <string.h>
#include "list.h"			// A little double-link list class
#include "yacas.h"

//#define USE_RAMSCRIPTS 1

CYacas* yacas=NULL;

// Custom list memory management functions for my history list
char *List<char>::allocElem(int size)
{
	char *string = new char[size*2];
	return string;
}

char *List<char>::copyElem(char *to, char *from, int size)
{
	return strcpy(to, from);
}

inline void List<char>::freeElem(char *string)
{
	delete[] string;
}

// The history list and iterator
List<char> *history = new List<char>;
ListIter<char> cur_hist(history);


void ReportNrCurrent()
{
#ifdef LISP_DEBUGHEAP
    extern long theNrCurrent;
    extern long theNrConstructed;
    extern long theNrDestructed;
    extern long theNrTokens;
    extern long theNrDefinedBuiltIn;
    extern long theNrDefinedUser;
    printf("left-over: %ld objects\n",theNrCurrent);
    printf("%ld constructed, %ld destructed\n",theNrConstructed,theNrDestructed);
    printf("nr tokens: %ld \n",theNrTokens);
    printf("-------------------------------\n");
    printf("Total %d functions defined (%d built-in, %d user)\n",
           theNrDefinedBuiltIn+theNrDefinedUser,
           theNrDefinedBuiltIn,theNrDefinedUser);
#endif
}


//TODO global!!!
static LispBoolean busy=true;

LispBoolean Busy()
{
    return busy;
}



void LispExit(LispEnvironment& aEnvironment, LispPtr& aResult,
              LispPtr& aArguments)
{
    busy=false;
    Check(0,KQuitting);
}


void my_exit(void)
{
	delete history;
    delete yacas;
    ReportNrCurrent();
}

void ShowResult(char *prompt)
{
    if (yacas->Error()[0] != '\0')
    {
        printf("%s\n",yacas->Error());
    }
    else
    {
        printf("%s%s\n",prompt,yacas->Result());
    }
    fflush(stdout);
}

void loadYacasScriptDir(void);
void runYacasCalculations(int argc, char *argv[]);

int main(int argc, char *argv[])
{
    int line = 0;
	char inpline[256];

    yacas = CYacas::NewL();
    atexit(my_exit);

	if(argc > 1)
		runYacasCalculations(argc, argv);

    (*yacas)()().Commands().SetAssociation(LispEvaluator(LispExit),
         (*yacas)()().HashTable().LookUp("Exit"));
	
	loadYacasScriptDir();
	
    printf("To exit Yacas, enter  Exit(); or Ctrl-c.\n");

    while (Busy())
    {
        printf("In( %d ) = ",line);

		// replace with getstring call that handles up arrow 
		// for history.
        gets(inpline);
        if(inpline) {
			// very temporary, is best handled out of this 
			// if statement
			/*if(strncmp("GetLast()", inpline, 9) == 0)
				strcpy(inpline, cur_hist.getPrev());

			cur_hist.list->addTail(inpline);*/

			yacas->Evaluate(inpline);
			char prompt[30];
			sprintf(prompt,"Out( %d ) = ",line);
			ShowResult(prompt);
			line++;
			
            memset(inpline, '\0', sizeof(inpline));
        }
    }

    return 0;
}

void loadYacasScriptDir(void)
{
#ifdef USE_RAMSCRIPTS
  #include "c:\ramfile.inc"
#else
	int i;
	FILE *config;
	char defpath[512];
	char fullpath[512];

	if(config = fopen("apptest.cfg", "r")) {
		fgets(defpath, 512, config);	// Use the location specified

		strcpy(fullpath, "DefaultDirectory(\"");
		strcat(fullpath, defpath);
		strcat(fullpath, "\");");

		yacas->Evaluate(fullpath);
	
		if(yacas->Error()[0] != '\0') {
			fclose(config);
			goto getdir;
		}
	} else {
getdir:
		config = fopen("apptest.cfg","w");
		printf("Directory where the scripts are (use a full path name)\n");
		printf("Path: ");	
		gets(defpath);
		for(i = 0; i <= strlen(defpath); i++){
			if(defpath[i] == '\\') 
				defpath[i] = '/';
		}

		// Make sure the end has a ending backslash
		if(defpath[i-2] != '/'){
			defpath[--i] = '/';
			defpath[++i] = '\0';
		}
		fputs(defpath, config);			// Store the location of scripts for
										// reference later
	}
	fclose(config);

	strcpy(fullpath, "DefaultDirectory(\"");
	strcat(fullpath, defpath);
	strcat(fullpath, "\");");

    yacas->Evaluate(fullpath);
#endif	// USE_RAMSCRIPTS

    yacas->Evaluate("Load(\"yacasinit\");");
    ShowResult("");
}

void runYacasCalculations(int argc, char *argv[])
{
	loadYacasScriptDir();

	char s[200];
	sprintf(s,"Load(\"%s\");",argv[1]);
	yacas->Evaluate(s);
	exit(0);
}