/** \file lispio.h
 * definitions of pure input output classes.
 */


#ifndef __lispio_h__
#define __lispio_h__

#include "lisptype.h"

// Hope this forward declaration doesn't screw us over...
class InputDirectories;
class InputStatus
{
public:
    InputStatus() : iLineNumber(-1), iFileName("none"),
					iLineString('\0') {};
	~InputStatus();

    void SetTo(LispCharPtr aFileName)
    {
        iFileName = aFileName;
        iLineNumber=1;
    }

    void RestoreFrom(InputStatus& aPreviousStatus)
    {
        iLineNumber = aPreviousStatus.iLineNumber;
        iFileName = aPreviousStatus.iFileName;
    }
    LispInt LineNumber() { return iLineNumber; }
    LispCharPtr FileName() { return iFileName; }
	LispCharPtr Line(InputDirectories& aInputDirectories);
    void NextLine() { iLineNumber++; }
private:
    LispCharPtr iFileName;
	LispCharPtr iLineString;
	LispInt		iLineNumber;
};

class LispInput
{
public:
    LispInput(InputStatus& aStatus) : iStatus(aStatus) {};
    virtual ~LispInput();
    virtual LispChar Next() = 0;
    virtual LispChar Peek() = 0;
    virtual LispBoolean EndOfStream() = 0;
    virtual LispCharPtr StartPtr() = 0;
    virtual LispInt Position() = 0;
protected:
    InputStatus& iStatus;
};


class LispOutput
{
public:
    virtual ~LispOutput();
    virtual void PutChar(LispChar aChar) = 0;

public:
    void Write(LispCharPtr aString);
};

#endif

