
#include <signal.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "yacasdo.h"

#include "yacas.h"
#include "standard.h"

extern void DBaseSendReceive(char* the_address,char* str,char* buffer,int max,int receive);

#define InternalEval aEnvironment.iEvaluator->Eval

#define BASE64_LENGTH(len) (4 * (((len) + 2) / 3))

static void
base64_encode (const char *s, char *store, int length)
{
	/* Conversion table. */
	static char tbl[64] = {
		'A','B','C','D','E','F','G','H',
		'I','J','K','L','M','N','O','P',
		'Q','R','S','T','U','V','W','X',
		'Y','Z','a','b','c','d','e','f',
		'g','h','i','j','k','l','m','n',
		'o','p','q','r','s','t','u','v',
		'w','x','y','z','0','1','2','3',
		'4','5','6','7','8','9','+','/'
	};
	int i;
	unsigned char *p = (unsigned char *)store;
	
	/* Transform the 3x8 bits to 4x6 bits, as required by base64. */
	for (i = 0; i < length; i += 3)
	{
		*p++ = tbl[s[0] >> 2];
		*p++ = tbl[((s[0] & 3) << 4) + (s[1] >> 4)];
		*p++ = tbl[((s[1] & 0xf) << 2) + (s[2] >> 6)];
		*p++ = tbl[s[2] & 0x3f];
		s += 3;
	}
	
	/* Pad the result if necessary... */
	if (i == length + 1)
		*(p - 1) = '=';
	else if (i == length + 2)
		*(p - 1) = *(p - 2) = '=';
	
	/* ...and zero-terminate it. */
	*p = '\0';
}

void Base64Encode(LispEnvironment& aEnvironment, LispPtr& aResult,
              LispPtr& aArguments)
{
//    Check(aEnvironment.iSecure == 0, KLispErrSecurityBreach);

    TESTARGS(2);
    LispPtr result1;
    InternalEval(aEnvironment, result1, Argument(aArguments,1));
    Check(result1.Get() != NULL, KLispErrInvalidArg);
    Check(result1.Get()->String() != NULL, KLispErrInvalidArg);

    LispString oper1;
    InternalUnstringify(oper1, result1.Get()->String());

    int len=strlen(oper1.String());
    char *buffer = (char*)malloc(BASE64_LENGTH(len)+3);
    buffer[0] = '\"';
    base64_encode (oper1.String(), &buffer[1], len);
    buffer[strlen(buffer)+1]='\0';
    buffer[strlen(buffer)]='\"';
    LispString string(buffer);
    aResult.Set(LispAtom::New(aEnvironment.HashTable().LookUp(string.String())));
    free(buffer);
}

void InternalDBaseSendAndReceive(LispEnvironment& aEnvironment, LispPtr& aResult,
              LispPtr& aArguments,LispInt receive)
{
    char buffer[16384];

    Check(aEnvironment.iSecure == 0, KLispErrSecurityBreach);

    TESTARGS(3);

    LispPtr result1;
    InternalEval(aEnvironment, result1, Argument(aArguments,1));
    Check(result1.Get() != NULL, KLispErrInvalidArg);
    Check(result1.Get()->String() != NULL, KLispErrInvalidArg);

    LispPtr result2;
    InternalEval(aEnvironment, result2, Argument(aArguments,2));
    Check(result2.Get() != NULL, KLispErrInvalidArg);
    Check(result2.Get()->String() != NULL, KLispErrInvalidArg);

    LispString oper1;
    InternalUnstringify(oper1, result1.Get()->String());
    LispString oper2;
    InternalUnstringify(oper2, result2.Get()->String());

    DBaseSendReceive(oper1.String(),oper2.String(),buffer,16384,receive);

    LispString string(buffer);
    aResult.Set(LispAtom::New(aEnvironment.HashTable().LookUp(string.String())));
}

void YacasDBaseSendAndReceive(LispEnvironment& aEnvironment, LispPtr& aResult,
                         LispPtr& aArguments)
{
    InternalDBaseSendAndReceive(aEnvironment, aResult,aArguments,1);
}
void YacasDBaseSend(LispEnvironment& aEnvironment, LispPtr& aResult,
                         LispPtr& aArguments)
{
    InternalDBaseSendAndReceive(aEnvironment, aResult,aArguments,0);
}


void LispExit(LispEnvironment& aEnvironment, LispPtr& aResult,
              LispPtr& aArguments)
{
    extern int serverbusy;
    serverbusy=0;
    InternalTrue(aEnvironment, aResult);
}



static void alarmer(int i)
{
    exit(0);
}

static void CallYacas(int process,int allowsend, char* base,int seconds)
{
    char sin[100];
    CYacas* yacas=NULL;
    yacas = CYacas::NewL();

    (*yacas)()().Commands().SetAssociation(LispEvaluator(LispExit),
         (*yacas)()().HashTable().LookUp("Exit"));

    if (allowsend)
    {
        (*yacas)()().Commands().SetAssociation(LispEvaluator(YacasDBaseSend),
                                               (*yacas)()().HashTable().LookUp("DBaseSend"));
        (*yacas)()().Commands().SetAssociation(LispEvaluator(YacasDBaseSendAndReceive),
                                               (*yacas)()().HashTable().LookUp("DBaseSendReceive"));
        (*yacas)()().Commands().SetAssociation(LispEvaluator(Base64Encode),
                                               (*yacas)()().HashTable().LookUp("Base64Encode"));
    }
    yacas->Evaluate("DefaultDirectory(\"" SCRIPT_DIR "\");");
    yacas->Evaluate("DefaultDirectory(\"ygi_bin/\");");
    yacas->Evaluate("Load(\"yacasinit\");");
    sprintf(sin,"ToFile(\"%soutput%d\")Load(\"%sinput%d\");",base,process,base,process);

    if (seconds>0)
    {
        signal(SIGALRM,alarmer);
        alarm(seconds);
    }

    yacas->Evaluate(sin);

    if (seconds>0)
    {
        signal(SIGALRM,SIG_IGN);
    }

    if (yacas->Error()[0] != '\0')
    {
        char s[1000];

        if (strlen(yacas->Error())<500)
        {
            sprintf(s,"Yacas returned the following error:\n%s",yacas->Error());
        }
        else
        {
            strcpy(s,"An error occurred");
        }
        
        ErrorPage(process,base,s);
    }

    delete yacas;
}

void SendToYacas(char* buffer, int process,int allowsend, char* base,int seconds)
{
    char sin[100];
    FILE* fi;
    sprintf(sin,"%sinput%d",base,process);
    fi=fopen(sin,"w");
    fprintf(fi,"Write([%s]);",buffer);
    fclose(fi);

    CallYacas(process,allowsend, base,seconds);
    return;
}

void SendToYacas02(CgiArgList* arglist, int process, char* authorization,int allowsend, char* base,int seconds)
{
    char sin[100];
    FILE* fi;

    sprintf(sin,"%sinput%d",base,process);
    fi=fopen(sin,"w");
    int i;

    fprintf(fi,"Authorization:=\"");
    if (authorization != NULL)
    {

//printf("authenticate %s\n",authorization);

       fprintf(fi,"%s",authorization);
    }
    fprintf(fi,"\";\n");

    fprintf(fi,"processid:=\"%d\";\n",process);
    
    for (i=0;i<arglist->nrargs;i++)
    {
        int j,n;
        char* value=arglist->values[i];
        fprintf(fi,"%s:=\"",arglist->variables[i]);
        n=strlen(value);
        for (j=0;j<n;j++)
        {
            if (value[j] == '\"' || value[j] == '\'')
            {
                fprintf(fi,"\\%c",value[j]);
            }
            else
            {
                fprintf(fi,"%c",value[j]);
            }
        }
        fprintf(fi,"\";\n");
    }
    fprintf(fi,"Load(\"ygi_bin/%s\");\n",arglist->command);
    fclose(fi);

    CallYacas(process,allowsend,base,seconds);
    return;
}

void GetYacasResult(char *buffer, int process, char* base)
{
    FILE* fi;
    char sin[100];
    int initlength=strlen(buffer);
    int length;

    sprintf(sin,"%soutput%d",base,process);
    fi=fopen(sin,"r");
    fseek(fi,0,SEEK_END);
    length=ftell(fi);
    fseek(fi,0,SEEK_SET);
    if (initlength+length>16383)
        length=16383-initlength;
    fread(&buffer[initlength],1,length,fi);
    buffer[initlength+length]='\0';
    fclose(fi);
}

void VoidYacas(int process, char* base)
{
    ErrorPage(process,base,"No results");
}

void ErrorPage(int process, char* base,char* title)
{
    FILE* fi;
    char sin[100];
    sprintf(sin,"%soutput%d",base,process);
    fi=fopen(sin,"w");
    fprintf(fi,"\n\n<html><head><title>Error</title></head><body><h1>%s</h1></body></html>",title,title);
    fclose(fi);
}


