#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "serverside.h"
#include "configread.h"

// Define this!
extern void server_init(void);
extern void server_process(char* buffer, int process,int*buflen);
extern void server_exit(void);

int serverbusy=1;

#define SOCKLEN_T unsigned int //socklen_t
int main(int argc, char** argv)
{
    int server_sockfd, client_sockfd;
    SOCKLEN_T server_len, client_len;
    struct sockaddr_in server_address;
    struct sockaddr_in client_address;
    int result;
    fd_set readfds, testfds;


    ConfigInit();
    if (argc>1)
    {
        ParseConfigFile(argv[1]);
    }
    else
    {
        ParseConfigFile("yacasserver.ini");
    }
    
    server_sockfd = socket(AF_INET, SOCK_STREAM, 0);

    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr = htonl(INADDR_ANY);
    server_address.sin_port = htons(9734);
    server_len = sizeof(server_address);

    bind(server_sockfd, (struct sockaddr *)&server_address, server_len);
    listen(server_sockfd, 5);

    FD_ZERO(&readfds);
    FD_SET(server_sockfd, &readfds);

    server_init();
    atexit(server_exit);
    
    while(serverbusy)
    {
        int fd;
        int nread;
        testfds = readfds;

//LOGTODO        printf("server waiting\n");
        result = select(FD_SETSIZE, &testfds, (fd_set *)0, 
                        (fd_set *)0, (struct timeval *) 0);

        if(result < 1)
        {
            perror("server5");
            exit(1);
        }
        for(fd = 0; fd < FD_SETSIZE; fd++)
        {
            if(FD_ISSET(fd,&testfds))
            {
                if(fd == server_sockfd)
                {
                    client_sockfd = accept(server_sockfd, 
                        (struct sockaddr *)&client_address, &client_len);
                    FD_SET(client_sockfd, &readfds);
//LOGTODO                    printf("adding client on fd %d\n", client_sockfd);
                }
                else
                {
                    ioctl(fd, FIONREAD, &nread);

                    if(nread == 0)
                    {
                        close(fd);
                        FD_CLR(fd, &readfds);
//LOGTODO                        printf("removing client on fd %d\n", fd);
                    }
                    else
                    {
                        char buffer[MAX_RETURNPAGE_SIZE];
//LOGTODO                        printf("nread=%d\n",nread);
                        if (nread>MAX_RETURNPAGE_SIZE)
                            nread=MAX_RETURNPAGE_SIZE;
                        int buflen;
                        read(fd, buffer, nread);
                        buffer[nread]='\0';
//LOGTODO                        printf("serving client on fd %d: \n", fd);

                        server_process(buffer,0,&buflen);
                        if (buflen>0)
                            write(fd, &buffer[0], buflen);
                        close(fd);
                        FD_CLR(fd, &readfds);
//LOGTODO                        printf("removing client on fd %d\n", fd);
                        
                    }
                }
            }
        }
    }
}
