
/*
 * TooltipP.h - Private Header file for Tooltip widget.
 */

#ifndef s_TooltipP_h
#define s_TooltipP_h

#include "Tooltip.h"
#include <X11/Xaw3d/SmeP.h>
#include <X11/ShellP.h>

typedef struct {
    XtPointer extension;		/* For future needs. */
} TooltipClassPart;

typedef struct s_TooltipClassRec {
  CoreClassPart	          core_class;
  CompositeClassPart      composite_class;
  ShellClassPart          shell_class;
  OverrideShellClassPart  override_shell_class;
  TooltipClassPart	  tooltip_class;
} TooltipClassRec;

extern TooltipClassRec tooltipClassRec;

typedef struct p_list {
	Widget w;
	char *p;
	struct p_list *next;
} p_list;

typedef struct s_TooltipPart {

  /* resources */

  Widget label;			/* mode 1 => display tip in this label */
  int mode;			/* 0 = don't display
				   1 = display in label
				   2 = display in popup
				   3 = display in both */
  int interval;

  /* private state */

  Widget plabel;		/* to display the tip */
  XtIntervalId timer;		/* used waiting to popup */
  p_list *plist;		/* list of widgets and tips */

} TooltipPart;

typedef struct s_TooltipRec {
  CorePart		core;
  CompositePart 	composite;
  ShellPart 	        shell;
  OverrideShellPart     override;
  TooltipPart		tooltip;
} TooltipRec;

#endif /* s_TooltipP_h */

