/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
/* $Id: write_pixmap.c,v 1.3 1999/02/27 04:21:59 lance Exp $ */
#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h> 
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/xpm.h>
#include "xwin.h"
#include "data.h"

extern int Draw_plot(PlotXwins *win, Plot *plot, Drawable drawable, 
		     unsigned int width, unsigned int height);
extern void scale_plot(PlotXwins *win, Plot *plot, unsigned int *w, 
		       unsigned int *h);

static Pixmap pixmap;


/* make a new Pixmap if the width and height have changed
 */
static int remake_plot_pixmap(PlotXwins *win,
			       Plot *plot, unsigned int width,unsigned int height)
{
  static int init = 0;

  if(init)
    {
      XFreePixmap(win->display, pixmap);
      init = 1;
    }
  pixmap = XCreatePixmap(win->display,DefaultRootWindow(win->display),
				width, height,
				DefaultDepth(win->display,win->screen_number));
  if((pixmap == BadAlloc) || (pixmap ==  BadValue))
    {
      fprintf(stderr,"quickplot Warning: Can't create pixmap: XCreatePixmap() failed.\n");

      return -1; /* error */
    }
  return 0; /* success */
}


int write_pixmap(PlotXwins *win, Plot *plot)
{
  static unsigned int w=0,h=0;
  unsigned int width, height;
  int returnVal = 0;
  char *file;
  char str[24];


  XtVaSetValues(win->saveButtonWig,
		  XtNlabel, "Saving ...", NULL);

  (void) scale_plot(win,plot,&width, &height);

  if(w != width || h != height)
    if(remake_plot_pixmap(win,plot,width,height))
      return -1; /** error **/

  /* Clear all pixels in PixMap to background */
  XSetForeground(win->display,win->gc,win->BWbackground_pix);
  XFillRectangle(win->display,pixmap,win->gc,0,0,
		 (int) width-1,(int) height-1);

  if(Draw_plot(win,plot,pixmap,width,height))
    {
      w = width;
      h = height;
    }

  XtVaGetValues(win->saveInputWig, XtNstring, &file, NULL);

  if(file == NULL || file[0] == '\0')
    {
      sprintf(str,"qp%d.xpm",win->savefile_count);
      file = str;
      XtVaSetValues(win->saveInputWig, XtNstring, str, NULL);
    }

  if(XpmWriteFileFromPixmap(win->display,file, pixmap,0,NULL))
    {
      fprintf(stderr,"quickplot Warning: Can't write pixmap to file: %s\n",
	      file);
      returnVal = -1;
    }

  
  if(returnVal == 0)
    {
      char str2[25];

      if(plot->flag & VERBOSE)
	printf("quickplot Info: saved pixmap file: \"%s\"\n",file);

      sprintf(str2,"qp%d.xpm",win->savefile_count);
      (win->savefile_count)++;
      
      if(!strcmp(str2,file)) /* if the user didn't edit filename */
	{
	  sprintf(str2,"qp%d.xpm",win->savefile_count);
	  XtVaSetValues(win->saveInputWig, XtNstring, str2, NULL);
	}
    }

  XtVaSetValues(win->saveButtonWig,
		XtNlabel, " Save XPM ", NULL);

  return returnVal;
}
