/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include "data.h"

extern void realloc_plot_data_and_max_min(Plot *plot, int num_fields);

void add_count_field(Plot *plot, int lenght)
{
  int i;
  struct Data *D;/* dummy data pointer */

  (plot->dim)++;/* add a field */
  assert((plot->num_points = (unsigned long *) realloc(
	  (void *)plot->num_points,
	  sizeof(unsigned long)*plot->dim)) != NULL);
  realloc_plot_data_and_max_min(plot,1);
  plot->min[plot->dim - 1] = 0.0;
  plot->max[plot->dim - 1] = (double) (lenght - 1);
  assert((D = (plot->data[plot->dim - 1] = (struct Data *) malloc(
	      sizeof(struct Data)*lenght))) != NULL);
  plot->num_points[plot->dim - 1] = lenght;

  /* make the linked list of new field of data */
  /* and set the value of the data */
  D[0].prev = NULL;
  D[0].val = 0.0;
  D[0].next = &(D[1]);
  for(i=1;i<lenght-1;i++)
    {
      D[i].next = &(D[i+1]);
      D[i].val = (double) i;
      D[i].prev = &(D[i-1]);
    }
  D[i].prev = &(D[i-1]);
  D[i].val = (double) i;
  D[i].next = NULL;
  if(plot->flag & VERBOSE)
    {
      fprintf(stderr,"quickplot Info: added additional counting field with %d points to the data.\n",lenght);
    }
}


