## Copyright (C) 1996, 1997  Friedrich Leisch
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## usage:  [in, out] = circle_in_square_set (n)
##
## Returns a 2 class training set of size n for the circle in a square
## classification problem. Inputs have uniform distribution on the
## 2-dimensional square -1 <= x,y <=1 and classified as
##    C1 :   x^2 + y^2 <= 2/pi 
##    C2 :   x^2 + y^2 >  2/pi
  
## Author:  FL <Friedrich.Leisch@ci.tuwien.ac.at>
## Description:  Data for circle in a square classification problem

function [in, out] = circle_in_square_set (n)

  in = 2 * randn (n, 2) - 1;
  s = sumsq (in')';
  out = [(s <= 2 / pi), (s > 2 / pi)];
  
endfunction

