/* Author:  G. Jungman
 * RCS:     $Id: gsl_sf_synchrotron.h,v 1.5 1998/12/14 01:13:11 jungman Exp $
 */
#ifndef GSL_SF_SYNCHROTRON_H_
#define GSL_SF_SYNCHROTRON_H_

#include <gsl_sf_result.h>


/* First synchrotron function:
 *   synchrotron_1(x) = x Integral[ K_{5/3}(t), {t, x, Infinity}]
 *
 * exceptions: GSL_EDOM, GSL_EUNDRFLW
 */
int     gsl_sf_synchrotron_1_impl(double x, gsl_sf_result * result);
int     gsl_sf_synchrotron_1_e(double x, gsl_sf_result * result);


/* Second synchroton function:
 *   synchrotron_2(x) = x * K_{2/3}(x)
 *
 * exceptions: GSL_EDOM, GSL_EUNDRFLW
 */
int     gsl_sf_synchrotron_2_impl(double x, gsl_sf_result * result);
int     gsl_sf_synchrotron_2_e(double x, gsl_sf_result * result);


#endif  /* !GSL_SF_SYNCHROTRON_H_ */
