/*

Copyright (C) 1998  Paul Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/* main.c by Paul Wilkins.
 * This file contains the main program.
 */

#include <stdio.h>
#ifdef USE_GNOME
#include <gnome.h>
#endif
#include <gtk/gtk.h>

#include "icon_bitmap"
#include "stack.h"
#include "menu.h"
#include "mode.h"
#include "lcd.h"
#include "undo.h"
#include "buttons.h"
#include "constant.h"

main(int argc, char *argv[])
{
   int i;
   GtkWidget *main_w;
   GtkWidget *vbox;
   GtkWidget *menu;
   GtkWidget *mdisp;
   GtkWidget *lcd;
   GtkWidget *btns;
   GdkBitmap *icon_bitmap;
#ifdef USE_GNOME
   GnomeAppBar *appbar;
#endif

#ifdef USE_GNOME
   gnome_init("grpn", "1.0", argc, argv);
   gnome_app_new("grpn", "grpn");
#else
   /* initialize gtk */
   gtk_init(&argc, &argv);
#endif

   /* any args left is an error */
   if(argc != 1){
      for(i=1; i<argc; i++){
         fprintf(stderr, "Unknown Argument '%s' Ignoring.\n", argv[i]);
      }
   }

   /* set up any constants we may use */
   setup_constant();

   /* initialize the undo system */
   initUndoSystem();

   /* setup the stack */
   if(0 == setup_stack()){
      fprintf(stderr, "Error: Could not initalize data structures.\n");
      exit(0);
   }

#ifdef USE_GNOME
   main_w = gnome_app_new("grpn", "grpn");
   setup_menu(main_w);

   appbar = GNOME_APPBAR(gnome_appbar_new(FALSE, FALSE, FALSE));
   gnome_app_set_statusbar(GNOME_APP(main_w), GTK_WIDGET(appbar));

   /*create the box that everyone goes in */
   vbox = gtk_vbox_new(FALSE, 0);
   gnome_app_set_contents(GNOME_APP(main_w), vbox);
   gtk_widget_show(vbox);

#else
   /* the main window contains the work area and the menubar */
   main_w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_widget_set_name(main_w, "grpn");

   /*create the box that everyone goes in */
   vbox = gtk_vbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(main_w), vbox);
   gtk_widget_show(vbox);

   /* set up the menu bar */
   menu = setup_menu(vbox);
#endif

   /* handle window manager close */
   gtk_signal_connect(GTK_OBJECT(main_w), "delete_event",
      GTK_SIGNAL_FUNC(delete_event), NULL);
   gtk_signal_connect(GTK_OBJECT(main_w), "destroy",
      GTK_SIGNAL_FUNC(destroy), NULL);

   /* create the varrious subsystems */
   mdisp = setupModeDisplay(vbox);
   btns = setupButtons(vbox);
   lcd = setupLCD(vbox);

   /* Create pixmap of depth 1 (bitmap) for icon */
   gtk_widget_realize(main_w);
   icon_bitmap = gdk_bitmap_create_from_data(main_w->window,
      icon_bitmap_bits, icon_bitmap_width, icon_bitmap_height);
   gdk_window_set_icon(main_w->window, NULL, icon_bitmap, NULL);

   gtk_widget_show(main_w);

   gtk_main();

}
