#
# RPM specification file for gri
# 
# Patterned on p127 et seq. in Bailey (1997)
#
Summary: a language for scientific graphics programming
Name: gri
Version: 2.4.2
Release: 1
Copyright: Dan E. Kelley
Group: Applications/Graphics
Source: ftp://ftp.phys.ocean.dal.ca/users/kelley/gri/gri-2.4.2.tgz
URL: http://www.phys.ocean.dal.ca/~kelley/gri/gri1.html
Vendor: Tantramar Software
Packager: Dan E. Kelley <Dan.Kelley@Dal.CA>
Icon: grilogo.gif

# Not really sure what to put for the following, so comment out.
#Provides: ?
#Distribution: ?



%description

Gri is a language for scientific graphics programming.  It is a
command-driven application, as opposed to a click/point application.
It is analogous to latex, and shares the property that extensive power
is the reward for tolerating a modest learning curve.  Gri output is
in industry-standard PostScript, suitable for incorporation in
documents prepared by various text processors.

Gri can make x-y graphs, contour-graphs, and image graphs.  In
addition to high-level capabilities, it has enough low-level
capabilities to allow users to achieve a high degree of customization.
Precise control is extended to all aspects of drawing, including
line-widths, colors, and fonts.  Text includes a subset of the tex
language, so that it is easy to incorporate Greek letters and
mathematical symbols in labels.

The following is a terse yet working Gri program.  If it is stored in
a file called 'example.gri', and executed with the unix command 'gri
example', it will create a postscript file called 'example.ps' with
a linegraph connecting data points in the file called `file.dat'.

   open file.dat        # open a file with columnar data
   read columns x * y   # read first column as x and third as y
   draw curve           # draw line through data (autoscaled axes)

%prep
%setup



%build
./configure --prefix=/opt/gri --exec-prefix=/opt/gri
make libdir=/opt/gri/lib gri
strip gri
mv README-linux-redhat README
cd doc ; make linux_redhat



%install
make install_linux_redhat


%post
# ref: Bailey 13.3.2.2
# Add a 'gri' item to info-directory, if one is not there already

# Note: as in Bailey (p182), this will be called with an argument of 1
# on the first time gri is installed.  So that is the time to insert
# a line in the info-dir database (if it's not there already).
if [ "$1" = 1 ]
then
	if ! grep -i gri /etc/info-dir
	then
		/sbin/install-info --dir-file="/etc/info-dir" --entry="* GRI: (gri). Scientific graphics language." --info-file=/usr/info/gri-1.gz
		chmod a+r /etc/info-dir
	fi
fi



%files
#
# The binary file (note: the name of the library directory
# is compiled into this.
/usr/bin/gri

# The actual executable.
/opt/gri/bin/gri

# The library file, license file, and startup message.
/opt/gri/lib/gri.cmd
/opt/gri/lib/license.txt
/opt/gri/lib/startup.msg

#
# Only put minimal documentation files in the redhat place,
# with the rest being stored in the /opt tree.
%doc README
%doc copyright.txt
/usr/man/man1/gri.1
/usr/info/gri.gz
/usr/info/gri-1.gz
/usr/info/gri-2.gz
/usr/info/gri-3.gz
/usr/info/gri-4.gz
/usr/info/gri-5.gz
/usr/info/gri-6.gz
/usr/info/gri-7.gz
/usr/info/gri-8.gz
/usr/info/gri-9.gz
/usr/info/gri-10.gz
/usr/info/gri-11.gz
/usr/info/gri-12.gz
/usr/share/emacs/site-lisp/gri-mode.el

#
# The following list of html sources is prepared by
# the gri/src/doc/RPM_prepare.pl script.
#
# IMPORTANT: must delete duplicates from this program:
#   RPM_prepare.pl | sort | uniq
#
/opt/gri/bin/gri_unpage
/opt/gri/bin/gri_merge
/opt/gri/doc/html/Access.html
/opt/gri/doc/html/Acknowledgments.html
/opt/gri/doc/html/BoxPlots.html
/opt/gri/doc/html/Bugs.html
/opt/gri/doc/html/Cd.html
/opt/gri/doc/html/Close.html
/opt/gri/doc/html/Color.html
/opt/gri/doc/html/CommandSyntax.html
/opt/gri/doc/html/Commands.html
/opt/gri/doc/html/CommandsOverview.html
/opt/gri/doc/html/ConceptIndex.html
/opt/gri/doc/html/Contour.html
/opt/gri/doc/html/ContouringExample.html
/opt/gri/doc/html/Convert.html
/opt/gri/doc/html/Create.html
/opt/gri/doc/html/Data.html
/opt/gri/doc/html/Debug.html
/opt/gri/doc/html/Debugging.html
/opt/gri/doc/html/Defaults.html
/opt/gri/doc/html/Delete.html
/opt/gri/doc/html/Differentiate.html
/opt/gri/doc/html/DiscussionGroup.html
/opt/gri/doc/html/Draw.html
/opt/gri/doc/html/Emacs.html
/opt/gri/doc/html/ErrorMessages.html
/opt/gri/doc/html/Evolution.html
/opt/gri/doc/html/Examples.html
/opt/gri/doc/html/Expecting.html
/opt/gri/doc/html/Extras.html
/opt/gri/doc/html/FAQ.html
/opt/gri/doc/html/FEM.html
/opt/gri/doc/html/FancyExample.html
/opt/gri/doc/html/FancyPlot.html
/opt/gri/doc/html/Fig2Gri.html
/opt/gri/doc/html/Filter.html
/opt/gri/doc/html/Flip.html
/opt/gri/doc/html/GeneralIssues.html
/opt/gri/doc/html/GetEnv.html
/opt/gri/doc/html/Heal.html
/opt/gri/doc/html/Help.html
/opt/gri/doc/html/Hints.html
/opt/gri/doc/html/If.html
/opt/gri/doc/html/IfStatements.html
/opt/gri/doc/html/Ignore.html
/opt/gri/doc/html/Image.html
/opt/gri/doc/html/ImageExample.html
/opt/gri/doc/html/ImageExt.html
/opt/gri/doc/html/ImageWithContours.html
/opt/gri/doc/html/Input.html
/opt/gri/doc/html/Insert.html
/opt/gri/doc/html/Interpolate.html
/opt/gri/doc/html/Introduction.html
/opt/gri/doc/html/InvokingGri.html
/opt/gri/doc/html/Legend.html
/opt/gri/doc/html/LibraryFiles.html
/opt/gri/doc/html/License.html
/opt/gri/doc/html/List.html
/opt/gri/doc/html/Loops.html
/opt/gri/doc/html/Ls.html
/opt/gri/doc/html/Mask.html
/opt/gri/doc/html/Mathematics.html
/opt/gri/doc/html/New.html
/opt/gri/doc/html/NewCommands1.html
/opt/gri/doc/html/NewCommands2.html
/opt/gri/doc/html/Newfeatures.html
/opt/gri/doc/html/Newpage.html
/opt/gri/doc/html/Newsgroup.html
/opt/gri/doc/html/Open.html
/opt/gri/doc/html/OperatingSystem.html
/opt/gri/doc/html/OverviewSystemTools.html
/opt/gri/doc/html/PDFDiagram.html
/opt/gri/doc/html/Polygons.html
/opt/gri/doc/html/PostScript.html
/opt/gri/doc/html/Programming.html
/opt/gri/doc/html/Pwd.html
/opt/gri/doc/html/Query.html
/opt/gri/doc/html/Quit.html
/opt/gri/doc/html/Read.html
/opt/gri/doc/html/Regress.html
/opt/gri/doc/html/Reorder.html
/opt/gri/doc/html/Rescale.html
/opt/gri/doc/html/Resize.html
/opt/gri/doc/html/ResourceFile.html
/opt/gri/doc/html/Return.html
/opt/gri/doc/html/ReversePolishMath.html
/opt/gri/doc/html/Rewind.html
/opt/gri/doc/html/Rpnfunction.html
/opt/gri/doc/html/RunningMeans.html
/opt/gri/doc/html/Set.html
/opt/gri/doc/html/Show.html
/opt/gri/doc/html/SimpleExample.html
/opt/gri/doc/html/Skip.html
/opt/gri/doc/html/Smooth.html
/opt/gri/doc/html/Sprintf.html
/opt/gri/doc/html/State.html
/opt/gri/doc/html/Superuser.html
/opt/gri/doc/html/Synonyms.html
/opt/gri/doc/html/System.html
/opt/gri/doc/html/TSDiagram.html
/opt/gri/doc/html/Text.html
/opt/gri/doc/html/Variables.html
/opt/gri/doc/html/Viewing.html
/opt/gri/doc/html/While.html
/opt/gri/doc/html/Write.html
/opt/gri/doc/html/X-Y.html
/opt/gri/doc/html/examples/1.gif
/opt/gri/doc/html/examples/10.gif
/opt/gri/doc/html/examples/10tiny.gif
/opt/gri/doc/html/examples/11.gif
/opt/gri/doc/html/examples/11tiny.gif
/opt/gri/doc/html/examples/12.gif
/opt/gri/doc/html/examples/12tiny.gif
/opt/gri/doc/html/examples/13.gif
/opt/gri/doc/html/examples/13tiny.gif
/opt/gri/doc/html/examples/1tiny.gif
/opt/gri/doc/html/examples/2.gif
/opt/gri/doc/html/examples/2tiny.gif
/opt/gri/doc/html/examples/3.gif
/opt/gri/doc/html/examples/3tiny.gif
/opt/gri/doc/html/examples/4.gif
/opt/gri/doc/html/examples/4tiny.gif
/opt/gri/doc/html/examples/5.gif
/opt/gri/doc/html/examples/5tiny.gif
/opt/gri/doc/html/examples/6.gif
/opt/gri/doc/html/examples/6color.gif
/opt/gri/doc/html/examples/6colortiny.gif
/opt/gri/doc/html/examples/6tiny.gif
/opt/gri/doc/html/examples/7.gif
/opt/gri/doc/html/examples/7tiny.gif
/opt/gri/doc/html/examples/8.gif
/opt/gri/doc/html/examples/8tiny.gif
/opt/gri/doc/html/examples/9.gif
/opt/gri/doc/html/examples/9tiny.gif
/opt/gri/doc/html/examples/model.elements
/opt/gri/doc/html/examples/model.nodes
/opt/gri/doc/html/examples/Makefile
/opt/gri/doc/html/examples/FEM.pl
/opt/gri/doc/html/examples/FEM.gif
/opt/gri/doc/html/examples/FEM.gri
/opt/gri/doc/html/examples/FEM.ps
/opt/gri/doc/html/examples/FEM.txt
/opt/gri/doc/html/examples/example1.dat
/opt/gri/doc/html/examples/example1.gri
/opt/gri/doc/html/examples/example1.ps
/opt/gri/doc/html/examples/example1.txt
/opt/gri/doc/html/examples/example10.dat
/opt/gri/doc/html/examples/example10.gri
/opt/gri/doc/html/examples/example10.ps
/opt/gri/doc/html/examples/example10.txt
/opt/gri/doc/html/examples/example10color.gri
/opt/gri/doc/html/examples/example10color.ps
/opt/gri/doc/html/examples/example10color.txt
/opt/gri/doc/html/examples/example11.dat
/opt/gri/doc/html/examples/example11.gri
/opt/gri/doc/html/examples/example11.ps
/opt/gri/doc/html/examples/example11.txt
/opt/gri/doc/html/examples/example12.dat
/opt/gri/doc/html/examples/example12.gri
/opt/gri/doc/html/examples/example12.ps
/opt/gri/doc/html/examples/example12.txt
/opt/gri/doc/html/examples/example13.dat
/opt/gri/doc/html/examples/example13.gri
/opt/gri/doc/html/examples/example13.ps
/opt/gri/doc/html/examples/example13.txt
/opt/gri/doc/html/examples/example2.gri
/opt/gri/doc/html/examples/example2.ps
/opt/gri/doc/html/examples/example2.txt
/opt/gri/doc/html/examples/example3.gri
/opt/gri/doc/html/examples/example3.ps
/opt/gri/doc/html/examples/example3.txt
/opt/gri/doc/html/examples/example4.gri
/opt/gri/doc/html/examples/example4.ps
/opt/gri/doc/html/examples/example4.txt
/opt/gri/doc/html/examples/example5.dat
/opt/gri/doc/html/examples/example5.gri
/opt/gri/doc/html/examples/example5.ps
/opt/gri/doc/html/examples/example5.txt
/opt/gri/doc/html/examples/example6.gri
/opt/gri/doc/html/examples/example6.ps
/opt/gri/doc/html/examples/example6.txt
/opt/gri/doc/html/examples/example6color.gri
/opt/gri/doc/html/examples/example6color.ps
/opt/gri/doc/html/examples/example6color.txt
/opt/gri/doc/html/examples/example6histogram.gri
/opt/gri/doc/html/examples/example6histogram.ps
/opt/gri/doc/html/examples/example6histogram.txt
/opt/gri/doc/html/examples/example6image.dat
/opt/gri/doc/html/examples/example6mask.dat
/opt/gri/doc/html/examples/example7.gri
/opt/gri/doc/html/examples/example7.ps
/opt/gri/doc/html/examples/example7.txt
/opt/gri/doc/html/examples/example7a.dat
/opt/gri/doc/html/examples/example7b.dat
/opt/gri/doc/html/examples/example7c.dat
/opt/gri/doc/html/examples/example7d.dat
/opt/gri/doc/html/examples/example7e.dat
/opt/gri/doc/html/examples/example7f.dat
/opt/gri/doc/html/examples/example7g.dat
/opt/gri/doc/html/examples/example8.gri
/opt/gri/doc/html/examples/example8.ps
/opt/gri/doc/html/examples/example8.txt
/opt/gri/doc/html/examples/example8a.dat
/opt/gri/doc/html/examples/example8b.dat
/opt/gri/doc/html/examples/example9.gri
/opt/gri/doc/html/examples/example9.ps
/opt/gri/doc/html/examples/example9.txt
/opt/gri/doc/html/examples/example9a.dat
/opt/gri/doc/html/examples/example9b.dat
/opt/gri/doc/html/gri1.html
/opt/gri/doc/html/index.html
/opt/gri/doc/html/resources/bl14.gif
/opt/gri/doc/html/resources/bottom_banner.gif
/opt/gri/doc/html/resources/logo.eps
/opt/gri/doc/html/resources/version-diagram-2.2.gri
/opt/gri/doc/html/resources/version-diagram-2.2.gif
/opt/gri/doc/html/resources/version-diagram-2.2.eps
/opt/gri/doc/html/resources/version-diagram-2.2.txt
/opt/gri/doc/html/resources/version-diagram-2.4.gri
/opt/gri/doc/html/resources/version-diagram-2.4.gif
/opt/gri/doc/html/resources/version-diagram-2.4.eps
/opt/gri/doc/html/resources/version-diagram-2.4.txt
/opt/gri/doc/html/resources/logo.gif
/opt/gri/doc/html/resources/logo.gri
/opt/gri/doc/html/resources/math_symbols.gif
/opt/gri/doc/html/resources/pixel.gif
/opt/gri/doc/html/resources/sm_bg.gif
/opt/gri/doc/html/resources/symbols.gif
/opt/gri/doc/html/resources/top_banner.gif


%postun
# Clean up, for uninstallation
# ref: Bailey 13.3.2.4; 20.4.3.2
#
# Note: as in Bailey (p182), this will be called with argument of 
# zero when the last version of Gri is uninstalled.  So that's the time
# to clean up the info-dir database, and not before.

# Clean up line in the info directory
if [ "$1" = 0 ];
then
	if grep -i "gri" /etc/info-dir
	then
		grep -vi "gri" /etc/info-dir > /etc/info-dir.tmp
		mv /etc/info-dir.tmp /etc/info-dir
		chmod a+r /etc/info-dir
	fi
	rmdir /opt/gri/doc/html/examples
	rmdir /opt/gri/doc/html/resources
	rmdir /opt/gri/doc/html
	rmdir /opt/gri/doc
	rmdir /opt/gri/bin
	rmdir /opt/gri/lib
	rmdir /opt/gri
fi

