/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * modellib_def.c
 */

/* This is a configuration file for dynamical systems */
#include <modellib.h>

struct  DS_DataS	DS_model;

char	*DS_Category[] = { "Mappings",          /* category 0 */
			   "Vector Fields",	/* category 1 */
			   "Animated systems",  /* category 2 */
			   };

/* ------------------------------------------------------------------ */
/*   declare names of initialization routines                         */
/* ------------------------------------------------------------------ */
extern int	lorenz_init(void); 
extern int      cubic_init(void); 
extern int      vdpol_init(void);
extern int	standard_init(void); 
extern int      henon_init(void); 
extern int      ko_init(void);
extern int	hh_init(void); 
extern int      d4_init(void); 
extern int      pendulum1d_init(void);
extern int 	parserwin_open(void);
extern int	d3_symm_map_init(void); 
extern int      double_toroid_init(void);
extern int      duffing_init(void); 
extern int      field_worfolk_init(void);
extern int      logistic_init(void);
extern int      mathieu_init(void);
extern int      perturbed_dtoroid_init(void); 
extern int      rlag_init(void);
extern int      simple_torus_map_init(void); 
extern int      symm_red_init(void);
extern int      four_param_init(void);
extern int      dblpend_init(void); 
extern int      central_init(void); 
extern int      plate_init(void);
extern int      restrict3pl_init(void); 
extern int      restrict3rpl_init(void);
extern int      fixed_top_init(void);


/* ------------------------------------------------------------------ */
/* fill structure according to: { category, title, init_routine }     */
/* the first system in the struct will be the default system          */
/* ------------------------------------------------------------------ */
struct	DS_DataS	DS_Sel[]={
       { 1, "Lorenz System", lorenz_init },
       { 0, "Standard Map", standard_init },
       { 0, "Kim-Ostlund Torus Map", ko_init },
       { 0, "Complex Henon Map", henon_init },
       { 0, "D3 Symmetric Mapping",d3_symm_map_init },
       { 0, "The Logistic Map", logistic_init },
       { 0, "Simple Torus Map", simple_torus_map_init },
       { 1, "Planar Cubic Vector Field", cubic_init },
       { 1, "Forced Van der Pol Eqns", vdpol_init },
       { 1, "Duffing's Equations", duffing_init },
       { 1, "Mathieu Equation", mathieu_init },
       { 1, "Hodgkin-Huxley Equations", hh_init },
       { 1, "Rinzel Lee Model + A Current", rlag_init },
       { 1, "D4 Symmetric Vector Field", d4_init },
       { 1, "Symmetry Reduced Planar Equations",symm_red_init }, 
       { 1, "Double Toroid",double_toroid_init },
       { 1, "The Field-Worfolk Equations", field_worfolk_init },
       { 1, "Perturbed Double Toroid",perturbed_dtoroid_init },
       { 1, "Four parameter system (Salvador)", four_param_init },
       { 2, "1 dof Damped Driven Pendulum", pendulum1d_init },
       { 2, "Double pendulum", dblpend_init },
       { 2, "Central body force", central_init},
       { 2, "Restricted 3 body problem", restrict3pl_init},
       { 2, "Restricted 3 body problem in rotating coordinates", restrict3rpl_init},
       { 2, "Oscillating plate", plate_init},
       { 2, "Spinning top with point fixed", fixed_top_init}
     };

/* ------------------------------------------------------------------ */
/* do not edit beyond this line                                       */
/* ------------------------------------------------------------------ */
int	N_DS = sizeof(DS_Sel) / sizeof(struct DS_DataS);
int	N_DS_Category = sizeof(DS_Category) / sizeof(char *);
