


/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "stdio.h"
#include "classbase.h"
#include "mode_obj.h"

extern GdkPixmap *current_screen;

// Definition des fonctions membres des classes de creation d'objets
char creer_figure_c::
inserer_figure (liste_elem & selection, figure_c * new_fig)
{
  //Insertion d'un objet new_fig dans la liste de selection selection :
  //si l'objet est deja dans la selection, on le supprime de la selection
  //sinon on l'insere
  //Retourne k>=0 si la selection permet la creation d'un type d'objet
  //k correspond a la position du mode de creation de la figure
  //-1 si necessite encore des selections
  char a, b, c, possible, possible1, position, pos;
  int type_fig;
  if (!detail)
    type_fig = new_fig->type;
  else
    type_fig = new_fig->classe;
  if (selection.position ((void *) new_fig) == 0)
    {
      // l'objet n'est pas dans la selection  on regarde s'il convient
      if (utilisable (new_fig))
	{
	  position = selection.ajoute ((void *) new_fig);
	  for (a = 0, c = 0, possible1 = FALSE; a < nb_mode; a++)
	    {			// parcours les  modes

	      b = 0;
	      possible = FALSE;
	      while (mode[0][a][b] != NO_OBJET)
		{		// regardre ds un mode les type d'objet

		  if (mode[0][a][b] == type_fig && mode[1][a][b] == NO_OBJET && cas_possible[a] != NO_VALIDE)
		    {
		      possible = possible1 = TRUE;
		      mode[1][a][b] = position;
		      break;
		    }
		  b++;
		}
	      if (!possible)
		cas_possible[a] = NO_VALIDE;	// erreur si l'objet ne convient pas

	      c += cas_possible[a];	// VALIDE=1
	      // // il y a des cas_possible supprime

	      if (cas_possible[a] != NO_VALIDE)
		pos = a;	// position du dernier cas valide

	    }
	  if (!possible1)
	    {
	      selection.supprime ((void *) new_fig);
	      return (-1);
	    }
	  if (c == 1)
	    {
	      // Il   n'y a plus qu'un mode de creation possible, on doit verifier
	      // si tout les elem necessaires a ce mode ont ete selectionnes
	      possible = TRUE;
	      b = 0;
	      while (mode[0][pos][b] != NO_OBJET)
		{
		  if (mode[1][pos][b] == NO_OBJET)
		    {
		      possible = FALSE;
		      break;
		    }
		  b++;
		}
	      if (possible)
		return (pos);
	    }
	  else
	    {
	      // verifie parmi les modes encore valides si un n'a pas sa selection complete
	      for (a = 0; a < nb_mode; a++)
		{
		  if (cas_possible[a] == NO_VALIDE)
		    continue;
		  b = 0;
		  possible = TRUE;
		  while (mode[0][a][b] != NO_OBJET)
		    {
		      if (mode[1][a][b] == NO_OBJET)
			{
			  possible = FALSE;
			  break;
			}
		      b++;
		    }
		  if (possible)
		    return a;
		}
	    }
	}
      return (-1);
    }
  else
    {
      // l'objet est  dans la liste, on le supprime
      // On reaffiche l'objet dans sa couleur original puisqu'il etait clignotant
      new_fig->dessine (current_screen, FALSE);
      selection.supprime ((void *) new_fig);
      for (a = 0; a < nb_mode; a++)
	{
	  cas_possible[a] = VALIDE;
	  b = 0;
	  while (mode[0][a][b] != NO_OBJET)
	    {
	      mode[1][a][b] = NO_OBJET;
	      b++;
	    }
	}
      selection.init_lire ();
      for (position = 1; position < selection.nb_elem; position++)
	{
	  if (!detail)
	    type_fig = ((figure_c *) selection.lire (0))->type;
	  else
	    type_fig = ((figure_c *) selection.lire (0))->classe;
	  for (a = 0; a < nb_mode; a++)
	    {
	      b = 0;
	      possible = FALSE;
	      while (mode[0][a][b] != NO_OBJET)
		{
		  if (mode[0][a][b] == type_fig && mode[1][a][b] == NO_OBJET && cas_possible[a] != NO_VALIDE)
		    {
		      possible = TRUE;
		      mode[1][a][b] = position;
		      break;
		    }
		  b++;
		}
	      if (!possible)
		cas_possible[a] = NO_VALIDE;
	    }
	}
      return (-1);
    }
}
char creer_figure_c::
utilisable (figure_c * fig)
{
  //test si le type de figure pass en paramtre    convient        pour la creation
  //de la figure en cours
  char a, b;
  int type_fig;
  if (!detail)
    type_fig = fig->type;
  else
    type_fig = fig->classe;
  for (a = 0; a < nb_mode; a++)
    {
      b = 0;
      while (mode[0][a][b] != 0)
	{
	  if (mode[0][a][b] == type_fig && mode[1][a][b] == 0 && cas_possible[a] != 0)
	    return (true);
	  b++;
	}
    }
  return (false);
}
char creer_figure_c::
utilisable1 (figure_c * fig, liste_elem & selection, figure_c * new_fig)
{
  //test si le type de figure passe en parametre convient pour la creation de la figure en cours,
  //ceci par rapport aux modes de creations initiaux et non actuel
  //l'objet n'est pas dans la selection on regarde s'il convient
  if (selection.position ((void *) new_fig) != 0 || utilisable (fig))
    return TRUE;
  else
    return FALSE;
}
