


/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef lieu_h
#define lieu_h

#include <string.h>
#include <libintl.h>
#include <math.h>

#include "classbase.h"
#include "complexe.h"
#include "mode_obj.h"
#include "graphic.h"
#include "traite.h"

// Class derived from the base class lieu_point_c
// Class lieu mobile on line
class lieu_point_mobile_sur_droite:public lieu_point_c
{
  public:
  lieu_point_mobile_sur_droite (void):lieu_point_c (NB_PT_LIEU_DR)
  {
    classe = LI_PT_DR;
  }
  lieu_point_mobile_sur_droite (liste_elem & lp):lieu_point_c (lp, NB_PT_LIEU_DR)
  {
    classe = LI_PT_DR;
    // dans lp : @pt libre sur droite, @pt !libre
    if (((figure_c *) lp.lire (1))->classe == POINT_DR)
      {
	mobile = (point_c *) lp.lire (1);
	lieu = (point_c *) lp.lire (2);
      }
    else
      {
	mobile = (point_c *) lp.lire (2);
	lieu = (point_c *) lp.lire (1);
      }
    init_nom ();
    actualise ();
  }
  void actualise (void);
};
// Class lieu mobile on circle
class lieu_point_mobile_sur_cercle:public lieu_point_c
{
  public:
  lieu_point_mobile_sur_cercle (void):lieu_point_c (NB_PT_LIEU_CE)
  {
    classe = LI_PT_CE;
  }
  lieu_point_mobile_sur_cercle (liste_elem & lp):lieu_point_c (lp, NB_PT_LIEU_CE)
  {
    classe = LI_PT_CE;
    // dans lp : @pt libre sur cercle, @pt !libre
    if (((figure_c *) lp.lire (1))->classe == POINT_CE)
      {
	mobile = (point_c *) lp.lire (1);
	lieu = (point_c *) lp.lire (2);
      }
    else
      {
	mobile = (point_c *) lp.lire (2);
	lieu = (point_c *) lp.lire (1);
      }
    init_nom ();
    actualise ();
  }
  void actualise (void);
};
// Class lieu mobile on segment
class lieu_point_mobile_sur_segment:public lieu_point_c
{
  public:
  lieu_point_mobile_sur_segment (void):lieu_point_c (NB_PT_LIEU_SE)
  {
    classe = LI_PT_SE;
  }
  lieu_point_mobile_sur_segment (liste_elem & lp):lieu_point_c (lp, NB_PT_LIEU_SE)
  {
    classe = LI_PT_SE;
    // dans lp : @pt libre sur droite, @pt !libre
    if (((figure_c *) lp.lire (1))->classe == POINT_SE)
      {
	mobile = (point_c *) lp.lire (1);
	lieu = (point_c *) lp.lire (2);
      }
    else
      {
	mobile = (point_c *) lp.lire (2);
	lieu = (point_c *) lp.lire (1);
      }
    init_nom ();
    actualise ();
  }
  void actualise (void);
};
// Class lieu mobile on half-line
class lieu_point_mobile_sur_demi_droite:public lieu_point_c
{
  public:
  lieu_point_mobile_sur_demi_droite (void):lieu_point_c (NB_PT_LIEU_DD)
  {
    classe = LI_PT_DD;
  }
  lieu_point_mobile_sur_demi_droite (liste_elem & lp):lieu_point_c (lp, NB_PT_LIEU_DD)
  {
    classe = LI_PT_DD;
    // dans lp : @pt libre sur droite, @pt !libre
    if (((figure_c *) lp.lire (1))->classe == POINT_DD)
      {
	mobile = (point_c *) lp.lire (1);
	lieu = (point_c *) lp.lire (2);
      }
    else
      {
	mobile = (point_c *) lp.lire (2);
	lieu = (point_c *) lp.lire (1);
      }
    init_nom ();
    actualise ();
  }
  void actualise (void);
};
// Class lieu mobile on locus
class lieu_point_mobile_sur_lieu_point:public lieu_point_c
{
  public:
  lieu_point_mobile_sur_lieu_point (void):lieu_point_c (NB_PT_LIEU_LI)
  {
    classe = LI_PT_LI_PT;
  }
  lieu_point_mobile_sur_lieu_point (liste_elem & lp):lieu_point_c (lp, NB_PT_LIEU_LI)
  {
    classe = LI_PT_LI_PT;
    // dans lp : @pt libre sur lieu, @pt !libre
    if (((figure_c *) lp.lire (1))->classe == POINT_LI)
      {
	mobile = (point_c *) lp.lire (1);
	lieu = (point_c *) lp.lire (2);
      }
    else
      {
	mobile = (point_c *) lp.lire (2);
	lieu = (point_c *) lp.lire (1);
      }
    init_nom ();
    actualise ();
  }
  void actualise (void);
};


#endif
