
/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1998
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef graphic_h
#define graphic_h

typedef struct point
  {
    float x, y;
  }
point;

void line_good_clip (GdkPixmap * bmp, int x1, int y1, int x2, int y2, int c);
void clip_line (point & p1, point & p2);
char clip_test (float p, float q, float &u1, float &u2);
void dotted_line (GdkPixmap * bmp, int x1, int y1, int x2, int y2, int col, unsigned char mask);
void gline (GdkPixmap * bmp, int x1, int y1, int x2, int y2, int col);
void dotted_circle (GdkPixmap * bmp, int x, int y, int rayon, int col, unsigned char mask);
void thick_line (GdkPixmap * bmp, int x1, int y1, int x2, int y2, int col, unsigned char epaisseur);
void thick_circle (GdkPixmap * bmp, int x, int y, int rayon, int col, unsigned char epaisseur);
void rectanglefilled (GdkPixmap * bmp, int x1, int y1, int x2, int y2, int c);
void circlefilled (GdkPixmap * bmp, int x, int y, int rayon, int col);
void gcircle (GdkPixmap * bmp, int x, int y, int rayon, int col);
void plotpixel (GdkPixmap * bmp, int x, int y, int col);
void dotted_arc_circle (GdkPixmap * bmp, int x, int y, int rayon, int a1, int a2, int col, unsigned char mask);
void thick_arc_circle (GdkPixmap * bmp, int x, int y, int rayon, int a1, int a2, int col, unsigned char epaisseur);
void arc_circlefilled (GdkPixmap * bmp, int x, int y, int rayon, int a1, int a2, int col);
void garc_circle (GdkPixmap * bmp, int x, int y, int rayon, int a1, int a2, int col);

#endif
