







/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef arc_cercle_h
#define arc_cercle_h

#include <string.h>
#include <libintl.h>
#include <math.h>

#include "classbase.h"
#include "complexe.h"
#include "mode_obj.h"
#include "graphic.h"
#include "traite.h"

// Class derived from the base class arc_cercle_c
// Class 'arc_cercle1', arc circle defines by three points, origin given by the first selected point
class arc_cercle1:public arc_cercle_c
{
  public:
  point_c * A, *B, *C;
  arc_cercle1 ():arc_cercle_c ()
  {
    classe = AC_3PT;
  }
  arc_cercle1 (liste_elem & lp):arc_cercle_c ()
  {
    A = (point_c *) lp.lire (1);
    B = (point_c *) lp.lire (2);
    C = (point_c *) lp.lire (3);
    classe = AC_3PT;
    actualise ();
    init_nom ();
  }
  arc_cercle1 (char a, char b, char c, char d, liste_elem & lp):arc_cercle_c (a, b, c, d)
  {
    A = (point_c *) lp.lire (1);
    B = (point_c *) lp.lire (2);
    C = (point_c *) lp.lire (3);
    classe = AC_3PT;
    actualise ();
    init_nom ();
  }
  void init_nom (void);
  double rayon (void);
  point_s centre (void);
  double arc_origin (void);
  double arc_length (void);
  void move (int xm, int ym);
  void actualise ();
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};

// Transformed arc circle
// By reflexion
class reflexion_arc_cercle:public arc_cercle_c
{
  public:
  droite_c * axe;
  arc_cercle_c *arc_cercle;
    reflexion_arc_cercle ():arc_cercle_c ()
  {
    classe = AR_RE;
  }
  reflexion_arc_cercle (liste_elem & lp):arc_cercle_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_DROITE)
      {
	arc_cercle = (arc_cercle_c *) f2;
	axe = (droite_c *) f1;
      }
    else
      {
	arc_cercle = (arc_cercle_c *) f1;
	axe = (droite_c *) f2;
      }
    actualise ();
    classe = AR_RE;
    init_nom ();
  }
  double rayon (void);
  point_s centre (void);
  double arc_origin (void);
  double arc_length (void);
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By symetry
class symetrie_arc_cercle:public arc_cercle_c
{
  public:
  point_c * symetrie;
  arc_cercle_c *arc_cercle;
    symetrie_arc_cercle ():arc_cercle_c ()
  {
    classe = AR_SY;
  }
  symetrie_arc_cercle (liste_elem & lp):arc_cercle_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_POINT)
      {
	arc_cercle = (arc_cercle_c *) f2;
	symetrie = (point_c *) f1;
      }
    else
      {
	arc_cercle = (arc_cercle_c *) f1;
	symetrie = (point_c *) f2;
      }
    actualise ();
    classe = AR_SY;
    init_nom ();
  }
  double rayon (void);
  point_s centre (void);
  double arc_origin (void);
  double arc_length (void);
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By translation
class translation_arc_cercle:public arc_cercle_c
{
  public:
  vecteur_c * v;
  arc_cercle_c *arc_cercle;
    translation_arc_cercle ():arc_cercle_c ()
  {
    classe = AR_TR;
  }
  translation_arc_cercle (liste_elem & lp):arc_cercle_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_VECTEUR)
      {
	arc_cercle = (arc_cercle_c *) f2;
	v = (vecteur_c *) f1;
      }
    else
      {
	arc_cercle = (arc_cercle_c *) f1;
	v = (vecteur_c *) f2;
      }
    actualise ();
    classe = AR_TR;
    init_nom ();
  }
  double rayon (void);
  point_s centre (void);
  double arc_origin (void);
  double arc_length (void);
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By rotation
class rotation_arc_cercle:public arc_cercle_c
{
  public:
  valeur_c * v;
  point_c *c;
  arc_cercle_c *arc_cercle;
    rotation_arc_cercle ():arc_cercle_c ()
  {
    classe = AR_RO;
  }
  rotation_arc_cercle (liste_elem & lp):arc_cercle_c ()
  {
    figure_c *f1, *f2, *f3;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    f3 = (figure_c *) lp.lire (3);
    if (f1->type == FIG_POINT)
      {
	c = (point_c *) f1;
	if (f2->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f2;
	    arc_cercle = (arc_cercle_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    arc_cercle = (arc_cercle_c *) f2;
	  }
      }
    else if (f2->type == FIG_POINT)
      {
	c = (point_c *) f2;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    arc_cercle = (arc_cercle_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    arc_cercle = (arc_cercle_c *) f1;
	  }
      }
    else
      {
	c = (point_c *) f3;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    arc_cercle = (arc_cercle_c *) f2;
	  }
	else
	  {
	    v = (valeur_c *) f2;
	    arc_cercle = (arc_cercle_c *) f1;
	  }
      }
    actualise ();
    classe = AR_RO;
    init_nom ();
  }
  double rayon (void);
  point_s centre (void);
  double arc_origin (void);
  double arc_length (void);
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By homothetie
class homothetie_arc_cercle:public arc_cercle_c
{
  public:
  valeur_c * v;
  point_c *c;
  arc_cercle_c *arc_cercle;
    homothetie_arc_cercle ():arc_cercle_c ()
  {
    classe = AR_HO;
  }
  homothetie_arc_cercle (liste_elem & lp):arc_cercle_c ()
  {
    figure_c *f1, *f2, *f3;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    f3 = (figure_c *) lp.lire (3);
    if (f1->type == FIG_POINT)
      {
	c = (point_c *) f1;
	if (f2->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f2;
	    arc_cercle = (arc_cercle_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    arc_cercle = (arc_cercle_c *) f2;
	  }
      }
    else if (f2->type == FIG_POINT)
      {
	c = (point_c *) f2;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    arc_cercle = (arc_cercle_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    arc_cercle = (arc_cercle_c *) f1;
	  }
      }
    else
      {
	c = (point_c *) f3;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    arc_cercle = (arc_cercle_c *) f2;
	  }
	else
	  {
	    v = (valeur_c *) f2;
	    arc_cercle = (arc_cercle_c *) f1;
	  }
      }
    actualise ();
    classe = AR_HO;
    init_nom ();
  }
  double rayon (void);
  point_s centre (void);
  double arc_origin (void);
  double arc_length (void);
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};


#endif
