/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __SOCKIO_H__
#define __SOCKIO_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <fcntl.h>
#include <netdb.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/*#include <sys/stat.h>*/
/*#include <sys/uio.h>*/
#include <unistd.h>
#include <sys/wait.h>
#include <sys/un.h>
/*#include <sys/param.h>*/
#undef MIN
#undef MAX
#include <glib.h>

typedef void Sigfunc(gint);

Sigfunc *signal(gint signo, Sigfunc *func);

/*static void sockio_alarm(gint signo);*/

gint connect_timeo(gint sockfd, const struct sockaddr *saptr, guint salen, gint nsec);

ssize_t recvch(gint sock, gchar *ptr);

ssize_t recvline(gint sock, void *vptr, size_t maxlen);

gint sockfd_readable_timeo(gint sockfd, guint nsec);

ssize_t recvline_timeo(gint sockfd, void *vptr, size_t maxlen, guint nsec);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
