/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* Coded to be compliant with RFC 1725 (Post Office Protocol - Version 3) */

#ifndef __POP3IO_H__
#define __POP3IO_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <fcntl.h>
#include <netdb.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/*#include <sys/stat.h>*/
/*#include <sys/uio.h>*/
#include <unistd.h>
#include <sys/wait.h>
#include <sys/un.h>
/*#include <sys/param.h>*/
#undef MIN
#undef MAX
#include <glib.h>

#include "defines.h"
#include "parse.h"
#include "sockio.h"
#include "server.h"

#include "status.h"
#include "globals.h"
#include "mailbox.h"

/* version information for pop3io */
#define P_VER_MAJOR '0'
#define P_VER_MINOR '3'
#define P_VER_REL   '6'

enum pop3_errnos {P_NO_ERROR,
                  P_ERR_RESOLVE,
                  P_ERR_SOCKET,
                  P_ERR_CONNECT,
                  P_ERR_SERV_ACK, 
                  P_ERR_USER_SEND,
                  P_ERR_USER_RECV,
                  P_ERR_PASS_SEND,
                  P_ERR_PASS_RECV, 
                  P_ERR_LIST_SEND,
                  P_ERR_LIST_RECV,
                  P_ERR_STAT_SEND,
                  P_ERR_STAT_RECV,
                  P_ERR_UIDL_SEND,
                  P_ERR_UIDL_RECV,
                  P_ERR_RETR_SEND,
                  P_ERR_RETR_RECV,
                  P_ERR_RSET_SEND,
                  P_ERR_RSET_RECV, 
                  P_ERR_QUIT_SEND,
                  P_ERR_QUIT_RECV,
                  P_ERR_DELE_SEND,
                  P_ERR_DELE_RECV};
					  
typedef enum pop3_errnos pop3errnos;

struct _emessage_
{
	gchar *header;
	gchar *body;
};

typedef struct _emessage_ Emesg;

void pop3error(gchar *reason, gint len);

void emesg_destroy(Emesg *msg);

gint p_user(gint sock, gchar *login);

gint p_pass(gint sock, gchar *passwd);

gint p_stat(gint sock);

gint p_list(gint sock);

gint p_uidl(gint sock, guint id, gchar *uid);

gint p_retr(gint sock, guint id, FILE *fp, gboolean del_yn);

gint p_dele(gint sock, guint id);

gint p_rset(gint sock);

gint p_quit(gint sock);

gint fetchmail(Server *server, gchar *login, gchar *passwd, gchar *finbox, 
               gboolean del_yn, gboolean show_dialog);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __POP3IO_H__ */
