/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "msgid.h"

GSList *msgids = NULL;

/* We have no foolproofing  */
gint open_msgids_file(void)
{
   gchar *home_dir, *msgids_file, *msgid, *hgc1;
   FILE *fp;

   home_dir = g_strdup(getenv("HOME"));   
   if (!home_dir)
	{
	   g_warning("Can't determine home dir !");
	   gtk_exit(1);
	}

   if (msgids != NULL)
      g_slist_free(msgids);
   msgids = NULL;

   msgids_file = g_malloc0(strlen(home_dir) + strlen(MSGIDS_FILE) + 1);
   strcpy(msgids_file, home_dir);
   strcat(msgids_file, MSGIDS_FILE);

   fp = fopen(msgids_file, "r");
   if (fp != NULL)
	{
	   while (!feof(fp))
		{
		   msgid = g_malloc0(128);
		   fgets(msgid, 127, fp); 
		   if (*msgid != '<')
            continue;
		   hgc1 = strchr(msgid, '>') + 1;
		   if (hgc1 != (gchar*) 1)
            *hgc1 = '\0';
		   msgids = g_slist_append(msgids, g_strdup(msgid));
		   g_free(msgid);
		}

      fclose(fp);
	}

   g_free(home_dir);
   g_free(msgids_file);

   return 0;
}

gboolean find_msgid(gchar *msgid)
{
   GSList *temp = msgids;

   while (temp != NULL)
   {
      if (!strcmp(msgid, (gchar *)(temp->data)))
         return TRUE;
      temp = g_slist_next(temp);
   }

   return FALSE;
}

void add_msgid(gchar *msgid)
{
   msgids = g_slist_append(msgids, g_strdup(msgid));
} 

void close_msgids_file(void)
{
   GSList *temp;
   FILE *fp;
   gchar *home_dir, *msgids_file;
   
   home_dir = g_strdup(getenv("HOME"));
   if (!home_dir)
	{
	    g_warning("Can't determine home dir!");
	    gtk_exit(1);
	}    
    
   temp = msgids;
   msgids_file = g_malloc0(strlen(home_dir) + strlen(MSGIDS_FILE) + 1);
   strcpy(msgids_file, home_dir);
   strcat(msgids_file, MSGIDS_FILE);

   fp = fopen(msgids_file, "w");
   if (fp != NULL)
	{
	   while (temp != NULL)
		{
		   fprintf(fp, "%s\n", (gchar *)(temp->data));
		   temp = g_slist_next(temp);
		}
      fclose(fp);
	}

   g_free(home_dir);
   g_free(msgids_file);
}
