/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __MAIN_H__
#define __MAIN_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#undef MIN
#undef MAX
#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/*#include <pthread.h>*/

#include "gui.h"

#include "gtkmanip.h"
#include "globals.h"
#include "init.h"
#include "mailbox.h"
#include "pop3io.h"
#include "rc.h"
#include "sort.h"
#include "status.h"
#include "pgp.h"

#include "about.h"
#include "accounts.h"
#include "addrbook.h"
#include "composer.h"
#include "filters.h"
#include "options.h"
#include "print.h"
#include "mesgreader.h"
#include "mime.h"
#include "imap.h"

#define TOP 0
#define STAY 1
#define BOTTOM -1

#define SHOW_STATUS_DIALOG 1
#define HIDE_STATUS_DIALOG 0

#define MCOPY 1
#define MMOVE 2

struct mailboxformat
{
   gint format;  /* 1: local, 2: imap */
   gint account;
};

void on_frmMain_destroy (GtkObject *object, gpointer user_data);

void on_mnuNew_Message_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_cmdNew_clicked (GtkWidget *widget, gpointer data);

void on_mnuSave_As_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_cmdSave_clicked (GtkWidget *widget, gpointer data);

void on_mnuPrint_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_cmdPrintToolbar_clicked (GtkWidget *widget, gpointer data);

void mail_check (gboolean show_dialog);

void on_mnuCheck_Mail_activate (GtkMenuItem *menuitem, gpointer user_data);

gint periodic_mail_check (gpointer data);

void on_cmdCheckMail_clicked (GtkWidget *widget, gpointer data);

void on_mnuExit_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuAddress_Book_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_cmdAddrbk_clicked (GtkWidget *widget, gpointer data);

void on_mnuAccounts_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuFilters_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuOptions_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuMailboxCreate_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuMailboxDelete_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuMesgNext_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_cmdNext_clicked (GtkWidget *widget, gpointer data);

void on_mnuMesgPrevious_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_cmdPrevious_clicked (GtkWidget *widget, gpointer data);

void on_mnuMesgReply_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_cmdReply_clicked (GtkWidget *widget, gpointer data);

void on_mnuMesgForward_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_cmdFwd_clicked (GtkWidget *widget, gpointer data);

void on_mnuMesgOpen_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuMesgDelete_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_cmdDel_clicked (GtkWidget *widget, gpointer data);

void on_mnuMesgExpunge_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuCopy_to_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuMove_to_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuMimeSave_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuMimeSave_file (GtkWidget *button, GtkFileSelection *file_sel);

void on_mnuMimeSave_file_cancel (GtkWidget *button, GtkFileSelection *file_sel);

void on_mnuHelpAbout_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuHelpManual_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_txtMessage_clicked (GtkWidget *clist, GdkEvent *event, gpointer user_data);

void on_clistMail_select_row (GtkCList *clist, gint row, gint column,
				     GdkEvent *event, gpointer user_data);

void on_clistMail_clicked (GtkWidget *clist, GdkEvent *event, gpointer user_data);

void on_clistMail_drag_data_get (GtkWidget *clist, GdkDragContext *context, GtkSelectionData *selection,
		                           guint info, guint32 clk_time, gpointer user_data);

void on_clistMail_click_column (GtkWidget *clist, gint column, gpointer user_data);

void on_treeBoxes_selection_changed (GtkWidget *tree);

void on_treeBoxes_drag_data_recieved (GtkWidget *item, GdkDragContext *context, 
                                      gint x, gint y, 
                                      GtkSelectionData *selection_data, 
                                      guint info, guint32 clk_time);

/*void on_clistBoxes_select_row (GtkCList *clist, gint row, gint column,
                               GdkEvent *event, gpointer user_data);*/

void on_treeBoxes_clicked (GtkWidget *tree, GdkEvent *event, gpointer user_data);

void on_treeBoxes_drag_data_recieved (GtkWidget *item, GdkDragContext *context, gint x,
                     gint y, GtkSelectionData *selection_data, guint info, guint32 clk_time);

void on_clistMime_select_row (GtkWidget *clist, gint row, gint col, gpointer user_data);

void on_frmMainSaveAs_destroy (GtkObject *object, gpointer user_data);

void on_cmdMainSaveAs_OK_clicked (GtkButton *button, gpointer user_data);

void on_cmdMainSaveAs_Cancel_clicked (GtkButton *button, gpointer user_data);

void on_dlgNewMailbox_destroy (GtkObject *object, gpointer user_data);

void on_cmdDlgNewMailboxOK_clicked (GtkButton *button, gpointer user_data);

void on_cmdDlgNewMailboxCancel_clicked (GtkButton *button, gpointer user_data);

void on_dlgCopyMove_destroy (GtkObject *object, gpointer user_data);

void on_cmdCopyMoveOK_clicked (GtkButton *button, gpointer user_data);

void on_cmdCopyMoveCancel_clicked (GtkButton *button, gpointer user_data);

void on_imaptree_expand (GtkWidget *item, gint account);

void on_imaptree_collapse (GtkWidget *item, gint account);

gint save_message(void);

void refresh_mailboxes(gint hilite);

void refresh_mail_list(gint hilite);

void refresh_txtMessage(void);

void refresh_clistMime(void);

void clistMail_update(void);

void read_sizes (void);

void update_messageStatus(void);

gchar *get_msgid_from_message(gchar *);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
