/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "imap.h"

/* this is used in the tag before each command */
static gint imap_commands = 0;

extern gint timeout;

/* returns 1 if <tag> OK was found */
gint imap_ok (gint tag, gchar *line)
{
   gchar find[64];
   gint ret;

   g_snprintf(find, sizeof(find)-1, "A%.5d OK", tag);

   ret = find_string (line, find);
   
   if (ret < 0)
      return 0;
      
   return 1;
}

/* this logs us in to the server */
gint imap_login (gint socket, gchar *username, gchar *password)
{
   gchar buffer[256];
   gchar temp[64];
   
   if (username == NULL || password == NULL)
      return ERROR;

   g_snprintf(buffer, sizeof(buffer)-1, "A%.5d LOGIN %s %s\r\n", imap_commands, username, password);

   if (send (socket, buffer, strlen(buffer), 0) < 0)
   {
      return ERROR;
   }
      
   g_snprintf(temp, sizeof(temp)-1, "A%.5d", imap_commands);

   memset(buffer, 0, sizeof(buffer));
   recvline(socket, buffer, sizeof(buffer)-1);
   while(find_string(buffer, temp) < 0)
   {
      memset(buffer, 0, sizeof(buffer));
      recvline(socket, buffer, sizeof(buffer)-1);
   }

   if (!imap_ok(imap_commands, buffer))
      return ERROR;

   imap_commands++;
   
   return SUCCESS;   
}

/* this gets the names of all the mailboxes */
GList *imap_list (gint socket)
{

   return (GList *)NULL;
}

/* selects a mailbox, returns the number of mails in that mailbox
 * or -1 on error */
gint imap_select_mailbox (gint socket, gchar *mailbox)
{
   gchar buffer[256], temp[64], *index, mesgs[16];
   gint ret, i;

   if (mailbox == NULL)
      return ERROR;

   g_snprintf(buffer, sizeof(buffer)-1, "A%.5d SELECT %s\r\n", imap_commands, mailbox);

   if (send(socket, buffer, strlen(buffer), 0) < 0)
   {
      return -1;
   }
   
   g_snprintf(temp, sizeof(temp)-1, "A%.5d", imap_commands);

   memset(buffer, 0, sizeof(buffer));
   ret = recvline(socket, buffer, sizeof(buffer)-1);
   while (ret > 0)
   {
      if (find_string(buffer, temp) >= 0)
         break;
      if (buffer[0] == '*')
      {
         if (find_string(buffer, "EXISTS") >= 0)
         {
            index = buffer;
            while (*index != ' ')
               index++;
            index++;
            
            i = 0;
            while (*index != ' ')
            {
               mesgs[i] = *index;
               index++;
               i++;
            }
         }
      }
      memset(buffer, 0, sizeof(buffer));
      ret = recvline(socket, buffer, sizeof(buffer)-1);   
   }
   
   if (!imap_ok(imap_commands, buffer))
      return -1;
   
   imap_commands++;

   return atoi(mesgs);
}

/* logs out */
gint imap_logout (gint socket)
{
   gchar buffer[256];

   g_snprintf(buffer, sizeof(buffer)-1, "A%.5d LOGOUT\r\n", imap_commands);

   if (send(socket, buffer, strlen(buffer), 0) < 0)
   {
      return ERROR;
   }

   return SUCCESS;
}

/* creates a new mailbox */
gint imap_mailbox_create (gint socket, gchar *mailbox)
{
   gchar buffer[256];

   if (mailbox == NULL)
      return ERROR;

   g_snprintf(buffer, sizeof(buffer)-1, "A%.5d CREATE %s\r\n", imap_commands, mailbox);

   if (send(socket, buffer, strlen(buffer), 0) < 0)
   {
      return ERROR;
   }

   memset(buffer, 0, sizeof(buffer));
   if (recvline(socket, buffer, sizeof(buffer)-1) < 0 ||
      !imap_ok(imap_commands, buffer))
   {
      return ERROR;
   }

   imap_commands++;

   return SUCCESS;
}

/* deletes a mailbox */
gint imap_mailbox_delete (gint socket, gchar *mailbox)
{
   gchar buffer[256];

   if (mailbox == NULL)
      return ERROR;

   g_snprintf(buffer, sizeof(buffer)-1, "A%.5d DELETE %s\r\n", imap_commands, mailbox);

   if (send(socket, buffer, strlen(buffer), 0) < 0)
   {
      return ERROR;
   }

   memset(buffer, 0, sizeof(buffer));
   if (recvline(socket, buffer, sizeof(buffer)-1) < 0 ||
      !imap_ok(imap_commands, buffer))
   {
      return ERROR;
   }

   imap_commands++;

   return SUCCESS;
}

/* fetches a message, or just the header */
gchar *imap_fetch (gint socket, gint mesgnum, gint header_only, gint *seen)
{
   gchar buffer[256];
   gchar *index, *mesg;
   gchar flags[128], size[16], temp[64];
   gint i, n, msgsize = 1000;

   if (mesg < 0)
      return (gchar *)NULL;

   g_snprintf(buffer, sizeof(buffer)-1, "A%.5d FETCH %d (FLAGS BODY[%s])\r\n", imap_commands, mesgnum,
            header_only ? "HEADER" : "");

   if (send(socket, buffer, strlen(buffer), 0) < 0)
   {
      return (gchar *)NULL;
   }   

   g_snprintf(temp, sizeof(temp)-1, "A%.5d", imap_commands);

   memset(buffer, 0, sizeof(buffer));
   n = recvline(socket, buffer, sizeof(buffer)-1);
   if (buffer[0] == '*')
   {
      index = strstrcase(buffer, "FLAGS");
      if (index == NULL) /* hmm */
      {
         return (gchar *)NULL;
      }
      else
      {
         while (*index != '(')
         {
            index++;
         }
         index++;
         i = 0;
         while (*index != ')')
         {
            flags[i] = *index;
            index++;
            i++;
         }
         flags[i] = '\0';
         index++;
         while (*index != '{')
         {
            index++;
         }
         index++;
         
         i = 0;
         while (*index != '}')
         {
            size[i] = *index;
            index++;
            i++;
         }
         size[i] = '\0';
         msgsize = atoi(size);
      }
   }
   else
      if (find_string(buffer, temp) >= 0) /* this means there's no such message */
      {
         return (gchar *)NULL;
      }

   mesg = g_malloc0(msgsize + 50); /* just to be safe */
   n = recvline(socket, buffer, 255);
   
   while ( !(n <= 0) && !imap_ok(imap_commands,buffer))
   {
      strip(buffer, '\r');  /* strip all the \r's */
      strcat(mesg, buffer);
      memset(buffer, 0, sizeof(buffer));
      n = recvline(socket, buffer, 255);
   }

   mesg[strlen(mesg)-3] = '\0';   /* strip the ending ) */

   if (find_string(flags, "\\Seen") >= 0)
      *seen = 1;
   else
      *seen = 0;

   imap_commands++;

   return (gchar *)mesg;
}

gint imap_delete (gint socket, guint mesgs, gint *mesg_nums)
{
   gchar buffer[256];
   gchar temp[16];
   gint i, ret;

   for (i = 0; i < mesgs; i++)
   {
      g_snprintf (buffer, sizeof(buffer)-1, "A%.5d STORE %d +FLAGS (\\Deleted)\r\n", imap_commands, mesg_nums[i]);
      if (send (socket, buffer, strlen(buffer), 0) < 0)
      {
         return ERROR;
      }
      
      g_snprintf (temp, sizeof(temp)-1, "A%.5d", imap_commands);

      memset(buffer, 0, sizeof(buffer));
      ret = recvline (socket, buffer, sizeof(buffer)-1);
      while (ret > 0)
      {
        if (find_string (buffer, temp) >= 0)
           break;

        memset(buffer, 0, sizeof(buffer));
        ret = recvline (socket, buffer, sizeof(buffer)-1);
      }

      if (!imap_ok (imap_commands, buffer))
      {
         return ERROR;
      }
       
      imap_commands++;
   }

   g_snprintf (buffer, 255, "A%.5d EXPUNGE\r\n", imap_commands);

   if (send (socket, buffer, strlen(buffer), 0) < 0)
   {
      return ERROR;
   }   

   g_snprintf (temp, 15, "A%.5d", imap_commands);

   memset(buffer, 0, sizeof(buffer));
   ret = recvline (socket, buffer, sizeof(buffer)-1);
   while (ret > 0)
   {
      if (find_string (buffer, temp) >= 0)
        break;

     memset(buffer, 0, sizeof(buffer));
     ret = recvline (socket, buffer, sizeof(buffer)-1);
   }
    
   if (!imap_ok (imap_commands, buffer))
   {
      return ERROR;
   }

   imap_commands++;

   return SUCCESS;
}

/* connects to the server and returns the socket or -1 on error */
gint imap_connect (Server *server)
{
   gint sock;

   if (!Resolve(server))
      return -1;

   sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
   if (sock < 0)
      return -1;

   server->sin.sin_family = AF_INET;
   server->sin.sin_port = htons(server->port);

   if (connect_timeo(sock, (struct sockaddr*)&server->sin, sizeof(server->sin), timeout) < 0)
   {
      close(sock);
      return -1;
   }

   return sock;
}
