/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * Filters.c originaly written by Kristoffer Brnemyr <ztion@swipnet.se>
 *
*/

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "filters.h"

/* external variables */
extern gchar *spruceconf;                /* spruce config file name */
extern GtkWidget *frmFilters;
extern gboolean FiltersOpen;             /* is frmFilters opened?? */
extern GtkWidget *frmMain;
extern gint NumMailboxes;

GtkWidget *dlgNewFilter;
GList *filters_mailboxes = NULL;
extern GList *filters;

GtkWidget* create_frmFilters ()
{
  GtkWidget *frmFilters;
  GtkWidget *fixed1;
  GtkWidget *cmdFiltersOK;
  GtkWidget *cmdFiltersApply;
  GtkWidget *cmdFiltersCancel;
  GtkWidget *frame2;
  GtkWidget *fixed3;
  GtkWidget *action_move_combo;
  GSList *action_button_group = NULL;
  GtkWidget *action_move_button;
  GtkWidget *action_forward_button;
  GtkWidget *action_forward_entry;
  GtkWidget *action_delete_button;
  GtkWidget *frameMatch;
  GtkWidget *fixed2;
  GtkWidget *lblMatchIn;
  GtkWidget *match_text_entry;
  GtkWidget *lblMatchText;
  GtkWidget *match_in_combo;
  GtkWidget *frame3;
  GtkWidget *fixed4;
  GtkWidget *scrolledwindow1;
  GtkWidget *filters_clist;
  GtkWidget *lblFilter;
  GtkWidget *cmdFiltersNew;
  GtkWidget *cmdFiltersDelete;
  GtkWidget *hseparator1;
  GList *match_in_combo_opts = NULL;

  frmFilters = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (frmFilters, "frmFilters");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "frmFilters", frmFilters);
  gtk_widget_set_usize (frmFilters, 532, 300);
  gtk_container_border_width (GTK_CONTAINER (frmFilters), 4);
  gtk_signal_connect_object (GTK_OBJECT (frmFilters), "destroy",
                             GTK_SIGNAL_FUNC (on_frmFilters_destroy),
                             GTK_OBJECT (frmFilters));
  gtk_window_set_title (GTK_WINDOW (frmFilters), _("Edit Filters"));
  gtk_window_position (GTK_WINDOW (frmFilters), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (frmFilters), FALSE, FALSE, FALSE);

  fixed1 = gtk_fixed_new ();
  gtk_widget_set_name (fixed1, "fixed1");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "fixed1", fixed1);
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (frmFilters), fixed1);

  cmdFiltersOK = gtk_button_new_with_label (_("OK"));
  gtk_widget_set_name (cmdFiltersOK, "cmdFiltersOK");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "cmdFiltersOK", cmdFiltersOK);
  gtk_widget_show (cmdFiltersOK);
  gtk_fixed_put (GTK_FIXED (fixed1), cmdFiltersOK, 272, 256);
  gtk_widget_set_uposition (cmdFiltersOK, 272, 256);
  gtk_widget_set_usize (cmdFiltersOK, 72, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdFiltersOK), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdFiltersOK_clicked),
                             GTK_OBJECT (frmFilters));

  cmdFiltersApply = gtk_button_new_with_label (_("Apply"));
  gtk_widget_set_name (cmdFiltersApply, "cmdFiltersApply");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "cmdFiltersApply", cmdFiltersApply);
  gtk_widget_show (cmdFiltersApply);
  gtk_fixed_put (GTK_FIXED (fixed1), cmdFiltersApply, 360, 256);
  gtk_widget_set_uposition (cmdFiltersApply, 360, 256);
  gtk_widget_set_usize (cmdFiltersApply, 72, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdFiltersApply), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdFiltersApply_clicked),
                             GTK_OBJECT (frmFilters));

  cmdFiltersCancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_set_name (cmdFiltersCancel, "cmdFiltersCancel");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "cmdFiltersCancel", cmdFiltersCancel);
  gtk_widget_show (cmdFiltersCancel);
  gtk_fixed_put (GTK_FIXED (fixed1), cmdFiltersCancel, 448, 256);
  gtk_widget_set_uposition (cmdFiltersCancel, 448, 256);
  gtk_widget_set_usize (cmdFiltersCancel, 72, 32);
  gtk_signal_connect_object (GTK_OBJECT (cmdFiltersCancel), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdFiltersCancel_clicked),
                             GTK_OBJECT (frmFilters));

  frame2 = gtk_frame_new (_("Action"));
  gtk_widget_set_name (frame2, "frame2");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "frame2", frame2);
  gtk_widget_show (frame2);
  gtk_fixed_put (GTK_FIXED (fixed1), frame2, 8, 112);
  gtk_widget_set_uposition (frame2, 8, 112);
  gtk_widget_set_usize (frame2, 304, 128);

  fixed3 = gtk_fixed_new ();
  gtk_widget_set_name (fixed3, "fixed3");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "fixed3", fixed3);
  gtk_widget_show (fixed3);
  gtk_container_add (GTK_CONTAINER (frame2), fixed3);

  action_move_combo = gtk_combo_new ();
  gtk_widget_set_name (action_move_combo, "action_move_combo");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "action_move_combo", action_move_combo);
  gtk_signal_connect(GTK_OBJECT(GTK_COMBO(action_move_combo)->button), "pressed",
                     GTK_SIGNAL_FUNC(on_cmdFiltersMoveComboButton_clicked), NULL);
  gtk_widget_show (action_move_combo);
  gtk_fixed_put (GTK_FIXED (fixed3), action_move_combo, 128, 8);
  gtk_widget_set_uposition (action_move_combo, 128, 8);
  gtk_widget_set_usize (GTK_COMBO (action_move_combo)->entry, 144, 24);
  gtk_widget_set_usize (action_move_combo, 160, 24);

  action_move_button = gtk_radio_button_new_with_label (action_button_group, _("Move to mailbox:"));
  action_button_group = gtk_radio_button_group (GTK_RADIO_BUTTON (action_move_button));
  gtk_widget_set_name (action_move_button, "action_move_button");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "action_move_button", action_move_button);
  gtk_widget_show (action_move_button);
  gtk_fixed_put (GTK_FIXED (fixed3), action_move_button, 8, 8);
  gtk_widget_set_uposition (action_move_button, 8, 8);
  gtk_widget_set_usize (action_move_button, 120, 24);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (action_move_button), TRUE);

  action_forward_button = gtk_radio_button_new_with_label (action_button_group, _("Forward to:"));
  action_button_group = gtk_radio_button_group (GTK_RADIO_BUTTON (action_forward_button));
  gtk_widget_set_name (action_forward_button, "action_forward_button");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "action_forward_button", action_forward_button);
  gtk_widget_show (action_forward_button);
  gtk_fixed_put (GTK_FIXED (fixed3), action_forward_button, 8, 40);
  gtk_widget_set_uposition (action_forward_button, 8, 40);
  gtk_widget_set_usize (action_forward_button, 112, 24);

  action_forward_entry = gtk_entry_new ();
  gtk_widget_set_name (action_forward_entry, "action_forward_entry");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "action_forward_entry", action_forward_entry);
  gtk_widget_show (action_forward_entry);
  gtk_fixed_put (GTK_FIXED (fixed3), action_forward_entry, 128, 40);
  gtk_widget_set_uposition (action_forward_entry, 128, 40);
  gtk_widget_set_usize (action_forward_entry, 158, 22);

  action_delete_button = gtk_radio_button_new_with_label (action_button_group, _("Delete message"));
  action_button_group = gtk_radio_button_group (GTK_RADIO_BUTTON (action_delete_button));
  gtk_widget_set_name (action_delete_button, "action_delete_button");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "action_delete_button", action_delete_button);
  gtk_widget_show (action_delete_button);
  gtk_fixed_put (GTK_FIXED (fixed3), action_delete_button, 8, 72);
  gtk_widget_set_uposition (action_delete_button, 8, 72);
  gtk_widget_set_usize (action_delete_button, 112, 24);

  frameMatch = gtk_frame_new (_("Match"));
  gtk_widget_set_name (frameMatch, "frameMatch");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "frameMatch", frameMatch);
  gtk_widget_show (frameMatch);
  gtk_fixed_put (GTK_FIXED (fixed1), frameMatch, 8, 8);
  gtk_widget_set_uposition (frameMatch, 8, 8);
  gtk_widget_set_usize (frameMatch, 304, 96);

  fixed2 = gtk_fixed_new ();
  gtk_widget_set_name (fixed2, "fixed2");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "fixed2", fixed2);
  gtk_widget_show (fixed2);
  gtk_container_add (GTK_CONTAINER (frameMatch), fixed2);

  lblMatchIn = gtk_label_new (_("In:"));
  gtk_widget_set_name (lblMatchIn, "lblMatchIn");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "lblMatchIn", lblMatchIn);
  gtk_widget_show (lblMatchIn);
  gtk_fixed_put (GTK_FIXED (fixed2), lblMatchIn, 8, 40);
  gtk_widget_set_uposition (lblMatchIn, 8, 40);
  gtk_widget_set_usize (lblMatchIn, 56, 24);
  gtk_label_set_justify (GTK_LABEL (lblMatchIn), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblMatchIn), 1.93715e-07, 0.5);

  match_text_entry = gtk_entry_new ();
  gtk_widget_set_name (match_text_entry, "match_text_entry");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "match_text_entry", match_text_entry);
  gtk_widget_show (match_text_entry);
  gtk_fixed_put (GTK_FIXED (fixed2), match_text_entry, 72, 8);
  gtk_widget_set_uposition (match_text_entry, 72, 8);
  gtk_widget_set_usize (match_text_entry, 216, 24);

  lblMatchText = gtk_label_new (_("Text:"));
  gtk_widget_set_name (lblMatchText, "lblMatchText");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "lblMatchText", lblMatchText);
  gtk_widget_show (lblMatchText);
  gtk_fixed_put (GTK_FIXED (fixed2), lblMatchText, 8, 8);
  gtk_widget_set_uposition (lblMatchText, 8, 8);
  gtk_widget_set_usize (lblMatchText, 56, 24);
  gtk_label_set_justify (GTK_LABEL (lblMatchText), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lblMatchText), 1.93715e-07, 0.5);

  match_in_combo = gtk_combo_new ();
  gtk_widget_set_name (match_in_combo, "match_in_combo");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "match_in_combo", match_in_combo);
  /* these should do by default */
  match_in_combo_opts = g_list_append(match_in_combo_opts, "To:");
  match_in_combo_opts = g_list_append(match_in_combo_opts, "From:");
  match_in_combo_opts = g_list_append(match_in_combo_opts, "Sender:");
  match_in_combo_opts = g_list_append(match_in_combo_opts, "Subject:");
  match_in_combo_opts = g_list_append(match_in_combo_opts, "Cc:");
  match_in_combo_opts = g_list_append(match_in_combo_opts, "Any recipient");
  gtk_combo_set_popdown_strings(GTK_COMBO(match_in_combo), match_in_combo_opts);
  gtk_widget_show (match_in_combo);
  gtk_fixed_put (GTK_FIXED (fixed2), match_in_combo, 72, 40);
  gtk_widget_set_uposition (match_in_combo, 72, 40);
  gtk_widget_set_usize (GTK_COMBO (match_in_combo)->entry, 200, 24);
  gtk_widget_set_usize (match_in_combo, 216, 24);

  frame3 = gtk_frame_new (_("Filters"));
  gtk_widget_set_name (frame3, "frame3");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "frame3", frame3);
  gtk_widget_show (frame3);
  gtk_fixed_put (GTK_FIXED (fixed1), frame3, 320, 8);
  gtk_widget_set_uposition (frame3, 320, 8);
  gtk_widget_set_usize (frame3, 200, 232);

  fixed4 = gtk_fixed_new ();
  gtk_widget_set_name (fixed4, "fixed4");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "fixed4", fixed4);
  gtk_widget_show (fixed4);
  gtk_container_add (GTK_CONTAINER (frame3), fixed4);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "scrolledwindow1", scrolledwindow1);
  gtk_widget_show (scrolledwindow1);
  gtk_fixed_put (GTK_FIXED (fixed4), scrolledwindow1, 8, 0);
  gtk_widget_set_uposition (scrolledwindow1, 8, 0);
  gtk_widget_set_usize (scrolledwindow1, 184, 176);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  filters_clist = gtk_clist_new (1);
  gtk_widget_set_name (filters_clist, "filters_clist");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "filters_clist", filters_clist);
  gtk_signal_connect(GTK_OBJECT(filters_clist), "select_row", GTK_SIGNAL_FUNC(on_clistrow_selected), NULL);
  gtk_widget_show (filters_clist);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), filters_clist);
  gtk_clist_set_column_width (GTK_CLIST (filters_clist), 0, 80);
  gtk_clist_column_titles_show (GTK_CLIST (filters_clist));

  lblFilter = gtk_label_new (_("Filter"));
  gtk_widget_set_name (lblFilter, "lblFilter");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "lblFilter", lblFilter);
  gtk_widget_show (lblFilter);
  gtk_clist_set_column_widget (GTK_CLIST (filters_clist), 0, lblFilter);

  cmdFiltersNew = gtk_button_new_with_label (_("New"));
  gtk_widget_set_name (cmdFiltersNew, "cmdFiltersNew");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "cmdFiltersNew", cmdFiltersNew);
  gtk_widget_show (cmdFiltersNew);
  gtk_fixed_put (GTK_FIXED (fixed4), cmdFiltersNew, 16, 184);
  gtk_widget_set_uposition (cmdFiltersNew, 16, 184);
  gtk_widget_set_usize (cmdFiltersNew, 72, 24);
  gtk_signal_connect (GTK_OBJECT (cmdFiltersNew), "clicked",
                      GTK_SIGNAL_FUNC (on_cmdFiltersNew_clicked),
                      NULL);

  cmdFiltersDelete = gtk_button_new_with_label (_("Delete"));
  gtk_widget_set_name (cmdFiltersDelete, "cmdFiltersDelete");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "cmdFiltersDelete", cmdFiltersDelete);
  gtk_widget_show (cmdFiltersDelete);
  gtk_fixed_put (GTK_FIXED (fixed4), cmdFiltersDelete, 112, 184);
  gtk_widget_set_uposition (cmdFiltersDelete, 112, 184);
  gtk_widget_set_usize (cmdFiltersDelete, 72, 24);
  gtk_signal_connect (GTK_OBJECT (cmdFiltersDelete), "clicked",
                      GTK_SIGNAL_FUNC (on_cmdFiltersDelete_clicked),
                      NULL);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator1, "hseparator1");
  gtk_object_set_data (GTK_OBJECT (frmFilters), "hseparator1", hseparator1);
  gtk_widget_show (hseparator1);
  gtk_fixed_put (GTK_FIXED (fixed1), hseparator1, 0, 240);
  gtk_widget_set_uposition (hseparator1, 0, 240);
  gtk_widget_set_usize (hseparator1, 520, 16);

  return frmFilters;
}
 
GtkWidget *create_dlgNewFilter(void)
{
 	GtkWidget *dlgNewFilter;
 	GtkWidget *box1;
 	GtkWidget *newfilter_entry;
 	GtkWidget *label;
 	GtkWidget *button;
 
 	dlgNewFilter = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 	gtk_window_set_title(GTK_WINDOW(dlgNewFilter), _("Name of the Filter?"));
 	gtk_widget_set_usize(dlgNewFilter, 300, 170);
 	gtk_container_set_border_width(GTK_CONTAINER(dlgNewFilter), 10);
 
 	box1 = gtk_vbox_new(FALSE, FALSE);
 	gtk_widget_show(box1);
 	gtk_container_add(GTK_CONTAINER(dlgNewFilter), box1);
 
 	label = gtk_label_new(_("Name of the Filter?"));
 	gtk_widget_show(label);
 	gtk_box_pack_start(GTK_BOX(box1), label, FALSE, FALSE, 0);
 	
 	newfilter_entry = gtk_entry_new();
 	gtk_widget_set_name(newfilter_entry, "newfilter_entry");
 	gtk_object_set_data(GTK_OBJECT(dlgNewFilter), "newfilter_entry", newfilter_entry);
 	gtk_box_pack_start(GTK_BOX(box1), newfilter_entry, FALSE, FALSE, 0);
 	gtk_widget_show(newfilter_entry);
 
 	button = gtk_button_new_with_label(_("Ok"));
 	gtk_widget_show(button);
 	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(on_dlgNewFilterOk_clicked), NULL);
 	gtk_box_pack_end(GTK_BOX(box1), button, FALSE, FALSE, 0);
 
 	return dlgNewFilter;
 
}

void on_frmFilters_destroy (GtkObject *object, gpointer user_data)
{
   gtk_widget_destroy(frmFilters);
   FiltersOpen = FALSE;
}

void on_cmdFiltersCancel_clicked (GtkObject *object, gpointer user_data)
{
   gtk_widget_destroy(frmFilters);
   FiltersOpen = FALSE;
}

void on_dlgNewFilter_destroy (GtkObject *object, gpointer user_data)
{
   gtk_widget_destroy(dlgNewFilter);
}

void on_cmdFiltersOK_clicked (GtkWidget *object, gpointer user_data)
{
 	filters_save();
 	gtk_widget_destroy(frmFilters);
 	FiltersOpen = FALSE;
}
 
void on_cmdFiltersDelete_clicked (GtkWidget *object, gpointer user_data)
{
 	GtkWidget *clist;
 	GtkWidget *match_entry;
 	GtkWidget *in_combo;
 	GtkWidget *move_combo;
 	GtkWidget *forward_entry;
 	GtkWidget *move_button;
 	GList *selection;
 	GList *tmp;
 	gint i = 0;
 
 	clist = get_widget(frmFilters, "filters_clist");
 	match_entry = get_widget(frmFilters, "match_text_entry");
 	in_combo = get_widget(frmFilters, "match_in_combo");
 	move_combo = get_widget(frmFilters, "action_move_combo");
 	move_button = get_widget(frmFilters, "action_move_button");
 	forward_entry = get_widget(frmFilters, "action_forward_entry");
 
 	tmp = filters;
 	selection = GTK_CLIST(clist)->selection;
 	while(selection != NULL)
   {
 		while(i < (int)selection->data)
      {
 			i++;
 			tmp = tmp->next;
 		}
 		free(tmp->data);
 		g_list_remove(filters, tmp->data);
 		selection = selection->next;
 
   }
 	
 	gtk_entry_set_text(GTK_ENTRY(match_entry), "");
 	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(in_combo)->entry), "");
 	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(move_combo)->entry), "");
 	gtk_entry_set_text(GTK_ENTRY(forward_entry), "");
 	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(move_button), 1);
 	
 	filters_refresh();
 	rc_save_defaults();
}
 
void on_cmdFiltersNew_clicked (GtkWidget *ob, gpointer user_data)
{
 	dlgNewFilter = create_dlgNewFilter();
 	gtk_widget_show(dlgNewFilter);
}
 
void on_cmdFiltersApply_clicked (GtkWidget *ob, gpointer user_data)
{
 	filters_save();
}
 
void on_cmdFiltersMoveComboButton_clicked (GtkWidget *ob, gpointer user_data)
{
 	gint i = 0;
 	gchar *box;
 	GtkWidget *combo = get_widget(frmFilters, "action_move_combo");
 	GtkWidget *treelocalBoxes = get_widget(frmMain, "treelocalBoxes");
 	GList *items;
 	
 	if(filters_mailboxes != NULL)
   {
 		g_list_free(filters_mailboxes);
 		filters_mailboxes = NULL;
 	}

	items = GTK_TREE(treelocalBoxes)->children;
	while (items != NULL)
	{
		gtk_label_get (GTK_LABEL (GTK_BIN (GTK_WIDGET(items->data))->child), &box);
		filters_mailboxes = g_list_append (filters_mailboxes, box);
		items = items->next;
		i++;
	}
 
 	if(i > 0)
	{
 		gtk_combo_set_popdown_strings(GTK_COMBO(combo), filters_mailboxes);
 	}
 	
 }
 
void on_clistrow_selected (GtkWidget *ob, gint row, gint column, GdkEventButton *event, gpointer user_data)
{
 	gint i = 0;
 	struct filter *flt;
 	GtkWidget *match_in       = get_widget(frmFilters, "match_in_combo");
 	GtkWidget *match_text     = get_widget(frmFilters, "match_text_entry");
 	GtkWidget *move_combo     = get_widget(frmFilters, "action_move_combo");
 	GtkWidget *move_button    = get_widget(frmFilters, "action_move_button");
 	GtkWidget *forward_entry  = get_widget(frmFilters, "action_forward_entry");
 	GtkWidget *forward_button = get_widget(frmFilters, "action_forward_button");
 	GtkWidget *delete_button  = get_widget(frmFilters, "action_delete_button");
 	GList *tmp;
 	
 	tmp = filters;
 	while(i < row)
   {
 		tmp = tmp->next;
 		i++;
 	}
 	flt = tmp->data;
 	gtk_entry_set_text(GTK_ENTRY(match_text), flt->match);
 	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(match_in)->entry), flt->in);
 	if(flt->action == 1)
   {
 		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(move_button), 1);
 		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(move_combo)->entry), flt->to);
 		gtk_entry_set_text(GTK_ENTRY(forward_entry), "");
 	}
 	if(flt->action == 2)
   {
 		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(forward_button), 1);
 		gtk_entry_set_text(GTK_ENTRY(forward_entry), flt->to);
 		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(move_combo)->entry), "");
 	}
 	if(flt->action == 3)
   {
 		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(delete_button), 1);
 		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(move_combo)->entry), "");
 		gtk_entry_set_text(GTK_ENTRY(forward_entry), "");
 	}
}
 
void on_dlgNewFilterOk_clicked (GtkWidget *ob, gpointer user_data)
{
 	struct filter *flt;
 	GtkWidget *entry = get_widget(dlgNewFilter, "newfilter_entry");
 	GtkWidget *clist = get_widget(frmFilters, "filters_clist");
 	char *name;
 
 	name = gtk_entry_get_text(GTK_ENTRY(entry));
 	
 	if(name[0] != '\0')
   {
		flt = g_malloc(sizeof(struct filter));
 		memset(flt, 0, sizeof(struct filter));
 	
 		strncpy(flt->name, name, 64);
 		filters = g_list_append(filters, flt);
 		filters_refresh();
 		gtk_clist_select_row(GTK_CLIST(clist), GTK_CLIST(clist)->rows - 1, 0);
 	}

 	gtk_widget_destroy(dlgNewFilter);
}
 
void filters_save(void)
{
 	GtkWidget *move_button    = get_widget(frmFilters, "action_move_button");
 	GtkWidget *move_combo     = get_widget(frmFilters, "action_move_combo");
 	GtkWidget *forward_button = get_widget(frmFilters, "action_forward_button");
 	GtkWidget *forward_entry  = get_widget(frmFilters, "action_forward_entry");
 	GtkWidget *delete_button  = get_widget(frmFilters, "action_delete_button");
 	GtkWidget *match_text     = get_widget(frmFilters, "match_text_entry");
 	GtkWidget *match_in       = get_widget(frmFilters, "match_in_combo");
 	GtkWidget *clist          = get_widget(frmFilters, "filters_clist");
 	GList *selection;
 	GList *tmp;
 	struct filter *flt;
 	gint i = 0;

 	selection = GTK_CLIST(clist)->selection;
 	if(selection == NULL)
 		return;
 	tmp = filters;
 	if(tmp == NULL)
 		return;
 	
 	while(i < (int)selection->data)
   {
 		tmp = tmp->next;
 		i++;
 	}
 	flt = tmp->data;
 	strncpy(flt->match, gtk_entry_get_text(GTK_ENTRY(match_text)), 127);
 	strncpy(flt->in, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(match_in)->entry)), 127);
 	if(GTK_TOGGLE_BUTTON(move_button)->active)
   {
 		flt->action = 1;
 		strncpy(flt->to, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(move_combo)->entry)), 127);
 	}
 	if(GTK_TOGGLE_BUTTON(forward_button)->active)
   {
 		flt->action = 2;
 		strncpy(flt->to, gtk_entry_get_text(GTK_ENTRY(forward_entry)), 127);
 	}
 	if(GTK_TOGGLE_BUTTON(delete_button)->active)
   {
 		flt->action = 3;
 	}
 	rc_save_defaults();
}
 
int filters_read(void)
{
   gchar buffer[257];
   FILE *fp;
   gchar *name  = NULL;
   gchar *to    = NULL;
   gchar *match = NULL;
   gchar *in;
   gint action;
   struct filter *flt;
  
   fp = fopen(spruceconf, "rt");
   if (fp == NULL)
   {
      fprintf(stderr, "Spruce: %s failed to open for reading.\n", spruceconf);
      fprintf(stderr, "Please check with your local Administrator.\n");
      return 0;
   }

   while (!feof(fp))
   {
      fgets(buffer, 256, fp);
      trim_leadspc(buffer);
      if(buffer[0] != '\n' && buffer[0] != '#')
      {
         if (!strncmp("filter", buffer, strlen("filter")))
         {
            strcut(buffer, 0, strlen("filter"));
            trim_whtspc(buffer);

            name   = get_field(buffer, 1, '^');
            match  = get_field(buffer, 2, '^');
            in     = get_field(buffer, 3, '^');
            action = atoi(get_field(buffer, 4, '^'));
            to     = get_field(buffer, 5, '^');
         			
            flt = g_malloc(sizeof(struct filter));
 	         memset(flt, 0, sizeof(struct filter));

            strncpy(flt->name, name, 63);
            strncpy(flt->match, match, 127);
            strncpy(flt->in, in, 127);
            flt->action = action;
            strncpy(flt->to, to, 127);

            filters = g_list_append(filters, flt);
         }
      }
   }
 
   fclose(fp);
   return 1;
}
 
void filters_refresh(void)
{
   GtkWidget *clist;
   GList *tmp;
   struct filter *flt;
   int i = 1;
   gchar *text[1];
 
   clist = get_widget(frmFilters, "filters_clist");
   gtk_clist_clear(GTK_CLIST(clist));

   tmp = filters;
   while(tmp != NULL)
   {
      flt = tmp->data;
      text[0] = flt->name;
      gtk_clist_append(GTK_CLIST(clist), text);
      tmp = tmp->next;
      i++;
   }
}
 
/* returns 1 if a filter was found for the mail , otherwise 0. */
int check_filters(FILE *file)
{
   FILE *folder;
   gint matched = 0;
   gchar buffer[256], c;
   gchar inmatch[256];
   struct filter *flt = NULL;
   gboolean next_field = FALSE;
   GList *tmp;

   fseek(file, 0, SEEK_SET);
   memset(buffer, 0, sizeof(buffer));

   tmp = filters;
   while(tmp != NULL)
   {
      flt = tmp->data;
      while((fgets(buffer, 255, file)))
      {
         if(!g_strncasecmp("Any recipient", flt->in, 13))
         {
            if(!g_strncasecmp("To:", buffer, 3))
               strcpy(inmatch, "To:");
            if(!g_strncasecmp("Cc:", buffer, 3))
               strcpy(inmatch, "Cc:");
         }
         else
            strcpy(inmatch, flt->in);
         if(!g_strncasecmp(inmatch, buffer, strlen(inmatch)))
         {
            strcut(buffer, 0, strlen(inmatch));
            next_field = FALSE;
            do
				{
               trim_whtspc(buffer);
               if(strstrcase(buffer, flt->match) != NULL)
               {
                  matched = flt->action;
                  goto out;
               }
               /* lets peek at the next char */
               c = fgetc(file);
               if (c != '\t' && c != ' ')
                  next_field = TRUE; /* the next line starts a new field... */
               ungetc(c, file); /* put the char back in the stream */
               if (!next_field)
               {
                  memset(buffer, 0, sizeof(buffer));
                  fgets(buffer, 255, file);
               }
            } while (!next_field);   /* this is in case the field got wrapped */
         }
      }
      fseek(file, 0, SEEK_SET);
      tmp = tmp->next;
   }

   out:
   if(matched)
   {
      switch(matched)
      {
            case 1: /* move to folder */
            fseek(file, 0, SEEK_SET);
            folder = fopen(get_mailbox(flt->to), "at+");
            while(fgets(buffer, 255, file))
            {
               fprintf(folder, "%s", buffer);
            }
            fclose(folder);
            break;
         case 2: /* forward - not done yet */
            break;
         case 3: /* delete it - dont have to do anything */
            break;
      }
      return 1;
   }

   return 0;
}
