/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __DATE_H__
#define __DATE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#undef MIN
#undef MAX
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

typedef struct
{
   gchar dow[6];   /* day of week (should only need 4 chars) */
   gint day;
   gint mon;       /* 1->12 or 0 if invalid */
   gint year;
   gint hour;
   gint min;
   gint sec;
   gchar zone[6];  /* time zone */
} date_t;

gint get_days_in_month (gint mon, gint year);
gint get_weekday (gchar *str);
gint get_month (gchar *str);

date_t parse_date (gchar*);
gchar* print_date (struct tm*);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
