/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __COMPOSER_H__
#define __COMPOSER_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#undef MIN
#undef MAX
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "gtkmanip.h"
#include "parse.h"
#include "smtpio.h"

#include "globals.h"
#include "pgp.h"

#include "about.h"
#include "addrbook.h"

GtkWidget* create_frmComposer (gchar *sender, gchar *recipient, gchar *subject, gchar *body);

GtkWidget* create_frmComposeSaveAs (void);

void on_frmComposeSaveAs_destroy (GtkObject *object, gpointer user_data);

void on_cmdCompSaveAs_OK_clicked (GtkButton *button, gpointer user_data);

void on_cmdCompSaveAs_Cancel_clicked (GtkButton *button, gpointer user_data);

void on_frmComposer_destroy (GtkObject *object, gpointer user_data);

void on_frmComposer_show (GtkObject *object, gpointer user_data);

void on_cmdComposerAddrBook_clicked (GtkWidget *txtForm, gpointer user_data);

void on_mnuComposerSend_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_cmdCompSend_clicked (GtkWidget *widget, gpointer data);

void on_mnuComposerSave_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_cmdCompSave_clicked (GtkWidget *widget, gpointer data);

void on_mnuComposerSave_As_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuComposerClose_activate (GtkMenuItem *menuitem, gpointer user_data);

void file_insert_ok (GtkWidget *w, GtkFileSelection *fs);

void on_mnuComposerFile_Insert_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuComposerFile_Attachment_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuComposerFile_Attachment_save (GtkWidget *button, GtkWidget *filesel);

void on_mnuComposerFile_Attachment_cancel (GtkWidget *button, GtkWidget *filesel);

void on_cmdCompAttach_clicked (GtkWidget *widget, gpointer data);

void on_mnuComposerSignature_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuComposerSpruce_Sig_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_mnuComposerAbout_activate (GtkMenuItem *menuitem, gpointer user_data);

void prepare_message (void);

gchar* get_randsig_path (void);
                                      
gint attach_sig(void);

gint attach_sigfile(void);

gint composer_save_email(Email *mesg, gchar *filename, gchar *mode);

gchar* SentMailbox(void);

void on_cmdCompEncrypt_clicked (GtkWidget *widget, gpointer data);

void Composer_PGP_Encrypt (gchar *passphrase);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
