/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "composer.h"
#include "gti.h"

/* icons */
#include "xpm/send.xpm"
#include "xpm/csave.xpm"
#include "xpm/attach.xpm"
#include "xpm/encrypt.xpm"

/* globals for Composer */
static Email message;
static gchar sprucesig[] = ".spruce/sprucesig";
static gchar xmailer[] = "Spruce 0.5.9 for X11";
static gint SaveAsOpen = 0;
static gchar *SaveFile;                       /* file name for email being saved */
static GtkWidget *frmComposeSaveAs;

/* external variables */
extern gboolean AboutOpen;               /* is frmAbout opened?? */
extern GtkWidget *frmAbout;
extern gboolean AddrBookOpen;            /* is frmAddrBook opened?? */
extern GtkWidget *frmAddrBook;
extern gchar *AddrSelected;              /* our returned addr from frmAddrBook */
extern GtkWidget *frmComposer;
extern gboolean ComposerOpen;            /* is frmComposer opened?? */
extern gint use_rand_sig;
extern gint auto_attach_sig;
extern gint save_outgoing;
extern gchar *signaturefile;
extern Server SmtpServer;
extern gchar *SenderAddr;
extern gchar *ReplyTo;
extern gint texticons;

extern gint pgp_sign;
extern gint use_gnupg;
extern gint store_passphrase;
extern gint encrypt_to_self;
extern gchar *pgp_identity;
extern gchar *pgp_passphrase;

extern gchar *mesg_body_font;

extern GList *mime_send_parts;

GtkWidget* create_frmComposer (gchar *sender, gchar *recipient, gchar *subject, gchar *body)
{
  GtkWidget *frmComposer;
  GtkWidget *table1;
  GtkWidget *vbox;
  GtkWidget *tableFrom;
  GtkWidget *lblFrom;
  GtkWidget *txtFrom;
  GtkWidget *table3;
  GtkWidget *lblTo;
  GtkWidget *txtTo;
  GtkWidget *tableCC;
  GtkWidget *lblCC;
  GtkWidget *txtCC;
  GtkWidget *cmdToAddrBook;
  GtkWidget *cmdCCAddrBook;
  GtkWidget *tableSubject;
  GtkWidget *lblSubject;
  GtkWidget *txtSubject;
  GtkWidget *hboxBody;
  GtkWidget *txtBody;
  GtkWidget *vsbBody;
  GtkWidget *scrlMime;
  GtkWidget *clistMime;
  GtkWidget *menubar;
  GtkWidget *mnuFile;
  GtkWidget *mnuFile_menu;
  GtkWidget *mnuComposerSend;
  GtkWidget *mnuComposerSave;
  GtkWidget *mnuComposerSave_As;
  GtkWidget *separator;
  GtkWidget *mnuComposerClose;
  GtkWidget *mnuInsert;
  GtkWidget *mnuInsert_menu;
  GtkWidget *mnuInsertFile;
  GtkWidget *mnuComposerFile_Attachment;
  GtkWidget *separator1;
  GtkWidget *mnuComposerSignature;
  GtkWidget *mnuComposerSpruce_Sig;
  GtkWidget *mnuHelp;
  GtkWidget *mnuHelp_menu;
  GtkWidget *mnuComposerAbout;
  
  GtkWidget *handlebox;
  GtkWidget *toolbar = NULL;
  GtkWidget *iconw;
  GtkWidget *cmdSend, *cmdSave, *cmdAttach, *cmdEncrypt;
  GdkBitmap *mask;
  GdkPixmap *icon;
  
  GdkFont *fixed_font = NULL;

  frmComposer = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (frmComposer, "frmComposer");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "frmComposer", frmComposer);
  gtk_widget_set_usize (frmComposer, 512, 550);
  gtk_signal_connect_object (GTK_OBJECT (frmComposer), "show",
                             GTK_SIGNAL_FUNC (on_frmComposer_show),
                             GTK_OBJECT (frmComposer));
  gtk_signal_connect_object (GTK_OBJECT (frmComposer), "destroy",
                             GTK_SIGNAL_FUNC (on_frmComposer_destroy),
                             GTK_OBJECT (frmComposer));
  gtk_window_set_title (GTK_WINDOW (frmComposer), _("Spruce Composer"));
  gtk_window_set_policy (GTK_WINDOW (frmComposer), TRUE, TRUE, FALSE);
  gtk_widget_realize(frmComposer);

  table1 = gtk_table_new (20, 16, FALSE);
  gtk_widget_set_name (table1, "table1");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "table1", table1);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frmComposer), table1);

  vbox = gtk_vbox_new (TRUE, 0);
  gtk_widget_set_name (vbox, "vbox");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "vbox", vbox);
  gtk_widget_show (vbox);
  gtk_table_attach (GTK_TABLE (table1), vbox, 0, 16, 2, 5,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_FILL, 0, 0);

  tableFrom = gtk_table_new (1, 8, TRUE);
  gtk_widget_set_name (tableFrom, "tableFrom");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "tableFrom", tableFrom);
  gtk_widget_show (tableFrom);
  gtk_box_pack_start (GTK_BOX (vbox), tableFrom, TRUE, TRUE, 0);

  lblFrom = gtk_label_new (_("From:"));
  gtk_widget_set_name (lblFrom, "lblFrom");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "lblFrom", lblFrom);
  gtk_widget_show (lblFrom);
  gtk_table_attach (GTK_TABLE (tableFrom), lblFrom, 0, 1, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  txtFrom = gtk_entry_new ();
  if (sender != NULL)
     gtk_entry_set_text(GTK_ENTRY(txtFrom), (gchar*) sender);
  else
     gtk_entry_set_text(GTK_ENTRY(txtFrom), (gchar*) SenderAddr);
  gtk_widget_set_name (txtFrom, "txtFrom");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "txtFrom", txtFrom);
  gtk_widget_show (txtFrom);
  gtk_table_attach (GTK_TABLE (tableFrom), txtFrom, 1, 7, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  table3 = gtk_table_new (1, 8, TRUE);
  gtk_widget_set_name (table3, "table3");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "table3", table3);
  gtk_widget_show (table3);
  gtk_box_pack_start (GTK_BOX (vbox), table3, TRUE, TRUE, 0);

  txtTo = gtk_entry_new ();
  if (recipient != NULL)
     gtk_entry_set_text(GTK_ENTRY(txtTo), (gchar*) recipient);
  gtk_widget_set_name (txtTo, "txtTo");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "txtTo", txtTo);
  gtk_widget_show (txtTo);
  gtk_table_attach (GTK_TABLE (table3), txtTo, 1, 7, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  lblTo = gtk_label_new (_("To:"));
  gtk_widget_set_name (lblTo, "lblTo");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "lblTo", lblTo);
  gtk_widget_show (lblTo);
  gtk_table_attach (GTK_TABLE (table3), lblTo, 0, 1, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  cmdToAddrBook = gtk_button_new_with_label ("...");
  gtk_widget_set_name (cmdToAddrBook, "cmdToAddrBook");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "cmdToAddrBook", 
		       cmdToAddrBook);
  gtk_widget_show (cmdToAddrBook);
  gtk_table_attach (GTK_TABLE (table3), cmdToAddrBook, 7, 8, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_container_border_width (GTK_CONTAINER (cmdToAddrBook), 4);
  gtk_signal_connect_object (GTK_OBJECT (cmdToAddrBook), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdComposerAddrBook_clicked),
                             GTK_OBJECT (txtTo));

  tableCC = gtk_table_new (1, 8, TRUE);
  gtk_widget_set_name (tableCC, "tableCC");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "tableCC", tableCC);
  gtk_widget_show (tableCC);
  gtk_box_pack_start (GTK_BOX (vbox), tableCC, TRUE, TRUE, 0);

  txtCC = gtk_entry_new ();
  gtk_widget_set_name (txtCC, "txtCC");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "txtCC", txtCC);
  gtk_widget_show (txtCC);
  gtk_table_attach (GTK_TABLE (tableCC), txtCC, 1, 7, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  lblCC = gtk_label_new (_("CC:"));
  gtk_widget_set_name (lblCC, "lblCC");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "lblCC", lblCC);
  gtk_widget_show (lblCC);
  gtk_table_attach (GTK_TABLE (tableCC), lblCC, 0, 1, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  cmdCCAddrBook = gtk_button_new_with_label ("...");
  gtk_widget_set_name (cmdCCAddrBook, "cmdCCAddrBook");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "cmdCCAddrBook", 
		       cmdCCAddrBook);
  gtk_widget_show (cmdCCAddrBook);
  gtk_table_attach (GTK_TABLE (tableCC), cmdCCAddrBook, 7, 8, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_container_border_width (GTK_CONTAINER (cmdCCAddrBook), 4);
  gtk_signal_connect_object (GTK_OBJECT (cmdCCAddrBook), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdComposerAddrBook_clicked),
                             GTK_OBJECT (txtCC));

  tableSubject = gtk_table_new (1, 8, TRUE);
  gtk_widget_set_name (tableSubject, "tableSubject");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "tableSubject", tableSubject);
  gtk_widget_show (tableSubject);
  gtk_box_pack_start (GTK_BOX (vbox), tableSubject, TRUE, TRUE, 0);

  lblSubject = gtk_label_new (_("Subject:"));
  gtk_widget_set_name (lblSubject, "lblSubject");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "lblSubject", lblSubject);
  gtk_widget_show (lblSubject);
  gtk_table_attach (GTK_TABLE (tableSubject), lblSubject, 0, 1, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  txtSubject = gtk_entry_new ();
  if (subject != NULL)
     gtk_entry_set_text(GTK_ENTRY(txtSubject), (gchar*) subject);
  gtk_widget_set_name (txtSubject, "txtSubject");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "txtSubject", txtSubject);
  gtk_widget_show (txtSubject);
  gtk_table_attach (GTK_TABLE (tableSubject), txtSubject, 1, 8, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  hboxBody = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hboxBody, "hboxBody");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "hboxBody", hboxBody);
  gtk_widget_show (hboxBody);
  gtk_table_attach (GTK_TABLE (table1), hboxBody, 0, 16, 5, 18,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);

  /* Load a fixed font. */
  if (mesg_body_font != NULL)
     fixed_font = gdk_font_load (mesg_body_font);

  txtBody = gtk_text_new (NULL, NULL);
  if (body != NULL)
     gti (GTK_TEXT (txtBody), fixed_font, NULL, NULL, 
		      (gchar *)body, -1);
  else
     gti (GTK_TEXT (txtBody), fixed_font, NULL, NULL, 
		      (gchar *)"\n", -1);

  gtk_text_set_point(GTK_TEXT(txtBody), 0);
  gtk_text_set_word_wrap (GTK_TEXT(txtBody), TRUE);
  gtk_editable_set_position (GTK_EDITABLE(txtBody), 0);
  gtk_widget_set_name (txtBody, "txtBody");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "txtBody", txtBody);
  gtk_widget_show (txtBody);
  gtk_box_pack_start (GTK_BOX (hboxBody), txtBody, TRUE, TRUE, 0);
  gtk_text_set_editable (GTK_TEXT (txtBody), TRUE);

  vsbBody = gtk_vscrollbar_new (GTK_TEXT (txtBody)->vadj);
  gtk_widget_set_name (vsbBody, "vsbBody");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "vsbBody", vsbBody);
  gtk_widget_show (vsbBody);
  gtk_box_pack_start (GTK_BOX (hboxBody), vsbBody, FALSE, FALSE, 0);

  scrlMime = gtk_scrolled_window_new (NULL,NULL);
  gtk_widget_set_name (scrlMime, "scrlMime");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "scrlMime", scrlMime);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrlMime), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_show (scrlMime);
  gtk_table_attach (GTK_TABLE (table1), scrlMime, 0, 16, 19, 20,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 
		    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, 0, 0);


  clistMime = gtk_clist_new(2);
  gtk_widget_set_name (clistMime, "clistMime");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "clistMime", clistMime);
  gtk_widget_show (clistMime);
  gtk_clist_set_column_width(GTK_CLIST(clistMime),0,300);
  gtk_clist_set_column_width(GTK_CLIST(clistMime),1,50);
  gtk_container_add (GTK_CONTAINER(scrlMime), clistMime);

  menubar = gtk_menu_bar_new ();
  gtk_widget_set_name (menubar, "menubar");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "menubar", menubar);
  gtk_widget_show (menubar);
  gtk_table_attach (GTK_TABLE (table1), menubar, 0, 16, 0, 1,
                    (GtkAttachOptions) GTK_EXPAND | GTK_FILL, (GtkAttachOptions) 0, 0, 0);

  mnuFile = gtk_menu_item_new_with_label (_("File"));
  gtk_widget_set_name (mnuFile, "mnuFile");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuFile", mnuFile);
  gtk_widget_show (mnuFile);
  gtk_container_add (GTK_CONTAINER (menubar), mnuFile);

  mnuFile_menu = gtk_menu_new ();
  gtk_widget_set_name (mnuFile_menu, "mnuFile_menu");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuFile_menu", mnuFile_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (mnuFile), mnuFile_menu);

  mnuComposerSend = gtk_menu_item_new_with_label (_("Send"));
  gtk_widget_set_name (mnuComposerSend, "mnuComposerSend");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuComposerSend", mnuComposerSend);
  gtk_widget_show (mnuComposerSend);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuComposerSend);
  gtk_signal_connect (GTK_OBJECT (mnuComposerSend), "activate",
                      GTK_SIGNAL_FUNC (on_mnuComposerSend_activate),
                      NULL);

  mnuComposerSave = gtk_menu_item_new_with_label (_("Save"));
  gtk_widget_set_name (mnuComposerSave, "mnuComposerSave");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuComposerSave", mnuComposerSave);
  gtk_widget_show (mnuComposerSave);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuComposerSave);
  gtk_signal_connect (GTK_OBJECT (mnuComposerSave), "activate",
                      GTK_SIGNAL_FUNC (on_mnuComposerSave_activate),
                      NULL);

  mnuComposerSave_As = gtk_menu_item_new_with_label (_("Save As..."));
  gtk_widget_set_name (mnuComposerSave_As, "mnuComposerSave_As");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuComposerSave_As", mnuComposerSave_As);
  gtk_widget_show (mnuComposerSave_As);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuComposerSave_As);
  gtk_signal_connect (GTK_OBJECT (mnuComposerSave_As), "activate",
                      GTK_SIGNAL_FUNC (on_mnuComposerSave_As_activate),
                      NULL);

  separator = gtk_menu_item_new ();
  gtk_widget_set_name (separator, "separator");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "separator", separator);
  gtk_widget_show (separator);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), separator);

  mnuComposerClose = gtk_menu_item_new_with_label (_("Close"));
  gtk_widget_set_name (mnuComposerClose, "mnuComposerClose");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuComposerClose", mnuComposerClose);
  gtk_widget_show (mnuComposerClose);
  gtk_container_add (GTK_CONTAINER (mnuFile_menu), mnuComposerClose);
  gtk_signal_connect (GTK_OBJECT (mnuComposerClose), "activate",
                      GTK_SIGNAL_FUNC (on_mnuComposerClose_activate),
                      NULL);

  mnuInsert = gtk_menu_item_new_with_label (_("Insert"));
  gtk_widget_set_name (mnuInsert, "mnuInsert");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuInsert", mnuInsert);
  gtk_widget_show (mnuInsert);
  gtk_container_add (GTK_CONTAINER (menubar), mnuInsert);

  mnuInsert_menu = gtk_menu_new ();
  gtk_widget_set_name (mnuInsert_menu, "mnuInsert_menu");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuInsert_menu", mnuInsert_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (mnuInsert), mnuInsert_menu);

  mnuInsertFile = gtk_menu_item_new_with_label (_("Insert File..."));
  gtk_widget_set_name (mnuInsertFile, "mnuInsertFile");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuInsertFile", mnuInsertFile);
  gtk_widget_show (mnuInsertFile);
  gtk_container_add (GTK_CONTAINER (mnuInsert_menu), mnuInsertFile);
  gtk_signal_connect (GTK_OBJECT (mnuInsertFile), "activate", GTK_SIGNAL_FUNC (on_mnuComposerFile_Insert_activate), NULL);
  
  mnuComposerFile_Attachment = gtk_menu_item_new_with_label (_("File Attachment"));
  gtk_widget_set_name (mnuComposerFile_Attachment, "mnuComposerFile_Attachment");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuComposerFile_Attachment", mnuComposerFile_Attachment);
  gtk_widget_show (mnuComposerFile_Attachment);
  gtk_container_add (GTK_CONTAINER (mnuInsert_menu), mnuComposerFile_Attachment);
  gtk_signal_connect (GTK_OBJECT (mnuComposerFile_Attachment), "activate",
                      GTK_SIGNAL_FUNC (on_mnuComposerFile_Attachment_activate),
                      NULL);

  separator1 = gtk_menu_item_new ();
  gtk_widget_set_name (separator1, "separator1");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "separator1", separator1);
  gtk_widget_show (separator1);
  gtk_container_add (GTK_CONTAINER (mnuInsert_menu), separator1);

  mnuComposerSignature = gtk_menu_item_new_with_label (_("Signature"));
  gtk_widget_set_name (mnuComposerSignature, "mnuComposerSignature");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuComposerSignature", mnuComposerSignature);
  gtk_widget_show (mnuComposerSignature);
  gtk_container_add (GTK_CONTAINER (mnuInsert_menu), mnuComposerSignature);
  gtk_signal_connect (GTK_OBJECT (mnuComposerSignature), "activate",
                      GTK_SIGNAL_FUNC (on_mnuComposerSignature_activate),
                      NULL);

  mnuComposerSpruce_Sig = gtk_menu_item_new_with_label (_("Spruce Sig"));
  gtk_widget_set_name (mnuComposerSpruce_Sig, "mnuComposerSpruce_Sig");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuComposerSpruce_Sig", mnuComposerSpruce_Sig);
  gtk_widget_show (mnuComposerSpruce_Sig);
  gtk_container_add (GTK_CONTAINER (mnuInsert_menu), mnuComposerSpruce_Sig);
  gtk_signal_connect (GTK_OBJECT (mnuComposerSpruce_Sig), "activate",
                      GTK_SIGNAL_FUNC (on_mnuComposerSpruce_Sig_activate),
                      NULL);

  mnuHelp = gtk_menu_item_new_with_label (_("Help"));
  gtk_widget_set_name (mnuHelp, "mnuHelp");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuHelp", mnuHelp);
  gtk_widget_show (mnuHelp);
  gtk_container_add (GTK_CONTAINER (menubar), mnuHelp);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (mnuHelp));

  mnuHelp_menu = gtk_menu_new ();
  gtk_widget_set_name (mnuHelp_menu, "mnuHelp_menu");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuHelp_menu", mnuHelp_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (mnuHelp), mnuHelp_menu);

  mnuComposerAbout = gtk_menu_item_new_with_label (_("About..."));
  gtk_widget_set_name (mnuComposerAbout, "mnuComposerAbout");
  gtk_object_set_data (GTK_OBJECT (frmComposer), "mnuComposerAbout", mnuComposerAbout);
  gtk_widget_show (mnuComposerAbout);
  gtk_container_add (GTK_CONTAINER (mnuHelp_menu), mnuComposerAbout);
  gtk_signal_connect (GTK_OBJECT (mnuComposerAbout), "activate",
                      GTK_SIGNAL_FUNC (on_mnuComposerAbout_activate),
                      NULL);
  
  handlebox = gtk_handle_box_new();
  gtk_table_attach(GTK_TABLE(table1), handlebox, 0, 16, 1, 2,
         (GtkAttachOptions) GTK_EXPAND | GTK_FILL, FALSE, 0, 0);
  gtk_widget_show(handlebox);
  
  switch (texticons)
  {
     case (TB_TEXT):
        toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_TEXT);
        break;
     case (TB_ICONS):
        toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
        break;
     case (TB_BOTH):
        toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
        break;
  }
  /* Smoother button bar */
  gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar),GTK_RELIEF_NONE);

  gtk_container_set_border_width (GTK_CONTAINER (toolbar), 2);
  gtk_toolbar_set_space_size (GTK_TOOLBAR (toolbar), 2);
  gtk_container_add (GTK_CONTAINER (handlebox), toolbar);
  gtk_widget_show(toolbar);
  
  icon = gdk_pixmap_create_from_xpm_d (frmComposer->window, &mask,
               &frmComposer->style->white, send_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdSend = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Send"), _("Send Message"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdCompSend_clicked), toolbar);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  
  icon = gdk_pixmap_create_from_xpm_d (frmComposer->window, &mask,
               &frmComposer->style->white, csave_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdSave = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Save"), _("Save Message"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdCompSave_clicked), toolbar);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  icon = gdk_pixmap_create_from_xpm_d (frmComposer->window, &mask,
               &frmComposer->style->white, attach_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdAttach = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Attach"), _("Attach File"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdCompAttach_clicked), toolbar);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  
  icon = gdk_pixmap_create_from_xpm_d (frmComposer->window, &mask,
               &frmComposer->style->white, encrypt_xpm);
  iconw = gtk_pixmap_new(icon, mask);
  cmdEncrypt = gtk_toolbar_append_element(GTK_TOOLBAR(toolbar),
               GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Encrypt"), _("PGP Encrypt"), "Private",
               iconw, GTK_SIGNAL_FUNC(on_cmdCompEncrypt_clicked), toolbar);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  
  message.status = UNDELIVERED;

  return frmComposer;
}

GtkWidget* create_frmComposeSaveAs ()
{
  GtkWidget *frmComposeSaveAs;
  GtkWidget *cmdCompSaveAs_OK;
  GtkWidget *cmdCompSaveAs_Cancel;

  frmComposeSaveAs = gtk_file_selection_new (_("Save Composition As..."));
  gtk_widget_set_name (frmComposeSaveAs, "frmComposeSaveAs");
  gtk_object_set_data (GTK_OBJECT (frmComposeSaveAs), "frmComposeSaveAs", frmComposeSaveAs);
  gtk_container_border_width (GTK_CONTAINER (frmComposeSaveAs), 10);
  gtk_signal_connect_object (GTK_OBJECT (frmComposeSaveAs), "destroy",
                             GTK_SIGNAL_FUNC (on_frmComposeSaveAs_destroy),
                             GTK_OBJECT (frmComposeSaveAs));

  cmdCompSaveAs_OK = GTK_FILE_SELECTION (frmComposeSaveAs)->ok_button;
  gtk_widget_set_name (cmdCompSaveAs_OK, "cmdCompSaveAs_OK");
  gtk_object_set_data (GTK_OBJECT (frmComposeSaveAs), "cmdCompSaveAs_OK", cmdCompSaveAs_OK);
  gtk_widget_show (cmdCompSaveAs_OK);
  GTK_WIDGET_SET_FLAGS (cmdCompSaveAs_OK, GTK_CAN_DEFAULT);
  gtk_signal_connect_object (GTK_OBJECT (cmdCompSaveAs_OK), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdCompSaveAs_OK_clicked),
                             GTK_OBJECT (cmdCompSaveAs_OK));

  cmdCompSaveAs_Cancel = GTK_FILE_SELECTION (frmComposeSaveAs)->cancel_button;
  gtk_widget_set_name (cmdCompSaveAs_Cancel, "cmdCompSaveAs_Cancel");
  gtk_object_set_data (GTK_OBJECT (frmComposeSaveAs), "cmdCompSaveAs_Cancel", cmdCompSaveAs_Cancel);
  gtk_widget_show (cmdCompSaveAs_Cancel);
  GTK_WIDGET_SET_FLAGS (cmdCompSaveAs_Cancel, GTK_CAN_DEFAULT);
  gtk_signal_connect_object (GTK_OBJECT (cmdCompSaveAs_Cancel), "clicked",
                             GTK_SIGNAL_FUNC (on_cmdCompSaveAs_Cancel_clicked),
                             GTK_OBJECT (cmdCompSaveAs_Cancel));

  return frmComposeSaveAs;
}

void on_frmComposeSaveAs_destroy (GtkObject *object, gpointer user_data)
{
   gtk_widget_destroy(frmComposeSaveAs);
   SaveAsOpen = FALSE;
}

void on_cmdCompSaveAs_OK_clicked (GtkButton *button, gpointer user_data)
{
   if (SaveFile != NULL)
      g_free(SaveFile);

   SaveFile = g_malloc0(strlen(gtk_file_selection_get_filename(GTK_FILE_SELECTION(frmComposeSaveAs))) + 1);
   strcpy(SaveFile, gtk_file_selection_get_filename(GTK_FILE_SELECTION(frmComposeSaveAs)));
   composer_save_email(&message, SaveFile, "wt");
  
   gtk_widget_destroy(frmComposeSaveAs);
   SaveAsOpen = FALSE;
}

void on_cmdCompSaveAs_Cancel_clicked (GtkButton *button, gpointer user_data)
{
   gtk_widget_destroy(frmComposeSaveAs);
   SaveAsOpen = FALSE;
}

void on_frmComposer_destroy (GtkObject *object, gpointer user_data)
{
   GList *tmp;

   tmp = mime_send_parts;
   while (tmp != NULL)
   {
      g_free(tmp->data);
      tmp = tmp->next;
   }
   g_list_free (mime_send_parts);
   mime_send_parts = NULL;
   
   gtk_widget_destroy(frmComposer);
   ComposerOpen = FALSE;
}

void on_frmComposer_show (GtkObject *object, gpointer user_data)
{
   if (auto_attach_sig)
   {
      if (use_rand_sig)
         attach_sig();
      else
         attach_sigfile();
   }
}

void on_cmdComposerAddrBook_clicked (GtkWidget *txtField, gpointer user_data)
{
   if (!AddrBookOpen)
   {
      frmAddrBook = create_frmAddrBook(txtField);
      gtk_widget_show(frmAddrBook);
      AddrBookOpen = TRUE;
   }
}

void on_mnuComposerSend_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   gchar reason[50];
   gchar *mailbox;

   prepare_message();
   
   fprintf(stderr, "Sending message...");
   fflush(stderr);

   send_message(&SmtpServer, &message);   
	
   /* if status is DELIVERED, set it to NULL. 
    * if status is DELIVERING, set it to UNDELIVERED */
   if ( (message.status = (message.status ^ DELIVERED)) )
   {
      smtperror(reason, 49);
      fprintf(stderr, "failed.\nSpruce%s\n", reason);
      fflush(stdout);
      return;
   }
	
   fprintf(stderr, "sent.\n");
   fflush(stderr);

   if (save_outgoing)
   {
      mailbox = SentMailbox();
      composer_save_email(&message, mailbox, "at");
      g_free(mailbox);
   }	

   email_destroy(&message);
   
   gtk_widget_destroy(frmComposer);
   ComposerOpen = FALSE;
}

void on_cmdCompSend_clicked (GtkWidget *widget, gpointer data)
{
   on_mnuComposerSend_activate((GtkMenuItem *)NULL, data);
}

void on_mnuComposerSave_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   if (!SaveAsOpen)
   {
      if (SaveFile == NULL)
      {
         frmComposeSaveAs = create_frmComposeSaveAs();
         gtk_widget_show(frmComposeSaveAs);
         SaveAsOpen = 1;
      }
      else
	      composer_save_email(&message, SaveFile, "wt");
   }
}

void on_cmdCompSave_clicked (GtkWidget *widget, gpointer data)
{
   if(!SaveAsOpen)
   {
      if(SaveFile == NULL)
      {
         frmComposeSaveAs = create_frmComposeSaveAs();
         gtk_widget_show(frmComposeSaveAs);
         SaveAsOpen = TRUE;
      }
      else
	      composer_save_email(&message, SaveFile, "wt");
   }
}

void on_mnuComposerSave_As_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   if (!SaveAsOpen)
   {
      frmComposeSaveAs = create_frmComposeSaveAs();
      gtk_widget_show(frmComposeSaveAs);
      SaveAsOpen = TRUE;
   }
}

void on_mnuComposerClose_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   gtk_widget_destroy(frmComposer);
   ComposerOpen = FALSE;
}

void file_insert_ok (GtkWidget *w, GtkFileSelection *fs)
{
   GtkWidget *txtBody = get_widget(frmComposer, "txtBody");
   GdkFont *fixed_font = NULL;
   gchar buffer[257];
   FILE *fp;

   fp = fopen(gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)), "rt");
   if(fp == NULL)
   {
      fprintf(stderr, "Spruce: %s not found.\n", gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
      return;
   }

   /* Load a fixed font */
   if (mesg_body_font != NULL)
      fixed_font = gdk_font_load (mesg_body_font);
	
   gtk_text_freeze(GTK_TEXT(txtBody));
   while (!feof(fp))
   {
      memset(buffer, 0, 257);
      fgets(buffer, 256, fp);
      gti (GTK_TEXT (txtBody), fixed_font, &txtBody->style->black, NULL, buffer, -1);
      gtk_text_set_point(GTK_TEXT (txtBody), gtk_text_get_length(GTK_TEXT(txtBody)));
   }
   gtk_text_thaw(GTK_TEXT(txtBody));
   fclose(fp);

   gtk_widget_destroy (GTK_WIDGET(fs));
}

void on_mnuComposerFile_Insert_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   GtkWidget *filew = gtk_file_selection_new (_("Select file to insert"));

   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filew)->ok_button), "clicked", 
                      GTK_SIGNAL_FUNC(file_insert_ok), filew);
   gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION(filew)->cancel_button), "clicked",
                             GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(filew));
   gtk_widget_show(filew);
}

void on_mnuComposerFile_Attachment_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *filesel;

	filesel = gtk_file_selection_new (_("Filename"));
	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button), "clicked",
                       GTK_SIGNAL_FUNC(on_mnuComposerFile_Attachment_save), filesel);
	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->cancel_button), "clicked",
                       GTK_SIGNAL_FUNC(on_mnuComposerFile_Attachment_cancel), filesel);

	gtk_widget_show (filesel);
}

void on_mnuComposerFile_Attachment_save (GtkWidget *button, GtkWidget *filesel)
{
	gchar *file;
	gchar *filename;
	GtkWidget *clistMime = get_widget(frmComposer, "clistMime");
	gchar *text[2];
	gchar temp[32];
	gint ret;
	struct stat st;

	file = gtk_file_selection_get_filename (GTK_FILE_SELECTION (filesel));
	
	filename = g_malloc0(strlen(file) + 1);
	strcpy (filename, file);
	mime_send_parts = g_list_append (mime_send_parts, filename);

	ret = stat(file, &st);
	if(ret < 0)
		perror("stat");
	
	sprintf(temp, "%d", (gint)st.st_size);

	text[0] = file;
	text[1] = temp;
	
	gtk_clist_append (GTK_CLIST (clistMime), text);
	
	gtk_widget_destroy (filesel);
}

void on_mnuComposerFile_Attachment_cancel (GtkWidget *button, GtkWidget *filesel)
{
	gtk_widget_destroy (filesel);
}

void on_cmdCompAttach_clicked (GtkWidget *widget, gpointer data)
{
	on_mnuComposerFile_Attachment_activate(NULL, NULL);
}

void on_mnuComposerSignature_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   GtkWidget *txtBody = get_widget(frmComposer, "txtBody");
   GdkFont *fixed_font = NULL;
   gchar buffer[257];
   FILE *fp;

   fp = fopen(signaturefile, "rt");
   if(fp == NULL)
   {
      fprintf(stderr, "Spruce: %s not found.\n", signaturefile);
      return;
   }

   /* Load a fixed font */
   if (mesg_body_font != NULL)
      fixed_font = gdk_font_load (mesg_body_font);

	gtk_text_freeze(GTK_TEXT(txtBody));

   gtk_text_set_point(GTK_TEXT (txtBody), gtk_text_get_length(GTK_TEXT(txtBody)));
   gti (GTK_TEXT (txtBody), fixed_font, &txtBody->style->black,
                              NULL, "\n-- \n", -1);
 
   while (!feof(fp))
	{
      memset(buffer, 0, 257);
      fgets(buffer, 256, fp);
      gtk_text_set_point(GTK_TEXT (txtBody), gtk_text_get_length(GTK_TEXT(txtBody)));
      gti (GTK_TEXT (txtBody), fixed_font, &txtBody->style->black,
                                 NULL, buffer, -1);
	}

   gtk_text_thaw(GTK_TEXT(txtBody));

   fclose(fp);
}

void on_mnuComposerSpruce_Sig_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   GtkWidget *txtBody = get_widget(frmComposer, "txtBody");
   GdkFont *fixed_font = NULL;
   gchar buffer[256];
   gchar *sig_file = get_randsig_path();
   long line, numlines;
   FILE *fp;
	
   srand((unsigned) time(0));   /* randomize the seed */
	
   fp = fopen(sig_file, "rt");
   if(fp == NULL)
   {
      fp = fopen("/etc/sprucesig", "rt");
      if (fp == NULL)
		{
         fprintf(stderr, "Could not attach random signature: %s not found.\n", sig_file);
         return;
		}
   }

   for(numlines = 0; !feof(fp); numlines++)
      fgets(buffer, 256, fp);

   line = rand() % numlines;
   fseek(fp, 0, SEEK_SET);       /* rewind to beginning of file */

   /* Load a fixed font */
   if (mesg_body_font != NULL)
      fixed_font = gdk_font_load (mesg_body_font);
	
   for(numlines = 0; numlines < line; numlines++)
      fgets(buffer, 256, fp);

   gtk_text_freeze(GTK_TEXT(txtBody));
   gtk_text_set_point(GTK_TEXT (txtBody), gtk_text_get_length(GTK_TEXT(txtBody)));
   gti (GTK_TEXT (txtBody), fixed_font, NULL, NULL, "\n-- \n", -1);
   gti (GTK_TEXT (txtBody), fixed_font, NULL, NULL, buffer, -1);
   gtk_text_thaw(GTK_TEXT(txtBody));

   fclose(fp);

   g_free(sig_file);
}

void on_mnuComposerAbout_activate (GtkMenuItem *menuitem, gpointer user_data)
{
   if(!AboutOpen)
	{
      frmAbout = create_frmAbout();
      gtk_widget_show(frmAbout);
      AboutOpen = TRUE;
	}
}

void prepare_message()
{
   GtkWidget *txtFrom    = get_widget(frmComposer, "txtFrom");
   GtkWidget *txtTo      = get_widget(frmComposer, "txtTo");
   GtkWidget *txtCC      = get_widget(frmComposer, "txtCC");
   GtkWidget *txtSubject = get_widget(frmComposer, "txtSubject");
   GtkWidget *txtBody    = get_widget(frmComposer, "txtBody");
   gchar *buffer = NULL;
   gchar *boundary = NULL, *body;
   gint index;
   gchar addr[256];
   gint fields, i;
   GList *tmp;
 
   if (message.status & UNDELIVERED)
   {
      /* Setup the X-Mailer information. */
      message.xmailer = g_strdup(xmailer);

      /* Setup the From field of the message. */
      buffer = make_8bit(gtk_entry_get_text(GTK_ENTRY(txtFrom)));
      trim_whtspc(buffer);
      message.from = g_strdup(buffer);
      g_free(buffer);
   
      /* Setup the To field of the message. */
      buffer = make_8bit(gtk_entry_get_text(GTK_ENTRY(txtTo)));
      trim_whtspc(buffer);
      message.to = g_strdup(buffer);
      g_free(buffer);
	
      /* Setup the CC field of the message. */
      gtk_editable_set_position(GTK_EDITABLE(txtCC), -1);
      if (gtk_editable_get_position(GTK_EDITABLE(txtCC)) > 1)
      {
         buffer = gtk_editable_get_chars(GTK_EDITABLE(txtCC), 0, -1);
         trim_whtspc(buffer);
         if (buffer == (gchar*) NULL)
            message.cc = (gchar*) NULL;
         else
         {
            message.cc = make_8bit(buffer);
            g_free(buffer);
         }
      }
      else
         message.cc = (gchar*) NULL;

      /* Setup the subject of the message. */
      buffer = make_8bit(gtk_entry_get_text(GTK_ENTRY(txtSubject)));
      trim_whtspc(buffer);
      message.subject = g_strdup(buffer);
      g_free(buffer);

      /* Set the body of the message into the structure */
      if (g_list_length (mime_send_parts) > 0)
      {
         boundary = g_strdup(mime_get_boundary());
         body = g_malloc0(200 + strlen(boundary) + strlen(gtk_editable_get_chars(GTK_EDITABLE(txtBody), 0, -1)));
         index = 0;
         index += sprintf(body, "This is a multi-part message in MIME format.\n\n");
         buffer = g_strdup(gtk_editable_get_chars(GTK_EDITABLE(txtBody), 0, -1));
         index += sprintf(body+index, "--%s\n",boundary);
         index += sprintf(body+index, "Content-Type: text/plain\nContent-Transfer-Type: 8bit\n\n%s",word_wrap(buffer, 80));
         g_free(buffer);
         tmp = mime_send_parts;
         while (tmp != NULL)
         {
            index += mime_insert_part (&body, index, boundary, (gchar *)tmp->data);
            tmp = tmp->next;
         }
         body = g_realloc(body, strlen(body) + strlen(boundary) + 7);
         /* insert the end marking boundary */
         sprintf(body + index, "--%s--\n", boundary);
         body[index + 2 + strlen(boundary) + 3] = '\0';
         message.body = g_strdup(body);
         g_free(body);
      }
      else
      {
          message.body = word_wrap(g_strdup(gtk_editable_get_chars(GTK_EDITABLE(txtBody), 0, -1)), 80);
      }
      /* Set sender's email address. */
      get_email_addr_from_text(addr, message.from);
      message.from_addr = g_strdup(addr);

      /* Set CC email address. */
      message.cc_addr = (gchar*) NULL;
      fields = get_num_fields(message.cc, ';');
      for (i = 1; i <= fields; i++)
      {
         buffer = get_field(message.cc, i, ';');
         memset(addr, 0, sizeof(addr));
         get_email_addr_from_text(addr, buffer);
         g_free(buffer);
         if (i == 1)
         {
            message.cc_addr = g_strdup(addr);
         }
         else
         {
            message.cc_addr = g_realloc(message.cc_addr, strlen(message.cc_addr) + strlen(addr) + 2);
            strcat(message.cc_addr, ";");
            strcat(message.cc_addr, addr);
         }
      }

      /* setup the mime stuff */
      if (g_list_length (mime_send_parts) > 0)
      {
         message.mime_version = g_strdup ("1.0");
         buffer = g_malloc0(sizeof(char)*76);
         sprintf(buffer, "multipart/mixed; boundary=\"%s\"", boundary);
         message.content_transfer_encoding = NULL;
         message.content_type = g_strdup(buffer);
         g_free(buffer);
      }
      else
      {
         /* for now we just use this, later on we should autodetect
          * if its 7bit or 8bit or if we should use quoted_printable etc.. */
         message.mime_version = g_strdup ("1.0");
         message.content_transfer_encoding = g_strdup ("8bit");
         message.content_type = g_strdup ("text/plain; charset=\"iso8859-1\"");
      }

      /* setup the Reply-To information... */
      if (ReplyTo != NULL)
         message.replyto = g_strdup(ReplyTo);
      else
         message.replyto = g_strdup(message.from_addr);

      /* Now that we have the Reply-To addr, we can format the header 
        information... */
      format_header(&message);

      /* Parse for each recipient and add them to the list */
      fields = get_num_fields(message.to, ';');
      for (i = 1; i <= fields; i++)
      {
         buffer = get_field(message.to, i, ';');
         memset(addr, 0, sizeof(addr));
         get_email_addr_from_text(addr, buffer);
         g_free(buffer);
         if (i == 1)
         {
            message.to_addr = g_strdup(addr);
         }
         else
         {
            message.to_addr = g_realloc(message.to_addr, strlen(message.to_addr) + strlen(addr) + 2);
            strcat(message.to_addr, ";");
            strcat(message.to_addr, addr);
         }
      }

      g_free(boundary);
   }
}

gchar* get_randsig_path()
{
   gchar *home_dir;
   gchar *buffer;

   home_dir = getenv("HOME");

   buffer = g_malloc0(strlen(home_dir) + 1 + strlen(sprucesig) + 1);
   sprintf(buffer, "%s/%s", home_dir, sprucesig);

   return buffer;	
}

gint attach_sig()
{
   GtkWidget *txtBody = get_widget(frmComposer, "txtBody");
   GdkFont *fixed_font = NULL;
   gchar buffer[513];
   gchar *sig_file = get_randsig_path();
   long line, numlines;
   FILE *fp;
	
   srand((unsigned) time(0));   /* randomize the seed */
	
   fp = fopen(sig_file, "rt");
   if(fp == NULL)
   {
      fp = fopen("/etc/sprucesig", "rt");
      if (fp == NULL)
		{
         fprintf(stderr, "Could not attach random signature: %s not found.\n", sig_file);
         return 0;
		}
   }

   for(numlines = 0; !feof(fp); numlines++)
      fgets(buffer, 512, fp);

   line = rand() % numlines;
   fseek(fp, 0, SEEK_SET);       /* rewind to beginning of file */
	
   for (numlines = 0; numlines < line; numlines++)
      fgets(buffer, 512, fp);

   /* Load a fixed font */
   if (mesg_body_font != NULL)
      fixed_font = gdk_font_load (mesg_body_font);

   gtk_text_freeze(GTK_TEXT(txtBody));
   gtk_text_set_point(GTK_TEXT (txtBody), gtk_text_get_length(GTK_TEXT(txtBody)));
   gti (GTK_TEXT (txtBody), fixed_font, NULL, NULL, "\n-- \n", -1);
   gti (GTK_TEXT (txtBody), fixed_font, NULL, NULL, buffer, -1);
   gtk_text_thaw(GTK_TEXT(txtBody));

   fclose(fp);

   g_free(sig_file);
   
   return 1;
}

gint attach_sigfile()
{
   GtkWidget *txtBody = get_widget(frmComposer, "txtBody");
   GdkFont *fixed_font = NULL;
   gchar buffer[257];
   FILE *fp;

   fp = fopen(signaturefile, "rt");
   if(fp == NULL)
   {
      fprintf(stderr, "Spruce: %s not found.\n", signaturefile);
      return 0;
   }

   gtk_text_freeze(GTK_TEXT(txtBody));

   /* Load a fixed font */
   if (mesg_body_font != NULL)
      fixed_font = gdk_font_load (mesg_body_font);	

   gtk_text_set_point(GTK_TEXT (txtBody), gtk_text_get_length(GTK_TEXT(txtBody)));
   gti (GTK_TEXT (txtBody), fixed_font, &txtBody->style->black,
                              NULL, "\n-- \n", -1);
 
   while (!feof(fp))
	{
      memset(buffer, 0, 257);
      fgets(buffer, 256, fp);
      gtk_text_set_point(GTK_TEXT (txtBody), gtk_text_get_length(GTK_TEXT(txtBody)));
      gti (GTK_TEXT (txtBody), fixed_font, &txtBody->style->black,
                                 NULL, buffer, -1);
	}

   gtk_text_thaw(GTK_TEXT(txtBody));

   fclose(fp);
   
   return 0;
}

gint composer_save_email(Email *mesg, gchar *filename, gchar *mode)
{
   FILE *fp;

   fp = fopen(filename, mode);
   if (fp == NULL)
   {
      fprintf(stderr, "Warning: %s failed for writing.\n", filename);
      return 0;
   }

   if (!strcmp(mode, "wt"))
   {
      /* we are not saving into Sent items... */
      prepare_message();
   }

   format_header(mesg);
   fprintf(fp, "%s\n\n", mesg->header);
   fflush(fp);
   fprintf(fp, "%s", mesg->body);
   fflush(fp);
   fprintf(fp, "\n.\r\n");
   fflush(fp);

   fclose(fp);

   if (!strcmp(mode, "wt"))
   {
      /* we are not saving into Sent items... */
      email_destroy(mesg);
      mesg->status = UNDELIVERED;
   }

   return 1;
}

gchar* SentMailbox()
{
   gchar *home_dir;
   gchar *buffer;

   home_dir = g_strdup(getenv("HOME"));
   buffer = g_malloc0(strlen(home_dir) + strlen("/.spruce/Sent_items.mbx") + 1);
   sprintf(buffer, "%s/.spruce/Sent_items.mbx", home_dir);

   g_free(home_dir);

   return buffer;	
}

void on_cmdCompEncrypt_clicked(GtkWidget *widget, gpointer data)
{
   if (pgp_passphrase == NULL)
   {
      /* get the passphrase */
   }
   else
   {
      Composer_PGP_Encrypt(pgp_passphrase);
   }
}

void Composer_PGP_Encrypt (gchar *passphrase)
{
   GtkWidget *txtBody = get_widget(frmComposer, "txtBody");
   GtkWidget *txtTo   = get_widget(frmComposer, "txtTo");
   GtkWidget *txtCC   = get_widget(frmComposer, "txtCC");
   GdkFont *fixed_font = NULL;
   gchar recipients[2049];
   gchar recip[256];
   gchar *recip_buffer, *cc_buffer, *buff;
   gchar *text;
   gchar *pgpd_mesg;
   guint len;
   guint num, i;

   memset(recipients, 0, sizeof(recipients));

   text = gtk_editable_get_chars(GTK_EDITABLE(txtBody), 0, -1);
   recip_buffer = gtk_editable_get_chars(GTK_EDITABLE(txtTo), 0, -1);
   cc_buffer = gtk_editable_get_chars(GTK_EDITABLE(txtCC), 0, -1);

   if (cc_buffer != (gchar *)NULL)
   {
       unsigned int recip_size = strlen(recip_buffer);
       unsigned int cc_size = strlen(cc_buffer);

       if (cc_size > 0)
       {
          recip_buffer = g_realloc(recip_buffer, recip_size + cc_size + 2);
          g_snprintf(recip_buffer, recip_size + cc_size + 2, "%s;%s", recip_buffer, cc_buffer);
       }

       g_free(cc_buffer);
       cc_buffer = (gchar *)NULL;
   }
   
   /* make the recipients list */
   num = get_num_fields(recip_buffer, ';');
   for (i = 1; i <= num; i++)
   {
      buff = get_field(recip_buffer, i, ';');
      get_email_addr_from_text (recip, buff);
      if (i > 1)
         strncat(recipients, " ", sizeof(recipients)-1);
      strncat(recipients, recip, sizeof(recipients)-1);
      g_free(buff);
   }

   g_free(recip_buffer);

   if (encrypt_to_self)
   {
      strncat(recipients, " ", sizeof(recipients)-1);
      strncat(recipients, pgp_identity, sizeof(recipients)-1);
   }

   pgpd_mesg = pgp_encrypt(text, recipients, passphrase, use_gnupg, pgp_sign);
   g_free(text);

   if (pgpd_mesg == NULL)
      return;

   /* Load a fixed font */
   if (mesg_body_font != NULL)
      fixed_font = gdk_font_load (mesg_body_font);

   gtk_text_freeze(GTK_TEXT(txtBody));

   /* delete all the the text in there */
   len = gtk_text_get_length(GTK_TEXT(txtBody));
   gtk_text_set_point(GTK_TEXT(txtBody), len);
   gtk_text_backward_delete(GTK_TEXT(txtBody), len);

   gti (GTK_TEXT (txtBody), fixed_font, NULL, NULL, pgpd_mesg, -1);
   g_free(pgpd_mesg);

   gtk_text_thaw(GTK_TEXT(txtBody));
}
