.\"
.\" %nmhwarning%
.\" $Id: forw.man,v 1.1.1.1 1999/04/30 18:08:36 doug Exp $
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH FORW %manext1% MH.6.8 [%nmhversion%]
.SH NAME
forw \- forward messages
.SH SYNOPSIS
.in +.5i
.ti -.5i
forw
\%[+folder] \%[msgs]
.br
\%[\-annotate] \%[\-noannotate]
\%[\-form\ formfile]
.br
\%[\-format] \%[\-noformat]
\%[\-filter\ filterfile]
.br
\%[\-inplace] \%[\-noinplace]
\%[\-mime] \%[\-nomime]
.br
\%[\-draftfolder\ +folder] \%[\-draftmessage\ msg]
.br
\%[\-nodraftfolder]
\%[\-editor\ editor] \%[\-noedit]
.br
\%[\-whatnowproc\ program] \%[\-nowhatnowproc]
.br
\%[\-dashstuffing] \%[\-nodashstuffing]
\%[\-version]
\%[\-help]

.ti .5i
forw
\%[+folder] \%[msgs]
\%[\-digest\ list] \%[\-issue\ number]
.br
\%[\-volume\ number]
\%[other\ switches\ for\ \fIforw\fR]
\%[\-help]
.in -.5i
.SH DESCRIPTION
\fIForw\fR may be used to prepare a message containing other messages.

It constructs the new message from a forms (components) file, with a
body composed of the message(s) to be forwarded.  An editor is invoked
as in \fIcomp\fR, and after editing is complete, the user is prompted
before the message is sent.

The default message form contains the following elements:

.nf
.in +.5i
.ne 10
.eo
.so %etcdir%/forwcomps
.ec
.in -.5i
.fi

If a file named \*(lqforwcomps\*(rq exists in the user's nmh directory,
it will be used instead of this default form.  You may also specify an
alternate forms file with the switch `\-form\ formfile'.

When If the draft already exists, \fIforw\fR will ask you as to the disposition
of the draft.  A reply of \fBquit\fR will abort \fIforw\fR, leaving the
draft intact; \fBreplace\fR will replace the existing draft with a blank
skeleton; and \fBlist\fR will display the draft.

If the `\-annotate' switch is given, each message being forwarded will
be annotated with the lines

     Forwarded:\ date
     Forwarded:\ addrs

where each address list contains as many lines as required.  This
annotation will be done only if the message is sent directly from
\fIforw\fR.  If the message is not sent immediately from \fIforw\fR,
\*(lqcomp\ \-use\*(rq may be used to re\-edit and send the constructed
message, but the annotations won't take place.  Normally annotations
are done inplace in order to preserve any links to the message.  You may
change this by using the '\-noinplace' switch.

See \fIcomp\fR\0(1) for a description of the `\-editor' and `\-noedit'
switches.

Although \fIforw\fR uses a forms (components) file to direct it how to
construct the beginning of the draft, it uses a message filter file to
direct it as to how each forwarded message should be formatted in the
body of the draft.  The filter file for \fIforw\fR should be a standard
form file for \fImhl\fR, as \fIforw\fR will invoke \fImhl\fR to filter
(re\-format) the forwarded messages prior to being output to the body
of the draft.

The switches `\-noformat', `\-format', and `\-filter\ filterfile' specify
which message filter file to use.

If `\-noformat' is specified (this is the default), then each forwarded
message is output into the draft exactly as it appears with no \fImhl\fR
filtering.

If `\-format' is specified, then a default message filter file is used.
This default message filter should be adequate for most users.
This default filter \*(lqmhl.forward\*(rq is:

.nf
.in +.5i
.ne 10
.eo
.so %etcdir%/mhl.forward
.ec
.in -.5i
.fi

If a file named \*(lqmhl.forward\*(rq exists in the user's nmh
directory, it will be used instead of this form.  You may specify an
alternate message filter file with the switch `\-filter\ filterfile'.

Each forwarded message is separated with an encapsulation delimiter.
By default, any dashes in the first column of the forwarded messages
will be prepended with `\-\ ' so that when received, the message is
suitable for bursting by \fIburst\fR\0(1).  This follows the Internet
RFC\-934 guidelines.  You may use the flag `\-nodashstuffing' in order
to suppress this form of quoting to the forwarded messages.

For users of \fIprompter\fR\0(1), by specifying prompter's `-prepend'
switch in the \&.mh\(ruprofile file, any commentary text is entered
before the forwarded messages.  (A major win!)

To use the MIME rules for encapsulation, specify the `\-mime' switch.
This directs \fIforw\fR to generate an \fImhbuild\fR composition file.
Note that nmh will not invoke \fImhbuild\fR automatically, unless you
add this line to your \&.mh\(ruprofile file:
.sp
.in +.5i
automimeproc: 1
.in -.5i
.sp
Otherwise,
you must specifically give the command
.sp
.in +.5i
What now? mime
.in -.5i
.sp
prior to sending the draft.

The `\-draftfolder\ +folder' and `\-draftmessage\ msg' switches invoke
the \fInmh\fR draft folder facility.  This is an advanced (and highly
useful) feature.  Consult the \fImh-draft\fR(5) man page for more
information.

Upon exiting from the editor, \fIforw\fR will invoke the \fIwhatnow\fR
program.  See \fIwhatnow\fR\0(1) for a discussion of available
options.  The invocation of this program can be inhibited by using the
`\-nowhatnowproc' switch.  (In truth of fact, it is the \fIwhatnow\fR
program which starts the initial edit.  Hence, `\-nowhatnowproc' will
prevent any edit from occurring.)

The `\-digest\ list', `\-issue\ number', and `\-volume\ number' switches
implement a digest facility for \fInmh\fR.  Specifying these switches
enables and/or overloads the following escapes:

.sp 1
.nf
.ta \w'Component  'u +\w'Escape  'u +\w'Returns  'u
\fIType\fR	\fIEscape\fR	\fIReturns\fR	\fIDescription\fR
\fIcomponent\fR	\fIdigest\fR	string	Argument to `\-digest'
\fIfunction\fR	\fIcur\fR	integer	Argument to `\-volume'
\fIfunction\fR	\fImsg\fR	integer	Argument to `\-issue'
.re
.fi

Consult the \fBAdvanced Features\fR section of 
the \fInmh\fR User's Manual for more information on making digests.
.Fi
^%etcdir%/forwcomps~^The standard message skeleton
^or <mh\-dir>/forwcomps~^Rather than the standard skeleton
^%etcdir%/digestcomps~^The message skeleton if `\-digest' is given
^or <mh\-dir>/digestcomps~^Rather than the standard skeleton
^%etcdir%/mhl.forward~^The standard message filter
^or <mh\-dir>/mhl.forward~^Rather than the standard filter
^$HOME/\&.mh\(ruprofile~^The user profile
^<mh\-dir>/draft~^The draft file
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Current\-Folder:~^To find the default current folder
.Ps
^Draft\-Folder:~^To find the default draft\-folder
.Ps
^Editor:~^To override the default editor
.Ps
^Msg\-Protect:~^To set mode when creating a new message (draft)
.Ps
^fileproc:~^Program to refile the message
.Ps
^mhlproc:~^Program to filter messages being forwarded
.Ps
^whatnowproc:~^Program to ask the \*(lqWhat now?\*(rq questions
.Sa
\fIProposed Standard for Message Encapsulation\fR (RFC\-934),
.br
mhbuild(1), comp(1), repl(1), send(1), whatnow(1), mh\-format(5)
.De
`+folder' defaults to the current folder
`msgs' defaults to cur
.Ds
`\-noannotate'
.Ds
`\-nodraftfolder'
.Ds
`\-noformat'
.Ds
`\-inplace'
.Ds
`\-dashstuffing'
.Ds
`\-nomime'
.Co
If a folder is given, it will become the current folder.
The first message forwarded will become the current message.
.Bu

If \fIwhatnowproc\fR is \fIwhatnow\fR, then \fIforw\fR uses a built\-in
\fIwhatnow\fR, it does not actually run the \fIwhatnow\fR program.
Hence, if you define your own \fIwhatnowproc\fR, don't call it
\fIwhatnow\fR since \fIforw\fR won't run it.

When \fIforw\fR is told to annotate the messages it forwards, it
doesn't actually annotate them until the draft is successfully sent.
If from the \fIwhatnowproc\fR, you \fIpush\fR instead of \fIsend\fR,
it's possible to confuse \fIforw\fR by re\-ordering the file (e.g.,
by using `folder\0\-pack') before the message is successfully sent.
\fIDist\fR and \fIrepl\fR don't have this problem.
.En
