/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998-1999, Double Precision Inc.                               */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	<stdlib.h>
#include	<sysexits.h>
#include	<sys/types.h>
#include	"config.h"
#include	"mywait.h"
#if	HAVE_FCNTL_H
#include	<fcntl.h>
#endif
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif
#if	HAVE_SYS_FILE_H
#include	<sys/file.h>
#endif
#include	"dotlock.h"
#include	"maildrop.h"
#include	"mio.h"
#include	"xconfig.h"
#include	"setgroupid.h"

static const char rcsid[]="$Id: dotlockmain.C 1.4 1999/03/31 07:30:03 mrsam Exp $";

static void help()
{
	merr << "Usage: dotlock\n";
	throw EX_TEMPFAIL;
}

static int run(int argc, char *argv[])
{
DotLock	dl;
Mio	mio;
int	use_flock=0;
pid_t	pid;
int	wait_stat;
int	argn;

	argn=1;
	if (argn < argc)
	{
		if ( strcmp(argv[argn], "-f") == 0)
		{
			use_flock=1;
			++argn;
		}
	}

	if (argc - argn < 2)
		help();

#if	RESET_GID
	setgroupid(getgid());
#endif
	setuid(getuid());	// Drop any setuid privileges.

	if (use_flock)
	{
		if (mio.Open(argv[argn], O_CREAT | O_WRONLY, MAILBOX_MODE) < 0)
			throw "Unable to open mailbox.";

	int	flockrc;

#if	HAS_LOCKF
		while ((flockrc=lockf(mio.fd(),F_LOCK,0)) < 0 && errno == EINTR)
			;
#else
#if	HAS_FLOCK
		while ((flockrc=flock(mio.fd(), LOCK_EX)) < 0 && errno == EINTR)
			;
#endif
#endif
		if (flockrc < 0)
			throw "flock() failed.";
	}
	else
	{
		dl.Lock(argv[argn]);
	}
	++argn;

	if ( (pid=fork()) < 0)
		throw "fork() failed.";
	if (pid == 0)
	{
	static char msg[]="maildrop: unable to execute command.\n";

		ExitTrap::onfork();
		setgroupid(getgid());	// Just in case.
		setuid(getuid());
		execvp(argv[argn], argv+argn);
		write(2, msg, sizeof(msg)-1);
		_exit(100);
	}

	while ( wait(&wait_stat) != pid )
		;
	mio.Close();
	dl.Unlock();
	wait_stat= WIFEXITED(wait_stat) ? WEXITSTATUS(wait_stat):-1;
	return (wait_stat);
}

int main(int argc, char *argv[])
{
	_exit(Maildrop::trap(run, argc, argv));
	exit (0);
}
