Summary: Courier-IMAP 0.31 IMAP server
Name: courier-imap
Version: 0.31
Release: 1
Copyright: GPL
Group: Applications/Mail
Source: courier-imap-0.31.tar.gz
Packager: Sam Varshavchik <mrsam@geocities.com>
BuildRoot: /tmp/courier-imap-install
Requires: /sbin/chkconfig

%define	_prefix	/usr/lib/courier-imap

%description
Courier-IMAP is an IMAP server for Maildir mailboxes.

%prep
%setup

%configure

%build
make
make check
%install

rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/pam.d
make install-strip DESTDIR=$RPM_BUILD_ROOT

#
# Red Hat init.d file
#

mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d

cat >$RPM_BUILD_ROOT/etc/rc.d/init.d/courier-imap <<EOF
#!/bin/sh
#
# chkconfig: 2345 80 30
# description: Courier-IMAP - IMAP server
#
#
#

case "\$1" in
start)
        cd /
	. /usr/lib/courier-imap/etc/imapd.config
	touch /var/lock/subsys/courier-imap

	echo -n "Starting Courier-IMAP server:"
	case x\$IMAPDSTART in
	x[yY]*)
		# Start daemons.
		/usr/lib/courier-imap/libexec/imapd.rc start
		;;
	esac

	. /usr/lib/courier-imap/etc/imapd-ssl.config
	case x\$IMAPDSSLSTART in
	x[yY]*)
		test -x \$STUNNEL && /usr/lib/courier-imap/libexec/imapd-ssl.rc start
		;;
	esac
	echo " imaplogin"
	;;
stop)
        echo -n "Stopping Courier-IMAP server:"
	/usr/lib/courier-imap/libexec/imapd.rc stop
	/usr/lib/courier-imap/libexec/imapd-ssl.rc stop
	echo " imaplogin"
	;;
restart)
	\$0 stop
	\$0 start
        ;;
esac
exit 0
EOF

#
# Fix imapd.config
#

sed 's/^IMAPDSTART=.*/IMAPDSTART=YES/' \
	<$RPM_BUILD_ROOT/usr/lib/courier-imap/etc/imapd.config \
	>$RPM_BUILD_ROOT/usr/lib/courier-imap/etc/imapd.config.tmp

mv $RPM_BUILD_ROOT/usr/lib/courier-imap/etc/imapd.config.tmp \
	$RPM_BUILD_ROOT/usr/lib/courier-imap/etc/imapd.config

sed 's/^IMAPDSSLSTART=.*/IMAPDSSLSTART=YES/' \
	<$RPM_BUILD_ROOT/usr/lib/courier-imap/etc/imapd-ssl.config \
	>$RPM_BUILD_ROOT/usr/lib/courier-imap/etc/imapd-ssl.config.tmp

mv $RPM_BUILD_ROOT/usr/lib/courier-imap/etc/imapd-ssl.config.tmp \
	$RPM_BUILD_ROOT/usr/lib/courier-imap/etc/imapd-ssl.config



#
# Red Hat /etc/profile.d scripts
#

mkdir -p $RPM_BUILD_ROOT/etc/profile.d
cat >$RPM_BUILD_ROOT/etc/profile.d/courier-imap.sh <<EOF
if echo "\$MANPATH" | tr ':' '\012' | fgrep -qx /usr/lib/courier-imap/man
then
	:
else
	MANPATH="/usr/lib/courier-imap/man:\$MANPATH"
	export MANPATH
	PATH="/usr/lib/courier-imap/bin:\$PATH"
	if test -w /etc
	then
		PATH="/usr/lib/courier-imap/sbin:\$PATH"
	fi
	export PATH
fi
EOF

cat >$RPM_BUILD_ROOT/etc/profile.d/courier-imap.csh <<EOF

if ( \$?MANPATH ) then
	true
else
	setenv MANPATH ""
endif

echo "\$MANPATH" | tr ':' '\012' | fgrep -qx /usr/lib/courier-imap/man

if ( \$? ) then
	true
else
	setenv MANPATH "/usr/lib/courier-imap/man:\$MANPATH"
	setenv PATH "/usr/lib/courier-imap/bin:\$PATH"
	test -w /etc
	if ( \$? ) then
		true
	else
		setenv PATH "/usr/lib/courier-imap/sbin:\$PATH"
	endif
endif
EOF

#
# Compress everything in man
#

find $RPM_BUILD_ROOT/usr/lib/courier-imap/man ! -type d -print | perl -e '

	while (<>)
	{
		chop if /\n$/;
		next if /\.gz$/;
		$file=$_;
		if ( -l $file)
		{
                        symlink readlink("$file")
                                . ".gz", "$file.gz";
			unlink($file);
                }
                else
                {
                        system("gzip <$file >$file.gz");
			unlink($file);
		}
	}
'

cp imap/README README.imap
cp maildir/README.maildirquota.txt README.maildirquota
cp maildir/README.sharedfolders.txt README.sharedfolders

%post
/sbin/chkconfig --add courier-imap

%preun

if test "$1" = "0"
then
	/sbin/chkconfig --del courier-imap
fi

/usr/lib/courier-imap/libexec/imapd.rc stop
/usr/lib/courier-imap/libexec/imapd-ssl.rc stop

%files
%defattr(-, bin, bin)
%config /etc/pam.d/imap
%attr(755, bin, bin) %config /etc/profile.d/courier-imap.csh
%attr(755, bin, bin) %config /etc/profile.d/courier-imap.sh
%attr(755, bin, bin) /etc/rc.d/init.d/courier-imap
%dir %{_prefix}

%if "%{_prefix}" != "%{_exec_prefix}"

%dir %{_exec_prefix}

%endif

%{_libexecdir}
%config %{_sysconfdir}
%{_bindir}
%{_sbindir}
%{_mandir}
%doc AUTHORS COPYING imap/BUGS README README.imap README.maildirquota
%doc imap/FAQ imap/FAQ.html README.sharedfolders authlib/README.*

%clean
rm -rf $RPM_BUILD_ROOT
