#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include "ysound.h"
#include "ymode.h"


int YModeIsAllocated(int n)
{
        if((n < 0) ||
           (n >= total_ymodes) ||
           (ymode == NULL)
        )
            return(0);
        else if(ymode[n] == NULL)
            return(0);
        else
            return(1);
}


YMode *YModeGetPtr(int n)
{
        if(YModeIsAllocated(n))
            return(ymode[n]);
        else
            return(NULL);
}


/*
 *	Attempts to match a mode by name, returns the YMode index
 *	number of -1 on no match.
 */
int YModeMatch(char *name)
{
	int i;


	if(name == NULL)
	    return(-1);


	for(i = 0; i < total_ymodes; i++)
	{
	    if(ymode[i] == NULL)
		continue;

	    if(ymode[i]->name == NULL)
		continue;


	    if(!strcasecmp(ymode[i]->name, name))
		return(i);
	}


	return(-1);
}


/*
 *	Allocates a new YMode, returns -1 on allocation error or the
 *	YMode index on success.
 */
int YModeAllocate(char *name)
{
        int i, n, len;

 
        for(i = 0; i < total_ymodes; i++)
        {   
            if(ymode[i] == NULL)
                break;
        }
        if(i < total_ymodes)
        {
            n = i;
        }
        else
        {
            n = total_ymodes;
            total_ymodes++;

            ymode = (YMode **)realloc(
                ymode,
                total_ymodes * sizeof(YMode *)
            );
            if(ymode == NULL)
            {
                total_ymodes = 0;
                return(-1);
            }
        }

        ymode[n] = (YMode *)calloc(1,
            sizeof(YMode)
        );
        if(ymode[n] == NULL)
        {
            return(-1);
        }
 

	/* ************************************************************ */
        /* Set values. */

	YModeReset(n);

	/* Set name. */
	if(name != NULL)
	{
	    len = strlen(name);
	    ymode[n]->name = (char *)calloc(1, (len + 1) * sizeof(char));
	    if(ymode[n]->name != NULL)
		strcpy(ymode[n]->name, name);
	}


        return(n);
}


/*
 *      Resets YMode values to default, freeing any allocated
 *      substructures.
 */
void YModeReset(int n)
{
        YMode *ptr;

        ptr = YModeGetPtr(n);
        if(ptr == NULL)  
            return;

	/* Free name. */
	free(ptr->name);
	ptr->name = NULL;

	ptr->cycle.ms = 1000;
	ptr->cycle.us = 0;

	ptr->write_ahead.ms = 0;
        ptr->write_ahead.us = 0;

        ptr->sample_size = 8;
        ptr->channels = 1;
        ptr->sample_rate = 11025;

	ptr->bytes_per_second = 11025;

#ifdef OSS_BUFFRAG
        ptr->allow_fragments = True;
        ptr->num_fragments = 0x02;
        ptr->fragment_size = 0x0a;
#endif  /* OSS_BUFFRAG */

        ptr->flip_stereo = False;
        ptr->direction = AUDIO_DIRECTION_PLAY;


        return;
}


void YModeDelete(int n)
{
        if(YModeIsAllocated(n))  
        {
            /* Free allocated substructures. */
            YModeReset(n);

            free(ymode[n]);
            ymode[n] = NULL;
        }

        return;
}


void YModeDeleteAll()
{
        int i;

        for(i = 0; i < total_ymodes; i++)
        {
            YModeDelete(i);
        }

        free(ymode);
        ymode = NULL;

        total_ymodes = 0;

        return;
}



void YModeReclaim()
{




	return;
}
