/*
                     Y I F F   S O U N D   S E R V E R


               Copyright (C) 1997, 1998, 1999, 2000 WolfPack

 */

#ifndef YIFF_H
#define YIFF_H

#include <stdio.h>
#include <db.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>

#include "ytypes.h"
#include "ytimming.h"

#include "soundpaths.h"
#include "yconnection.h"
#include "ysound.h"
#include "playstack.h"

#include "afw.h"


/*
 *	Program name and version:
 */
#define PROG_NAME	"YIFF"
#define PROG_VERSION	"2.06"

#define PROG_VERSION_MAJOR	2
#define PROG_VERSION_MINOR	6

#define PROG_VENDOR_NAME	"WolfPack Development Organization"

#define YPROTOCOL_VERSION_MAJOR	2
#define YPROTOCOL_VERSION_MINOR	6

/*
 *	Program help message:
 */
#ifdef HAVE_LIBKMID
#define PROG_HELP_MESG "\
Usage: yiff [config_file] [options]\n\
\n\
    [config_file] specifies the configuration file to be used.\n\
\n\
    [options] can be any of the following:\n\
\n\
        --device <device>       Specifies the digital audio device.\n\
        --mixer <device>        Specifies the mixer device.\n\
        --mixer_rc <file>       Specifies alternate mixer settings file.\n\
        --port <port>           Specifies the port number to accept\n\
                                incoming connections on.\n\
        --path <path>           Adds a sound path (can be used\n\
                                more than once).\n\
        --midi_port             MIDI Device port (needed by ALSA and\n\
                                libkmid).\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n"
#else	/* HAVE_LIBKMID */
#define PROG_HELP_MESG "\
Usage: yiff [config_file] [options]\n\
\n\
    [config_file] specifies the configuration file to be used.\n\
\n\
    [options] can be any of the following:\n\
\n\
        --device <device>       Specifies the digital audio device.\n\
        --mixer <device>        Specifies the mixer device.\n\
        --mixer_rc <file>       Specifies alternate mixer settings file.\n\
        --port <port>           Specifies the port number to accept\n\
                                incoming connections on.\n\
        --path <path>           Adds a sound path (can be used\n\
                                more than once).\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n"
#endif


/*
 *	Copyright mesg:
 */
#define PROG_COPYRIGHT "\
Copyright (C) 1997, 1998, 1999, 2000 Wolfpack Development Organization."


/*
 *	Listening Socket Backlog:
 */
#define LISTEN_SOCKET_BACKLOG   10

/*
 *	Network recieve buffer:
 *
 *	Should be big enough to hold a few large yiff network
 *	data segments.
 */
#define YNET_SEG_MAX	10000


/*
 *	Program statistics:
 */
typedef struct {

	/* PID of this program's process. */
	pid_t pid;

	/* When the program was started (in systime seconds). */
	time_t start_time;

	/*    Cycle load in microseconds. Calculated by taking the
         *    compensated cycle interval - the time it took to
         *    process stuff per loop / the compensated cycle interval.
	 */
	Coefficient cycle_load;

} yiff_stats_struct;
extern yiff_stats_struct ystats;


/*
 *	Program master run level:
 */
extern int runlevel;


/*
 *	Current time since midnight:
 */
extern YTime cur_time;



/*
 *	Next operation timmers:
 *
 *	(In milliseconds unless noted otherwise.)
 */
typedef struct {

	YTime	refresh;

} yiff_next_struct;
extern yiff_next_struct next;


/*
 *	Sound device data pointer.
 */
extern Recorder *recorder;

/*
 *	Network incoming connections listening socket:
 */
extern int listen_socket;




/* *************************************************************** */

/* In bufmix.c */
extern void YiffMixBuffers(
	Audio *audio,
        SoundBuffer *tar_buf,
        SoundBuffer *src_buf,
        YDataLength len,
        Coefficient volume_left,
        Coefficient volume_right,
        Coefficient volume_up,
        Coefficient volume_down,
        Coefficient volume_away
);


/* In main.c */
extern void YiffResetMixer(void);
extern void YiffHangupHandle(void);
extern void YiffSignalHandler(int sig);

extern int YiffInit(int argc, char **argv);
extern void YiffShutdown(void);

extern void YiffCloseConnection(YConnectionNumber con_num);
extern int YiffCheckNewConnection(int socket);
extern void YiffManageConnections(void);

extern int YiffCreatePlaystack(
        char *path, 
        YConnectionNumber owner,
        YID yid,
        YDataPosition pos,
        YVolumeStruct *volume,
        int repeats
);
extern void YiffDestroyPlaystack(int n);
extern void YiffManageSound(void);

extern void YiffUpdateTimmers(void);
extern void YiffResetTimmers(void);




#endif	/* YIFF_H */
