/*
	YIFF Sound buffer mixing.
 */

#include <stdio.h>
#include "ysound.h"

#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define MAX(a,b)	(((a) > (b)) ? (a) : (b))


void YiffMixBuffers(
	Audio *audio,
        SoundBuffer *tar_buf,
        SoundBuffer *src_buf,
        YDataLength len,
	Coefficient volume_left,
        Coefficient volume_right,
        Coefficient volume_up,
        Coefficient volume_down,
        Coefficient volume_away
) 
{
        int i, b, blocks;
        SoundBuffer *tp, *sp;
	Coefficient lc, rc;
	Boolean flip;

   
        if((audio == NULL) ||
           (tar_buf == NULL) ||
           (src_buf == NULL) ||
           (len <= 0)
        )
            return;

	flip = audio->flip_stereo;


	/* Calculate coefficients. */
	if(audio->channels == 2)
	{
	    /* Stereo. */
	    blocks = 2;

	    /* Calculate left and right coefficients. */
	    lc = MAX(MIN(volume_left, 1), 0);
            rc = MAX(MIN(volume_right, 1), 0);
	}
	else
	{
	    /* Mono. */
	    blocks = 1;

	    /* Average left and right coefficients. */
	    lc = (volume_left + volume_right) / 2;

            rc = MAX(MIN(lc, 1), 0);
	    lc = rc;
	}

	/* Begin buffer mixing. */
        for(i = 0, b = 0, tp = tar_buf, sp = src_buf;
            i < len;
            i++, tp++, sp++
        ) 
        {
	    /* Is source byte positive or negative? */
            if(*sp < 0)
            {
		/* Source byte is negative. */

		if(b == 0)
                    *tp = MAX((int)*tp +
                        ((int)*sp * ((flip) ? rc : lc)),
			(int)-128
		    );
		else
		    *tp = MAX((int)*tp +
                        ((int)*sp * ((flip) ? lc : rc)),
			(int)-128
		    );
            }
            else
            {
		/* Source byte is positive. */

                if(b == 0)
                    *tp = MIN((int)*tp +
                        ((int)*sp * ((flip) ? rc : lc)),
			(int)127
		    );
		else
                    *tp = MIN((int)*tp +
                        ((int)*sp * ((flip) ? lc : rc)),
			(int)127
		    );
            }

	    /* Increment block position b. */
            b++;
            if(b >= blocks)
                b = 0;
        }
           
           
        return;
}
