/*								-*- C++ -*-
 * $Id: WIN_toolbar.h,v 1.2 1997-01-15 14:58:10+01 mho Exp $
 *
 * Purpose: wxWindows Tool Bar
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef ToolBar_h
#define ToolBar_h

#ifdef __GNUG__
#pragma interface
#endif

class wxToolBarTool;

class wxToolBar : public wxPanel {
DECLARE_DYNAMIC_CLASS(wxToolBar)
public:
    wxToolBar(wxWindow *parent = NULL, int x = 0, int y = 0, int w = -1, int h = -1,
	      long style = wxPRIVATE_CHILD, int orientation = wxVERTICAL, int RowsOrColumns = 2,
	      Constdata char *name = wxToolBarNameStr);
    ~wxToolBar(void);

    wxToolBarTool* AddTool(int toolIndex, wxBitmap *bitmap, wxBitmap *pushedBitmap=NULL,
			   Bool toggle=FALSE, float xPos=-1, float yPos=-1,
			   wxObject *clientData = NULL,
			   char *helpString1 = NULL, char *helpString2 = NULL);

    wxToolBarTool *FindToolForPosition(float x, float y);

    void      AddSeparator(void);
    void      ClearTools(void);
    void      EnableTool(int toolIndex, Bool enable);
    void      GetMaxSize(float *w, float *h);
    wxObject* GetToolClientData(int index);
    Bool      GetToolEnabled(int toolIndex);
    Bool      GetToolState(int toolIndex);
    void      Layout(void);
    void      SetMargins(float x, float y);
    void      SetOrientation(int orient);
    void      SetToggle(int toolIndex, Bool toggle);
    void      ToggleTool(int toolIndex, Bool toggle);

    // positioning methods
    void NewLine(void);
    void NewLine(int pixels);
    void Tab(void);
    void Tab(int pixels);

    // wxToolBar events
    virtual Bool OnLeftClick(int toolIndex, Bool toggleDown);
    virtual void OnMouseEnter(int toolIndex);
    virtual void OnRightClick(int toolIndex, float x, float y);

    // translate wxWindows events  to wxToolBar events
    virtual void OnLeftClick(int WXUNUSED(x), int WXUNUSED(y), int WXUNUSED(keys))
	{ OnLeftClick(-1, FALSE); }
    virtual void OnRightClick(int x, int y, int WXUNUSED(keys))
	{ OnRightClick(-1, float(x), float(y)); }

    // Win96 compatibility
    Bool CreateTools(void) { return TRUE; }
protected:
    int rows_or_columns;
    int current_pos;
};

#endif // ToolBar_h
