/*								-*- C++ -*-
 * $Id: APP_app.h,v 1.1 1996-09-25 11:05:47+02 mho Exp $
 *
 * Purpose: wxWindows application and main loop
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef AppMain_h
#define AppMain_h

#ifdef __GNUG__
#pragma interface
#endif

class wxFrame;
class wxKeyEvent;
class wxWindow;

class wxApp : public wxObject {
DECLARE_DYNAMIC_CLASS(wxApp)
public:
    // functions
    wxApp(wxlanguage_t language = wxLANGUAGE_DEFAULT);

    virtual void    Dispatch(void);
    virtual Bool    Initialized(void) { return initialized; };
    virtual int     MainLoop(void);
    virtual void    ExitMainLoop(void) { keep_going = False; }
    virtual wxFrame *OnInit(void) { return 0; };
    virtual int     OnExit(void) { return 0; };
    virtual Bool    Pending(void);

    char* GetAppName(void)	   { return wxAPP_NAME; }
    void  SetAppName(char *name)   { wxAPP_NAME = name; }
    char* GetClassName(void)	   { return wxAPP_CLASS; }
    void  SetClassName(char *name) { wxAPP_CLASS = name; }
    int   GetPrintMode(void)	   { return wxAPP_PRINTMODE; }
    void  SetPrintMode(int mode)   { wxAPP_PRINTMODE = mode; }

    Bool  GetExitOnFrameDelete(void)      { return exit_on_frame_delete; }
    void  SetExitOnFrameDelete(Bool flag) { exit_on_frame_delete = flag; }

    wxFrame*  GetInitFrame(void)	  { return init_frame; }
    wxWindow* GetTopWindow(void);

    // OnCharHook allows to intercept e.g F1 and ESC
    inline virtual Bool OnCharHook(wxKeyEvent& WXUNUSED(event)) { return FALSE; }

    // data
    int    argc;
    char** argv;
    static Bool&  wantDebugOutput;
    static char*& wx_class;
    static char*& appName;
    static int&   printMode;
private:
    friend int wxEntry(int argc, char **argv);

    Bool     keep_going;
    Bool     initialized;
    Bool     exit_on_frame_delete;
    wxFrame* init_frame;
};

// Register user-defined initialization and cleanup routines
void wxRegisterModule(void (*init)(void*), void (*exit)(void*),
		      void* arg = 0);

// Here's a macro you can use if your compiler
// really, really wants main() to be in your main program
#if defined(AIX) || defined(AIX4)
#define IMPLEMENT_WXWIN_MAIN \
     int main(int argc, char *argv[]) { return wxEntry(argc, argv); }
#else
#define IMPLEMENT_WXWIN_MAIN
#endif

#endif // AppMain_h
