/*								-*- C++ -*-
 * $Id: UTL_app.cpp,v 1.3 1997-01-15 14:58:52+01 mho Exp $
 *
 * Purpose: global utilities for wxWindows application and main loop
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#define  Uses_XtIntrinsic
#define  Uses_wxApp
#include "wx.h"

//-----------------------------------------------------------------------------
// exit the application with retvalue of OnExit
//-----------------------------------------------------------------------------

void wxExit(void)
{
    exit(wxTheApp->OnExit());
}

//-----------------------------------------------------------------------------
// flush all events in the queue
//-----------------------------------------------------------------------------

void wxFlushEvents(void)
{
#if WXDEBUG_EVENTS
    if (wxAPP_DEBUGEVENTS)
	printf("----- flush events -----\n");
#endif
    XFlush(wxAPP_DISPLAY);
    XSync(wxAPP_DISPLAY, FALSE);
    XEvent event;
    while (XtAppPending(wxAPP_CONTEXT)) {
	XFlush(wxAPP_DISPLAY);
	XSync(wxAPP_DISPLAY, FALSE);
	XtAppNextEvent(wxAPP_CONTEXT, &event);
#if WXDEBUG_EVENTS
	if (wxAPP_DEBUGEVENTS) {
	    // print widgetname and event number
	    Widget w; int type = event.xany.type;
	    static char* event_name[] = {
		"", "unknown(-)",                                         // 0-1
		"KeyPress", "KeyRelease", "ButtonPress", "ButtonRelease", // 2-5
		"MotionNotify", "EnterNotify", "LeaveNotify", "FocusIn",  // 6-9
		"FocusOut", "KeymapNotify", "Expose", "GraphicsExpose",   // 10-13
		"NoExpose", "VisibilityNotify", "CreateNotify",           // 14-16
		"DestroyNotify", "UnmapNotify", "MapNotify", "MapRequest",// 17-20
		"ReparentNotify", "ConfigureNotify", "ConfigureRequest",  // 21-23
		"GravityNotify", "ResizeRequest", "CirculateNotify",      // 24-26
		"CirculateRequest", "PropertyNotify", "SelectionClear",   // 27-29
		"SelectionRequest", "SelectionNotify", "ColormapNotify",  // 30-32
		"ClientMessage", "MappingNotify",                         // 33-34
		"unknown(+)"};                                            // 35
	    type = wxMin(35, type); type = wxMax(1, type);
	    w = XtWindowToWidget(event.xany.display, event.xany.window);
	    printf("%-17s: %s(%p)\n", event_name[type], (w ? XtName(w) : "unknown"), w);
	    fflush(stdout);
	}
#endif
	XtDispatchEvent(&event);
    }
#if WXDEBUG_EVENTS
    if (wxAPP_DEBUGEVENTS) {
	printf("--------- done ---------\n");
	fflush(stdout);
    }
#endif
}

//-----------------------------------------------------------------------------
// yield to incomming messages
//-----------------------------------------------------------------------------

Bool wxYield(void)
{
    while (wxTheApp->Pending())
	wxTheApp->Dispatch();
    return TRUE;
}

