/* Copyright (c) 1992, 1998 John E. Davis
 * This file is part of the S-Lang library.
 *
 * You may distribute under the terms of either the GNU General Public
 * License or the Perl Artistic License.
 */

/* These routines are fast memcpy, memset routines.  When available, I
   use system rouines.  For msdos, I use inline assembly. */

/* The current versions only work in the forward direction only!! */

#include "config.h"
#include "sl-feat.h"

#include <stdio.h>
#include "slang.h"
#include "_slang.h"
#if SLANG_HAS_KANJI_SUPPORT
#include "slkanji.h"
#endif

char *SLmemchr(register char *p, register char c, register int n)
{
   int n2;
   register char *pmax;

   pmax = p + (n - 32);

   while (p <= pmax)
     {
	if ((*p == c) || (*++p == c) || (*++p == c) || (*++p == c)
	    || (*++p == c) || (*++p == c) || (*++p == c) || (*++p == c)
	    || (*++p == c) || (*++p == c) || (*++p == c) || (*++p == c)
	    || (*++p == c) || (*++p == c) || (*++p == c) || (*++p == c)
	    || (*++p == c) || (*++p == c) || (*++p == c) || (*++p == c)
	    || (*++p == c) || (*++p == c) || (*++p == c) || (*++p == c)
	    || (*++p == c) || (*++p == c) || (*++p == c) || (*++p == c)
	    || (*++p == c) || (*++p == c) || (*++p == c) || (*++p == c))
	  return p;
	p++;
     }

   n2 = n % 32;

   while (n2--)
     {
	if (*p == c) return p;
	p++;
     }
   return(NULL);
}

#ifdef SLANG_HAS_KANJI_SUPPORT
char *kSLmemchr(register unsigned char *p, register unsigned int c, register int n)
{
   unsigned char first, second = 0;
   int i;
   
   if (c & 0xff00)
     {
	first = (c >> 8);
	second = (c & 0xff);
     }
   else
     first = c;
   
   for(i=0 ; i<n ; i++)
     {
	if(iskanji(p[i]))
	  {
	     if(second && (p[i] == first && p[i+1] == second))
	       return (p + i);
	     
	     i++;
	  }
	else if (p[i] == first) return (p + i);
     }
   return (NULL);
}
#endif /* SLANG_HAS_KANJI_SUPPORT */
