/****************************************************************************
** $Id: qstring.cpp,v 2.166.2.12 1999/09/21 17:07:08 hanord Exp $
**
** Implementation of the QString class and related Unicode functions
**
** Created : 920722
**
** Copyright (C) 1992-1999 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.troll.no/pricing.html or email sales@troll.no for
** information about the Professional Edition licensing, or see
** http://www.troll.no/qpl/ for QPL licensing information.
**
*****************************************************************************/

// Don't define it while compiling this module, or USERS of Qt will
// not be able to link.
#ifdef QT_NO_CAST_ASCII
#undef QT_NO_CAST_ASCII
#endif

#include "qstring.h"
#include "qregexp.h"
#include "qdatastream.h"
#include "qtextcodec.h"
#include "qstack.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <limits.h>

/* -------------------------------------------------------------------------
 * unicode information
 * these tables are generated from the unicode reference file
 * ftp://ftp.unicode.org/Public/2.1-Update3/UnicodeData-2.1.8.txt
 *
 * Lars Knoll <knoll@mpi-hd.mpg.de>
 * -------------------------------------------------------------------------
 */

/* Perl script to generate (run perl -x tools/qstring.cpp)

#!perl

sub numberize
{
    my(%r, $n, $id);
    for $id ( @_ ) {
	$id="" if $id eq "EMPTY";
	$r{$id}=$n++;
    }
    return %r;
}


# Code to integer mappings...
#
%category_code = numberize(qw{
      EMPTY
      Mn Mc Me
      Nd Nl No
      Zs Zl Zp
      Cc Cf Cs Co Cn

      Lu Ll Lt Lm Lo
      Pc Pd Ps Pe Pi Pf Po
      Sm Sc Sk So
});
%bidi_category_code = numberize(qw{
      L R EN ES ET AN CS B S WS ON });
%character_decomposition_tag = numberize(qw{
      <single> <canonical> <font> <noBreak> <initial> <medial>
      <final> <isolated> <circle> <super> <sub> <vertical>
      <wide> <narrow> <small> <square> <compat> <fraction>
});
%mirrored_code = numberize(qw{N Y});

# Read data into hashes...
#
open IN, "data/UnicodeData-2.1.8.txt";
$position = 1;
while (<IN>) {
    @fields = split /;/;
    $code = shift @fields;
    for $n (qw{
      name category combining_class bidi_category
      character_decomposition decimal_digit_value digit_value
      numeric_value mirrored oldname comment
      uppercase lowercase titlecase})
    {
	$id = shift @fields;
	$codes = "${n}_code";
	if ( defined %$codes && defined $$codes{$id} ) {
	    $id = $$codes{$id};
	}
	${$n}{$code}=$id;
    }
    $decomp = $character_decomposition{$code};
    if ( length $decomp == 0 ) {
	$decomp = "<single>";
    }
    if (substr($decomp, 0, 1) ne '<') {
	$decomp = "<canonical> " . $decomp;
    }
    @fields = split(" ", $decomp);
    $tag = shift @fields;
    $tag = $character_decomposition_tag{$tag};
    $decomp = join( ", 0x", @fields );
    $decomp = "0x".$decomp;
    $decomposition{$code} = $decomp;
    $decomposition_tag{$code} = $tag;
    $decomposition_pos{$code} = $position;
    $len = scalar(@fields);
    $decomposition_len{$code} = $len;

#   we use canonical decompositions longer than 1 char
#   and all arabic ligatures for the ligature table
    if(($len > 1 and $tag == 1) or ($tag > 3 and $tag < 8)) {
#      ligature to add...
	$start = shift @fields;
	$ligature{$start} = $ligature{$start}." ".$code;
    }

#   adjust position
    if($len != 0) {
	$position += $len + 3;
    }


}


# Build pages...
#
$rowtable_txt =
    "static const Q_UINT8 *unicode_info [256] = {";
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$info = $category{$code};
	$info = 0 if !defined $info;
	$txt .= "\n    " if $cell%8 == 0;
	$txt .= "$info, ";
    }
    $therow = $row{$txt};
    if ( !defined $therow ) {
	$size+=256;
	$therow = "ui_".sprintf("%02X",$row);
	$rowtext{$therow} =
	    "static const Q_UINT8 ${therow}[] = {$txt\n};\n\n";
	$row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

print "// START OF GENERATED DATA\n\n";

# Print pages...
#
for $r ( sort keys %rowtext ) {
    print $rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";

# Build decomposition tables
#
$rowtable_txt =
    "static const Q_UINT16 *decomposition_info [256] = {";
$table_txt =
    "static const Q_UINT16 decomposition_map [] = {\n    0,\n";
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$txt .= "\n   " if $cell%8 == 0;
	if( $decomposition_tag{$code} != 0 ) {
	    $txt .= " $decomposition_pos{$code},";
	    $table_txt .= "    $decomposition_tag{$code},";
	    $table_txt .= " 0x$code,";
	    $table_txt .= " $decomposition{$code}, 0,\n";
	    $size += 2 * $decomposition_len{$code} + 6;
	} else {
	    $txt .= " 0,";
	}
    }
    $therow = $row{$txt};
    if ( !defined $therow ) {
	$size+=512;
	$therow = "di_".sprintf("%02X",$row);
	$dec_rowtext{$therow} =
	    "static const Q_UINT16 ${therow}[] = {$txt\n};\n\n";
	$row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print decomposition tables
#
print "$table_txt\n};\n\n";
for $r ( sort keys %dec_rowtext ) {
    print $dec_rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";


# build ligature tables
#
$size = 0;
$position = 1;
$rowtable_txt =
    "static const Q_UINT16 *ligature_info [256] = {";
$table_txt =
    "static const Q_UINT16 ligature_map [] = {\n    0,\n";
for $row ( 0..255 ) {
    $nonzero=0;
    $txt = "";
    for $cell ( 0..255 ) {
	$code = sprintf("%02X%02X",$row,$cell);
	$txt .= "\n   " if $cell%8 == 0;
	if( defined $ligature{$code} ) {
	    $txt .= " $position,";
	    @ligature = split(" ", $ligature{$code});
#           we need to sort ligatures according to their length.
#           long ones have to come first!
	    @ligature_sort = sort { $decomposition_len{$b} <=>  $decomposition_len{$a} } @ligature;
#           now replace each code by it's position in
#           the decomposition map.
	    undef(@lig_pos);
	    for $n (@ligature_sort) {
		push(@lig_pos, $decomposition_pos{$n});
	    }
#           debug info
	    if( 0 ) {
		print "ligatures: $ligature{$code}\n";
		$sort = join(" ", @ligature_sort);
		print "sorted   : $sort\n";
	    }
	    $lig = join(", ", @lig_pos);
	    $table_txt .= "    $lig, 0,\n";
	    $size += 2 * scalar(@ligature) + 2;
	    $position += scalar(@ligature) + 1;
	} else {
	    $txt .= " 0,";
	}
    }
    $therow = $row{$txt};
    if ( !defined $therow ) {
	$size+=512;
	$therow = "li_".sprintf("%02X",$row);
	$lig_rowtext{$therow} =
	    "static const Q_UINT16 ${therow}[] = {$txt\n};\n\n";
	$row{$txt}=$therow;
    }
    $rowtable_txt .= "\n    " if $row%8 == 0;
    $rowtable_txt .= "$therow, ";
}

# Print ligature tables
#
print "$table_txt\n};\n\n";
for $r ( sort keys %lig_rowtext ) {
    print $lig_rowtext{$r};
}
print "$rowtable_txt\n};\n";
$size += 256*4;
print "// $size bytes\n\n";

print "// END OF GENERATED DATA\n\n";

__END__

*/

// START OF GENERATED DATA

static const Q_UINT8 ui_00[] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    7, 26, 26, 26, 28, 26, 26, 26,
    22, 23, 26, 27, 26, 21, 26, 26,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 27, 27, 27, 26,
    26, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 22, 26, 23, 29, 20,
    29, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 22, 27, 23, 27, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    7, 26, 28, 28, 28, 28, 30, 30,
    29, 30, 16, 24, 27, 21, 30, 29,
    30, 27, 6, 6, 29, 16, 30, 26,
    29, 6, 16, 25, 6, 6, 6, 26,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 27,
    15, 15, 15, 15, 15, 15, 15, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 27,
    16, 16, 16, 16, 16, 16, 16, 16,
};

static const Q_UINT8 ui_01[] = {
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    16, 15, 16, 15, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 15, 16, 15,
    16, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 15, 16, 15, 16, 15, 16, 16,
    16, 15, 15, 16, 15, 16, 15, 15,
    16, 15, 15, 15, 16, 16, 15, 15,
    15, 15, 16, 15, 15, 16, 15, 15,
    15, 16, 16, 16, 15, 15, 16, 15,
    15, 16, 15, 16, 15, 16, 15, 15,
    16, 15, 19, 16, 15, 16, 15, 15,
    16, 15, 15, 15, 16, 15, 16, 15,
    15, 16, 16, 19, 15, 16, 19, 19,
    19, 19, 19, 19, 15, 17, 16, 15,
    17, 16, 15, 17, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 15, 16, 15,
    16, 15, 16, 15, 16, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    16, 15, 17, 16, 15, 16, 0, 0,
    0, 0, 15, 16, 15, 16, 15, 16,
};

static const Q_UINT8 ui_02[] = {
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 0, 0, 0, 0, 0, 0, 0,
    18, 18, 18, 18, 18, 18, 18, 18,
    18, 29, 29, 18, 18, 18, 18, 18,
    18, 18, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 29,
    18, 18, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 0,
    18, 18, 18, 18, 18, 29, 29, 29,
    29, 29, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_03[] = {
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 26, 26, 0, 0,
    0, 0, 18, 0, 0, 0, 26, 0,
    0, 0, 0, 0, 29, 29, 15, 26,
    15, 15, 15, 0, 15, 0, 15, 15,
    16, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 0, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 0,
    16, 16, 15, 15, 15, 16, 16, 0,
    0, 0, 15, 0, 15, 0, 15, 0,
    15, 0, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    16, 16, 16, 19, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_04[] = {
    0, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 0, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    0, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 0, 16, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 30, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    19, 15, 16, 15, 16, 0, 0, 15,
    16, 0, 0, 15, 16, 0, 0, 0,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 0, 0, 15, 16,
    15, 16, 15, 16, 15, 16, 0, 0,
    15, 16, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_05[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 0,
    0, 18, 26, 26, 26, 26, 26, 26,
    0, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    0, 26, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 1, 26, 1,
    26, 1, 1, 26, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    19, 19, 19, 26, 26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_06[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 26, 0, 0, 0, 26,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    18, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 26, 26, 0, 0,
    1, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 26, 19, 1, 1,
    1, 1, 1, 1, 1, 3, 3, 1,
    1, 1, 1, 1, 1, 18, 18, 1,
    1, 30, 1, 1, 1, 1, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_07[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_09[] = {
    0, 1, 1, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 1, 19, 2, 2,
    2, 1, 1, 1, 1, 1, 1, 1,
    1, 2, 2, 2, 2, 1, 0, 0,
    19, 1, 1, 1, 1, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 1, 1, 26, 26, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    26, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 19,
    19, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 0, 0, 0, 19, 19,
    19, 19, 0, 0, 1, 0, 2, 2,
    2, 1, 1, 1, 1, 0, 0, 2,
    2, 0, 0, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 19, 19, 0, 19,
    19, 19, 1, 1, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    19, 19, 28, 28, 6, 6, 6, 6,
    6, 6, 30, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0A[] = {
    0, 0, 1, 0, 0, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 19,
    19, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 0, 19, 19, 0,
    19, 19, 0, 0, 1, 0, 2, 2,
    2, 1, 1, 0, 0, 0, 0, 1,
    1, 0, 0, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 19, 19, 19, 0, 19, 0,
    0, 0, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    1, 1, 19, 19, 19, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 0, 19,
    19, 19, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 0, 19, 19, 19,
    19, 19, 0, 0, 1, 19, 2, 2,
    2, 1, 1, 1, 1, 1, 0, 1,
    1, 2, 0, 2, 2, 1, 0, 0,
    19, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 0, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0B[] = {
    0, 1, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 19,
    19, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 0, 0, 19, 19,
    19, 19, 0, 0, 1, 19, 2, 1,
    2, 1, 1, 1, 0, 0, 0, 2,
    2, 0, 0, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 2,
    0, 0, 0, 0, 19, 19, 0, 19,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    30, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 2, 0, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 0, 0,
    0, 19, 19, 0, 19, 0, 19, 19,
    0, 0, 0, 19, 19, 0, 0, 0,
    19, 19, 19, 0, 0, 0, 19, 19,
    19, 19, 19, 19, 19, 19, 0, 19,
    19, 19, 0, 0, 0, 0, 2, 2,
    1, 2, 2, 0, 0, 0, 2, 2,
    2, 0, 2, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    6, 6, 6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0C[] = {
    0, 2, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 1, 1,
    1, 2, 2, 2, 2, 0, 1, 1,
    1, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 2, 1,
    2, 2, 2, 2, 2, 0, 1, 2,
    2, 0, 2, 2, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 19, 0,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0D[] = {
    0, 0, 2, 2, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 2, 2,
    2, 1, 1, 1, 0, 0, 2, 2,
    2, 0, 2, 2, 2, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 0, 0, 0, 0, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0E[] = {
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 1, 19, 19, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 28,
    19, 19, 19, 19, 19, 19, 18, 1,
    1, 1, 1, 1, 1, 1, 1, 30,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 19, 0, 19, 0, 0, 19,
    19, 0, 19, 0, 0, 19, 0, 0,
    0, 0, 0, 0, 19, 19, 19, 19,
    0, 19, 19, 19, 19, 19, 19, 19,
    0, 19, 19, 19, 0, 19, 0, 19,
    0, 0, 19, 19, 0, 19, 19, 19,
    19, 1, 19, 19, 1, 1, 1, 1,
    1, 1, 0, 1, 1, 19, 0, 0,
    19, 19, 19, 19, 19, 0, 18, 0,
    1, 1, 1, 1, 1, 1, 0, 0,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 0, 0, 19, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_0F[] = {
    19, 30, 30, 30, 26, 26, 26, 26,
    26, 26, 26, 26, 26, 26, 26, 26,
    26, 26, 26, 30, 30, 30, 30, 30,
    1, 1, 30, 30, 30, 30, 30, 30,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 30, 1, 30, 1,
    30, 1, 22, 23, 22, 23, 2, 2,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 2,
    1, 1, 1, 1, 1, 26, 1, 1,
    19, 19, 19, 19, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 0, 1,
    0, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_10[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 0,
    0, 0, 0, 26, 0, 0, 0, 0,
};

static const Q_UINT8 ui_11[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_1E[] = {
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 16, 16,
    16, 16, 16, 16, 0, 0, 0, 0,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 15, 16, 15, 16, 15, 16,
    15, 16, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_1F[] = {
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 0, 0,
    15, 15, 15, 15, 15, 15, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 0, 0,
    15, 15, 15, 15, 15, 15, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    0, 15, 0, 15, 0, 15, 0, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 0, 0,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 0, 16, 16,
    15, 15, 15, 15, 15, 29, 16, 29,
    29, 29, 16, 16, 16, 0, 16, 16,
    15, 15, 15, 15, 15, 29, 29, 29,
    16, 16, 16, 16, 0, 0, 16, 16,
    15, 15, 15, 15, 0, 29, 29, 29,
    16, 16, 16, 16, 16, 16, 16, 16,
    15, 15, 15, 15, 15, 29, 29, 29,
    0, 0, 16, 16, 16, 0, 16, 16,
    15, 15, 15, 15, 15, 29, 29, 0,
};

static const Q_UINT8 ui_20[] = {
    7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 11, 11, 11, 11,
    21, 21, 21, 21, 21, 21, 26, 26,
    24, 25, 22, 24, 24, 25, 22, 24,
    26, 26, 26, 26, 26, 26, 26, 26,
    8, 9, 11, 11, 11, 11, 11, 0,
    26, 26, 26, 26, 26, 26, 26, 26,
    26, 24, 25, 26, 26, 26, 26, 20,
    20, 26, 26, 26, 27, 22, 23, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 11, 11, 11, 11, 11,
    6, 0, 0, 0, 6, 6, 6, 6,
    6, 6, 27, 27, 27, 22, 23, 16,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 27, 27, 27, 22, 23, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 3, 3, 3,
    3, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_21[] = {
    30, 30, 15, 30, 30, 30, 30, 15,
    30, 30, 16, 15, 15, 15, 16, 16,
    15, 15, 15, 16, 30, 15, 30, 30,
    16, 15, 15, 15, 15, 15, 30, 30,
    30, 30, 30, 30, 15, 30, 15, 30,
    15, 30, 15, 15, 15, 15, 16, 16,
    15, 15, 30, 15, 16, 19, 19, 19,
    19, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    27, 27, 27, 27, 27, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 27, 30, 27, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_22[] = {
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_23[] = {
    30, 0, 30, 30, 30, 30, 30, 30,
    27, 27, 27, 27, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    27, 27, 30, 30, 30, 30, 30, 30,
    30, 22, 23, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_24[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_25[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_26[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    0, 0, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_27[] = {
    0, 30, 30, 30, 30, 0, 30, 30,
    30, 30, 0, 0, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    0, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 30, 0, 30,
    30, 30, 30, 0, 0, 0, 30, 0,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 30, 30, 30, 30, 30, 30, 30,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 30, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    0, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_30[] = {
    7, 26, 26, 26, 30, 18, 19, 5,
    22, 23, 22, 23, 22, 23, 22, 23,
    22, 23, 30, 30, 22, 23, 22, 23,
    22, 23, 22, 23, 21, 22, 23, 23,
    30, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 1, 1, 1, 1, 1, 1,
    21, 18, 18, 18, 18, 18, 30, 30,
    0, 0, 0, 0, 0, 0, 0, 30,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    0, 1, 1, 29, 29, 18, 18, 0,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 20, 18, 18, 18, 0,
};

static const Q_UINT8 ui_31[] = {
    0, 0, 0, 0, 0, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 0,
    0, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    30, 30, 6, 6, 6, 6, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_32[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 0, 0, 0,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 30,
    6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 0, 0, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
};

static const Q_UINT8 ui_33[] = {
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
    0, 0, 0, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 0, 0,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 30,
    30, 30, 30, 30, 30, 30, 30, 0,
};

static const Q_UINT8 ui_4E[] = {
    19, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_9F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_D7[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 19, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_D8[] = {
    12, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_DB[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12,
    12, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12,
};

static const Q_UINT8 ui_DF[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12,
};

static const Q_UINT8 ui_E0[] = {
    13, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_F8[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 13,
};

static const Q_UINT8 ui_F9[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
};

static const Q_UINT8 ui_FA[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 ui_FB[] = {
    16, 16, 16, 16, 16, 16, 16, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 16, 16, 16, 16, 16,
    0, 0, 0, 0, 0, 0, 1, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 27, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    19, 19, 19, 19, 19, 0, 19, 0,
    19, 19, 0, 19, 19, 0, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
};

static const Q_UINT8 ui_FD[] = {
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 22, 23,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 0, 0, 0, 0,
};

static const Q_UINT8 ui_FE[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    26, 21, 21, 20, 20, 22, 23, 22,
    23, 22, 23, 22, 23, 22, 23, 22,
    23, 22, 23, 22, 23, 0, 0, 0,
    0, 26, 26, 26, 26, 20, 20, 20,
    26, 26, 26, 0, 26, 26, 26, 26,
    21, 22, 23, 22, 23, 22, 23, 26,
    26, 26, 27, 21, 27, 27, 27, 0,
    26, 28, 26, 26, 0, 0, 0, 0,
    19, 19, 19, 0, 19, 0, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 0, 0, 11,
};

static const Q_UINT8 ui_FF[] = {
    0, 26, 26, 26, 28, 26, 26, 26,
    22, 23, 26, 27, 26, 21, 26, 26,
    4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 26, 26, 27, 27, 27, 26,
    26, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 22, 26, 23, 29, 20,
    29, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 22, 27, 23, 27, 0,
    0, 26, 22, 23, 26, 20, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    18, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 18, 18,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 19,
    19, 19, 19, 19, 19, 19, 19, 0,
    0, 0, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 19, 19, 19,
    0, 0, 19, 19, 19, 0, 0, 0,
    28, 28, 27, 29, 30, 28, 28, 0,
    27, 27, 27, 27, 27, 30, 30, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 30, 30, 0, 0,
};

static const Q_UINT8 *unicode_info [256] = {
    ui_00, ui_01, ui_02, ui_03, ui_04, ui_05, ui_06, ui_07,
    ui_07, ui_09, ui_0A, ui_0B, ui_0C, ui_0D, ui_0E, ui_0F,
    ui_10, ui_11, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_1E, ui_1F,
    ui_20, ui_21, ui_22, ui_23, ui_24, ui_25, ui_26, ui_27,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_30, ui_31, ui_32, ui_33, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_4E, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_9F,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_4E, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_D7,
    ui_D8, ui_07, ui_07, ui_DB, ui_D8, ui_07, ui_07, ui_DF,
    ui_E0, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07, ui_07,
    ui_F8, ui_F9, ui_FA, ui_FB, ui_F9, ui_FD, ui_FE, ui_FF,
};
// 12544 bytes

static const Q_UINT16 decomposition_map [] = {
    0,
    16, 0x005E, 0x0020, 0x0302, 0,
    16, 0x005F, 0x0020, 0x0332, 0,
    16, 0x0060, 0x0020, 0x0300, 0,
    3, 0x00A0, 0x0020, 0,
    16, 0x00A8, 0x0020, 0x0308, 0,
    9, 0x00AA, 0x0061, 0,
    16, 0x00AF, 0x0020, 0x0304, 0,
    9, 0x00B2, 0x0032, 0,
    9, 0x00B3, 0x0033, 0,
    16, 0x00B4, 0x0020, 0x0301, 0,
    16, 0x00B5, 0x03BC, 0,
    16, 0x00B8, 0x0020, 0x0327, 0,
    9, 0x00B9, 0x0031, 0,
    9, 0x00BA, 0x006F, 0,
    17, 0x00BC, 0x0031, 0x2044, 0x0034, 0,
    17, 0x00BD, 0x0031, 0x2044, 0x0032, 0,
    17, 0x00BE, 0x0033, 0x2044, 0x0034, 0,
    1, 0x00C0, 0x0041, 0x0300, 0,
    1, 0x00C1, 0x0041, 0x0301, 0,
    1, 0x00C2, 0x0041, 0x0302, 0,
    1, 0x00C3, 0x0041, 0x0303, 0,
    1, 0x00C4, 0x0041, 0x0308, 0,
    1, 0x00C5, 0x0041, 0x030A, 0,
    1, 0x00C7, 0x0043, 0x0327, 0,
    1, 0x00C8, 0x0045, 0x0300, 0,
    1, 0x00C9, 0x0045, 0x0301, 0,
    1, 0x00CA, 0x0045, 0x0302, 0,
    1, 0x00CB, 0x0045, 0x0308, 0,
    1, 0x00CC, 0x0049, 0x0300, 0,
    1, 0x00CD, 0x0049, 0x0301, 0,
    1, 0x00CE, 0x0049, 0x0302, 0,
    1, 0x00CF, 0x0049, 0x0308, 0,
    1, 0x00D1, 0x004E, 0x0303, 0,
    1, 0x00D2, 0x004F, 0x0300, 0,
    1, 0x00D3, 0x004F, 0x0301, 0,
    1, 0x00D4, 0x004F, 0x0302, 0,
    1, 0x00D5, 0x004F, 0x0303, 0,
    1, 0x00D6, 0x004F, 0x0308, 0,
    1, 0x00D9, 0x0055, 0x0300, 0,
    1, 0x00DA, 0x0055, 0x0301, 0,
    1, 0x00DB, 0x0055, 0x0302, 0,
    1, 0x00DC, 0x0055, 0x0308, 0,
    1, 0x00DD, 0x0059, 0x0301, 0,
    1, 0x00E0, 0x0061, 0x0300, 0,
    1, 0x00E1, 0x0061, 0x0301, 0,
    1, 0x00E2, 0x0061, 0x0302, 0,
    1, 0x00E3, 0x0061, 0x0303, 0,
    1, 0x00E4, 0x0061, 0x0308, 0,
    1, 0x00E5, 0x0061, 0x030A, 0,
    1, 0x00E7, 0x0063, 0x0327, 0,
    1, 0x00E8, 0x0065, 0x0300, 0,
    1, 0x00E9, 0x0065, 0x0301, 0,
    1, 0x00EA, 0x0065, 0x0302, 0,
    1, 0x00EB, 0x0065, 0x0308, 0,
    1, 0x00EC, 0x0069, 0x0300, 0,
    1, 0x00ED, 0x0069, 0x0301, 0,
    1, 0x00EE, 0x0069, 0x0302, 0,
    1, 0x00EF, 0x0069, 0x0308, 0,
    1, 0x00F1, 0x006E, 0x0303, 0,
    1, 0x00F2, 0x006F, 0x0300, 0,
    1, 0x00F3, 0x006F, 0x0301, 0,
    1, 0x00F4, 0x006F, 0x0302, 0,
    1, 0x00F5, 0x006F, 0x0303, 0,
    1, 0x00F6, 0x006F, 0x0308, 0,
    1, 0x00F9, 0x0075, 0x0300, 0,
    1, 0x00FA, 0x0075, 0x0301, 0,
    1, 0x00FB, 0x0075, 0x0302, 0,
    1, 0x00FC, 0x0075, 0x0308, 0,
    1, 0x00FD, 0x0079, 0x0301, 0,
    1, 0x00FF, 0x0079, 0x0308, 0,
    1, 0x0100, 0x0041, 0x0304, 0,
    1, 0x0101, 0x0061, 0x0304, 0,
    1, 0x0102, 0x0041, 0x0306, 0,
    1, 0x0103, 0x0061, 0x0306, 0,
    1, 0x0104, 0x0041, 0x0328, 0,
    1, 0x0105, 0x0061, 0x0328, 0,
    1, 0x0106, 0x0043, 0x0301, 0,
    1, 0x0107, 0x0063, 0x0301, 0,
    1, 0x0108, 0x0043, 0x0302, 0,
    1, 0x0109, 0x0063, 0x0302, 0,
    1, 0x010A, 0x0043, 0x0307, 0,
    1, 0x010B, 0x0063, 0x0307, 0,
    1, 0x010C, 0x0043, 0x030C, 0,
    1, 0x010D, 0x0063, 0x030C, 0,
    1, 0x010E, 0x0044, 0x030C, 0,
    1, 0x010F, 0x0064, 0x030C, 0,
    1, 0x0112, 0x0045, 0x0304, 0,
    1, 0x0113, 0x0065, 0x0304, 0,
    1, 0x0114, 0x0045, 0x0306, 0,
    1, 0x0115, 0x0065, 0x0306, 0,
    1, 0x0116, 0x0045, 0x0307, 0,
    1, 0x0117, 0x0065, 0x0307, 0,
    1, 0x0118, 0x0045, 0x0328, 0,
    1, 0x0119, 0x0065, 0x0328, 0,
    1, 0x011A, 0x0045, 0x030C, 0,
    1, 0x011B, 0x0065, 0x030C, 0,
    1, 0x011C, 0x0047, 0x0302, 0,
    1, 0x011D, 0x0067, 0x0302, 0,
    1, 0x011E, 0x0047, 0x0306, 0,
    1, 0x011F, 0x0067, 0x0306, 0,
    1, 0x0120, 0x0047, 0x0307, 0,
    1, 0x0121, 0x0067, 0x0307, 0,
    1, 0x0122, 0x0047, 0x0327, 0,
    1, 0x0123, 0x0067, 0x0327, 0,
    1, 0x0124, 0x0048, 0x0302, 0,
    1, 0x0125, 0x0068, 0x0302, 0,
    1, 0x0128, 0x0049, 0x0303, 0,
    1, 0x0129, 0x0069, 0x0303, 0,
    1, 0x012A, 0x0049, 0x0304, 0,
    1, 0x012B, 0x0069, 0x0304, 0,
    1, 0x012C, 0x0049, 0x0306, 0,
    1, 0x012D, 0x0069, 0x0306, 0,
    1, 0x012E, 0x0049, 0x0328, 0,
    1, 0x012F, 0x0069, 0x0328, 0,
    1, 0x0130, 0x0049, 0x0307, 0,
    16, 0x0132, 0x0049, 0x004A, 0,
    16, 0x0133, 0x0069, 0x006A, 0,
    1, 0x0134, 0x004A, 0x0302, 0,
    1, 0x0135, 0x006A, 0x0302, 0,
    1, 0x0136, 0x004B, 0x0327, 0,
    1, 0x0137, 0x006B, 0x0327, 0,
    1, 0x0139, 0x004C, 0x0301, 0,
    1, 0x013A, 0x006C, 0x0301, 0,
    1, 0x013B, 0x004C, 0x0327, 0,
    1, 0x013C, 0x006C, 0x0327, 0,
    1, 0x013D, 0x004C, 0x030C, 0,
    1, 0x013E, 0x006C, 0x030C, 0,
    16, 0x013F, 0x004C, 0x00B7, 0,
    16, 0x0140, 0x006C, 0x00B7, 0,
    1, 0x0143, 0x004E, 0x0301, 0,
    1, 0x0144, 0x006E, 0x0301, 0,
    1, 0x0145, 0x004E, 0x0327, 0,
    1, 0x0146, 0x006E, 0x0327, 0,
    1, 0x0147, 0x004E, 0x030C, 0,
    1, 0x0148, 0x006E, 0x030C, 0,
    16, 0x0149, 0x02BC, 0x006E, 0,
    1, 0x014C, 0x004F, 0x0304, 0,
    1, 0x014D, 0x006F, 0x0304, 0,
    1, 0x014E, 0x004F, 0x0306, 0,
    1, 0x014F, 0x006F, 0x0306, 0,
    1, 0x0150, 0x004F, 0x030B, 0,
    1, 0x0151, 0x006F, 0x030B, 0,
    1, 0x0154, 0x0052, 0x0301, 0,
    1, 0x0155, 0x0072, 0x0301, 0,
    1, 0x0156, 0x0052, 0x0327, 0,
    1, 0x0157, 0x0072, 0x0327, 0,
    1, 0x0158, 0x0052, 0x030C, 0,
    1, 0x0159, 0x0072, 0x030C, 0,
    1, 0x015A, 0x0053, 0x0301, 0,
    1, 0x015B, 0x0073, 0x0301, 0,
    1, 0x015C, 0x0053, 0x0302, 0,
    1, 0x015D, 0x0073, 0x0302, 0,
    1, 0x015E, 0x0053, 0x0327, 0,
    1, 0x015F, 0x0073, 0x0327, 0,
    1, 0x0160, 0x0053, 0x030C, 0,
    1, 0x0161, 0x0073, 0x030C, 0,
    1, 0x0162, 0x0054, 0x0327, 0,
    1, 0x0163, 0x0074, 0x0327, 0,
    1, 0x0164, 0x0054, 0x030C, 0,
    1, 0x0165, 0x0074, 0x030C, 0,
    1, 0x0168, 0x0055, 0x0303, 0,
    1, 0x0169, 0x0075, 0x0303, 0,
    1, 0x016A, 0x0055, 0x0304, 0,
    1, 0x016B, 0x0075, 0x0304, 0,
    1, 0x016C, 0x0055, 0x0306, 0,
    1, 0x016D, 0x0075, 0x0306, 0,
    1, 0x016E, 0x0055, 0x030A, 0,
    1, 0x016F, 0x0075, 0x030A, 0,
    1, 0x0170, 0x0055, 0x030B, 0,
    1, 0x0171, 0x0075, 0x030B, 0,
    1, 0x0172, 0x0055, 0x0328, 0,
    1, 0x0173, 0x0075, 0x0328, 0,
    1, 0x0174, 0x0057, 0x0302, 0,
    1, 0x0175, 0x0077, 0x0302, 0,
    1, 0x0176, 0x0059, 0x0302, 0,
    1, 0x0177, 0x0079, 0x0302, 0,
    1, 0x0178, 0x0059, 0x0308, 0,
    1, 0x0179, 0x005A, 0x0301, 0,
    1, 0x017A, 0x007A, 0x0301, 0,
    1, 0x017B, 0x005A, 0x0307, 0,
    1, 0x017C, 0x007A, 0x0307, 0,
    1, 0x017D, 0x005A, 0x030C, 0,
    1, 0x017E, 0x007A, 0x030C, 0,
    16, 0x017F, 0x0073, 0,
    1, 0x01A0, 0x004F, 0x031B, 0,
    1, 0x01A1, 0x006F, 0x031B, 0,
    1, 0x01AF, 0x0055, 0x031B, 0,
    1, 0x01B0, 0x0075, 0x031B, 0,
    16, 0x01C4, 0x0044, 0x017D, 0,
    16, 0x01C5, 0x0044, 0x017E, 0,
    16, 0x01C6, 0x0064, 0x017E, 0,
    16, 0x01C7, 0x004C, 0x004A, 0,
    16, 0x01C8, 0x004C, 0x006A, 0,
    16, 0x01C9, 0x006C, 0x006A, 0,
    16, 0x01CA, 0x004E, 0x004A, 0,
    16, 0x01CB, 0x004E, 0x006A, 0,
    16, 0x01CC, 0x006E, 0x006A, 0,
    1, 0x01CD, 0x0041, 0x030C, 0,
    1, 0x01CE, 0x0061, 0x030C, 0,
    1, 0x01CF, 0x0049, 0x030C, 0,
    1, 0x01D0, 0x0069, 0x030C, 0,
    1, 0x01D1, 0x004F, 0x030C, 0,
    1, 0x01D2, 0x006F, 0x030C, 0,
    1, 0x01D3, 0x0055, 0x030C, 0,
    1, 0x01D4, 0x0075, 0x030C, 0,
    1, 0x01D5, 0x00DC, 0x0304, 0,
    1, 0x01D6, 0x00FC, 0x0304, 0,
    1, 0x01D7, 0x00DC, 0x0301, 0,
    1, 0x01D8, 0x00FC, 0x0301, 0,
    1, 0x01D9, 0x00DC, 0x030C, 0,
    1, 0x01DA, 0x00FC, 0x030C, 0,
    1, 0x01DB, 0x00DC, 0x0300, 0,
    1, 0x01DC, 0x00FC, 0x0300, 0,
    1, 0x01DE, 0x00C4, 0x0304, 0,
    1, 0x01DF, 0x00E4, 0x0304, 0,
    1, 0x01E0, 0x0041, 0x0307, 0x0304, 0,
    1, 0x01E1, 0x0061, 0x0307, 0x0304, 0,
    1, 0x01E2, 0x00C6, 0x0304, 0,
    1, 0x01E3, 0x00E6, 0x0304, 0,
    1, 0x01E6, 0x0047, 0x030C, 0,
    1, 0x01E7, 0x0067, 0x030C, 0,
    1, 0x01E8, 0x004B, 0x030C, 0,
    1, 0x01E9, 0x006B, 0x030C, 0,
    1, 0x01EA, 0x004F, 0x0328, 0,
    1, 0x01EB, 0x006F, 0x0328, 0,
    1, 0x01EC, 0x01EA, 0x0304, 0,
    1, 0x01ED, 0x01EB, 0x0304, 0,
    1, 0x01EE, 0x01B7, 0x030C, 0,
    1, 0x01EF, 0x0292, 0x030C, 0,
    1, 0x01F0, 0x006A, 0x030C, 0,
    16, 0x01F1, 0x0044, 0x005A, 0,
    16, 0x01F2, 0x0044, 0x007A, 0,
    16, 0x01F3, 0x0064, 0x007A, 0,
    1, 0x01F4, 0x0047, 0x0301, 0,
    1, 0x01F5, 0x0067, 0x0301, 0,
    1, 0x01FA, 0x00C5, 0x0301, 0,
    1, 0x01FB, 0x00E5, 0x0301, 0,
    1, 0x01FC, 0x00C6, 0x0301, 0,
    1, 0x01FD, 0x00E6, 0x0301, 0,
    1, 0x01FE, 0x00D8, 0x0301, 0,
    1, 0x01FF, 0x00F8, 0x0301, 0,
    1, 0x0200, 0x0041, 0x030F, 0,
    1, 0x0201, 0x0061, 0x030F, 0,
    1, 0x0202, 0x0041, 0x0311, 0,
    1, 0x0203, 0x0061, 0x0311, 0,
    1, 0x0204, 0x0045, 0x030F, 0,
    1, 0x0205, 0x0065, 0x030F, 0,
    1, 0x0206, 0x0045, 0x0311, 0,
    1, 0x0207, 0x0065, 0x0311, 0,
    1, 0x0208, 0x0049, 0x030F, 0,
    1, 0x0209, 0x0069, 0x030F, 0,
    1, 0x020A, 0x0049, 0x0311, 0,
    1, 0x020B, 0x0069, 0x0311, 0,
    1, 0x020C, 0x004F, 0x030F, 0,
    1, 0x020D, 0x006F, 0x030F, 0,
    1, 0x020E, 0x004F, 0x0311, 0,
    1, 0x020F, 0x006F, 0x0311, 0,
    1, 0x0210, 0x0052, 0x030F, 0,
    1, 0x0211, 0x0072, 0x030F, 0,
    1, 0x0212, 0x0052, 0x0311, 0,
    1, 0x0213, 0x0072, 0x0311, 0,
    1, 0x0214, 0x0055, 0x030F, 0,
    1, 0x0215, 0x0075, 0x030F, 0,
    1, 0x0216, 0x0055, 0x0311, 0,
    1, 0x0217, 0x0075, 0x0311, 0,
    9, 0x02B0, 0x0068, 0,
    9, 0x02B1, 0x0266, 0,
    9, 0x02B2, 0x006A, 0,
    9, 0x02B3, 0x0072, 0,
    9, 0x02B4, 0x0279, 0,
    9, 0x02B5, 0x027B, 0,
    9, 0x02B6, 0x0281, 0,
    9, 0x02B7, 0x0077, 0,
    9, 0x02B8, 0x0079, 0,
    16, 0x02D8, 0x0020, 0x0306, 0,
    16, 0x02D9, 0x0020, 0x0307, 0,
    16, 0x02DA, 0x0020, 0x030A, 0,
    16, 0x02DB, 0x0020, 0x0328, 0,
    16, 0x02DC, 0x0020, 0x0303, 0,
    16, 0x02DD, 0x0020, 0x030B, 0,
    9, 0x02E0, 0x0263, 0,
    9, 0x02E1, 0x006C, 0,
    9, 0x02E2, 0x0073, 0,
    9, 0x02E3, 0x0078, 0,
    9, 0x02E4, 0x0295, 0,
    1, 0x0340, 0x0300, 0,
    1, 0x0341, 0x0301, 0,
    1, 0x0343, 0x0313, 0,
    1, 0x0344, 0x0308, 0x0301, 0,
    1, 0x0374, 0x02B9, 0,
    16, 0x037A, 0x0020, 0x0345, 0,
    1, 0x037E, 0x003B, 0,
    16, 0x0384, 0x0020, 0x0301, 0,
    1, 0x0385, 0x00A8, 0x0301, 0,
    1, 0x0386, 0x0391, 0x0301, 0,
    1, 0x0387, 0x00B7, 0,
    1, 0x0388, 0x0395, 0x0301, 0,
    1, 0x0389, 0x0397, 0x0301, 0,
    1, 0x038A, 0x0399, 0x0301, 0,
    1, 0x038C, 0x039F, 0x0301, 0,
    1, 0x038E, 0x03A5, 0x0301, 0,
    1, 0x038F, 0x03A9, 0x0301, 0,
    1, 0x0390, 0x03CA, 0x0301, 0,
    1, 0x03AA, 0x0399, 0x0308, 0,
    1, 0x03AB, 0x03A5, 0x0308, 0,
    1, 0x03AC, 0x03B1, 0x0301, 0,
    1, 0x03AD, 0x03B5, 0x0301, 0,
    1, 0x03AE, 0x03B7, 0x0301, 0,
    1, 0x03AF, 0x03B9, 0x0301, 0,
    1, 0x03B0, 0x03CB, 0x0301, 0,
    1, 0x03CA, 0x03B9, 0x0308, 0,
    1, 0x03CB, 0x03C5, 0x0308, 0,
    1, 0x03CC, 0x03BF, 0x0301, 0,
    1, 0x03CD, 0x03C5, 0x0301, 0,
    1, 0x03CE, 0x03C9, 0x0301, 0,
    1, 0x03D3, 0x03D2, 0x0301, 0,
    1, 0x03D4, 0x03D2, 0x0308, 0,
    1, 0x0401, 0x0415, 0x0308, 0,
    1, 0x0403, 0x0413, 0x0301, 0,
    1, 0x0407, 0x0406, 0x0308, 0,
    1, 0x040C, 0x041A, 0x0301, 0,
    1, 0x040E, 0x0423, 0x0306, 0,
    1, 0x0419, 0x0418, 0x0306, 0,
    1, 0x0439, 0x0438, 0x0306, 0,
    1, 0x0451, 0x0435, 0x0308, 0,
    1, 0x0453, 0x0433, 0x0301, 0,
    1, 0x0457, 0x0456, 0x0308, 0,
    1, 0x045C, 0x043A, 0x0301, 0,
    1, 0x045E, 0x0443, 0x0306, 0,
    1, 0x0476, 0x0474, 0x030F, 0,
    1, 0x0477, 0x0475, 0x030F, 0,
    1, 0x04C1, 0x0416, 0x0306, 0,
    1, 0x04C2, 0x0436, 0x0306, 0,
    1, 0x04D0, 0x0410, 0x0306, 0,
    1, 0x04D1, 0x0430, 0x0306, 0,
    1, 0x04D2, 0x0410, 0x0308, 0,
    1, 0x04D3, 0x0430, 0x0308, 0,
    1, 0x04D6, 0x0415, 0x0306, 0,
    1, 0x04D7, 0x0435, 0x0306, 0,
    1, 0x04DA, 0x04D8, 0x0308, 0,
    1, 0x04DB, 0x04D9, 0x0308, 0,
    1, 0x04DC, 0x0416, 0x0308, 0,
    1, 0x04DD, 0x0436, 0x0308, 0,
    1, 0x04DE, 0x0417, 0x0308, 0,
    1, 0x04DF, 0x0437, 0x0308, 0,
    1, 0x04E2, 0x0418, 0x0304, 0,
    1, 0x04E3, 0x0438, 0x0304, 0,
    1, 0x04E4, 0x0418, 0x0308, 0,
    1, 0x04E5, 0x0438, 0x0308, 0,
    1, 0x04E6, 0x041E, 0x0308, 0,
    1, 0x04E7, 0x043E, 0x0308, 0,
    1, 0x04EA, 0x04E8, 0x0308, 0,
    1, 0x04EB, 0x04E9, 0x0308, 0,
    1, 0x04EE, 0x0423, 0x0304, 0,
    1, 0x04EF, 0x0443, 0x0304, 0,
    1, 0x04F0, 0x0423, 0x0308, 0,
    1, 0x04F1, 0x0443, 0x0308, 0,
    1, 0x04F2, 0x0423, 0x030B, 0,
    1, 0x04F3, 0x0443, 0x030B, 0,
    1, 0x04F4, 0x0427, 0x0308, 0,
    1, 0x04F5, 0x0447, 0x0308, 0,
    1, 0x04F8, 0x042B, 0x0308, 0,
    1, 0x04F9, 0x044B, 0x0308, 0,
    16, 0x0587, 0x0565, 0x0582, 0,
    1, 0x0929, 0x0928, 0x093C, 0,
    1, 0x0931, 0x0930, 0x093C, 0,
    1, 0x0934, 0x0933, 0x093C, 0,
    1, 0x0958, 0x0915, 0x093C, 0,
    1, 0x0959, 0x0916, 0x093C, 0,
    1, 0x095A, 0x0917, 0x093C, 0,
    1, 0x095B, 0x091C, 0x093C, 0,
    1, 0x095C, 0x0921, 0x093C, 0,
    1, 0x095D, 0x0922, 0x093C, 0,
    1, 0x095E, 0x092B, 0x093C, 0,
    1, 0x095F, 0x092F, 0x093C, 0,
    1, 0x09B0, 0x09AC, 0x09BC, 0,
    1, 0x09CB, 0x09C7, 0x09BE, 0,
    1, 0x09CC, 0x09C7, 0x09D7, 0,
    1, 0x09DC, 0x09A1, 0x09BC, 0,
    1, 0x09DD, 0x09A2, 0x09BC, 0,
    1, 0x09DF, 0x09AF, 0x09BC, 0,
    1, 0x0A59, 0x0A16, 0x0A3C, 0,
    1, 0x0A5A, 0x0A17, 0x0A3C, 0,
    1, 0x0A5B, 0x0A1C, 0x0A3C, 0,
    1, 0x0A5C, 0x0A21, 0x0A3C, 0,
    1, 0x0A5E, 0x0A2B, 0x0A3C, 0,
    1, 0x0B48, 0x0B47, 0x0B56, 0,
    1, 0x0B4B, 0x0B47, 0x0B3E, 0,
    1, 0x0B4C, 0x0B47, 0x0B57, 0,
    1, 0x0B5C, 0x0B21, 0x0B3C, 0,
    1, 0x0B5D, 0x0B22, 0x0B3C, 0,
    1, 0x0B5F, 0x0B2F, 0x0B3C, 0,
    1, 0x0B94, 0x0B92, 0x0BD7, 0,
    1, 0x0BCA, 0x0BC6, 0x0BBE, 0,
    1, 0x0BCB, 0x0BC7, 0x0BBE, 0,
    1, 0x0BCC, 0x0BC6, 0x0BD7, 0,
    1, 0x0C48, 0x0C46, 0x0C56, 0,
    1, 0x0CC0, 0x0CBF, 0x0CD5, 0,
    1, 0x0CC7, 0x0CC6, 0x0CD5, 0,
    1, 0x0CC8, 0x0CC6, 0x0CD6, 0,
    1, 0x0CCA, 0x0CC6, 0x0CC2, 0,
    1, 0x0CCB, 0x0CCA, 0x0CD5, 0,
    1, 0x0D4A, 0x0D46, 0x0D3E, 0,
    1, 0x0D4B, 0x0D47, 0x0D3E, 0,
    1, 0x0D4C, 0x0D46, 0x0D57, 0,
    1, 0x0E33, 0x0E4D, 0x0E32, 0,
    1, 0x0EB3, 0x0ECD, 0x0EB2, 0,
    16, 0x0EDC, 0x0EAB, 0x0E99, 0,
    16, 0x0EDD, 0x0EAB, 0x0EA1, 0,
    1, 0x0F43, 0x0F42, 0x0FB7, 0,
    1, 0x0F4D, 0x0F4C, 0x0FB7, 0,
    1, 0x0F52, 0x0F51, 0x0FB7, 0,
    1, 0x0F57, 0x0F56, 0x0FB7, 0,
    1, 0x0F5C, 0x0F5B, 0x0FB7, 0,
    1, 0x0F69, 0x0F40, 0x0FB5, 0,
    1, 0x0F73, 0x0F72, 0x0F71, 0,
    1, 0x0F75, 0x0F71, 0x0F74, 0,
    1, 0x0F76, 0x0FB2, 0x0F80, 0,
    1, 0x0F77, 0x0F76, 0x0F71, 0,
    1, 0x0F78, 0x0FB3, 0x0F80, 0,
    1, 0x0F79, 0x0F78, 0x0F71, 0,
    1, 0x0F81, 0x0F80, 0x0F71, 0,
    1, 0x0F93, 0x0F92, 0x0FB7, 0,
    1, 0x0F9D, 0x0F9C, 0x0FB7, 0,
    1, 0x0FA2, 0x0FA1, 0x0FB7, 0,
    1, 0x0FA7, 0x0FA6, 0x0FB7, 0,
    1, 0x0FAC, 0x0FAB, 0x0FB7, 0,
    1, 0x0FB9, 0x0F90, 0x0FB5, 0,
    16, 0x1101, 0x1100, 0x1100, 0,
    16, 0x1104, 0x1103, 0x1103, 0,
    16, 0x1108, 0x1107, 0x1107, 0,
    16, 0x110A, 0x1109, 0x1109, 0,
    16, 0x110D, 0x110C, 0x110C, 0,
    16, 0x1113, 0x1102, 0x1100, 0,
    16, 0x1114, 0x1102, 0x1102, 0,
    16, 0x1115, 0x1102, 0x1103, 0,
    16, 0x1116, 0x1102, 0x1107, 0,
    16, 0x1117, 0x1103, 0x1100, 0,
    16, 0x1118, 0x1105, 0x1102, 0,
    16, 0x1119, 0x1105, 0x1105, 0,
    16, 0x111A, 0x1105, 0x1112, 0,
    16, 0x111B, 0x1105, 0x110B, 0,
    16, 0x111C, 0x1106, 0x1107, 0,
    16, 0x111D, 0x1106, 0x110B, 0,
    16, 0x111E, 0x1107, 0x1100, 0,
    16, 0x111F, 0x1107, 0x1102, 0,
    16, 0x1120, 0x1107, 0x1103, 0,
    16, 0x1121, 0x1107, 0x1109, 0,
    16, 0x1122, 0x1107, 0x1109, 0x1100, 0,
    16, 0x1123, 0x1107, 0x1109, 0x1103, 0,
    16, 0x1124, 0x1107, 0x1109, 0x1107, 0,
    16, 0x1125, 0x1107, 0x1109, 0x1109, 0,
    16, 0x1126, 0x1107, 0x1109, 0x110C, 0,
    16, 0x1127, 0x1107, 0x110C, 0,
    16, 0x1128, 0x1107, 0x110E, 0,
    16, 0x1129, 0x1107, 0x1110, 0,
    16, 0x112A, 0x1107, 0x1111, 0,
    16, 0x112B, 0x1107, 0x110B, 0,
    16, 0x112C, 0x1107, 0x1107, 0x110B, 0,
    16, 0x112D, 0x1109, 0x1100, 0,
    16, 0x112E, 0x1109, 0x1102, 0,
    16, 0x112F, 0x1109, 0x1103, 0,
    16, 0x1130, 0x1109, 0x1105, 0,
    16, 0x1131, 0x1109, 0x1106, 0,
    16, 0x1132, 0x1109, 0x1107, 0,
    16, 0x1133, 0x1109, 0x1107, 0x1100, 0,
    16, 0x1134, 0x1109, 0x1109, 0x1109, 0,
    16, 0x1135, 0x1109, 0x110B, 0,
    16, 0x1136, 0x1109, 0x110C, 0,
    16, 0x1137, 0x1109, 0x110E, 0,
    16, 0x1138, 0x1109, 0x110F, 0,
    16, 0x1139, 0x1109, 0x1110, 0,
    16, 0x113A, 0x1109, 0x1111, 0,
    16, 0x113B, 0x1109, 0x1112, 0,
    16, 0x113D, 0x113C, 0x113C, 0,
    16, 0x113F, 0x113E, 0x113E, 0,
    16, 0x1141, 0x110B, 0x1100, 0,
    16, 0x1142, 0x110B, 0x1103, 0,
    16, 0x1143, 0x110B, 0x1106, 0,
    16, 0x1144, 0x110B, 0x1107, 0,
    16, 0x1145, 0x110B, 0x1109, 0,
    16, 0x1146, 0x110B, 0x1140, 0,
    16, 0x1147, 0x110B, 0x110B, 0,
    16, 0x1148, 0x110B, 0x110C, 0,
    16, 0x1149, 0x110B, 0x110E, 0,
    16, 0x114A, 0x110B, 0x1110, 0,
    16, 0x114B, 0x110B, 0x1111, 0,
    16, 0x114D, 0x110C, 0x110B, 0,
    16, 0x114F, 0x114E, 0x114E, 0,
    16, 0x1151, 0x1150, 0x1150, 0,
    16, 0x1152, 0x110E, 0x110F, 0,
    16, 0x1153, 0x110E, 0x1112, 0,
    16, 0x1156, 0x1111, 0x1107, 0,
    16, 0x1157, 0x1111, 0x110B, 0,
    16, 0x1158, 0x1112, 0x1112, 0,
    16, 0x1162, 0x1161, 0x1175, 0,
    16, 0x1164, 0x1163, 0x1175, 0,
    16, 0x1166, 0x1165, 0x1175, 0,
    16, 0x1168, 0x1167, 0x1175, 0,
    16, 0x116A, 0x1169, 0x1161, 0,
    16, 0x116B, 0x1169, 0x1161, 0x1175, 0,
    16, 0x116C, 0x1169, 0x1175, 0,
    16, 0x116F, 0x116E, 0x1165, 0,
    16, 0x1170, 0x116E, 0x1165, 0x1175, 0,
    16, 0x1171, 0x116E, 0x1175, 0,
    16, 0x1174, 0x1173, 0x1175, 0,
    16, 0x1176, 0x1161, 0x1169, 0,
    16, 0x1177, 0x1161, 0x116E, 0,
    16, 0x1178, 0x1163, 0x1169, 0,
    16, 0x1179, 0x1163, 0x116D, 0,
    16, 0x117A, 0x1165, 0x1169, 0,
    16, 0x117B, 0x1165, 0x116E, 0,
    16, 0x117C, 0x1165, 0x1173, 0,
    16, 0x117D, 0x1167, 0x1169, 0,
    16, 0x117E, 0x1167, 0x116E, 0,
    16, 0x117F, 0x1169, 0x1165, 0,
    16, 0x1180, 0x1169, 0x1166, 0,
    16, 0x1181, 0x1169, 0x1168, 0,
    16, 0x1182, 0x1169, 0x1169, 0,
    16, 0x1183, 0x1169, 0x116E, 0,
    16, 0x1184, 0x116D, 0x1163, 0,
    16, 0x1185, 0x116D, 0x1164, 0,
    16, 0x1186, 0x116D, 0x1167, 0,
    16, 0x1187, 0x116D, 0x1169, 0,
    16, 0x1188, 0x116D, 0x1175, 0,
    16, 0x1189, 0x116E, 0x1161, 0,
    16, 0x118A, 0x116E, 0x1162, 0,
    16, 0x118B, 0x116E, 0x1165, 0x1173, 0,
    16, 0x118C, 0x116E, 0x1168, 0,
    16, 0x118D, 0x116E, 0x116E, 0,
    16, 0x118E, 0x1172, 0x1161, 0,
    16, 0x118F, 0x1172, 0x1165, 0,
    16, 0x1190, 0x1172, 0x1166, 0,
    16, 0x1191, 0x1172, 0x1167, 0,
    16, 0x1192, 0x1172, 0x1168, 0,
    16, 0x1193, 0x1172, 0x116E, 0,
    16, 0x1194, 0x1172, 0x1175, 0,
    16, 0x1195, 0x1173, 0x116E, 0,
    16, 0x1196, 0x1173, 0x1173, 0,
    16, 0x1197, 0x1174, 0x116E, 0,
    16, 0x1198, 0x1175, 0x1161, 0,
    16, 0x1199, 0x1175, 0x1163, 0,
    16, 0x119A, 0x1175, 0x1169, 0,
    16, 0x119B, 0x1175, 0x116E, 0,
    16, 0x119C, 0x1175, 0x1173, 0,
    16, 0x119D, 0x1175, 0x119E, 0,
    16, 0x119F, 0x119E, 0x1165, 0,
    16, 0x11A0, 0x119E, 0x116E, 0,
    16, 0x11A1, 0x119E, 0x1175, 0,
    16, 0x11A2, 0x119E, 0x119E, 0,
    16, 0x11A9, 0x11A8, 0x11A8, 0,
    16, 0x11AA, 0x11A8, 0x11BA, 0,
    16, 0x11AC, 0x11AB, 0x11BD, 0,
    16, 0x11AD, 0x11AB, 0x11C2, 0,
    16, 0x11B0, 0x11AF, 0x11A8, 0,
    16, 0x11B1, 0x11AF, 0x11B7, 0,
    16, 0x11B2, 0x11AF, 0x11B8, 0,
    16, 0x11B3, 0x11AF, 0x11BA, 0,
    16, 0x11B4, 0x11AF, 0x11C0, 0,
    16, 0x11B5, 0x11AF, 0x11C1, 0,
    16, 0x11B6, 0x11AF, 0x11C2, 0,
    16, 0x11B9, 0x11B8, 0x11BA, 0,
    16, 0x11BB, 0x11BA, 0x11BA, 0,
    16, 0x11C3, 0x11A8, 0x11AF, 0,
    16, 0x11C4, 0x11A8, 0x11BA, 0x11A8, 0,
    16, 0x11C5, 0x11AB, 0x11A8, 0,
    16, 0x11C6, 0x11AB, 0x11AE, 0,
    16, 0x11C7, 0x11AB, 0x11BA, 0,
    16, 0x11C8, 0x11AB, 0x11EB, 0,
    16, 0x11C9, 0x11AB, 0x11C0, 0,
    16, 0x11CA, 0x11AE, 0x11A8, 0,
    16, 0x11CB, 0x11AE, 0x11AF, 0,
    16, 0x11CC, 0x11AF, 0x11A8, 0x11BA, 0,
    16, 0x11CD, 0x11AF, 0x11AB, 0,
    16, 0x11CE, 0x11AF, 0x11AE, 0,
    16, 0x11CF, 0x11AF, 0x11AE, 0x11C2, 0,
    16, 0x11D0, 0x11AF, 0x11AF, 0,
    16, 0x11D1, 0x11AF, 0x11B7, 0x11A8, 0,
    16, 0x11D2, 0x11AF, 0x11B7, 0x11BA, 0,
    16, 0x11D3, 0x11AF, 0x11B8, 0x11BA, 0,
    16, 0x11D4, 0x11AF, 0x11B8, 0x11C2, 0,
    16, 0x11D5, 0x11AF, 0x11B8, 0x11BC, 0,
    16, 0x11D6, 0x11AF, 0x11BA, 0x11BA, 0,
    16, 0x11D7, 0x11AF, 0x11EB, 0,
    16, 0x11D8, 0x11AF, 0x11BF, 0,
    16, 0x11D9, 0x11AF, 0x11F9, 0,
    16, 0x11DA, 0x11B7, 0x11A8, 0,
    16, 0x11DB, 0x11B7, 0x11AF, 0,
    16, 0x11DC, 0x11B7, 0x11B8, 0,
    16, 0x11DD, 0x11B7, 0x11BA, 0,
    16, 0x11DE, 0x11B7, 0x11BA, 0x11BA, 0,
    16, 0x11DF, 0x11B7, 0x11EB, 0,
    16, 0x11E0, 0x11B7, 0x11BE, 0,
    16, 0x11E1, 0x11B7, 0x11C2, 0,
    16, 0x11E2, 0x11B7, 0x11BC, 0,
    16, 0x11E3, 0x11B8, 0x11AF, 0,
    16, 0x11E4, 0x11B8, 0x11C1, 0,
    16, 0x11E5, 0x11B8, 0x11C2, 0,
    16, 0x11E6, 0x11B8, 0x11BC, 0,
    16, 0x11E7, 0x11BA, 0x11A8, 0,
    16, 0x11E8, 0x11BA, 0x11AE, 0,
    16, 0x11E9, 0x11BA, 0x11AF, 0,
    16, 0x11EA, 0x11BA, 0x11B8, 0,
    16, 0x11EC, 0x11BC, 0x11A8, 0,
    16, 0x11ED, 0x11BC, 0x11A8, 0x11A8, 0,
    16, 0x11EE, 0x11BC, 0x11BC, 0,
    16, 0x11EF, 0x11BC, 0x11BF, 0,
    16, 0x11F1, 0x11F0, 0x11BA, 0,
    16, 0x11F2, 0x11F0, 0x11EB, 0,
    16, 0x11F3, 0x11C1, 0x11B8, 0,
    16, 0x11F4, 0x11C1, 0x11BC, 0,
    16, 0x11F5, 0x11C2, 0x11AB, 0,
    16, 0x11F6, 0x11C2, 0x11AF, 0,
    16, 0x11F7, 0x11C2, 0x11B7, 0,
    16, 0x11F8, 0x11C2, 0x11B8, 0,
    1, 0x1E00, 0x0041, 0x0325, 0,
    1, 0x1E01, 0x0061, 0x0325, 0,
    1, 0x1E02, 0x0042, 0x0307, 0,
    1, 0x1E03, 0x0062, 0x0307, 0,
    1, 0x1E04, 0x0042, 0x0323, 0,
    1, 0x1E05, 0x0062, 0x0323, 0,
    1, 0x1E06, 0x0042, 0x0331, 0,
    1, 0x1E07, 0x0062, 0x0331, 0,
    1, 0x1E08, 0x00C7, 0x0301, 0,
    1, 0x1E09, 0x00E7, 0x0301, 0,
    1, 0x1E0A, 0x0044, 0x0307, 0,
    1, 0x1E0B, 0x0064, 0x0307, 0,
    1, 0x1E0C, 0x0044, 0x0323, 0,
    1, 0x1E0D, 0x0064, 0x0323, 0,
    1, 0x1E0E, 0x0044, 0x0331, 0,
    1, 0x1E0F, 0x0064, 0x0331, 0,
    1, 0x1E10, 0x0044, 0x0327, 0,
    1, 0x1E11, 0x0064, 0x0327, 0,
    1, 0x1E12, 0x0044, 0x032D, 0,
    1, 0x1E13, 0x0064, 0x032D, 0,
    1, 0x1E14, 0x0112, 0x0300, 0,
    1, 0x1E15, 0x0113, 0x0300, 0,
    1, 0x1E16, 0x0112, 0x0301, 0,
    1, 0x1E17, 0x0113, 0x0301, 0,
    1, 0x1E18, 0x0045, 0x032D, 0,
    1, 0x1E19, 0x0065, 0x032D, 0,
    1, 0x1E1A, 0x0045, 0x0330, 0,
    1, 0x1E1B, 0x0065, 0x0330, 0,
    1, 0x1E1C, 0x0114, 0x0327, 0,
    1, 0x1E1D, 0x0115, 0x0327, 0,
    1, 0x1E1E, 0x0046, 0x0307, 0,
    1, 0x1E1F, 0x0066, 0x0307, 0,
    1, 0x1E20, 0x0047, 0x0304, 0,
    1, 0x1E21, 0x0067, 0x0304, 0,
    1, 0x1E22, 0x0048, 0x0307, 0,
    1, 0x1E23, 0x0068, 0x0307, 0,
    1, 0x1E24, 0x0048, 0x0323, 0,
    1, 0x1E25, 0x0068, 0x0323, 0,
    1, 0x1E26, 0x0048, 0x0308, 0,
    1, 0x1E27, 0x0068, 0x0308, 0,
    1, 0x1E28, 0x0048, 0x0327, 0,
    1, 0x1E29, 0x0068, 0x0327, 0,
    1, 0x1E2A, 0x0048, 0x032E, 0,
    1, 0x1E2B, 0x0068, 0x032E, 0,
    1, 0x1E2C, 0x0049, 0x0330, 0,
    1, 0x1E2D, 0x0069, 0x0330, 0,
    1, 0x1E2E, 0x00CF, 0x0301, 0,
    1, 0x1E2F, 0x00EF, 0x0301, 0,
    1, 0x1E30, 0x004B, 0x0301, 0,
    1, 0x1E31, 0x006B, 0x0301, 0,
    1, 0x1E32, 0x004B, 0x0323, 0,
    1, 0x1E33, 0x006B, 0x0323, 0,
    1, 0x1E34, 0x004B, 0x0331, 0,
    1, 0x1E35, 0x006B, 0x0331, 0,
    1, 0x1E36, 0x004C, 0x0323, 0,
    1, 0x1E37, 0x006C, 0x0323, 0,
    1, 0x1E38, 0x1E36, 0x0304, 0,
    1, 0x1E39, 0x1E37, 0x0304, 0,
    1, 0x1E3A, 0x004C, 0x0331, 0,
    1, 0x1E3B, 0x006C, 0x0331, 0,
    1, 0x1E3C, 0x004C, 0x032D, 0,
    1, 0x1E3D, 0x006C, 0x032D, 0,
    1, 0x1E3E, 0x004D, 0x0301, 0,
    1, 0x1E3F, 0x006D, 0x0301, 0,
    1, 0x1E40, 0x004D, 0x0307, 0,
    1, 0x1E41, 0x006D, 0x0307, 0,
    1, 0x1E42, 0x004D, 0x0323, 0,
    1, 0x1E43, 0x006D, 0x0323, 0,
    1, 0x1E44, 0x004E, 0x0307, 0,
    1, 0x1E45, 0x006E, 0x0307, 0,
    1, 0x1E46, 0x004E, 0x0323, 0,
    1, 0x1E47, 0x006E, 0x0323, 0,
    1, 0x1E48, 0x004E, 0x0331, 0,
    1, 0x1E49, 0x006E, 0x0331, 0,
    1, 0x1E4A, 0x004E, 0x032D, 0,
    1, 0x1E4B, 0x006E, 0x032D, 0,
    1, 0x1E4C, 0x00D5, 0x0301, 0,
    1, 0x1E4D, 0x00F5, 0x0301, 0,
    1, 0x1E4E, 0x00D5, 0x0308, 0,
    1, 0x1E4F, 0x00F5, 0x0308, 0,
    1, 0x1E50, 0x014C, 0x0300, 0,
    1, 0x1E51, 0x014D, 0x0300, 0,
    1, 0x1E52, 0x014C, 0x0301, 0,
    1, 0x1E53, 0x014D, 0x0301, 0,
    1, 0x1E54, 0x0050, 0x0301, 0,
    1, 0x1E55, 0x0070, 0x0301, 0,
    1, 0x1E56, 0x0050, 0x0307, 0,
    1, 0x1E57, 0x0070, 0x0307, 0,
    1, 0x1E58, 0x0052, 0x0307, 0,
    1, 0x1E59, 0x0072, 0x0307, 0,
    1, 0x1E5A, 0x0052, 0x0323, 0,
    1, 0x1E5B, 0x0072, 0x0323, 0,
    1, 0x1E5C, 0x1E5A, 0x0304, 0,
    1, 0x1E5D, 0x1E5B, 0x0304, 0,
    1, 0x1E5E, 0x0052, 0x0331, 0,
    1, 0x1E5F, 0x0072, 0x0331, 0,
    1, 0x1E60, 0x0053, 0x0307, 0,
    1, 0x1E61, 0x0073, 0x0307, 0,
    1, 0x1E62, 0x0053, 0x0323, 0,
    1, 0x1E63, 0x0073, 0x0323, 0,
    1, 0x1E64, 0x015A, 0x0307, 0,
    1, 0x1E65, 0x015B, 0x0307, 0,
    1, 0x1E66, 0x0160, 0x0307, 0,
    1, 0x1E67, 0x0161, 0x0307, 0,
    1, 0x1E68, 0x1E62, 0x0307, 0,
    1, 0x1E69, 0x1E63, 0x0307, 0,
    1, 0x1E6A, 0x0054, 0x0307, 0,
    1, 0x1E6B, 0x0074, 0x0307, 0,
    1, 0x1E6C, 0x0054, 0x0323, 0,
    1, 0x1E6D, 0x0074, 0x0323, 0,
    1, 0x1E6E, 0x0054, 0x0331, 0,
    1, 0x1E6F, 0x0074, 0x0331, 0,
    1, 0x1E70, 0x0054, 0x032D, 0,
    1, 0x1E71, 0x0074, 0x032D, 0,
    1, 0x1E72, 0x0055, 0x0324, 0,
    1, 0x1E73, 0x0075, 0x0324, 0,
    1, 0x1E74, 0x0055, 0x0330, 0,
    1, 0x1E75, 0x0075, 0x0330, 0,
    1, 0x1E76, 0x0055, 0x032D, 0,
    1, 0x1E77, 0x0075, 0x032D, 0,
    1, 0x1E78, 0x0168, 0x0301, 0,
    1, 0x1E79, 0x0169, 0x0301, 0,
    1, 0x1E7A, 0x016A, 0x0308, 0,
    1, 0x1E7B, 0x016B, 0x0308, 0,
    1, 0x1E7C, 0x0056, 0x0303, 0,
    1, 0x1E7D, 0x0076, 0x0303, 0,
    1, 0x1E7E, 0x0056, 0x0323, 0,
    1, 0x1E7F, 0x0076, 0x0323, 0,
    1, 0x1E80, 0x0057, 0x0300, 0,
    1, 0x1E81, 0x0077, 0x0300, 0,
    1, 0x1E82, 0x0057, 0x0301, 0,
    1, 0x1E83, 0x0077, 0x0301, 0,
    1, 0x1E84, 0x0057, 0x0308, 0,
    1, 0x1E85, 0x0077, 0x0308, 0,
    1, 0x1E86, 0x0057, 0x0307, 0,
    1, 0x1E87, 0x0077, 0x0307, 0,
    1, 0x1E88, 0x0057, 0x0323, 0,
    1, 0x1E89, 0x0077, 0x0323, 0,
    1, 0x1E8A, 0x0058, 0x0307, 0,
    1, 0x1E8B, 0x0078, 0x0307, 0,
    1, 0x1E8C, 0x0058, 0x0308, 0,
    1, 0x1E8D, 0x0078, 0x0308, 0,
    1, 0x1E8E, 0x0059, 0x0307, 0,
    1, 0x1E8F, 0x0079, 0x0307, 0,
    1, 0x1E90, 0x005A, 0x0302, 0,
    1, 0x1E91, 0x007A, 0x0302, 0,
    1, 0x1E92, 0x005A, 0x0323, 0,
    1, 0x1E93, 0x007A, 0x0323, 0,
    1, 0x1E94, 0x005A, 0x0331, 0,
    1, 0x1E95, 0x007A, 0x0331, 0,
    1, 0x1E96, 0x0068, 0x0331, 0,
    1, 0x1E97, 0x0074, 0x0308, 0,
    1, 0x1E98, 0x0077, 0x030A, 0,
    1, 0x1E99, 0x0079, 0x030A, 0,
    16, 0x1E9A, 0x0061, 0x02BE, 0,
    1, 0x1E9B, 0x017F, 0x0307, 0,
    1, 0x1EA0, 0x0041, 0x0323, 0,
    1, 0x1EA1, 0x0061, 0x0323, 0,
    1, 0x1EA2, 0x0041, 0x0309, 0,
    1, 0x1EA3, 0x0061, 0x0309, 0,
    1, 0x1EA4, 0x00C2, 0x0301, 0,
    1, 0x1EA5, 0x00E2, 0x0301, 0,
    1, 0x1EA6, 0x00C2, 0x0300, 0,
    1, 0x1EA7, 0x00E2, 0x0300, 0,
    1, 0x1EA8, 0x00C2, 0x0309, 0,
    1, 0x1EA9, 0x00E2, 0x0309, 0,
    1, 0x1EAA, 0x00C2, 0x0303, 0,
    1, 0x1EAB, 0x00E2, 0x0303, 0,
    1, 0x1EAC, 0x00C2, 0x0323, 0,
    1, 0x1EAD, 0x00E2, 0x0323, 0,
    1, 0x1EAE, 0x0102, 0x0301, 0,
    1, 0x1EAF, 0x0103, 0x0301, 0,
    1, 0x1EB0, 0x0102, 0x0300, 0,
    1, 0x1EB1, 0x0103, 0x0300, 0,
    1, 0x1EB2, 0x0102, 0x0309, 0,
    1, 0x1EB3, 0x0103, 0x0309, 0,
    1, 0x1EB4, 0x0102, 0x0303, 0,
    1, 0x1EB5, 0x0103, 0x0303, 0,
    1, 0x1EB6, 0x0102, 0x0323, 0,
    1, 0x1EB7, 0x0103, 0x0323, 0,
    1, 0x1EB8, 0x0045, 0x0323, 0,
    1, 0x1EB9, 0x0065, 0x0323, 0,
    1, 0x1EBA, 0x0045, 0x0309, 0,
    1, 0x1EBB, 0x0065, 0x0309, 0,
    1, 0x1EBC, 0x0045, 0x0303, 0,
    1, 0x1EBD, 0x0065, 0x0303, 0,
    1, 0x1EBE, 0x00CA, 0x0301, 0,
    1, 0x1EBF, 0x00EA, 0x0301, 0,
    1, 0x1EC0, 0x00CA, 0x0300, 0,
    1, 0x1EC1, 0x00EA, 0x0300, 0,
    1, 0x1EC2, 0x00CA, 0x0309, 0,
    1, 0x1EC3, 0x00EA, 0x0309, 0,
    1, 0x1EC4, 0x00CA, 0x0303, 0,
    1, 0x1EC5, 0x00EA, 0x0303, 0,
    1, 0x1EC6, 0x00CA, 0x0323, 0,
    1, 0x1EC7, 0x00EA, 0x0323, 0,
    1, 0x1EC8, 0x0049, 0x0309, 0,
    1, 0x1EC9, 0x0069, 0x0309, 0,
    1, 0x1ECA, 0x0049, 0x0323, 0,
    1, 0x1ECB, 0x0069, 0x0323, 0,
    1, 0x1ECC, 0x004F, 0x0323, 0,
    1, 0x1ECD, 0x006F, 0x0323, 0,
    1, 0x1ECE, 0x004F, 0x0309, 0,
    1, 0x1ECF, 0x006F, 0x0309, 0,
    1, 0x1ED0, 0x00D4, 0x0301, 0,
    1, 0x1ED1, 0x00F4, 0x0301, 0,
    1, 0x1ED2, 0x00D4, 0x0300, 0,
    1, 0x1ED3, 0x00F4, 0x0300, 0,
    1, 0x1ED4, 0x00D4, 0x0309, 0,
    1, 0x1ED5, 0x00F4, 0x0309, 0,
    1, 0x1ED6, 0x00D4, 0x0303, 0,
    1, 0x1ED7, 0x00F4, 0x0303, 0,
    1, 0x1ED8, 0x00D4, 0x0323, 0,
    1, 0x1ED9, 0x00F4, 0x0323, 0,
    1, 0x1EDA, 0x01A0, 0x0301, 0,
    1, 0x1EDB, 0x01A1, 0x0301, 0,
    1, 0x1EDC, 0x01A0, 0x0300, 0,
    1, 0x1EDD, 0x01A1, 0x0300, 0,
    1, 0x1EDE, 0x01A0, 0x0309, 0,
    1, 0x1EDF, 0x01A1, 0x0309, 0,
    1, 0x1EE0, 0x01A0, 0x0303, 0,
    1, 0x1EE1, 0x01A1, 0x0303, 0,
    1, 0x1EE2, 0x01A0, 0x0323, 0,
    1, 0x1EE3, 0x01A1, 0x0323, 0,
    1, 0x1EE4, 0x0055, 0x0323, 0,
    1, 0x1EE5, 0x0075, 0x0323, 0,
    1, 0x1EE6, 0x0055, 0x0309, 0,
    1, 0x1EE7, 0x0075, 0x0309, 0,
    1, 0x1EE8, 0x01AF, 0x0301, 0,
    1, 0x1EE9, 0x01B0, 0x0301, 0,
    1, 0x1EEA, 0x01AF, 0x0300, 0,
    1, 0x1EEB, 0x01B0, 0x0300, 0,
    1, 0x1EEC, 0x01AF, 0x0309, 0,
    1, 0x1EED, 0x01B0, 0x0309, 0,
    1, 0x1EEE, 0x01AF, 0x0303, 0,
    1, 0x1EEF, 0x01B0, 0x0303, 0,
    1, 0x1EF0, 0x01AF, 0x0323, 0,
    1, 0x1EF1, 0x01B0, 0x0323, 0,
    1, 0x1EF2, 0x0059, 0x0300, 0,
    1, 0x1EF3, 0x0079, 0x0300, 0,
    1, 0x1EF4, 0x0059, 0x0323, 0,
    1, 0x1EF5, 0x0079, 0x0323, 0,
    1, 0x1EF6, 0x0059, 0x0309, 0,
    1, 0x1EF7, 0x0079, 0x0309, 0,
    1, 0x1EF8, 0x0059, 0x0303, 0,
    1, 0x1EF9, 0x0079, 0x0303, 0,
    1, 0x1F00, 0x03B1, 0x0313, 0,
    1, 0x1F01, 0x03B1, 0x0314, 0,
    1, 0x1F02, 0x1F00, 0x0300, 0,
    1, 0x1F03, 0x1F01, 0x0300, 0,
    1, 0x1F04, 0x1F00, 0x0301, 0,
    1, 0x1F05, 0x1F01, 0x0301, 0,
    1, 0x1F06, 0x1F00, 0x0342, 0,
    1, 0x1F07, 0x1F01, 0x0342, 0,
    1, 0x1F08, 0x0391, 0x0313, 0,
    1, 0x1F09, 0x0391, 0x0314, 0,
    1, 0x1F0A, 0x1F08, 0x0300, 0,
    1, 0x1F0B, 0x1F09, 0x0300, 0,
    1, 0x1F0C, 0x1F08, 0x0301, 0,
    1, 0x1F0D, 0x1F09, 0x0301, 0,
    1, 0x1F0E, 0x1F08, 0x0342, 0,
    1, 0x1F0F, 0x1F09, 0x0342, 0,
    1, 0x1F10, 0x03B5, 0x0313, 0,
    1, 0x1F11, 0x03B5, 0x0314, 0,
    1, 0x1F12, 0x1F10, 0x0300, 0,
    1, 0x1F13, 0x1F11, 0x0300, 0,
    1, 0x1F14, 0x1F10, 0x0301, 0,
    1, 0x1F15, 0x1F11, 0x0301, 0,
    1, 0x1F18, 0x0395, 0x0313, 0,
    1, 0x1F19, 0x0395, 0x0314, 0,
    1, 0x1F1A, 0x1F18, 0x0300, 0,
    1, 0x1F1B, 0x1F19, 0x0300, 0,
    1, 0x1F1C, 0x1F18, 0x0301, 0,
    1, 0x1F1D, 0x1F19, 0x0301, 0,
    1, 0x1F20, 0x03B7, 0x0313, 0,
    1, 0x1F21, 0x03B7, 0x0314, 0,
    1, 0x1F22, 0x1F20, 0x0300, 0,
    1, 0x1F23, 0x1F21, 0x0300, 0,
    1, 0x1F24, 0x1F20, 0x0301, 0,
    1, 0x1F25, 0x1F21, 0x0301, 0,
    1, 0x1F26, 0x1F20, 0x0342, 0,
    1, 0x1F27, 0x1F21, 0x0342, 0,
    1, 0x1F28, 0x0397, 0x0313, 0,
    1, 0x1F29, 0x0397, 0x0314, 0,
    1, 0x1F2A, 0x1F28, 0x0300, 0,
    1, 0x1F2B, 0x1F29, 0x0300, 0,
    1, 0x1F2C, 0x1F28, 0x0301, 0,
    1, 0x1F2D, 0x1F29, 0x0301, 0,
    1, 0x1F2E, 0x1F28, 0x0342, 0,
    1, 0x1F2F, 0x1F29, 0x0342, 0,
    1, 0x1F30, 0x03B9, 0x0313, 0,
    1, 0x1F31, 0x03B9, 0x0314, 0,
    1, 0x1F32, 0x1F30, 0x0300, 0,
    1, 0x1F33, 0x1F31, 0x0300, 0,
    1, 0x1F34, 0x1F30, 0x0301, 0,
    1, 0x1F35, 0x1F31, 0x0301, 0,
    1, 0x1F36, 0x1F30, 0x0342, 0,
    1, 0x1F37, 0x1F31, 0x0342, 0,
    1, 0x1F38, 0x0399, 0x0313, 0,
    1, 0x1F39, 0x0399, 0x0314, 0,
    1, 0x1F3A, 0x1F38, 0x0300, 0,
    1, 0x1F3B, 0x1F39, 0x0300, 0,
    1, 0x1F3C, 0x1F38, 0x0301, 0,
    1, 0x1F3D, 0x1F39, 0x0301, 0,
    1, 0x1F3E, 0x1F38, 0x0342, 0,
    1, 0x1F3F, 0x1F39, 0x0342, 0,
    1, 0x1F40, 0x03BF, 0x0313, 0,
    1, 0x1F41, 0x03BF, 0x0314, 0,
    1, 0x1F42, 0x1F40, 0x0300, 0,
    1, 0x1F43, 0x1F41, 0x0300, 0,
    1, 0x1F44, 0x1F40, 0x0301, 0,
    1, 0x1F45, 0x1F41, 0x0301, 0,
    1, 0x1F48, 0x039F, 0x0313, 0,
    1, 0x1F49, 0x039F, 0x0314, 0,
    1, 0x1F4A, 0x1F48, 0x0300, 0,
    1, 0x1F4B, 0x1F49, 0x0300, 0,
    1, 0x1F4C, 0x1F48, 0x0301, 0,
    1, 0x1F4D, 0x1F49, 0x0301, 0,
    1, 0x1F50, 0x03C5, 0x0313, 0,
    1, 0x1F51, 0x03C5, 0x0314, 0,
    1, 0x1F52, 0x1F50, 0x0300, 0,
    1, 0x1F53, 0x1F51, 0x0300, 0,
    1, 0x1F54, 0x1F50, 0x0301, 0,
    1, 0x1F55, 0x1F51, 0x0301, 0,
    1, 0x1F56, 0x1F50, 0x0342, 0,
    1, 0x1F57, 0x1F51, 0x0342, 0,
    1, 0x1F59, 0x03A5, 0x0314, 0,
    1, 0x1F5B, 0x1F59, 0x0300, 0,
    1, 0x1F5D, 0x1F59, 0x0301, 0,
    1, 0x1F5F, 0x1F59, 0x0342, 0,
    1, 0x1F60, 0x03C9, 0x0313, 0,
    1, 0x1F61, 0x03C9, 0x0314, 0,
    1, 0x1F62, 0x1F60, 0x0300, 0,
    1, 0x1F63, 0x1F61, 0x0300, 0,
    1, 0x1F64, 0x1F60, 0x0301, 0,
    1, 0x1F65, 0x1F61, 0x0301, 0,
    1, 0x1F66, 0x1F60, 0x0342, 0,
    1, 0x1F67, 0x1F61, 0x0342, 0,
    1, 0x1F68, 0x03A9, 0x0313, 0,
    1, 0x1F69, 0x03A9, 0x0314, 0,
    1, 0x1F6A, 0x1F68, 0x0300, 0,
    1, 0x1F6B, 0x1F69, 0x0300, 0,
    1, 0x1F6C, 0x1F68, 0x0301, 0,
    1, 0x1F6D, 0x1F69, 0x0301, 0,
    1, 0x1F6E, 0x1F68, 0x0342, 0,
    1, 0x1F6F, 0x1F69, 0x0342, 0,
    1, 0x1F70, 0x03B1, 0x0300, 0,
    1, 0x1F71, 0x03AC, 0,
    1, 0x1F72, 0x03B5, 0x0300, 0,
    1, 0x1F73, 0x03AD, 0,
    1, 0x1F74, 0x03B7, 0x0300, 0,
    1, 0x1F75, 0x03AE, 0,
    1, 0x1F76, 0x03B9, 0x0300, 0,
    1, 0x1F77, 0x03AF, 0,
    1, 0x1F78, 0x03BF, 0x0300, 0,
    1, 0x1F79, 0x03CC, 0,
    1, 0x1F7A, 0x03C5, 0x0300, 0,
    1, 0x1F7B, 0x03CD, 0,
    1, 0x1F7C, 0x03C9, 0x0300, 0,
    1, 0x1F7D, 0x03CE, 0,
    1, 0x1F80, 0x1F00, 0x0345, 0,
    1, 0x1F81, 0x1F01, 0x0345, 0,
    1, 0x1F82, 0x1F02, 0x0345, 0,
    1, 0x1F83, 0x1F03, 0x0345, 0,
    1, 0x1F84, 0x1F04, 0x0345, 0,
    1, 0x1F85, 0x1F05, 0x0345, 0,
    1, 0x1F86, 0x1F06, 0x0345, 0,
    1, 0x1F87, 0x1F07, 0x0345, 0,
    1, 0x1F88, 0x1F08, 0x0345, 0,
    1, 0x1F89, 0x1F09, 0x0345, 0,
    1, 0x1F8A, 0x1F0A, 0x0345, 0,
    1, 0x1F8B, 0x1F0B, 0x0345, 0,
    1, 0x1F8C, 0x1F0C, 0x0345, 0,
    1, 0x1F8D, 0x1F0D, 0x0345, 0,
    1, 0x1F8E, 0x1F0E, 0x0345, 0,
    1, 0x1F8F, 0x1F0F, 0x0345, 0,
    1, 0x1F90, 0x1F20, 0x0345, 0,
    1, 0x1F91, 0x1F21, 0x0345, 0,
    1, 0x1F92, 0x1F22, 0x0345, 0,
    1, 0x1F93, 0x1F23, 0x0345, 0,
    1, 0x1F94, 0x1F24, 0x0345, 0,
    1, 0x1F95, 0x1F25, 0x0345, 0,
    1, 0x1F96, 0x1F26, 0x0345, 0,
    1, 0x1F97, 0x1F27, 0x0345, 0,
    1, 0x1F98, 0x1F28, 0x0345, 0,
    1, 0x1F99, 0x1F29, 0x0345, 0,
    1, 0x1F9A, 0x1F2A, 0x0345, 0,
    1, 0x1F9B, 0x1F2B, 0x0345, 0,
    1, 0x1F9C, 0x1F2C, 0x0345, 0,
    1, 0x1F9D, 0x1F2D, 0x0345, 0,
    1, 0x1F9E, 0x1F2E, 0x0345, 0,
    1, 0x1F9F, 0x1F2F, 0x0345, 0,
    1, 0x1FA0, 0x1F60, 0x0345, 0,
    1, 0x1FA1, 0x1F61, 0x0345, 0,
    1, 0x1FA2, 0x1F62, 0x0345, 0,
    1, 0x1FA3, 0x1F63, 0x0345, 0,
    1, 0x1FA4, 0x1F64, 0x0345, 0,
    1, 0x1FA5, 0x1F65, 0x0345, 0,
    1, 0x1FA6, 0x1F66, 0x0345, 0,
    1, 0x1FA7, 0x1F67, 0x0345, 0,
    1, 0x1FA8, 0x1F68, 0x0345, 0,
    1, 0x1FA9, 0x1F69, 0x0345, 0,
    1, 0x1FAA, 0x1F6A, 0x0345, 0,
    1, 0x1FAB, 0x1F6B, 0x0345, 0,
    1, 0x1FAC, 0x1F6C, 0x0345, 0,
    1, 0x1FAD, 0x1F6D, 0x0345, 0,
    1, 0x1FAE, 0x1F6E, 0x0345, 0,
    1, 0x1FAF, 0x1F6F, 0x0345, 0,
    1, 0x1FB0, 0x03B1, 0x0306, 0,
    1, 0x1FB1, 0x03B1, 0x0304, 0,
    1, 0x1FB2, 0x1F70, 0x0345, 0,
    1, 0x1FB3, 0x03B1, 0x0345, 0,
    1, 0x1FB4, 0x03AC, 0x0345, 0,
    1, 0x1FB6, 0x03B1, 0x0342, 0,
    1, 0x1FB7, 0x1FB6, 0x0345, 0,
    1, 0x1FB8, 0x0391, 0x0306, 0,
    1, 0x1FB9, 0x0391, 0x0304, 0,
    1, 0x1FBA, 0x0391, 0x0300, 0,
    1, 0x1FBB, 0x0386, 0,
    1, 0x1FBC, 0x0391, 0x0345, 0,
    16, 0x1FBD, 0x0020, 0x0313, 0,
    1, 0x1FBE, 0x03B9, 0,
    16, 0x1FBF, 0x0020, 0x0313, 0,
    16, 0x1FC0, 0x0020, 0x0342, 0,
    1, 0x1FC1, 0x00A8, 0x0342, 0,
    1, 0x1FC2, 0x1F74, 0x0345, 0,
    1, 0x1FC3, 0x03B7, 0x0345, 0,
    1, 0x1FC4, 0x03AE, 0x0345, 0,
    1, 0x1FC6, 0x03B7, 0x0342, 0,
    1, 0x1FC7, 0x1FC6, 0x0345, 0,
    1, 0x1FC8, 0x0395, 0x0300, 0,
    1, 0x1FC9, 0x0388, 0,
    1, 0x1FCA, 0x0397, 0x0300, 0,
    1, 0x1FCB, 0x0389, 0,
    1, 0x1FCC, 0x0397, 0x0345, 0,
    1, 0x1FCD, 0x1FBF, 0x0300, 0,
    1, 0x1FCE, 0x1FBF, 0x0301, 0,
    1, 0x1FCF, 0x1FBF, 0x0342, 0,
    1, 0x1FD0, 0x03B9, 0x0306, 0,
    1, 0x1FD1, 0x03B9, 0x0304, 0,
    1, 0x1FD2, 0x03CA, 0x0300, 0,
    1, 0x1FD3, 0x0390, 0,
    1, 0x1FD6, 0x03B9, 0x0342, 0,
    1, 0x1FD7, 0x03CA, 0x0342, 0,
    1, 0x1FD8, 0x0399, 0x0306, 0,
    1, 0x1FD9, 0x0399, 0x0304, 0,
    1, 0x1FDA, 0x0399, 0x0300, 0,
    1, 0x1FDB, 0x038A, 0,
    1, 0x1FDD, 0x1FFE, 0x0300, 0,
    1, 0x1FDE, 0x1FFE, 0x0301, 0,
    1, 0x1FDF, 0x1FFE, 0x0342, 0,
    1, 0x1FE0, 0x03C5, 0x0306, 0,
    1, 0x1FE1, 0x03C5, 0x0304, 0,
    1, 0x1FE2, 0x03CB, 0x0300, 0,
    1, 0x1FE3, 0x03B0, 0,
    1, 0x1FE4, 0x03C1, 0x0313, 0,
    1, 0x1FE5, 0x03C1, 0x0314, 0,
    1, 0x1FE6, 0x03C5, 0x0342, 0,
    1, 0x1FE7, 0x03CB, 0x0342, 0,
    1, 0x1FE8, 0x03A5, 0x0306, 0,
    1, 0x1FE9, 0x03A5, 0x0304, 0,
    1, 0x1FEA, 0x03A5, 0x0300, 0,
    1, 0x1FEB, 0x038E, 0,
    1, 0x1FEC, 0x03A1, 0x0314, 0,
    1, 0x1FED, 0x00A8, 0x0300, 0,
    1, 0x1FEE, 0x0385, 0,
    1, 0x1FEF, 0x0060, 0,
    1, 0x1FF2, 0x1F7C, 0x0345, 0,
    1, 0x1FF3, 0x03C9, 0x0345, 0,
    1, 0x1FF4, 0x03CE, 0x0345, 0,
    1, 0x1FF6, 0x03C9, 0x0342, 0,
    1, 0x1FF7, 0x1FF6, 0x0345, 0,
    1, 0x1FF8, 0x039F, 0x0300, 0,
    1, 0x1FF9, 0x038C, 0,
    1, 0x1FFA, 0x03A9, 0x0300, 0,
    1, 0x1FFB, 0x038F, 0,
    1, 0x1FFC, 0x03A9, 0x0345, 0,
    1, 0x1FFD, 0x00B4, 0,
    16, 0x1FFE, 0x0020, 0x0314, 0,
    1, 0x2000, 0x2002, 0,
    1, 0x2001, 0x2003, 0,
    16, 0x2002, 0x0020, 0,
    16, 0x2003, 0x0020, 0,
    16, 0x2004, 0x0020, 0,
    16, 0x2005, 0x0020, 0,
    16, 0x2006, 0x0020, 0,
    3, 0x2007, 0x0020, 0,
    16, 0x2008, 0x0020, 0,
    16, 0x2009, 0x0020, 0,
    16, 0x200A, 0x0020, 0,
    3, 0x2011, 0x2010, 0,
    16, 0x2017, 0x0020, 0x0333, 0,
    16, 0x2024, 0x002E, 0,
    16, 0x2025, 0x002E, 0x002E, 0,
    16, 0x2026, 0x002E, 0x002E, 0x002E, 0,
    16, 0x2033, 0x2032, 0x2032, 0,
    16, 0x2034, 0x2032, 0x2032, 0x2032, 0,
    16, 0x2036, 0x2035, 0x2035, 0,
    16, 0x2037, 0x2035, 0x2035, 0x2035, 0,
    16, 0x203C, 0x0021, 0x0021, 0,
    16, 0x203E, 0x0020, 0x0305, 0,
    9, 0x2070, 0x0030, 0,
    9, 0x2074, 0x0034, 0,
    9, 0x2075, 0x0035, 0,
    9, 0x2076, 0x0036, 0,
    9, 0x2077, 0x0037, 0,
    9, 0x2078, 0x0038, 0,
    9, 0x2079, 0x0039, 0,
    9, 0x207A, 0x002B, 0,
    9, 0x207B, 0x2212, 0,
    9, 0x207C, 0x003D, 0,
    9, 0x207D, 0x0028, 0,
    9, 0x207E, 0x0029, 0,
    9, 0x207F, 0x006E, 0,
    10, 0x2080, 0x0030, 0,
    10, 0x2081, 0x0031, 0,
    10, 0x2082, 0x0032, 0,
    10, 0x2083, 0x0033, 0,
    10, 0x2084, 0x0034, 0,
    10, 0x2085, 0x0035, 0,
    10, 0x2086, 0x0036, 0,
    10, 0x2087, 0x0037, 0,
    10, 0x2088, 0x0038, 0,
    10, 0x2089, 0x0039, 0,
    10, 0x208A, 0x002B, 0,
    10, 0x208B, 0x2212, 0,
    10, 0x208C, 0x003D, 0,
    10, 0x208D, 0x0028, 0,
    10, 0x208E, 0x0029, 0,
    16, 0x20A8, 0x0052, 0x0073, 0,
    16, 0x2100, 0x0061, 0x002F, 0x0063, 0,
    16, 0x2101, 0x0061, 0x002F, 0x0073, 0,
    2, 0x2102, 0x0043, 0,
    16, 0x2103, 0x00B0, 0x0043, 0,
    16, 0x2105, 0x0063, 0x002F, 0x006F, 0,
    16, 0x2106, 0x0063, 0x002F, 0x0075, 0,
    16, 0x2107, 0x0190, 0,
    16, 0x2109, 0x00B0, 0x0046, 0,
    2, 0x210A, 0x0067, 0,
    2, 0x210B, 0x0048, 0,
    2, 0x210C, 0x0048, 0,
    2, 0x210D, 0x0048, 0,
    2, 0x210E, 0x0068, 0,
    2, 0x210F, 0x0127, 0,
    2, 0x2110, 0x0049, 0,
    2, 0x2111, 0x0049, 0,
    2, 0x2112, 0x004C, 0,
    2, 0x2113, 0x006C, 0,
    2, 0x2115, 0x004E, 0,
    16, 0x2116, 0x004E, 0x006F, 0,
    2, 0x2119, 0x0050, 0,
    2, 0x211A, 0x0051, 0,
    2, 0x211B, 0x0052, 0,
    2, 0x211C, 0x0052, 0,
    2, 0x211D, 0x0052, 0,
    9, 0x2120, 0x0053, 0x004D, 0,
    16, 0x2121, 0x0054, 0x0045, 0x004C, 0,
    9, 0x2122, 0x0054, 0x004D, 0,
    2, 0x2124, 0x005A, 0,
    1, 0x2126, 0x03A9, 0,
    2, 0x2128, 0x005A, 0,
    1, 0x212A, 0x004B, 0,
    1, 0x212B, 0x00C5, 0,
    2, 0x212C, 0x0042, 0,
    2, 0x212D, 0x0043, 0,
    2, 0x212F, 0x0065, 0,
    2, 0x2130, 0x0045, 0,
    2, 0x2131, 0x0046, 0,
    2, 0x2133, 0x004D, 0,
    2, 0x2134, 0x006F, 0,
    16, 0x2135, 0x05D0, 0,
    16, 0x2136, 0x05D1, 0,
    16, 0x2137, 0x05D2, 0,
    16, 0x2138, 0x05D3, 0,
    17, 0x2153, 0x0031, 0x2044, 0x0033, 0,
    17, 0x2154, 0x0032, 0x2044, 0x0033, 0,
    17, 0x2155, 0x0031, 0x2044, 0x0035, 0,
    17, 0x2156, 0x0032, 0x2044, 0x0035, 0,
    17, 0x2157, 0x0033, 0x2044, 0x0035, 0,
    17, 0x2158, 0x0034, 0x2044, 0x0035, 0,
    17, 0x2159, 0x0031, 0x2044, 0x0036, 0,
    17, 0x215A, 0x0035, 0x2044, 0x0036, 0,
    17, 0x215B, 0x0031, 0x2044, 0x0038, 0,
    17, 0x215C, 0x0033, 0x2044, 0x0038, 0,
    17, 0x215D, 0x0035, 0x2044, 0x0038, 0,
    17, 0x215E, 0x0037, 0x2044, 0x0038, 0,
    17, 0x215F, 0x0031, 0x2044, 0,
    16, 0x2160, 0x0049, 0,
    16, 0x2161, 0x0049, 0x0049, 0,
    16, 0x2162, 0x0049, 0x0049, 0x0049, 0,
    16, 0x2163, 0x0049, 0x0056, 0,
    16, 0x2164, 0x0056, 0,
    16, 0x2165, 0x0056, 0x0049, 0,
    16, 0x2166, 0x0056, 0x0049, 0x0049, 0,
    16, 0x2167, 0x0056, 0x0049, 0x0049, 0x0049, 0,
    16, 0x2168, 0x0049, 0x0058, 0,
    16, 0x2169, 0x0058, 0,
    16, 0x216A, 0x0058, 0x0049, 0,
    16, 0x216B, 0x0058, 0x0049, 0x0049, 0,
    16, 0x216C, 0x004C, 0,
    16, 0x216D, 0x0043, 0,
    16, 0x216E, 0x0044, 0,
    16, 0x216F, 0x004D, 0,
    16, 0x2170, 0x0069, 0,
    16, 0x2171, 0x0069, 0x0069, 0,
    16, 0x2172, 0x0069, 0x0069, 0x0069, 0,
    16, 0x2173, 0x0069, 0x0076, 0,
    16, 0x2174, 0x0076, 0,
    16, 0x2175, 0x0076, 0x0069, 0,
    16, 0x2176, 0x0076, 0x0069, 0x0069, 0,
    16, 0x2177, 0x0076, 0x0069, 0x0069, 0x0069, 0,
    16, 0x2178, 0x0069, 0x0078, 0,
    16, 0x2179, 0x0078, 0,
    16, 0x217A, 0x0078, 0x0069, 0,
    16, 0x217B, 0x0078, 0x0069, 0x0069, 0,
    16, 0x217C, 0x006C, 0,
    16, 0x217D, 0x0063, 0,
    16, 0x217E, 0x0064, 0,
    16, 0x217F, 0x006D, 0,
    1, 0x2204, 0x2203, 0x0338, 0,
    1, 0x2209, 0x2208, 0x0338, 0,
    1, 0x220C, 0x220B, 0x0338, 0,
    1, 0x2224, 0x2223, 0x0338, 0,
    1, 0x2226, 0x2225, 0x0338, 0,
    16, 0x222C, 0x222B, 0x222B, 0,
    16, 0x222D, 0x222B, 0x222B, 0x222B, 0,
    16, 0x222F, 0x222E, 0x222E, 0,
    16, 0x2230, 0x222E, 0x222E, 0x222E, 0,
    1, 0x2241, 0x007E, 0x0338, 0,
    1, 0x2244, 0x2243, 0x0338, 0,
    1, 0x2247, 0x2245, 0x0338, 0,
    1, 0x2249, 0x2248, 0x0338, 0,
    1, 0x2260, 0x003D, 0x0338, 0,
    1, 0x2262, 0x2261, 0x0338, 0,
    1, 0x226D, 0x224D, 0x0338, 0,
    1, 0x226E, 0x003C, 0x0338, 0,
    1, 0x226F, 0x003E, 0x0338, 0,
    1, 0x2270, 0x2264, 0x0338, 0,
    1, 0x2271, 0x2265, 0x0338, 0,
    1, 0x2274, 0x2272, 0x0338, 0,
    1, 0x2275, 0x2273, 0x0338, 0,
    1, 0x2278, 0x2276, 0x0338, 0,
    1, 0x2279, 0x2277, 0x0338, 0,
    1, 0x2280, 0x227A, 0x0338, 0,
    1, 0x2281, 0x227B, 0x0338, 0,
    1, 0x2284, 0x2282, 0x0338, 0,
    1, 0x2285, 0x2283, 0x0338, 0,
    1, 0x2288, 0x2286, 0x0338, 0,
    1, 0x2289, 0x2287, 0x0338, 0,
    1, 0x22AC, 0x22A2, 0x0338, 0,
    1, 0x22AD, 0x22A8, 0x0338, 0,
    1, 0x22AE, 0x22A9, 0x0338, 0,
    1, 0x22AF, 0x22AB, 0x0338, 0,
    1, 0x22E0, 0x227C, 0x0338, 0,
    1, 0x22E1, 0x227D, 0x0338, 0,
    1, 0x22E2, 0x2291, 0x0338, 0,
    1, 0x22E3, 0x2292, 0x0338, 0,
    1, 0x22EA, 0x22B2, 0x0338, 0,
    1, 0x22EB, 0x22B3, 0x0338, 0,
    1, 0x22EC, 0x22B4, 0x0338, 0,
    1, 0x22ED, 0x22B5, 0x0338, 0,
    1, 0x2329, 0x3008, 0,
    1, 0x232A, 0x3009, 0,
    8, 0x2460, 0x0031, 0,
    8, 0x2461, 0x0032, 0,
    8, 0x2462, 0x0033, 0,
    8, 0x2463, 0x0034, 0,
    8, 0x2464, 0x0035, 0,
    8, 0x2465, 0x0036, 0,
    8, 0x2466, 0x0037, 0,
    8, 0x2467, 0x0038, 0,
    8, 0x2468, 0x0039, 0,
    8, 0x2469, 0x0031, 0x0030, 0,
    8, 0x246A, 0x0031, 0x0031, 0,
    8, 0x246B, 0x0031, 0x0032, 0,
    8, 0x246C, 0x0031, 0x0033, 0,
    8, 0x246D, 0x0031, 0x0034, 0,
    8, 0x246E, 0x0031, 0x0035, 0,
    8, 0x246F, 0x0031, 0x0036, 0,
    8, 0x2470, 0x0031, 0x0037, 0,
    8, 0x2471, 0x0031, 0x0038, 0,
    8, 0x2472, 0x0031, 0x0039, 0,
    8, 0x2473, 0x0032, 0x0030, 0,
    16, 0x2474, 0x0028, 0x0031, 0x0029, 0,
    16, 0x2475, 0x0028, 0x0032, 0x0029, 0,
    16, 0x2476, 0x0028, 0x0033, 0x0029, 0,
    16, 0x2477, 0x0028, 0x0034, 0x0029, 0,
    16, 0x2478, 0x0028, 0x0035, 0x0029, 0,
    16, 0x2479, 0x0028, 0x0036, 0x0029, 0,
    16, 0x247A, 0x0028, 0x0037, 0x0029, 0,
    16, 0x247B, 0x0028, 0x0038, 0x0029, 0,
    16, 0x247C, 0x0028, 0x0039, 0x0029, 0,
    16, 0x247D, 0x0028, 0x0031, 0x0030, 0x0029, 0,
    16, 0x247E, 0x0028, 0x0031, 0x0031, 0x0029, 0,
    16, 0x247F, 0x0028, 0x0031, 0x0032, 0x0029, 0,
    16, 0x2480, 0x0028, 0x0031, 0x0033, 0x0029, 0,
    16, 0x2481, 0x0028, 0x0031, 0x0034, 0x0029, 0,
    16, 0x2482, 0x0028, 0x0031, 0x0035, 0x0029, 0,
    16, 0x2483, 0x0028, 0x0031, 0x0036, 0x0029, 0,
    16, 0x2484, 0x0028, 0x0031, 0x0037, 0x0029, 0,
    16, 0x2485, 0x0028, 0x0031, 0x0038, 0x0029, 0,
    16, 0x2486, 0x0028, 0x0031, 0x0039, 0x0029, 0,
    16, 0x2487, 0x0028, 0x0032, 0x0030, 0x0029, 0,
    16, 0x2488, 0x0031, 0x002E, 0,
    16, 0x2489, 0x0032, 0x002E, 0,
    16, 0x248A, 0x0033, 0x002E, 0,
    16, 0x248B, 0x0034, 0x002E, 0,
    16, 0x248C, 0x0035, 0x002E, 0,
    16, 0x248D, 0x0036, 0x002E, 0,
    16, 0x248E, 0x0037, 0x002E, 0,
    16, 0x248F, 0x0038, 0x002E, 0,
    16, 0x2490, 0x0039, 0x002E, 0,
    16, 0x2491, 0x0031, 0x0030, 0x002E, 0,
    16, 0x2492, 0x0031, 0x0031, 0x002E, 0,
    16, 0x2493, 0x0031, 0x0032, 0x002E, 0,
    16, 0x2494, 0x0031, 0x0033, 0x002E, 0,
    16, 0x2495, 0x0031, 0x0034, 0x002E, 0,
    16, 0x2496, 0x0031, 0x0035, 0x002E, 0,
    16, 0x2497, 0x0031, 0x0036, 0x002E, 0,
    16, 0x2498, 0x0031, 0x0037, 0x002E, 0,
    16, 0x2499, 0x0031, 0x0038, 0x002E, 0,
    16, 0x249A, 0x0031, 0x0039, 0x002E, 0,
    16, 0x249B, 0x0032, 0x0030, 0x002E, 0,
    16, 0x249C, 0x0028, 0x0061, 0x0029, 0,
    16, 0x249D, 0x0028, 0x0062, 0x0029, 0,
    16, 0x249E, 0x0028, 0x0063, 0x0029, 0,
    16, 0x249F, 0x0028, 0x0064, 0x0029, 0,
    16, 0x24A0, 0x0028, 0x0065, 0x0029, 0,
    16, 0x24A1, 0x0028, 0x0066, 0x0029, 0,
    16, 0x24A2, 0x0028, 0x0067, 0x0029, 0,
    16, 0x24A3, 0x0028, 0x0068, 0x0029, 0,
    16, 0x24A4, 0x0028, 0x0069, 0x0029, 0,
    16, 0x24A5, 0x0028, 0x006A, 0x0029, 0,
    16, 0x24A6, 0x0028, 0x006B, 0x0029, 0,
    16, 0x24A7, 0x0028, 0x006C, 0x0029, 0,
    16, 0x24A8, 0x0028, 0x006D, 0x0029, 0,
    16, 0x24A9, 0x0028, 0x006E, 0x0029, 0,
    16, 0x24AA, 0x0028, 0x006F, 0x0029, 0,
    16, 0x24AB, 0x0028, 0x0070, 0x0029, 0,
    16, 0x24AC, 0x0028, 0x0071, 0x0029, 0,
    16, 0x24AD, 0x0028, 0x0072, 0x0029, 0,
    16, 0x24AE, 0x0028, 0x0073, 0x0029, 0,
    16, 0x24AF, 0x0028, 0x0074, 0x0029, 0,
    16, 0x24B0, 0x0028, 0x0075, 0x0029, 0,
    16, 0x24B1, 0x0028, 0x0076, 0x0029, 0,
    16, 0x24B2, 0x0028, 0x0077, 0x0029, 0,
    16, 0x24B3, 0x0028, 0x0078, 0x0029, 0,
    16, 0x24B4, 0x0028, 0x0079, 0x0029, 0,
    16, 0x24B5, 0x0028, 0x007A, 0x0029, 0,
    8, 0x24B6, 0x0041, 0,
    8, 0x24B7, 0x0042, 0,
    8, 0x24B8, 0x0043, 0,
    8, 0x24B9, 0x0044, 0,
    8, 0x24BA, 0x0045, 0,
    8, 0x24BB, 0x0046, 0,
    8, 0x24BC, 0x0047, 0,
    8, 0x24BD, 0x0048, 0,
    8, 0x24BE, 0x0049, 0,
    8, 0x24BF, 0x004A, 0,
    8, 0x24C0, 0x004B, 0,
    8, 0x24C1, 0x004C, 0,
    8, 0x24C2, 0x004D, 0,
    8, 0x24C3, 0x004E, 0,
    8, 0x24C4, 0x004F, 0,
    8, 0x24C5, 0x0050, 0,
    8, 0x24C6, 0x0051, 0,
    8, 0x24C7, 0x0052, 0,
    8, 0x24C8, 0x0053, 0,
    8, 0x24C9, 0x0054, 0,
    8, 0x24CA, 0x0055, 0,
    8, 0x24CB, 0x0056, 0,
    8, 0x24CC, 0x0057, 0,
    8, 0x24CD, 0x0058, 0,
    8, 0x24CE, 0x0059, 0,
    8, 0x24CF, 0x005A, 0,
    8, 0x24D0, 0x0061, 0,
    8, 0x24D1, 0x0062, 0,
    8, 0x24D2, 0x0063, 0,
    8, 0x24D3, 0x0064, 0,
    8, 0x24D4, 0x0065, 0,
    8, 0x24D5, 0x0066, 0,
    8, 0x24D6, 0x0067, 0,
    8, 0x24D7, 0x0068, 0,
    8, 0x24D8, 0x0069, 0,
    8, 0x24D9, 0x006A, 0,
    8, 0x24DA, 0x006B, 0,
    8, 0x24DB, 0x006C, 0,
    8, 0x24DC, 0x006D, 0,
    8, 0x24DD, 0x006E, 0,
    8, 0x24DE, 0x006F, 0,
    8, 0x24DF, 0x0070, 0,
    8, 0x24E0, 0x0071, 0,
    8, 0x24E1, 0x0072, 0,
    8, 0x24E2, 0x0073, 0,
    8, 0x24E3, 0x0074, 0,
    8, 0x24E4, 0x0075, 0,
    8, 0x24E5, 0x0076, 0,
    8, 0x24E6, 0x0077, 0,
    8, 0x24E7, 0x0078, 0,
    8, 0x24E8, 0x0079, 0,
    8, 0x24E9, 0x007A, 0,
    8, 0x24EA, 0x0030, 0,
    12, 0x3000, 0x0020, 0,
    16, 0x3036, 0x3012, 0,
    1, 0x304C, 0x304B, 0x3099, 0,
    1, 0x304E, 0x304D, 0x3099, 0,
    1, 0x3050, 0x304F, 0x3099, 0,
    1, 0x3052, 0x3051, 0x3099, 0,
    1, 0x3054, 0x3053, 0x3099, 0,
    1, 0x3056, 0x3055, 0x3099, 0,
    1, 0x3058, 0x3057, 0x3099, 0,
    1, 0x305A, 0x3059, 0x3099, 0,
    1, 0x305C, 0x305B, 0x3099, 0,
    1, 0x305E, 0x305D, 0x3099, 0,
    1, 0x3060, 0x305F, 0x3099, 0,
    1, 0x3062, 0x3061, 0x3099, 0,
    1, 0x3065, 0x3064, 0x3099, 0,
    1, 0x3067, 0x3066, 0x3099, 0,
    1, 0x3069, 0x3068, 0x3099, 0,
    1, 0x3070, 0x306F, 0x3099, 0,
    1, 0x3071, 0x306F, 0x309A, 0,
    1, 0x3073, 0x3072, 0x3099, 0,
    1, 0x3074, 0x3072, 0x309A, 0,
    1, 0x3076, 0x3075, 0x3099, 0,
    1, 0x3077, 0x3075, 0x309A, 0,
    1, 0x3079, 0x3078, 0x3099, 0,
    1, 0x307A, 0x3078, 0x309A, 0,
    1, 0x307C, 0x307B, 0x3099, 0,
    1, 0x307D, 0x307B, 0x309A, 0,
    1, 0x3094, 0x3046, 0x3099, 0,
    16, 0x309B, 0x0020, 0x3099, 0,
    16, 0x309C, 0x0020, 0x309A, 0,
    1, 0x309E, 0x309D, 0x3099, 0,
    1, 0x30AC, 0x30AB, 0x3099, 0,
    1, 0x30AE, 0x30AD, 0x3099, 0,
    1, 0x30B0, 0x30AF, 0x3099, 0,
    1, 0x30B2, 0x30B1, 0x3099, 0,
    1, 0x30B4, 0x30B3, 0x3099, 0,
    1, 0x30B6, 0x30B5, 0x3099, 0,
    1, 0x30B8, 0x30B7, 0x3099, 0,
    1, 0x30BA, 0x30B9, 0x3099, 0,
    1, 0x30BC, 0x30BB, 0x3099, 0,
    1, 0x30BE, 0x30BD, 0x3099, 0,
    1, 0x30C0, 0x30BF, 0x3099, 0,
    1, 0x30C2, 0x30C1, 0x3099, 0,
    1, 0x30C5, 0x30C4, 0x3099, 0,
    1, 0x30C7, 0x30C6, 0x3099, 0,
    1, 0x30C9, 0x30C8, 0x3099, 0,
    1, 0x30D0, 0x30CF, 0x3099, 0,
    1, 0x30D1, 0x30CF, 0x309A, 0,
    1, 0x30D3, 0x30D2, 0x3099, 0,
    1, 0x30D4, 0x30D2, 0x309A, 0,
    1, 0x30D6, 0x30D5, 0x3099, 0,
    1, 0x30D7, 0x30D5, 0x309A, 0,
    1, 0x30D9, 0x30D8, 0x3099, 0,
    1, 0x30DA, 0x30D8, 0x309A, 0,
    1, 0x30DC, 0x30DB, 0x3099, 0,
    1, 0x30DD, 0x30DB, 0x309A, 0,
    1, 0x30F4, 0x30A6, 0x3099, 0,
    1, 0x30F7, 0x30EF, 0x3099, 0,
    1, 0x30F8, 0x30F0, 0x3099, 0,
    1, 0x30F9, 0x30F1, 0x3099, 0,
    1, 0x30FA, 0x30F2, 0x3099, 0,
    1, 0x30FE, 0x30FD, 0x3099, 0,
    16, 0x3131, 0x1100, 0,
    16, 0x3132, 0x1101, 0,
    16, 0x3133, 0x11AA, 0,
    16, 0x3134, 0x1102, 0,
    16, 0x3135, 0x11AC, 0,
    16, 0x3136, 0x11AD, 0,
    16, 0x3137, 0x1103, 0,
    16, 0x3138, 0x1104, 0,
    16, 0x3139, 0x1105, 0,
    16, 0x313A, 0x11B0, 0,
    16, 0x313B, 0x11B1, 0,
    16, 0x313C, 0x11B2, 0,
    16, 0x313D, 0x11B3, 0,
    16, 0x313E, 0x11B4, 0,
    16, 0x313F, 0x11B5, 0,
    16, 0x3140, 0x111A, 0,
    16, 0x3141, 0x1106, 0,
    16, 0x3142, 0x1107, 0,
    16, 0x3143, 0x1108, 0,
    16, 0x3144, 0x1121, 0,
    16, 0x3145, 0x1109, 0,
    16, 0x3146, 0x110A, 0,
    16, 0x3147, 0x110B, 0,
    16, 0x3148, 0x110C, 0,
    16, 0x3149, 0x110D, 0,
    16, 0x314A, 0x110E, 0,
    16, 0x314B, 0x110F, 0,
    16, 0x314C, 0x1110, 0,
    16, 0x314D, 0x1111, 0,
    16, 0x314E, 0x1112, 0,
    16, 0x314F, 0x1161, 0,
    16, 0x3150, 0x1162, 0,
    16, 0x3151, 0x1163, 0,
    16, 0x3152, 0x1164, 0,
    16, 0x3153, 0x1165, 0,
    16, 0x3154, 0x1166, 0,
    16, 0x3155, 0x1167, 0,
    16, 0x3156, 0x1168, 0,
    16, 0x3157, 0x1169, 0,
    16, 0x3158, 0x116A, 0,
    16, 0x3159, 0x116B, 0,
    16, 0x315A, 0x116C, 0,
    16, 0x315B, 0x116D, 0,
    16, 0x315C, 0x116E, 0,
    16, 0x315D, 0x116F, 0,
    16, 0x315E, 0x1170, 0,
    16, 0x315F, 0x1171, 0,
    16, 0x3160, 0x1172, 0,
    16, 0x3161, 0x1173, 0,
    16, 0x3162, 0x1174, 0,
    16, 0x3163, 0x1175, 0,
    16, 0x3164, 0x1160, 0,
    16, 0x3165, 0x1114, 0,
    16, 0x3166, 0x1115, 0,
    16, 0x3167, 0x11C7, 0,
    16, 0x3168, 0x11C8, 0,
    16, 0x3169, 0x11CC, 0,
    16, 0x316A, 0x11CE, 0,
    16, 0x316B, 0x11D3, 0,
    16, 0x316C, 0x11D7, 0,
    16, 0x316D, 0x11D9, 0,
    16, 0x316E, 0x111C, 0,
    16, 0x316F, 0x11DD, 0,
    16, 0x3170, 0x11DF, 0,
    16, 0x3171, 0x111D, 0,
    16, 0x3172, 0x111E, 0,
    16, 0x3173, 0x1120, 0,
    16, 0x3174, 0x1122, 0,
    16, 0x3175, 0x1123, 0,
    16, 0x3176, 0x1127, 0,
    16, 0x3177, 0x1129, 0,
    16, 0x3178, 0x112B, 0,
    16, 0x3179, 0x112C, 0,
    16, 0x317A, 0x112D, 0,
    16, 0x317B, 0x112E, 0,
    16, 0x317C, 0x112F, 0,
    16, 0x317D, 0x1132, 0,
    16, 0x317E, 0x1136, 0,
    16, 0x317F, 0x1140, 0,
    16, 0x3180, 0x1147, 0,
    16, 0x3181, 0x114C, 0,
    16, 0x3182, 0x11F1, 0,
    16, 0x3183, 0x11F2, 0,
    16, 0x3184, 0x1157, 0,
    16, 0x3185, 0x1158, 0,
    16, 0x3186, 0x1159, 0,
    16, 0x3187, 0x1184, 0,
    16, 0x3188, 0x1185, 0,
    16, 0x3189, 0x1188, 0,
    16, 0x318A, 0x1191, 0,
    16, 0x318B, 0x1192, 0,
    16, 0x318C, 0x1194, 0,
    16, 0x318D, 0x119E, 0,
    16, 0x318E, 0x11A1, 0,
    9, 0x3192, 0x4E00, 0,
    9, 0x3193, 0x4E8C, 0,
    9, 0x3194, 0x4E09, 0,
    9, 0x3195, 0x56DB, 0,
    9, 0x3196, 0x4E0A, 0,
    9, 0x3197, 0x4E2D, 0,
    9, 0x3198, 0x4E0B, 0,
    9, 0x3199, 0x7532, 0,
    9, 0x319A, 0x4E59, 0,
    9, 0x319B, 0x4E19, 0,
    9, 0x319C, 0x4E01, 0,
    9, 0x319D, 0x5929, 0,
    9, 0x319E, 0x5730, 0,
    9, 0x319F, 0x4EBA, 0,
    16, 0x3200, 0x0028, 0x1100, 0x0029, 0,
    16, 0x3201, 0x0028, 0x1102, 0x0029, 0,
    16, 0x3202, 0x0028, 0x1103, 0x0029, 0,
    16, 0x3203, 0x0028, 0x1105, 0x0029, 0,
    16, 0x3204, 0x0028, 0x1106, 0x0029, 0,
    16, 0x3205, 0x0028, 0x1107, 0x0029, 0,
    16, 0x3206, 0x0028, 0x1109, 0x0029, 0,
    16, 0x3207, 0x0028, 0x110B, 0x0029, 0,
    16, 0x3208, 0x0028, 0x110C, 0x0029, 0,
    16, 0x3209, 0x0028, 0x110E, 0x0029, 0,
    16, 0x320A, 0x0028, 0x110F, 0x0029, 0,
    16, 0x320B, 0x0028, 0x1110, 0x0029, 0,
    16, 0x320C, 0x0028, 0x1111, 0x0029, 0,
    16, 0x320D, 0x0028, 0x1112, 0x0029, 0,
    16, 0x320E, 0x0028, 0x1100, 0x1161, 0x0029, 0,
    16, 0x320F, 0x0028, 0x1102, 0x1161, 0x0029, 0,
    16, 0x3210, 0x0028, 0x1103, 0x1161, 0x0029, 0,
    16, 0x3211, 0x0028, 0x1105, 0x1161, 0x0029, 0,
    16, 0x3212, 0x0028, 0x1106, 0x1161, 0x0029, 0,
    16, 0x3213, 0x0028, 0x1107, 0x1161, 0x0029, 0,
    16, 0x3214, 0x0028, 0x1109, 0x1161, 0x0029, 0,
    16, 0x3215, 0x0028, 0x110B, 0x1161, 0x0029, 0,
    16, 0x3216, 0x0028, 0x110C, 0x1161, 0x0029, 0,
    16, 0x3217, 0x0028, 0x110E, 0x1161, 0x0029, 0,
    16, 0x3218, 0x0028, 0x110F, 0x1161, 0x0029, 0,
    16, 0x3219, 0x0028, 0x1110, 0x1161, 0x0029, 0,
    16, 0x321A, 0x0028, 0x1111, 0x1161, 0x0029, 0,
    16, 0x321B, 0x0028, 0x1112, 0x1161, 0x0029, 0,
    16, 0x321C, 0x0028, 0x110C, 0x116E, 0x0029, 0,
    16, 0x3220, 0x0028, 0x4E00, 0x0029, 0,
    16, 0x3221, 0x0028, 0x4E8C, 0x0029, 0,
    16, 0x3222, 0x0028, 0x4E09, 0x0029, 0,
    16, 0x3223, 0x0028, 0x56DB, 0x0029, 0,
    16, 0x3224, 0x0028, 0x4E94, 0x0029, 0,
    16, 0x3225, 0x0028, 0x516D, 0x0029, 0,
    16, 0x3226, 0x0028, 0x4E03, 0x0029, 0,
    16, 0x3227, 0x0028, 0x516B, 0x0029, 0,
    16, 0x3228, 0x0028, 0x4E5D, 0x0029, 0,
    16, 0x3229, 0x0028, 0x5341, 0x0029, 0,
    16, 0x322A, 0x0028, 0x6708, 0x0029, 0,
    16, 0x322B, 0x0028, 0x706B, 0x0029, 0,
    16, 0x322C, 0x0028, 0x6C34, 0x0029, 0,
    16, 0x322D, 0x0028, 0x6728, 0x0029, 0,
    16, 0x322E, 0x0028, 0x91D1, 0x0029, 0,
    16, 0x322F, 0x0028, 0x571F, 0x0029, 0,
    16, 0x3230, 0x0028, 0x65E5, 0x0029, 0,
    16, 0x3231, 0x0028, 0x682A, 0x0029, 0,
    16, 0x3232, 0x0028, 0x6709, 0x0029, 0,
    16, 0x3233, 0x0028, 0x793E, 0x0029, 0,
    16, 0x3234, 0x0028, 0x540D, 0x0029, 0,
    16, 0x3235, 0x0028, 0x7279, 0x0029, 0,
    16, 0x3236, 0x0028, 0x8CA1, 0x0029, 0,
    16, 0x3237, 0x0028, 0x795D, 0x0029, 0,
    16, 0x3238, 0x0028, 0x52B4, 0x0029, 0,
    16, 0x3239, 0x0028, 0x4EE3, 0x0029, 0,
    16, 0x323A, 0x0028, 0x547C, 0x0029, 0,
    16, 0x323B, 0x0028, 0x5B66, 0x0029, 0,
    16, 0x323C, 0x0028, 0x76E3, 0x0029, 0,
    16, 0x323D, 0x0028, 0x4F01, 0x0029, 0,
    16, 0x323E, 0x0028, 0x8CC7, 0x0029, 0,
    16, 0x323F, 0x0028, 0x5354, 0x0029, 0,
    16, 0x3240, 0x0028, 0x796D, 0x0029, 0,
    16, 0x3241, 0x0028, 0x4F11, 0x0029, 0,
    16, 0x3242, 0x0028, 0x81EA, 0x0029, 0,
    16, 0x3243, 0x0028, 0x81F3, 0x0029, 0,
    8, 0x3260, 0x1100, 0,
    8, 0x3261, 0x1102, 0,
    8, 0x3262, 0x1103, 0,
    8, 0x3263, 0x1105, 0,
    8, 0x3264, 0x1106, 0,
    8, 0x3265, 0x1107, 0,
    8, 0x3266, 0x1109, 0,
    8, 0x3267, 0x110B, 0,
    8, 0x3268, 0x110C, 0,
    8, 0x3269, 0x110E, 0,
    8, 0x326A, 0x110F, 0,
    8, 0x326B, 0x1110, 0,
    8, 0x326C, 0x1111, 0,
    8, 0x326D, 0x1112, 0,
    8, 0x326E, 0x1100, 0x1161, 0,
    8, 0x326F, 0x1102, 0x1161, 0,
    8, 0x3270, 0x1103, 0x1161, 0,
    8, 0x3271, 0x1105, 0x1161, 0,
    8, 0x3272, 0x1106, 0x1161, 0,
    8, 0x3273, 0x1107, 0x1161, 0,
    8, 0x3274, 0x1109, 0x1161, 0,
    8, 0x3275, 0x110B, 0x1161, 0,
    8, 0x3276, 0x110C, 0x1161, 0,
    8, 0x3277, 0x110E, 0x1161, 0,
    8, 0x3278, 0x110F, 0x1161, 0,
    8, 0x3279, 0x1110, 0x1161, 0,
    8, 0x327A, 0x1111, 0x1161, 0,
    8, 0x327B, 0x1112, 0x1161, 0,
    8, 0x3280, 0x4E00, 0,
    8, 0x3281, 0x4E8C, 0,
    8, 0x3282, 0x4E09, 0,
    8, 0x3283, 0x56DB, 0,
    8, 0x3284, 0x4E94, 0,
    8, 0x3285, 0x516D, 0,
    8, 0x3286, 0x4E03, 0,
    8, 0x3287, 0x516B, 0,
    8, 0x3288, 0x4E5D, 0,
    8, 0x3289, 0x5341, 0,
    8, 0x328A, 0x6708, 0,
    8, 0x328B, 0x706B, 0,
    8, 0x328C, 0x6C34, 0,
    8, 0x328D, 0x6728, 0,
    8, 0x328E, 0x91D1, 0,
    8, 0x328F, 0x571F, 0,
    8, 0x3290, 0x65E5, 0,
    8, 0x3291, 0x682A, 0,
    8, 0x3292, 0x6709, 0,
    8, 0x3293, 0x793E, 0,
    8, 0x3294, 0x540D, 0,
    8, 0x3295, 0x7279, 0,
    8, 0x3296, 0x8CA1, 0,
    8, 0x3297, 0x795D, 0,
    8, 0x3298, 0x52B4, 0,
    8, 0x3299, 0x79D8, 0,
    8, 0x329A, 0x7537, 0,
    8, 0x329B, 0x5973, 0,
    8, 0x329C, 0x9069, 0,
    8, 0x329D, 0x512A, 0,
    8, 0x329E, 0x5370, 0,
    8, 0x329F, 0x6CE8, 0,
    8, 0x32A0, 0x9805, 0,
    8, 0x32A1, 0x4F11, 0,
    8, 0x32A2, 0x5199, 0,
    8, 0x32A3, 0x6B63, 0,
    8, 0x32A4, 0x4E0A, 0,
    8, 0x32A5, 0x4E2D, 0,
    8, 0x32A6, 0x4E0B, 0,
    8, 0x32A7, 0x5DE6, 0,
    8, 0x32A8, 0x53F3, 0,
    8, 0x32A9, 0x533B, 0,
    8, 0x32AA, 0x5B97, 0,
    8, 0x32AB, 0x5B66, 0,
    8, 0x32AC, 0x76E3, 0,
    8, 0x32AD, 0x4F01, 0,
    8, 0x32AE, 0x8CC7, 0,
    8, 0x32AF, 0x5354, 0,
    8, 0x32B0, 0x591C, 0,
    16, 0x32C0, 0x0031, 0x6708, 0,
    16, 0x32C1, 0x0032, 0x6708, 0,
    16, 0x32C2, 0x0033, 0x6708, 0,
    16, 0x32C3, 0x0034, 0x6708, 0,
    16, 0x32C4, 0x0035, 0x6708, 0,
    16, 0x32C5, 0x0036, 0x6708, 0,
    16, 0x32C6, 0x0037, 0x6708, 0,
    16, 0x32C7, 0x0038, 0x6708, 0,
    16, 0x32C8, 0x0039, 0x6708, 0,
    16, 0x32C9, 0x0031, 0x0030, 0x6708, 0,
    16, 0x32CA, 0x0031, 0x0031, 0x6708, 0,
    16, 0x32CB, 0x0031, 0x0032, 0x6708, 0,
    8, 0x32D0, 0x30A2, 0,
    8, 0x32D1, 0x30A4, 0,
    8, 0x32D2, 0x30A6, 0,
    8, 0x32D3, 0x30A8, 0,
    8, 0x32D4, 0x30AA, 0,
    8, 0x32D5, 0x30AB, 0,
    8, 0x32D6, 0x30AD, 0,
    8, 0x32D7, 0x30AF, 0,
    8, 0x32D8, 0x30B1, 0,
    8, 0x32D9, 0x30B3, 0,
    8, 0x32DA, 0x30B5, 0,
    8, 0x32DB, 0x30B7, 0,
    8, 0x32DC, 0x30B9, 0,
    8, 0x32DD, 0x30BB, 0,
    8, 0x32DE, 0x30BD, 0,
    8, 0x32DF, 0x30BF, 0,
    8, 0x32E0, 0x30C1, 0,
    8, 0x32E1, 0x30C4, 0,
    8, 0x32E2, 0x30C6, 0,
    8, 0x32E3, 0x30C8, 0,
    8, 0x32E4, 0x30CA, 0,
    8, 0x32E5, 0x30CB, 0,
    8, 0x32E6, 0x30CC, 0,
    8, 0x32E7, 0x30CD, 0,
    8, 0x32E8, 0x30CE, 0,
    8, 0x32E9, 0x30CF, 0,
    8, 0x32EA, 0x30D2, 0,
    8, 0x32EB, 0x30D5, 0,
    8, 0x32EC, 0x30D8, 0,
    8, 0x32ED, 0x30DB, 0,
    8, 0x32EE, 0x30DE, 0,
    8, 0x32EF, 0x30DF, 0,
    8, 0x32F0, 0x30E0, 0,
    8, 0x32F1, 0x30E1, 0,
    8, 0x32F2, 0x30E2, 0,
    8, 0x32F3, 0x30E4, 0,
    8, 0x32F4, 0x30E6, 0,
    8, 0x32F5, 0x30E8, 0,
    8, 0x32F6, 0x30E9, 0,
    8, 0x32F7, 0x30EA, 0,
    8, 0x32F8, 0x30EB, 0,
    8, 0x32F9, 0x30EC, 0,
    8, 0x32FA, 0x30ED, 0,
    8, 0x32FB, 0x30EF, 0,
    8, 0x32FC, 0x30F0, 0,
    8, 0x32FD, 0x30F1, 0,
    8, 0x32FE, 0x30F2, 0,
    15, 0x3300, 0x30A2, 0x30D1, 0x30FC, 0x30C8, 0,
    15, 0x3301, 0x30A2, 0x30EB, 0x30D5, 0x30A1, 0,
    15, 0x3302, 0x30A2, 0x30F3, 0x30DA, 0x30A2, 0,
    15, 0x3303, 0x30A2, 0x30FC, 0x30EB, 0,
    15, 0x3304, 0x30A4, 0x30CB, 0x30F3, 0x30B0, 0,
    15, 0x3305, 0x30A4, 0x30F3, 0x30C1, 0,
    15, 0x3306, 0x30A6, 0x30A9, 0x30F3, 0,
    15, 0x3307, 0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C9, 0,
    15, 0x3308, 0x30A8, 0x30FC, 0x30AB, 0x30FC, 0,
    15, 0x3309, 0x30AA, 0x30F3, 0x30B9, 0,
    15, 0x330A, 0x30AA, 0x30FC, 0x30E0, 0,
    15, 0x330B, 0x30AB, 0x30A4, 0x30EA, 0,
    15, 0x330C, 0x30AB, 0x30E9, 0x30C3, 0x30C8, 0,
    15, 0x330D, 0x30AB, 0x30ED, 0x30EA, 0x30FC, 0,
    15, 0x330E, 0x30AC, 0x30ED, 0x30F3, 0,
    15, 0x330F, 0x30AC, 0x30F3, 0x30DE, 0,
    15, 0x3310, 0x30AE, 0x30AC, 0,
    15, 0x3311, 0x30AE, 0x30CB, 0x30FC, 0,
    15, 0x3312, 0x30AD, 0x30E5, 0x30EA, 0x30FC, 0,
    15, 0x3313, 0x30AE, 0x30EB, 0x30C0, 0x30FC, 0,
    15, 0x3314, 0x30AD, 0x30ED, 0,
    15, 0x3315, 0x30AD, 0x30ED, 0x30B0, 0x30E9, 0x30E0, 0,
    15, 0x3316, 0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0,
    15, 0x3317, 0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8, 0,
    15, 0x3318, 0x30B0, 0x30E9, 0x30E0, 0,
    15, 0x3319, 0x30B0, 0x30E9, 0x30E0, 0x30C8, 0x30F3, 0,
    15, 0x331A, 0x30AF, 0x30EB, 0x30BC, 0x30A4, 0x30ED, 0,
    15, 0x331B, 0x30AF, 0x30ED, 0x30FC, 0x30CD, 0,
    15, 0x331C, 0x30B1, 0x30FC, 0x30B9, 0,
    15, 0x331D, 0x30B3, 0x30EB, 0x30CA, 0,
    15, 0x331E, 0x30B3, 0x30FC, 0x30DD, 0,
    15, 0x331F, 0x30B5, 0x30A4, 0x30AF, 0x30EB, 0,
    15, 0x3320, 0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0, 0,
    15, 0x3321, 0x30B7, 0x30EA, 0x30F3, 0x30B0, 0,
    15, 0x3322, 0x30BB, 0x30F3, 0x30C1, 0,
    15, 0x3323, 0x30BB, 0x30F3, 0x30C8, 0,
    15, 0x3324, 0x30C0, 0x30FC, 0x30B9, 0,
    15, 0x3325, 0x30C7, 0x30B7, 0,
    15, 0x3326, 0x30C9, 0x30EB, 0,
    15, 0x3327, 0x30C8, 0x30F3, 0,
    15, 0x3328, 0x30CA, 0x30CE, 0,
    15, 0x3329, 0x30CE, 0x30C3, 0x30C8, 0,
    15, 0x332A, 0x30CF, 0x30A4, 0x30C4, 0,
    15, 0x332B, 0x30D1, 0x30FC, 0x30BB, 0x30F3, 0x30C8, 0,
    15, 0x332C, 0x30D1, 0x30FC, 0x30C4, 0,
    15, 0x332D, 0x30D0, 0x30FC, 0x30EC, 0x30EB, 0,
    15, 0x332E, 0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB, 0,
    15, 0x332F, 0x30D4, 0x30AF, 0x30EB, 0,
    15, 0x3330, 0x30D4, 0x30B3, 0,
    15, 0x3331, 0x30D3, 0x30EB, 0,
    15, 0x3332, 0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C9, 0,
    15, 0x3333, 0x30D5, 0x30A3, 0x30FC, 0x30C8, 0,
    15, 0x3334, 0x30D6, 0x30C3, 0x30B7, 0x30A7, 0x30EB, 0,
    15, 0x3335, 0x30D5, 0x30E9, 0x30F3, 0,
    15, 0x3336, 0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB, 0,
    15, 0x3337, 0x30DA, 0x30BD, 0,
    15, 0x3338, 0x30DA, 0x30CB, 0x30D2, 0,
    15, 0x3339, 0x30D8, 0x30EB, 0x30C4, 0,
    15, 0x333A, 0x30DA, 0x30F3, 0x30B9, 0,
    15, 0x333B, 0x30DA, 0x30FC, 0x30B8, 0,
    15, 0x333C, 0x30D9, 0x30FC, 0x30BF, 0,
    15, 0x333D, 0x30DD, 0x30A4, 0x30F3, 0x30C8, 0,
    15, 0x333E, 0x30DC, 0x30EB, 0x30C8, 0,
    15, 0x333F, 0x30DB, 0x30F3, 0,
    15, 0x3340, 0x30DD, 0x30F3, 0x30C9, 0,
    15, 0x3341, 0x30DB, 0x30FC, 0x30EB, 0,
    15, 0x3342, 0x30DB, 0x30FC, 0x30F3, 0,
    15, 0x3343, 0x30DE, 0x30A4, 0x30AF, 0x30ED, 0,
    15, 0x3344, 0x30DE, 0x30A4, 0x30EB, 0,
    15, 0x3345, 0x30DE, 0x30C3, 0x30CF, 0,
    15, 0x3346, 0x30DE, 0x30EB, 0x30AF, 0,
    15, 0x3347, 0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3, 0,
    15, 0x3348, 0x30DF, 0x30AF, 0x30ED, 0x30F3, 0,
    15, 0x3349, 0x30DF, 0x30EA, 0,
    15, 0x334A, 0x30DF, 0x30EA, 0x30D0, 0x30FC, 0x30EB, 0,
    15, 0x334B, 0x30E1, 0x30AC, 0,
    15, 0x334C, 0x30E1, 0x30AC, 0x30C8, 0x30F3, 0,
    15, 0x334D, 0x30E1, 0x30FC, 0x30C8, 0x30EB, 0,
    15, 0x334E, 0x30E4, 0x30FC, 0x30C9, 0,
    15, 0x334F, 0x30E4, 0x30FC, 0x30EB, 0,
    15, 0x3350, 0x30E6, 0x30A2, 0x30F3, 0,
    15, 0x3351, 0x30EA, 0x30C3, 0x30C8, 0x30EB, 0,
    15, 0x3352, 0x30EA, 0x30E9, 0,
    15, 0x3353, 0x30EB, 0x30D4, 0x30FC, 0,
    15, 0x3354, 0x30EB, 0x30FC, 0x30D6, 0x30EB, 0,
    15, 0x3355, 0x30EC, 0x30E0, 0,
    15, 0x3356, 0x30EC, 0x30F3, 0x30C8, 0x30B2, 0x30F3, 0,
    15, 0x3357, 0x30EF, 0x30C3, 0x30C8, 0,
    16, 0x3358, 0x0030, 0x70B9, 0,
    16, 0x3359, 0x0031, 0x70B9, 0,
    16, 0x335A, 0x0032, 0x70B9, 0,
    16, 0x335B, 0x0033, 0x70B9, 0,
    16, 0x335C, 0x0034, 0x70B9, 0,
    16, 0x335D, 0x0035, 0x70B9, 0,
    16, 0x335E, 0x0036, 0x70B9, 0,
    16, 0x335F, 0x0037, 0x70B9, 0,
    16, 0x3360, 0x0038, 0x70B9, 0,
    16, 0x3361, 0x0039, 0x70B9, 0,
    16, 0x3362, 0x0031, 0x0030, 0x70B9, 0,
    16, 0x3363, 0x0031, 0x0031, 0x70B9, 0,
    16, 0x3364, 0x0031, 0x0032, 0x70B9, 0,
    16, 0x3365, 0x0031, 0x0033, 0x70B9, 0,
    16, 0x3366, 0x0031, 0x0034, 0x70B9, 0,
    16, 0x3367, 0x0031, 0x0035, 0x70B9, 0,
    16, 0x3368, 0x0031, 0x0036, 0x70B9, 0,
    16, 0x3369, 0x0031, 0x0037, 0x70B9, 0,
    16, 0x336A, 0x0031, 0x0038, 0x70B9, 0,
    16, 0x336B, 0x0031, 0x0039, 0x70B9, 0,
    16, 0x336C, 0x0032, 0x0030, 0x70B9, 0,
    16, 0x336D, 0x0032, 0x0031, 0x70B9, 0,
    16, 0x336E, 0x0032, 0x0032, 0x70B9, 0,
    16, 0x336F, 0x0032, 0x0033, 0x70B9, 0,
    16, 0x3370, 0x0032, 0x0034, 0x70B9, 0,
    15, 0x3371, 0x0068, 0x0050, 0x0061, 0,
    15, 0x3372, 0x0064, 0x0061, 0,
    15, 0x3373, 0x0041, 0x0055, 0,
    15, 0x3374, 0x0062, 0x0061, 0x0072, 0,
    15, 0x3375, 0x006F, 0x0056, 0,
    15, 0x3376, 0x0070, 0x0063, 0,
    15, 0x337B, 0x5E73, 0x6210, 0,
    15, 0x337C, 0x662D, 0x548C, 0,
    15, 0x337D, 0x5927, 0x6B63, 0,
    15, 0x337E, 0x660E, 0x6CBB, 0,
    15, 0x337F, 0x682A, 0x5F0F, 0x4F1A, 0x793E, 0,
    15, 0x3380, 0x0070, 0x0041, 0,
    15, 0x3381, 0x006E, 0x0041, 0,
    15, 0x3382, 0x03BC, 0x0041, 0,
    15, 0x3383, 0x006D, 0x0041, 0,
    15, 0x3384, 0x006B, 0x0041, 0,
    15, 0x3385, 0x004B, 0x0042, 0,
    15, 0x3386, 0x004D, 0x0042, 0,
    15, 0x3387, 0x0047, 0x0042, 0,
    15, 0x3388, 0x0063, 0x0061, 0x006C, 0,
    15, 0x3389, 0x006B, 0x0063, 0x0061, 0x006C, 0,
    15, 0x338A, 0x0070, 0x0046, 0,
    15, 0x338B, 0x006E, 0x0046, 0,
    15, 0x338C, 0x03BC, 0x0046, 0,
    15, 0x338D, 0x03BC, 0x0067, 0,
    15, 0x338E, 0x006D, 0x0067, 0,
    15, 0x338F, 0x006B, 0x0067, 0,
    15, 0x3390, 0x0048, 0x007A, 0,
    15, 0x3391, 0x006B, 0x0048, 0x007A, 0,
    15, 0x3392, 0x004D, 0x0048, 0x007A, 0,
    15, 0x3393, 0x0047, 0x0048, 0x007A, 0,
    15, 0x3394, 0x0054, 0x0048, 0x007A, 0,
    15, 0x3395, 0x03BC, 0x2113, 0,
    15, 0x3396, 0x006D, 0x2113, 0,
    15, 0x3397, 0x0064, 0x2113, 0,
    15, 0x3398, 0x006B, 0x2113, 0,
    15, 0x3399, 0x0066, 0x006D, 0,
    15, 0x339A, 0x006E, 0x006D, 0,
    15, 0x339B, 0x03BC, 0x006D, 0,
    15, 0x339C, 0x006D, 0x006D, 0,
    15, 0x339D, 0x0063, 0x006D, 0,
    15, 0x339E, 0x006B, 0x006D, 0,
    15, 0x339F, 0x006D, 0x006D, 0x00B2, 0,
    15, 0x33A0, 0x0063, 0x006D, 0x00B2, 0,
    15, 0x33A1, 0x006D, 0x00B2, 0,
    15, 0x33A2, 0x006B, 0x006D, 0x00B2, 0,
    15, 0x33A3, 0x006D, 0x006D, 0x00B3, 0,
    15, 0x33A4, 0x0063, 0x006D, 0x00B3, 0,
    15, 0x33A5, 0x006D, 0x00B3, 0,
    15, 0x33A6, 0x006B, 0x006D, 0x00B3, 0,
    15, 0x33A7, 0x006D, 0x2215, 0x0073, 0,
    15, 0x33A8, 0x006D, 0x2215, 0x0073, 0x00B2, 0,
    15, 0x33A9, 0x0050, 0x0061, 0,
    15, 0x33AA, 0x006B, 0x0050, 0x0061, 0,
    15, 0x33AB, 0x004D, 0x0050, 0x0061, 0,
    15, 0x33AC, 0x0047, 0x0050, 0x0061, 0,
    15, 0x33AD, 0x0072, 0x0061, 0x0064, 0,
    15, 0x33AE, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0,
    15, 0x33AF, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x00B2, 0,
    15, 0x33B0, 0x0070, 0x0073, 0,
    15, 0x33B1, 0x006E, 0x0073, 0,
    15, 0x33B2, 0x03BC, 0x0073, 0,
    15, 0x33B3, 0x006D, 0x0073, 0,
    15, 0x33B4, 0x0070, 0x0056, 0,
    15, 0x33B5, 0x006E, 0x0056, 0,
    15, 0x33B6, 0x03BC, 0x0056, 0,
    15, 0x33B7, 0x006D, 0x0056, 0,
    15, 0x33B8, 0x006B, 0x0056, 0,
    15, 0x33B9, 0x004D, 0x0056, 0,
    15, 0x33BA, 0x0070, 0x0057, 0,
    15, 0x33BB, 0x006E, 0x0057, 0,
    15, 0x33BC, 0x03BC, 0x0057, 0,
    15, 0x33BD, 0x006D, 0x0057, 0,
    15, 0x33BE, 0x006B, 0x0057, 0,
    15, 0x33BF, 0x004D, 0x0057, 0,
    15, 0x33C0, 0x006B, 0x03A9, 0,
    15, 0x33C1, 0x004D, 0x03A9, 0,
    15, 0x33C2, 0x0061, 0x002E, 0x006D, 0x002E, 0,
    15, 0x33C3, 0x0042, 0x0071, 0,
    15, 0x33C4, 0x0063, 0x0063, 0,
    15, 0x33C5, 0x0063, 0x0064, 0,
    15, 0x33C6, 0x0043, 0x2215, 0x006B, 0x0067, 0,
    15, 0x33C7, 0x0043, 0x006F, 0x002E, 0,
    15, 0x33C8, 0x0064, 0x0042, 0,
    15, 0x33C9, 0x0047, 0x0079, 0,
    15, 0x33CA, 0x0068, 0x0061, 0,
    15, 0x33CB, 0x0048, 0x0050, 0,
    15, 0x33CC, 0x0069, 0x006E, 0,
    15, 0x33CD, 0x004B, 0x004B, 0,
    15, 0x33CE, 0x004B, 0x004D, 0,
    15, 0x33CF, 0x006B, 0x0074, 0,
    15, 0x33D0, 0x006C, 0x006D, 0,
    15, 0x33D1, 0x006C, 0x006E, 0,
    15, 0x33D2, 0x006C, 0x006F, 0x0067, 0,
    15, 0x33D3, 0x006C, 0x0078, 0,
    15, 0x33D4, 0x006D, 0x0062, 0,
    15, 0x33D5, 0x006D, 0x0069, 0x006C, 0,
    15, 0x33D6, 0x006D, 0x006F, 0x006C, 0,
    15, 0x33D7, 0x0050, 0x0048, 0,
    15, 0x33D8, 0x0070, 0x002E, 0x006D, 0x002E, 0,
    15, 0x33D9, 0x0050, 0x0050, 0x004D, 0,
    15, 0x33DA, 0x0050, 0x0052, 0,
    15, 0x33DB, 0x0073, 0x0072, 0,
    15, 0x33DC, 0x0053, 0x0076, 0,
    15, 0x33DD, 0x0057, 0x0062, 0,
    16, 0x33E0, 0x0031, 0x65E5, 0,
    16, 0x33E1, 0x0032, 0x65E5, 0,
    16, 0x33E2, 0x0033, 0x65E5, 0,
    16, 0x33E3, 0x0034, 0x65E5, 0,
    16, 0x33E4, 0x0035, 0x65E5, 0,
    16, 0x33E5, 0x0036, 0x65E5, 0,
    16, 0x33E6, 0x0037, 0x65E5, 0,
    16, 0x33E7, 0x0038, 0x65E5, 0,
    16, 0x33E8, 0x0039, 0x65E5, 0,
    16, 0x33E9, 0x0031, 0x0030, 0x65E5, 0,
    16, 0x33EA, 0x0031, 0x0031, 0x65E5, 0,
    16, 0x33EB, 0x0031, 0x0032, 0x65E5, 0,
    16, 0x33EC, 0x0031, 0x0033, 0x65E5, 0,
    16, 0x33ED, 0x0031, 0x0034, 0x65E5, 0,
    16, 0x33EE, 0x0031, 0x0035, 0x65E5, 0,
    16, 0x33EF, 0x0031, 0x0036, 0x65E5, 0,
    16, 0x33F0, 0x0031, 0x0037, 0x65E5, 0,
    16, 0x33F1, 0x0031, 0x0038, 0x65E5, 0,
    16, 0x33F2, 0x0031, 0x0039, 0x65E5, 0,
    16, 0x33F3, 0x0032, 0x0030, 0x65E5, 0,
    16, 0x33F4, 0x0032, 0x0031, 0x65E5, 0,
    16, 0x33F5, 0x0032, 0x0032, 0x65E5, 0,
    16, 0x33F6, 0x0032, 0x0033, 0x65E5, 0,
    16, 0x33F7, 0x0032, 0x0034, 0x65E5, 0,
    16, 0x33F8, 0x0032, 0x0035, 0x65E5, 0,
    16, 0x33F9, 0x0032, 0x0036, 0x65E5, 0,
    16, 0x33FA, 0x0032, 0x0037, 0x65E5, 0,
    16, 0x33FB, 0x0032, 0x0038, 0x65E5, 0,
    16, 0x33FC, 0x0032, 0x0039, 0x65E5, 0,
    16, 0x33FD, 0x0033, 0x0030, 0x65E5, 0,
    16, 0x33FE, 0x0033, 0x0031, 0x65E5, 0,
    1, 0xF900, 0x8C48, 0,
    1, 0xF901, 0x66F4, 0,
    1, 0xF902, 0x8ECA, 0,
    1, 0xF903, 0x8CC8, 0,
    1, 0xF904, 0x6ED1, 0,
    1, 0xF905, 0x4E32, 0,
    1, 0xF906, 0x53E5, 0,
    1, 0xF907, 0x9F9C, 0,
    1, 0xF908, 0x9F9C, 0,
    1, 0xF909, 0x5951, 0,
    1, 0xF90A, 0x91D1, 0,
    1, 0xF90B, 0x5587, 0,
    1, 0xF90C, 0x5948, 0,
    1, 0xF90D, 0x61F6, 0,
    1, 0xF90E, 0x7669, 0,
    1, 0xF90F, 0x7F85, 0,
    1, 0xF910, 0x863F, 0,
    1, 0xF911, 0x87BA, 0,
    1, 0xF912, 0x88F8, 0,
    1, 0xF913, 0x908F, 0,
    1, 0xF914, 0x6A02, 0,
    1, 0xF915, 0x6D1B, 0,
    1, 0xF916, 0x70D9, 0,
    1, 0xF917, 0x73DE, 0,
    1, 0xF918, 0x843D, 0,
    1, 0xF919, 0x916A, 0,
    1, 0xF91A, 0x99F1, 0,
    1, 0xF91B, 0x4E82, 0,
    1, 0xF91C, 0x5375, 0,
    1, 0xF91D, 0x6B04, 0,
    1, 0xF91E, 0x721B, 0,
    1, 0xF91F, 0x862D, 0,
    1, 0xF920, 0x9E1E, 0,
    1, 0xF921, 0x5D50, 0,
    1, 0xF922, 0x6FEB, 0,
    1, 0xF923, 0x85CD, 0,
    1, 0xF924, 0x8964, 0,
    1, 0xF925, 0x62C9, 0,
    1, 0xF926, 0x81D8, 0,
    1, 0xF927, 0x881F, 0,
    1, 0xF928, 0x5ECA, 0,
    1, 0xF929, 0x6717, 0,
    1, 0xF92A, 0x6D6A, 0,
    1, 0xF92B, 0x72FC, 0,
    1, 0xF92C, 0x90CE, 0,
    1, 0xF92D, 0x4F86, 0,
    1, 0xF92E, 0x51B7, 0,
    1, 0xF92F, 0x52DE, 0,
    1, 0xF930, 0x64C4, 0,
    1, 0xF931, 0x6AD3, 0,
    1, 0xF932, 0x7210, 0,
    1, 0xF933, 0x76E7, 0,
    1, 0xF934, 0x8001, 0,
    1, 0xF935, 0x8606, 0,
    1, 0xF936, 0x865C, 0,
    1, 0xF937, 0x8DEF, 0,
    1, 0xF938, 0x9732, 0,
    1, 0xF939, 0x9B6F, 0,
    1, 0xF93A, 0x9DFA, 0,
    1, 0xF93B, 0x788C, 0,
    1, 0xF93C, 0x797F, 0,
    1, 0xF93D, 0x7DA0, 0,
    1, 0xF93E, 0x83C9, 0,
    1, 0xF93F, 0x9304, 0,
    1, 0xF940, 0x9E7F, 0,
    1, 0xF941, 0x8AD6, 0,
    1, 0xF942, 0x58DF, 0,
    1, 0xF943, 0x5F04, 0,
    1, 0xF944, 0x7C60, 0,
    1, 0xF945, 0x807E, 0,
    1, 0xF946, 0x7262, 0,
    1, 0xF947, 0x78CA, 0,
    1, 0xF948, 0x8CC2, 0,
    1, 0xF949, 0x96F7, 0,
    1, 0xF94A, 0x58D8, 0,
    1, 0xF94B, 0x5C62, 0,
    1, 0xF94C, 0x6A13, 0,
    1, 0xF94D, 0x6DDA, 0,
    1, 0xF94E, 0x6F0F, 0,
    1, 0xF94F, 0x7D2F, 0,
    1, 0xF950, 0x7E37, 0,
    1, 0xF951, 0x96FB, 0,
    1, 0xF952, 0x52D2, 0,
    1, 0xF953, 0x808B, 0,
    1, 0xF954, 0x51DC, 0,
    1, 0xF955, 0x51CC, 0,
    1, 0xF956, 0x7A1C, 0,
    1, 0xF957, 0x7DBE, 0,
    1, 0xF958, 0x83F1, 0,
    1, 0xF959, 0x9675, 0,
    1, 0xF95A, 0x8B80, 0,
    1, 0xF95B, 0x62CF, 0,
    1, 0xF95C, 0x6A02, 0,
    1, 0xF95D, 0x8AFE, 0,
    1, 0xF95E, 0x4E39, 0,
    1, 0xF95F, 0x5BE7, 0,
    1, 0xF960, 0x6012, 0,
    1, 0xF961, 0x7387, 0,
    1, 0xF962, 0x7570, 0,
    1, 0xF963, 0x5317, 0,
    1, 0xF964, 0x78FB, 0,
    1, 0xF965, 0x4FBF, 0,
    1, 0xF966, 0x5FA9, 0,
    1, 0xF967, 0x4E0D, 0,
    1, 0xF968, 0x6CCC, 0,
    1, 0xF969, 0x6578, 0,
    1, 0xF96A, 0x7D22, 0,
    1, 0xF96B, 0x53C3, 0,
    1, 0xF96C, 0x585E, 0,
    1, 0xF96D, 0x7701, 0,
    1, 0xF96E, 0x8449, 0,
    1, 0xF96F, 0x8AAA, 0,
    1, 0xF970, 0x6BBA, 0,
    1, 0xF971, 0x8FB0, 0,
    1, 0xF972, 0x6C88, 0,
    1, 0xF973, 0x62FE, 0,
    1, 0xF974, 0x82E5, 0,
    1, 0xF975, 0x63A0, 0,
    1, 0xF976, 0x7565, 0,
    1, 0xF977, 0x4EAE, 0,
    1, 0xF978, 0x5169, 0,
    1, 0xF979, 0x51C9, 0,
    1, 0xF97A, 0x6881, 0,
    1, 0xF97B, 0x7CE7, 0,
    1, 0xF97C, 0x826F, 0,
    1, 0xF97D, 0x8AD2, 0,
    1, 0xF97E, 0x91CF, 0,
    1, 0xF97F, 0x52F5, 0,
    1, 0xF980, 0x5442, 0,
    1, 0xF981, 0x5973, 0,
    1, 0xF982, 0x5EEC, 0,
    1, 0xF983, 0x65C5, 0,
    1, 0xF984, 0x6FFE, 0,
    1, 0xF985, 0x792A, 0,
    1, 0xF986, 0x95AD, 0,
    1, 0xF987, 0x9A6A, 0,
    1, 0xF988, 0x9E97, 0,
    1, 0xF989, 0x9ECE, 0,
    1, 0xF98A, 0x529B, 0,
    1, 0xF98B, 0x66C6, 0,
    1, 0xF98C, 0x6B77, 0,
    1, 0xF98D, 0x8F62, 0,
    1, 0xF98E, 0x5E74, 0,
    1, 0xF98F, 0x6190, 0,
    1, 0xF990, 0x6200, 0,
    1, 0xF991, 0x649A, 0,
    1, 0xF992, 0x6F23, 0,
    1, 0xF993, 0x7149, 0,
    1, 0xF994, 0x7489, 0,
    1, 0xF995, 0x79CA, 0,
    1, 0xF996, 0x7DF4, 0,
    1, 0xF997, 0x806F, 0,
    1, 0xF998, 0x8F26, 0,
    1, 0xF999, 0x84EE, 0,
    1, 0xF99A, 0x9023, 0,
    1, 0xF99B, 0x934A, 0,
    1, 0xF99C, 0x5217, 0,
    1, 0xF99D, 0x52A3, 0,
    1, 0xF99E, 0x54BD, 0,
    1, 0xF99F, 0x70C8, 0,
    1, 0xF9A0, 0x88C2, 0,
    1, 0xF9A1, 0x8AAA, 0,
    1, 0xF9A2, 0x5EC9, 0,
    1, 0xF9A3, 0x5FF5, 0,
    1, 0xF9A4, 0x637B, 0,
    1, 0xF9A5, 0x6BAE, 0,
    1, 0xF9A6, 0x7C3E, 0,
    1, 0xF9A7, 0x7375, 0,
    1, 0xF9A8, 0x4EE4, 0,
    1, 0xF9A9, 0x56F9, 0,
    1, 0xF9AA, 0x5BE7, 0,
    1, 0xF9AB, 0x5DBA, 0,
    1, 0xF9AC, 0x601C, 0,
    1, 0xF9AD, 0x73B2, 0,
    1, 0xF9AE, 0x7469, 0,
    1, 0xF9AF, 0x7F9A, 0,
    1, 0xF9B0, 0x8046, 0,
    1, 0xF9B1, 0x9234, 0,
    1, 0xF9B2, 0x96F6, 0,
    1, 0xF9B3, 0x9748, 0,
    1, 0xF9B4, 0x9818, 0,
    1, 0xF9B5, 0x4F8B, 0,
    1, 0xF9B6, 0x79AE, 0,
    1, 0xF9B7, 0x91B4, 0,
    1, 0xF9B8, 0x96B8, 0,
    1, 0xF9B9, 0x60E1, 0,
    1, 0xF9BA, 0x4E86, 0,
    1, 0xF9BB, 0x50DA, 0,
    1, 0xF9BC, 0x5BEE, 0,
    1, 0xF9BD, 0x5C3F, 0,
    1, 0xF9BE, 0x6599, 0,
    1, 0xF9BF, 0x6A02, 0,
    1, 0xF9C0, 0x71CE, 0,
    1, 0xF9C1, 0x7642, 0,
    1, 0xF9C2, 0x84FC, 0,
    1, 0xF9C3, 0x907C, 0,
    1, 0xF9C4, 0x9F8D, 0,
    1, 0xF9C5, 0x6688, 0,
    1, 0xF9C6, 0x962E, 0,
    1, 0xF9C7, 0x5289, 0,
    1, 0xF9C8, 0x677B, 0,
    1, 0xF9C9, 0x67F3, 0,
    1, 0xF9CA, 0x6D41, 0,
    1, 0xF9CB, 0x6E9C, 0,
    1, 0xF9CC, 0x7409, 0,
    1, 0xF9CD, 0x7559, 0,
    1, 0xF9CE, 0x786B, 0,
    1, 0xF9CF, 0x7D10, 0,
    1, 0xF9D0, 0x985E, 0,
    1, 0xF9D1, 0x516D, 0,
    1, 0xF9D2, 0x622E, 0,
    1, 0xF9D3, 0x9678, 0,
    1, 0xF9D4, 0x502B, 0,
    1, 0xF9D5, 0x5D19, 0,
    1, 0xF9D6, 0x6DEA, 0,
    1, 0xF9D7, 0x8F2A, 0,
    1, 0xF9D8, 0x5F8B, 0,
    1, 0xF9D9, 0x6144, 0,
    1, 0xF9DA, 0x6817, 0,
    1, 0xF9DB, 0x7387, 0,
    1, 0xF9DC, 0x9686, 0,
    1, 0xF9DD, 0x5229, 0,
    1, 0xF9DE, 0x540F, 0,
    1, 0xF9DF, 0x5C65, 0,
    1, 0xF9E0, 0x6613, 0,
    1, 0xF9E1, 0x674E, 0,
    1, 0xF9E2, 0x68A8, 0,
    1, 0xF9E3, 0x6CE5, 0,
    1, 0xF9E4, 0x7406, 0,
    1, 0xF9E5, 0x75E2, 0,
    1, 0xF9E6, 0x7F79, 0,
    1, 0xF9E7, 0x88CF, 0,
    1, 0xF9E8, 0x88E1, 0,
    1, 0xF9E9, 0x91CC, 0,
    1, 0xF9EA, 0x96E2, 0,
    1, 0xF9EB, 0x533F, 0,
    1, 0xF9EC, 0x6EBA, 0,
    1, 0xF9ED, 0x541D, 0,
    1, 0xF9EE, 0x71D0, 0,
    1, 0xF9EF, 0x7498, 0,
    1, 0xF9F0, 0x85FA, 0,
    1, 0xF9F1, 0x96A3, 0,
    1, 0xF9F2, 0x9C57, 0,
    1, 0xF9F3, 0x9E9F, 0,
    1, 0xF9F4, 0x6797, 0,
    1, 0xF9F5, 0x6DCB, 0,
    1, 0xF9F6, 0x81E8, 0,
    1, 0xF9F7, 0x7ACB, 0,
    1, 0xF9F8, 0x7B20, 0,
    1, 0xF9F9, 0x7C92, 0,
    1, 0xF9FA, 0x72C0, 0,
    1, 0xF9FB, 0x7099, 0,
    1, 0xF9FC, 0x8B58, 0,
    1, 0xF9FD, 0x4EC0, 0,
    1, 0xF9FE, 0x8336, 0,
    1, 0xF9FF, 0x523A, 0,
    1, 0xFA00, 0x5207, 0,
    1, 0xFA01, 0x5EA6, 0,
    1, 0xFA02, 0x62D3, 0,
    1, 0xFA03, 0x7CD6, 0,
    1, 0xFA04, 0x5B85, 0,
    1, 0xFA05, 0x6D1E, 0,
    1, 0xFA06, 0x66B4, 0,
    1, 0xFA07, 0x8F3B, 0,
    1, 0xFA08, 0x884C, 0,
    1, 0xFA09, 0x964D, 0,
    1, 0xFA0A, 0x898B, 0,
    1, 0xFA0B, 0x5ED3, 0,
    1, 0xFA0C, 0x5140, 0,
    1, 0xFA0D, 0x55C0, 0,
    1, 0xFA10, 0x585A, 0,
    1, 0xFA12, 0x6674, 0,
    1, 0xFA15, 0x51DE, 0,
    1, 0xFA16, 0x732A, 0,
    1, 0xFA17, 0x76CA, 0,
    1, 0xFA18, 0x793C, 0,
    1, 0xFA19, 0x795E, 0,
    1, 0xFA1A, 0x7965, 0,
    1, 0xFA1B, 0x798F, 0,
    1, 0xFA1C, 0x9756, 0,
    1, 0xFA1D, 0x7CBE, 0,
    1, 0xFA1E, 0x7FBD, 0,
    1, 0xFA20, 0x8612, 0,
    1, 0xFA22, 0x8AF8, 0,
    1, 0xFA25, 0x9038, 0,
    1, 0xFA26, 0x90FD, 0,
    1, 0xFA2A, 0x98EF, 0,
    1, 0xFA2B, 0x98FC, 0,
    1, 0xFA2C, 0x9928, 0,
    1, 0xFA2D, 0x9DB4, 0,
    16, 0xFB00, 0x0066, 0x0066, 0,
    16, 0xFB01, 0x0066, 0x0069, 0,
    16, 0xFB02, 0x0066, 0x006C, 0,
    16, 0xFB03, 0x0066, 0x0066, 0x0069, 0,
    16, 0xFB04, 0x0066, 0x0066, 0x006C, 0,
    16, 0xFB05, 0x017F, 0x0074, 0,
    16, 0xFB06, 0x0073, 0x0074, 0,
    16, 0xFB13, 0x0574, 0x0576, 0,
    16, 0xFB14, 0x0574, 0x0565, 0,
    16, 0xFB15, 0x0574, 0x056B, 0,
    16, 0xFB16, 0x057E, 0x0576, 0,
    16, 0xFB17, 0x0574, 0x056D, 0,
    1, 0xFB1F, 0x05F2, 0x05B7, 0,
    2, 0xFB20, 0x05E2, 0,
    2, 0xFB21, 0x05D0, 0,
    2, 0xFB22, 0x05D3, 0,
    2, 0xFB23, 0x05D4, 0,
    2, 0xFB24, 0x05DB, 0,
    2, 0xFB25, 0x05DC, 0,
    2, 0xFB26, 0x05DD, 0,
    2, 0xFB27, 0x05E8, 0,
    2, 0xFB28, 0x05EA, 0,
    2, 0xFB29, 0x002B, 0,
    1, 0xFB2A, 0x05E9, 0x05C1, 0,
    1, 0xFB2B, 0x05E9, 0x05C2, 0,
    1, 0xFB2C, 0xFB49, 0x05C1, 0,
    1, 0xFB2D, 0xFB49, 0x05C2, 0,
    1, 0xFB2E, 0x05D0, 0x05B7, 0,
    1, 0xFB2F, 0x05D0, 0x05B8, 0,
    1, 0xFB30, 0x05D0, 0x05BC, 0,
    1, 0xFB31, 0x05D1, 0x05BC, 0,
    1, 0xFB32, 0x05D2, 0x05BC, 0,
    1, 0xFB33, 0x05D3, 0x05BC, 0,
    1, 0xFB34, 0x05D4, 0x05BC, 0,
    1, 0xFB35, 0x05D5, 0x05BC, 0,
    1, 0xFB36, 0x05D6, 0x05BC, 0,
    1, 0xFB38, 0x05D8, 0x05BC, 0,
    1, 0xFB39, 0x05D9, 0x05BC, 0,
    1, 0xFB3A, 0x05DA, 0x05BC, 0,
    1, 0xFB3B, 0x05DB, 0x05BC, 0,
    1, 0xFB3C, 0x05DC, 0x05BC, 0,
    1, 0xFB3E, 0x05DE, 0x05BC, 0,
    1, 0xFB40, 0x05E0, 0x05BC, 0,
    1, 0xFB41, 0x05E1, 0x05BC, 0,
    1, 0xFB43, 0x05E3, 0x05BC, 0,
    1, 0xFB44, 0x05E4, 0x05BC, 0,
    1, 0xFB46, 0x05E6, 0x05BC, 0,
    1, 0xFB47, 0x05E7, 0x05BC, 0,
    1, 0xFB48, 0x05E8, 0x05BC, 0,
    1, 0xFB49, 0x05E9, 0x05BC, 0,
    1, 0xFB4A, 0x05EA, 0x05BC, 0,
    1, 0xFB4B, 0x05D5, 0x05B9, 0,
    1, 0xFB4C, 0x05D1, 0x05BF, 0,
    1, 0xFB4D, 0x05DB, 0x05BF, 0,
    1, 0xFB4E, 0x05E4, 0x05BF, 0,
    16, 0xFB4F, 0x05D0, 0x05DC, 0,
    7, 0xFB50, 0x0671, 0,
    6, 0xFB51, 0x0671, 0,
    7, 0xFB52, 0x067B, 0,
    6, 0xFB53, 0x067B, 0,
    4, 0xFB54, 0x067B, 0,
    5, 0xFB55, 0x067B, 0,
    7, 0xFB56, 0x067E, 0,
    6, 0xFB57, 0x067E, 0,
    4, 0xFB58, 0x067E, 0,
    5, 0xFB59, 0x067E, 0,
    7, 0xFB5A, 0x0680, 0,
    6, 0xFB5B, 0x0680, 0,
    4, 0xFB5C, 0x0680, 0,
    5, 0xFB5D, 0x0680, 0,
    7, 0xFB5E, 0x067A, 0,
    6, 0xFB5F, 0x067A, 0,
    4, 0xFB60, 0x067A, 0,
    5, 0xFB61, 0x067A, 0,
    7, 0xFB62, 0x067F, 0,
    6, 0xFB63, 0x067F, 0,
    4, 0xFB64, 0x067F, 0,
    5, 0xFB65, 0x067F, 0,
    7, 0xFB66, 0x0679, 0,
    6, 0xFB67, 0x0679, 0,
    4, 0xFB68, 0x0679, 0,
    5, 0xFB69, 0x0679, 0,
    7, 0xFB6A, 0x06A4, 0,
    6, 0xFB6B, 0x06A4, 0,
    4, 0xFB6C, 0x06A4, 0,
    5, 0xFB6D, 0x06A4, 0,
    7, 0xFB6E, 0x06A6, 0,
    6, 0xFB6F, 0x06A6, 0,
    4, 0xFB70, 0x06A6, 0,
    5, 0xFB71, 0x06A6, 0,
    7, 0xFB72, 0x0684, 0,
    6, 0xFB73, 0x0684, 0,
    4, 0xFB74, 0x0684, 0,
    5, 0xFB75, 0x0684, 0,
    7, 0xFB76, 0x0683, 0,
    6, 0xFB77, 0x0683, 0,
    4, 0xFB78, 0x0683, 0,
    5, 0xFB79, 0x0683, 0,
    7, 0xFB7A, 0x0686, 0,
    6, 0xFB7B, 0x0686, 0,
    4, 0xFB7C, 0x0686, 0,
    5, 0xFB7D, 0x0686, 0,
    7, 0xFB7E, 0x0687, 0,
    6, 0xFB7F, 0x0687, 0,
    4, 0xFB80, 0x0687, 0,
    5, 0xFB81, 0x0687, 0,
    7, 0xFB82, 0x068D, 0,
    6, 0xFB83, 0x068D, 0,
    7, 0xFB84, 0x068C, 0,
    6, 0xFB85, 0x068C, 0,
    7, 0xFB86, 0x068E, 0,
    6, 0xFB87, 0x068E, 0,
    7, 0xFB88, 0x0688, 0,
    6, 0xFB89, 0x0688, 0,
    7, 0xFB8A, 0x0698, 0,
    6, 0xFB8B, 0x0698, 0,
    7, 0xFB8C, 0x0691, 0,
    6, 0xFB8D, 0x0691, 0,
    7, 0xFB8E, 0x06A9, 0,
    6, 0xFB8F, 0x06A9, 0,
    4, 0xFB90, 0x06A9, 0,
    5, 0xFB91, 0x06A9, 0,
    7, 0xFB92, 0x06AF, 0,
    6, 0xFB93, 0x06AF, 0,
    4, 0xFB94, 0x06AF, 0,
    5, 0xFB95, 0x06AF, 0,
    7, 0xFB96, 0x06B3, 0,
    6, 0xFB97, 0x06B3, 0,
    4, 0xFB98, 0x06B3, 0,
    5, 0xFB99, 0x06B3, 0,
    7, 0xFB9A, 0x06B1, 0,
    6, 0xFB9B, 0x06B1, 0,
    4, 0xFB9C, 0x06B1, 0,
    5, 0xFB9D, 0x06B1, 0,
    7, 0xFB9E, 0x06BA, 0,
    6, 0xFB9F, 0x06BA, 0,
    7, 0xFBA0, 0x06BB, 0,
    6, 0xFBA1, 0x06BB, 0,
    4, 0xFBA2, 0x06BB, 0,
    5, 0xFBA3, 0x06BB, 0,
    7, 0xFBA4, 0x06C0, 0,
    6, 0xFBA5, 0x06C0, 0,
    7, 0xFBA6, 0x06C1, 0,
    6, 0xFBA7, 0x06C1, 0,
    4, 0xFBA8, 0x06C1, 0,
    5, 0xFBA9, 0x06C1, 0,
    7, 0xFBAA, 0x06BE, 0,
    6, 0xFBAB, 0x06BE, 0,
    4, 0xFBAC, 0x06BE, 0,
    5, 0xFBAD, 0x06BE, 0,
    7, 0xFBAE, 0x06D2, 0,
    6, 0xFBAF, 0x06D2, 0,
    7, 0xFBB0, 0x06D3, 0,
    6, 0xFBB1, 0x06D3, 0,
    7, 0xFBD3, 0x06AD, 0,
    6, 0xFBD4, 0x06AD, 0,
    4, 0xFBD5, 0x06AD, 0,
    5, 0xFBD6, 0x06AD, 0,
    7, 0xFBD7, 0x06C7, 0,
    6, 0xFBD8, 0x06C7, 0,
    7, 0xFBD9, 0x06C6, 0,
    6, 0xFBDA, 0x06C6, 0,
    7, 0xFBDB, 0x06C8, 0,
    6, 0xFBDC, 0x06C8, 0,
    7, 0xFBDD, 0x0677, 0,
    7, 0xFBDE, 0x06CB, 0,
    6, 0xFBDF, 0x06CB, 0,
    7, 0xFBE0, 0x06C5, 0,
    6, 0xFBE1, 0x06C5, 0,
    7, 0xFBE2, 0x06C9, 0,
    6, 0xFBE3, 0x06C9, 0,
    7, 0xFBE4, 0x06D0, 0,
    6, 0xFBE5, 0x06D0, 0,
    4, 0xFBE6, 0x06D0, 0,
    5, 0xFBE7, 0x06D0, 0,
    4, 0xFBE8, 0x0649, 0,
    5, 0xFBE9, 0x0649, 0,
    7, 0xFBEA, 0x0626, 0x0627, 0,
    6, 0xFBEB, 0x0626, 0x0627, 0,
    7, 0xFBEC, 0x0626, 0x06D5, 0,
    6, 0xFBED, 0x0626, 0x06D5, 0,
    7, 0xFBEE, 0x0626, 0x0648, 0,
    6, 0xFBEF, 0x0626, 0x0648, 0,
    7, 0xFBF0, 0x0626, 0x06C7, 0,
    6, 0xFBF1, 0x0626, 0x06C7, 0,
    7, 0xFBF2, 0x0626, 0x06C6, 0,
    6, 0xFBF3, 0x0626, 0x06C6, 0,
    7, 0xFBF4, 0x0626, 0x06C8, 0,
    6, 0xFBF5, 0x0626, 0x06C8, 0,
    7, 0xFBF6, 0x0626, 0x06D0, 0,
    6, 0xFBF7, 0x0626, 0x06D0, 0,
    4, 0xFBF8, 0x0626, 0x06D0, 0,
    7, 0xFBF9, 0x0626, 0x0649, 0,
    6, 0xFBFA, 0x0626, 0x0649, 0,
    4, 0xFBFB, 0x0626, 0x0649, 0,
    7, 0xFBFC, 0x06CC, 0,
    6, 0xFBFD, 0x06CC, 0,
    4, 0xFBFE, 0x06CC, 0,
    5, 0xFBFF, 0x06CC, 0,
    7, 0xFC00, 0x0626, 0x062C, 0,
    7, 0xFC01, 0x0626, 0x062D, 0,
    7, 0xFC02, 0x0626, 0x0645, 0,
    7, 0xFC03, 0x0626, 0x0649, 0,
    7, 0xFC04, 0x0626, 0x064A, 0,
    7, 0xFC05, 0x0628, 0x062C, 0,
    7, 0xFC06, 0x0628, 0x062D, 0,
    7, 0xFC07, 0x0628, 0x062E, 0,
    7, 0xFC08, 0x0628, 0x0645, 0,
    7, 0xFC09, 0x0628, 0x0649, 0,
    7, 0xFC0A, 0x0628, 0x064A, 0,
    7, 0xFC0B, 0x062A, 0x062C, 0,
    7, 0xFC0C, 0x062A, 0x062D, 0,
    7, 0xFC0D, 0x062A, 0x062E, 0,
    7, 0xFC0E, 0x062A, 0x0645, 0,
    7, 0xFC0F, 0x062A, 0x0649, 0,
    7, 0xFC10, 0x062A, 0x064A, 0,
    7, 0xFC11, 0x062B, 0x062C, 0,
    7, 0xFC12, 0x062B, 0x0645, 0,
    7, 0xFC13, 0x062B, 0x0649, 0,
    7, 0xFC14, 0x062B, 0x064A, 0,
    7, 0xFC15, 0x062C, 0x062D, 0,
    7, 0xFC16, 0x062C, 0x0645, 0,
    7, 0xFC17, 0x062D, 0x062C, 0,
    7, 0xFC18, 0x062D, 0x0645, 0,
    7, 0xFC19, 0x062E, 0x062C, 0,
    7, 0xFC1A, 0x062E, 0x062D, 0,
    7, 0xFC1B, 0x062E, 0x0645, 0,
    7, 0xFC1C, 0x0633, 0x062C, 0,
    7, 0xFC1D, 0x0633, 0x062D, 0,
    7, 0xFC1E, 0x0633, 0x062E, 0,
    7, 0xFC1F, 0x0633, 0x0645, 0,
    7, 0xFC20, 0x0635, 0x062D, 0,
    7, 0xFC21, 0x0635, 0x0645, 0,
    7, 0xFC22, 0x0636, 0x062C, 0,
    7, 0xFC23, 0x0636, 0x062D, 0,
    7, 0xFC24, 0x0636, 0x062E, 0,
    7, 0xFC25, 0x0636, 0x0645, 0,
    7, 0xFC26, 0x0637, 0x062D, 0,
    7, 0xFC27, 0x0637, 0x0645, 0,
    7, 0xFC28, 0x0638, 0x0645, 0,
    7, 0xFC29, 0x0639, 0x062C, 0,
    7, 0xFC2A, 0x0639, 0x0645, 0,
    7, 0xFC2B, 0x063A, 0x062C, 0,
    7, 0xFC2C, 0x063A, 0x0645, 0,
    7, 0xFC2D, 0x0641, 0x062C, 0,
    7, 0xFC2E, 0x0641, 0x062D, 0,
    7, 0xFC2F, 0x0641, 0x062E, 0,
    7, 0xFC30, 0x0641, 0x0645, 0,
    7, 0xFC31, 0x0641, 0x0649, 0,
    7, 0xFC32, 0x0641, 0x064A, 0,
    7, 0xFC33, 0x0642, 0x062D, 0,
    7, 0xFC34, 0x0642, 0x0645, 0,
    7, 0xFC35, 0x0642, 0x0649, 0,
    7, 0xFC36, 0x0642, 0x064A, 0,
    7, 0xFC37, 0x0643, 0x0627, 0,
    7, 0xFC38, 0x0643, 0x062C, 0,
    7, 0xFC39, 0x0643, 0x062D, 0,
    7, 0xFC3A, 0x0643, 0x062E, 0,
    7, 0xFC3B, 0x0643, 0x0644, 0,
    7, 0xFC3C, 0x0643, 0x0645, 0,
    7, 0xFC3D, 0x0643, 0x0649, 0,
    7, 0xFC3E, 0x0643, 0x064A, 0,
    7, 0xFC3F, 0x0644, 0x062C, 0,
    7, 0xFC40, 0x0644, 0x062D, 0,
    7, 0xFC41, 0x0644, 0x062E, 0,
    7, 0xFC42, 0x0644, 0x0645, 0,
    7, 0xFC43, 0x0644, 0x0649, 0,
    7, 0xFC44, 0x0644, 0x064A, 0,
    7, 0xFC45, 0x0645, 0x062C, 0,
    7, 0xFC46, 0x0645, 0x062D, 0,
    7, 0xFC47, 0x0645, 0x062E, 0,
    7, 0xFC48, 0x0645, 0x0645, 0,
    7, 0xFC49, 0x0645, 0x0649, 0,
    7, 0xFC4A, 0x0645, 0x064A, 0,
    7, 0xFC4B, 0x0646, 0x062C, 0,
    7, 0xFC4C, 0x0646, 0x062D, 0,
    7, 0xFC4D, 0x0646, 0x062E, 0,
    7, 0xFC4E, 0x0646, 0x0645, 0,
    7, 0xFC4F, 0x0646, 0x0649, 0,
    7, 0xFC50, 0x0646, 0x064A, 0,
    7, 0xFC51, 0x0647, 0x062C, 0,
    7, 0xFC52, 0x0647, 0x0645, 0,
    7, 0xFC53, 0x0647, 0x0649, 0,
    7, 0xFC54, 0x0647, 0x064A, 0,
    7, 0xFC55, 0x064A, 0x062C, 0,
    7, 0xFC56, 0x064A, 0x062D, 0,
    7, 0xFC57, 0x064A, 0x062E, 0,
    7, 0xFC58, 0x064A, 0x0645, 0,
    7, 0xFC59, 0x064A, 0x0649, 0,
    7, 0xFC5A, 0x064A, 0x064A, 0,
    7, 0xFC5B, 0x0630, 0x0670, 0,
    7, 0xFC5C, 0x0631, 0x0670, 0,
    7, 0xFC5D, 0x0649, 0x0670, 0,
    7, 0xFC5E, 0x0020, 0x0651, 0x064C, 0,
    7, 0xFC5F, 0x0020, 0x0651, 0x064D, 0,
    7, 0xFC60, 0x0020, 0x0651, 0x064E, 0,
    7, 0xFC61, 0x0020, 0x0651, 0x064F, 0,
    7, 0xFC62, 0x0020, 0x0651, 0x0650, 0,
    7, 0xFC63, 0x0020, 0x0651, 0x0670, 0,
    6, 0xFC64, 0x0626, 0x0631, 0,
    6, 0xFC65, 0x0626, 0x0632, 0,
    6, 0xFC66, 0x0626, 0x0645, 0,
    6, 0xFC67, 0x0626, 0x0646, 0,
    6, 0xFC68, 0x0626, 0x0649, 0,
    6, 0xFC69, 0x0626, 0x064A, 0,
    6, 0xFC6A, 0x0628, 0x0631, 0,
    6, 0xFC6B, 0x0628, 0x0632, 0,
    6, 0xFC6C, 0x0628, 0x0645, 0,
    6, 0xFC6D, 0x0628, 0x0646, 0,
    6, 0xFC6E, 0x0628, 0x0649, 0,
    6, 0xFC6F, 0x0628, 0x064A, 0,
    6, 0xFC70, 0x062A, 0x0631, 0,
    6, 0xFC71, 0x062A, 0x0632, 0,
    6, 0xFC72, 0x062A, 0x0645, 0,
    6, 0xFC73, 0x062A, 0x0646, 0,
    6, 0xFC74, 0x062A, 0x0649, 0,
    6, 0xFC75, 0x062A, 0x064A, 0,
    6, 0xFC76, 0x062B, 0x0631, 0,
    6, 0xFC77, 0x062B, 0x0632, 0,
    6, 0xFC78, 0x062B, 0x0645, 0,
    6, 0xFC79, 0x062B, 0x0646, 0,
    6, 0xFC7A, 0x062B, 0x0649, 0,
    6, 0xFC7B, 0x062B, 0x064A, 0,
    6, 0xFC7C, 0x0641, 0x0649, 0,
    6, 0xFC7D, 0x0641, 0x064A, 0,
    6, 0xFC7E, 0x0642, 0x0649, 0,
    6, 0xFC7F, 0x0642, 0x064A, 0,
    6, 0xFC80, 0x0643, 0x0627, 0,
    6, 0xFC81, 0x0643, 0x0644, 0,
    6, 0xFC82, 0x0643, 0x0645, 0,
    6, 0xFC83, 0x0643, 0x0649, 0,
    6, 0xFC84, 0x0643, 0x064A, 0,
    6, 0xFC85, 0x0644, 0x0645, 0,
    6, 0xFC86, 0x0644, 0x0649, 0,
    6, 0xFC87, 0x0644, 0x064A, 0,
    6, 0xFC88, 0x0645, 0x0627, 0,
    6, 0xFC89, 0x0645, 0x0645, 0,
    6, 0xFC8A, 0x0646, 0x0631, 0,
    6, 0xFC8B, 0x0646, 0x0632, 0,
    6, 0xFC8C, 0x0646, 0x0645, 0,
    6, 0xFC8D, 0x0646, 0x0646, 0,
    6, 0xFC8E, 0x0646, 0x0649, 0,
    6, 0xFC8F, 0x0646, 0x064A, 0,
    6, 0xFC90, 0x0649, 0x0670, 0,
    6, 0xFC91, 0x064A, 0x0631, 0,
    6, 0xFC92, 0x064A, 0x0632, 0,
    6, 0xFC93, 0x064A, 0x0645, 0,
    6, 0xFC94, 0x064A, 0x0646, 0,
    6, 0xFC95, 0x064A, 0x0649, 0,
    6, 0xFC96, 0x064A, 0x064A, 0,
    4, 0xFC97, 0x0626, 0x062C, 0,
    4, 0xFC98, 0x0626, 0x062D, 0,
    4, 0xFC99, 0x0626, 0x062E, 0,
    4, 0xFC9A, 0x0626, 0x0645, 0,
    4, 0xFC9B, 0x0626, 0x0647, 0,
    4, 0xFC9C, 0x0628, 0x062C, 0,
    4, 0xFC9D, 0x0628, 0x062D, 0,
    4, 0xFC9E, 0x0628, 0x062E, 0,
    4, 0xFC9F, 0x0628, 0x0645, 0,
    4, 0xFCA0, 0x0628, 0x0647, 0,
    4, 0xFCA1, 0x062A, 0x062C, 0,
    4, 0xFCA2, 0x062A, 0x062D, 0,
    4, 0xFCA3, 0x062A, 0x062E, 0,
    4, 0xFCA4, 0x062A, 0x0645, 0,
    4, 0xFCA5, 0x062A, 0x0647, 0,
    4, 0xFCA6, 0x062B, 0x0645, 0,
    4, 0xFCA7, 0x062C, 0x062D, 0,
    4, 0xFCA8, 0x062C, 0x0645, 0,
    4, 0xFCA9, 0x062D, 0x062C, 0,
    4, 0xFCAA, 0x062D, 0x0645, 0,
    4, 0xFCAB, 0x062E, 0x062C, 0,
    4, 0xFCAC, 0x062E, 0x0645, 0,
    4, 0xFCAD, 0x0633, 0x062C, 0,
    4, 0xFCAE, 0x0633, 0x062D, 0,
    4, 0xFCAF, 0x0633, 0x062E, 0,
    4, 0xFCB0, 0x0633, 0x0645, 0,
    4, 0xFCB1, 0x0635, 0x062D, 0,
    4, 0xFCB2, 0x0635, 0x062E, 0,
    4, 0xFCB3, 0x0635, 0x0645, 0,
    4, 0xFCB4, 0x0636, 0x062C, 0,
    4, 0xFCB5, 0x0636, 0x062D, 0,
    4, 0xFCB6, 0x0636, 0x062E, 0,
    4, 0xFCB7, 0x0636, 0x0645, 0,
    4, 0xFCB8, 0x0637, 0x062D, 0,
    4, 0xFCB9, 0x0638, 0x0645, 0,
    4, 0xFCBA, 0x0639, 0x062C, 0,
    4, 0xFCBB, 0x0639, 0x0645, 0,
    4, 0xFCBC, 0x063A, 0x062C, 0,
    4, 0xFCBD, 0x063A, 0x0645, 0,
    4, 0xFCBE, 0x0641, 0x062C, 0,
    4, 0xFCBF, 0x0641, 0x062D, 0,
    4, 0xFCC0, 0x0641, 0x062E, 0,
    4, 0xFCC1, 0x0641, 0x0645, 0,
    4, 0xFCC2, 0x0642, 0x062D, 0,
    4, 0xFCC3, 0x0642, 0x0645, 0,
    4, 0xFCC4, 0x0643, 0x062C, 0,
    4, 0xFCC5, 0x0643, 0x062D, 0,
    4, 0xFCC6, 0x0643, 0x062E, 0,
    4, 0xFCC7, 0x0643, 0x0644, 0,
    4, 0xFCC8, 0x0643, 0x0645, 0,
    4, 0xFCC9, 0x0644, 0x062C, 0,
    4, 0xFCCA, 0x0644, 0x062D, 0,
    4, 0xFCCB, 0x0644, 0x062E, 0,
    4, 0xFCCC, 0x0644, 0x0645, 0,
    4, 0xFCCD, 0x0644, 0x0647, 0,
    4, 0xFCCE, 0x0645, 0x062C, 0,
    4, 0xFCCF, 0x0645, 0x062D, 0,
    4, 0xFCD0, 0x0645, 0x062E, 0,
    4, 0xFCD1, 0x0645, 0x0645, 0,
    4, 0xFCD2, 0x0646, 0x062C, 0,
    4, 0xFCD3, 0x0646, 0x062D, 0,
    4, 0xFCD4, 0x0646, 0x062E, 0,
    4, 0xFCD5, 0x0646, 0x0645, 0,
    4, 0xFCD6, 0x0646, 0x0647, 0,
    4, 0xFCD7, 0x0647, 0x062C, 0,
    4, 0xFCD8, 0x0647, 0x0645, 0,
    4, 0xFCD9, 0x0647, 0x0670, 0,
    4, 0xFCDA, 0x064A, 0x062C, 0,
    4, 0xFCDB, 0x064A, 0x062D, 0,
    4, 0xFCDC, 0x064A, 0x062E, 0,
    4, 0xFCDD, 0x064A, 0x0645, 0,
    4, 0xFCDE, 0x064A, 0x0647, 0,
    5, 0xFCDF, 0x0626, 0x0645, 0,
    5, 0xFCE0, 0x0626, 0x0647, 0,
    5, 0xFCE1, 0x0628, 0x0645, 0,
    5, 0xFCE2, 0x0628, 0x0647, 0,
    5, 0xFCE3, 0x062A, 0x0645, 0,
    5, 0xFCE4, 0x062A, 0x0647, 0,
    5, 0xFCE5, 0x062B, 0x0645, 0,
    5, 0xFCE6, 0x062B, 0x0647, 0,
    5, 0xFCE7, 0x0633, 0x0645, 0,
    5, 0xFCE8, 0x0633, 0x0647, 0,
    5, 0xFCE9, 0x0634, 0x0645, 0,
    5, 0xFCEA, 0x0634, 0x0647, 0,
    5, 0xFCEB, 0x0643, 0x0644, 0,
    5, 0xFCEC, 0x0643, 0x0645, 0,
    5, 0xFCED, 0x0644, 0x0645, 0,
    5, 0xFCEE, 0x0646, 0x0645, 0,
    5, 0xFCEF, 0x0646, 0x0647, 0,
    5, 0xFCF0, 0x064A, 0x0645, 0,
    5, 0xFCF1, 0x064A, 0x0647, 0,
    5, 0xFCF2, 0x0640, 0x0651, 0x064E, 0,
    5, 0xFCF3, 0x0640, 0x0651, 0x064F, 0,
    5, 0xFCF4, 0x0640, 0x0651, 0x0650, 0,
    7, 0xFCF5, 0x0637, 0x0649, 0,
    7, 0xFCF6, 0x0637, 0x064A, 0,
    7, 0xFCF7, 0x0639, 0x0649, 0,
    7, 0xFCF8, 0x0639, 0x064A, 0,
    7, 0xFCF9, 0x063A, 0x0649, 0,
    7, 0xFCFA, 0x063A, 0x064A, 0,
    7, 0xFCFB, 0x0633, 0x0649, 0,
    7, 0xFCFC, 0x0633, 0x064A, 0,
    7, 0xFCFD, 0x0634, 0x0649, 0,
    7, 0xFCFE, 0x0634, 0x064A, 0,
    7, 0xFCFF, 0x062D, 0x0649, 0,
    7, 0xFD00, 0x062D, 0x064A, 0,
    7, 0xFD01, 0x062C, 0x0649, 0,
    7, 0xFD02, 0x062C, 0x064A, 0,
    7, 0xFD03, 0x062E, 0x0649, 0,
    7, 0xFD04, 0x062E, 0x064A, 0,
    7, 0xFD05, 0x0635, 0x0649, 0,
    7, 0xFD06, 0x0635, 0x064A, 0,
    7, 0xFD07, 0x0636, 0x0649, 0,
    7, 0xFD08, 0x0636, 0x064A, 0,
    7, 0xFD09, 0x0634, 0x062C, 0,
    7, 0xFD0A, 0x0634, 0x062D, 0,
    7, 0xFD0B, 0x0634, 0x062E, 0,
    7, 0xFD0C, 0x0634, 0x0645, 0,
    7, 0xFD0D, 0x0634, 0x0631, 0,
    7, 0xFD0E, 0x0633, 0x0631, 0,
    7, 0xFD0F, 0x0635, 0x0631, 0,
    7, 0xFD10, 0x0636, 0x0631, 0,
    6, 0xFD11, 0x0637, 0x0649, 0,
    6, 0xFD12, 0x0637, 0x064A, 0,
    6, 0xFD13, 0x0639, 0x0649, 0,
    6, 0xFD14, 0x0639, 0x064A, 0,
    6, 0xFD15, 0x063A, 0x0649, 0,
    6, 0xFD16, 0x063A, 0x064A, 0,
    6, 0xFD17, 0x0633, 0x0649, 0,
    6, 0xFD18, 0x0633, 0x064A, 0,
    6, 0xFD19, 0x0634, 0x0649, 0,
    6, 0xFD1A, 0x0634, 0x064A, 0,
    6, 0xFD1B, 0x062D, 0x0649, 0,
    6, 0xFD1C, 0x062D, 0x064A, 0,
    6, 0xFD1D, 0x062C, 0x0649, 0,
    6, 0xFD1E, 0x062C, 0x064A, 0,
    6, 0xFD1F, 0x062E, 0x0649, 0,
    6, 0xFD20, 0x062E, 0x064A, 0,
    6, 0xFD21, 0x0635, 0x0649, 0,
    6, 0xFD22, 0x0635, 0x064A, 0,
    6, 0xFD23, 0x0636, 0x0649, 0,
    6, 0xFD24, 0x0636, 0x064A, 0,
    6, 0xFD25, 0x0634, 0x062C, 0,
    6, 0xFD26, 0x0634, 0x062D, 0,
    6, 0xFD27, 0x0634, 0x062E, 0,
    6, 0xFD28, 0x0634, 0x0645, 0,
    6, 0xFD29, 0x0634, 0x0631, 0,
    6, 0xFD2A, 0x0633, 0x0631, 0,
    6, 0xFD2B, 0x0635, 0x0631, 0,
    6, 0xFD2C, 0x0636, 0x0631, 0,
    4, 0xFD2D, 0x0634, 0x062C, 0,
    4, 0xFD2E, 0x0634, 0x062D, 0,
    4, 0xFD2F, 0x0634, 0x062E, 0,
    4, 0xFD30, 0x0634, 0x0645, 0,
    4, 0xFD31, 0x0633, 0x0647, 0,
    4, 0xFD32, 0x0634, 0x0647, 0,
    4, 0xFD33, 0x0637, 0x0645, 0,
    5, 0xFD34, 0x0633, 0x062C, 0,
    5, 0xFD35, 0x0633, 0x062D, 0,
    5, 0xFD36, 0x0633, 0x062E, 0,
    5, 0xFD37, 0x0634, 0x062C, 0,
    5, 0xFD38, 0x0634, 0x062D, 0,
    5, 0xFD39, 0x0634, 0x062E, 0,
    5, 0xFD3A, 0x0637, 0x0645, 0,
    5, 0xFD3B, 0x0638, 0x0645, 0,
    6, 0xFD3C, 0x0627, 0x064B, 0,
    7, 0xFD3D, 0x0627, 0x064B, 0,
    4, 0xFD50, 0x062A, 0x062C, 0x0645, 0,
    6, 0xFD51, 0x062A, 0x062D, 0x062C, 0,
    4, 0xFD52, 0x062A, 0x062D, 0x062C, 0,
    4, 0xFD53, 0x062A, 0x062D, 0x0645, 0,
    4, 0xFD54, 0x062A, 0x062E, 0x0645, 0,
    4, 0xFD55, 0x062A, 0x0645, 0x062C, 0,
    4, 0xFD56, 0x062A, 0x0645, 0x062D, 0,
    4, 0xFD57, 0x062A, 0x0645, 0x062E, 0,
    6, 0xFD58, 0x062C, 0x0645, 0x062D, 0,
    4, 0xFD59, 0x062C, 0x0645, 0x062D, 0,
    6, 0xFD5A, 0x062D, 0x0645, 0x064A, 0,
    6, 0xFD5B, 0x062D, 0x0645, 0x0649, 0,
    4, 0xFD5C, 0x0633, 0x062D, 0x062C, 0,
    4, 0xFD5D, 0x0633, 0x062C, 0x062D, 0,
    6, 0xFD5E, 0x0633, 0x062C, 0x0649, 0,
    6, 0xFD5F, 0x0633, 0x0645, 0x062D, 0,
    4, 0xFD60, 0x0633, 0x0645, 0x062D, 0,
    4, 0xFD61, 0x0633, 0x0645, 0x062C, 0,
    6, 0xFD62, 0x0633, 0x0645, 0x0645, 0,
    4, 0xFD63, 0x0633, 0x0645, 0x0645, 0,
    6, 0xFD64, 0x0635, 0x062D, 0x062D, 0,
    4, 0xFD65, 0x0635, 0x062D, 0x062D, 0,
    6, 0xFD66, 0x0635, 0x0645, 0x0645, 0,
    6, 0xFD67, 0x0634, 0x062D, 0x0645, 0,
    4, 0xFD68, 0x0634, 0x062D, 0x0645, 0,
    6, 0xFD69, 0x0634, 0x062C, 0x064A, 0,
    6, 0xFD6A, 0x0634, 0x0645, 0x062E, 0,
    4, 0xFD6B, 0x0634, 0x0645, 0x062E, 0,
    6, 0xFD6C, 0x0634, 0x0645, 0x0645, 0,
    4, 0xFD6D, 0x0634, 0x0645, 0x0645, 0,
    6, 0xFD6E, 0x0636, 0x062D, 0x0649, 0,
    6, 0xFD6F, 0x0636, 0x062E, 0x0645, 0,
    4, 0xFD70, 0x0636, 0x062E, 0x0645, 0,
    6, 0xFD71, 0x0637, 0x0645, 0x062D, 0,
    4, 0xFD72, 0x0637, 0x0645, 0x062D, 0,
    4, 0xFD73, 0x0637, 0x0645, 0x0645, 0,
    6, 0xFD74, 0x0637, 0x0645, 0x064A, 0,
    6, 0xFD75, 0x0639, 0x062C, 0x0645, 0,
    6, 0xFD76, 0x0639, 0x0645, 0x0645, 0,
    4, 0xFD77, 0x0639, 0x0645, 0x0645, 0,
    6, 0xFD78, 0x0639, 0x0645, 0x0649, 0,
    6, 0xFD79, 0x063A, 0x0645, 0x0645, 0,
    6, 0xFD7A, 0x063A, 0x0645, 0x064A, 0,
    6, 0xFD7B, 0x063A, 0x0645, 0x0649, 0,
    6, 0xFD7C, 0x0641, 0x062E, 0x0645, 0,
    4, 0xFD7D, 0x0641, 0x062E, 0x0645, 0,
    6, 0xFD7E, 0x0642, 0x0645, 0x062D, 0,
    6, 0xFD7F, 0x0642, 0x0645, 0x0645, 0,
    6, 0xFD80, 0x0644, 0x062D, 0x0645, 0,
    6, 0xFD81, 0x0644, 0x062D, 0x064A, 0,
    6, 0xFD82, 0x0644, 0x062D, 0x0649, 0,
    4, 0xFD83, 0x0644, 0x062C, 0x062C, 0,
    6, 0xFD84, 0x0644, 0x062C, 0x062C, 0,
    6, 0xFD85, 0x0644, 0x062E, 0x0645, 0,
    4, 0xFD86, 0x0644, 0x062E, 0x0645, 0,
    6, 0xFD87, 0x0644, 0x0645, 0x062D, 0,
    4, 0xFD88, 0x0644, 0x0645, 0x062D, 0,
    4, 0xFD89, 0x0645, 0x062D, 0x062C, 0,
    4, 0xFD8A, 0x0645, 0x062D, 0x0645, 0,
    6, 0xFD8B, 0x0645, 0x062D, 0x064A, 0,
    4, 0xFD8C, 0x0645, 0x062C, 0x062D, 0,
    4, 0xFD8D, 0x0645, 0x062C, 0x0645, 0,
    4, 0xFD8E, 0x0645, 0x062E, 0x062C, 0,
    4, 0xFD8F, 0x0645, 0x062E, 0x0645, 0,
    4, 0xFD92, 0x0645, 0x062C, 0x062E, 0,
    4, 0xFD93, 0x0647, 0x0645, 0x062C, 0,
    4, 0xFD94, 0x0647, 0x0645, 0x0645, 0,
    4, 0xFD95, 0x0646, 0x062D, 0x0645, 0,
    6, 0xFD96, 0x0646, 0x062D, 0x0649, 0,
    6, 0xFD97, 0x0646, 0x062C, 0x0645, 0,
    4, 0xFD98, 0x0646, 0x062C, 0x0645, 0,
    6, 0xFD99, 0x0646, 0x062C, 0x0649, 0,
    6, 0xFD9A, 0x0646, 0x0645, 0x064A, 0,
    6, 0xFD9B, 0x0646, 0x0645, 0x0649, 0,
    6, 0xFD9C, 0x064A, 0x0645, 0x0645, 0,
    4, 0xFD9D, 0x064A, 0x0645, 0x0645, 0,
    6, 0xFD9E, 0x0628, 0x062E, 0x064A, 0,
    6, 0xFD9F, 0x062A, 0x062C, 0x064A, 0,
    6, 0xFDA0, 0x062A, 0x062C, 0x0649, 0,
    6, 0xFDA1, 0x062A, 0x062E, 0x064A, 0,
    6, 0xFDA2, 0x062A, 0x062E, 0x0649, 0,
    6, 0xFDA3, 0x062A, 0x0645, 0x064A, 0,
    6, 0xFDA4, 0x062A, 0x0645, 0x0649, 0,
    6, 0xFDA5, 0x062C, 0x0645, 0x064A, 0,
    6, 0xFDA6, 0x062C, 0x062D, 0x0649, 0,
    6, 0xFDA7, 0x062C, 0x0645, 0x0649, 0,
    6, 0xFDA8, 0x0633, 0x062E, 0x0649, 0,
    6, 0xFDA9, 0x0635, 0x062D, 0x064A, 0,
    6, 0xFDAA, 0x0634, 0x062D, 0x064A, 0,
    6, 0xFDAB, 0x0636, 0x062D, 0x064A, 0,
    6, 0xFDAC, 0x0644, 0x062C, 0x064A, 0,
    6, 0xFDAD, 0x0644, 0x0645, 0x064A, 0,
    6, 0xFDAE, 0x064A, 0x062D, 0x064A, 0,
    6, 0xFDAF, 0x064A, 0x062C, 0x064A, 0,
    6, 0xFDB0, 0x064A, 0x0645, 0x064A, 0,
    6, 0xFDB1, 0x0645, 0x0645, 0x064A, 0,
    6, 0xFDB2, 0x0642, 0x0645, 0x064A, 0,
    6, 0xFDB3, 0x0646, 0x062D, 0x064A, 0,
    4, 0xFDB4, 0x0642, 0x0645, 0x062D, 0,
    4, 0xFDB5, 0x0644, 0x062D, 0x0645, 0,
    6, 0xFDB6, 0x0639, 0x0645, 0x064A, 0,
    6, 0xFDB7, 0x0643, 0x0645, 0x064A, 0,
    4, 0xFDB8, 0x0646, 0x062C, 0x062D, 0,
    6, 0xFDB9, 0x0645, 0x062E, 0x064A, 0,
    4, 0xFDBA, 0x0644, 0x062C, 0x0645, 0,
    6, 0xFDBB, 0x0643, 0x0645, 0x0645, 0,
    6, 0xFDBC, 0x0644, 0x062C, 0x0645, 0,
    6, 0xFDBD, 0x0646, 0x062C, 0x062D, 0,
    6, 0xFDBE, 0x062C, 0x062D, 0x064A, 0,
    6, 0xFDBF, 0x062D, 0x062C, 0x064A, 0,
    6, 0xFDC0, 0x0645, 0x062C, 0x064A, 0,
    6, 0xFDC1, 0x0641, 0x0645, 0x064A, 0,
    6, 0xFDC2, 0x0628, 0x062D, 0x064A, 0,
    4, 0xFDC3, 0x0643, 0x0645, 0x0645, 0,
    4, 0xFDC4, 0x0639, 0x062C, 0x0645, 0,
    4, 0xFDC5, 0x0635, 0x0645, 0x0645, 0,
    6, 0xFDC6, 0x0633, 0x062E, 0x064A, 0,
    6, 0xFDC7, 0x0646, 0x062C, 0x064A, 0,
    7, 0xFDF0, 0x0635, 0x0644, 0x06D2, 0,
    7, 0xFDF1, 0x0642, 0x0644, 0x06D2, 0,
    7, 0xFDF2, 0x0627, 0x0644, 0x0644, 0x0647, 0,
    7, 0xFDF3, 0x0627, 0x0643, 0x0628, 0x0631, 0,
    7, 0xFDF4, 0x0645, 0x062D, 0x0645, 0x062F, 0,
    7, 0xFDF5, 0x0635, 0x0644, 0x0639, 0x0645, 0,
    7, 0xFDF6, 0x0631, 0x0633, 0x0648, 0x0644, 0,
    7, 0xFDF7, 0x0639, 0x0644, 0x064A, 0x0647, 0,
    7, 0xFDF8, 0x0648, 0x0633, 0x0644, 0x0645, 0,
    7, 0xFDF9, 0x0635, 0x0644, 0x0649, 0,
    7, 0xFDFA, 0x0635, 0x0644, 0x0649, 0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644, 0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645, 0,
    7, 0xFDFB, 0x062C, 0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647, 0,
    11, 0xFE30, 0x2025, 0,
    11, 0xFE31, 0x2014, 0,
    11, 0xFE32, 0x2013, 0,
    11, 0xFE33, 0x005F, 0,
    11, 0xFE34, 0x005F, 0,
    11, 0xFE35, 0x0028, 0,
    11, 0xFE36, 0x0029, 0,
    11, 0xFE37, 0x007B, 0,
    11, 0xFE38, 0x007D, 0,
    11, 0xFE39, 0x3014, 0,
    11, 0xFE3A, 0x3015, 0,
    11, 0xFE3B, 0x3010, 0,
    11, 0xFE3C, 0x3011, 0,
    11, 0xFE3D, 0x300A, 0,
    11, 0xFE3E, 0x300B, 0,
    11, 0xFE3F, 0x3008, 0,
    11, 0xFE40, 0x3009, 0,
    11, 0xFE41, 0x300C, 0,
    11, 0xFE42, 0x300D, 0,
    11, 0xFE43, 0x300E, 0,
    11, 0xFE44, 0x300F, 0,
    16, 0xFE49, 0x203E, 0,
    16, 0xFE4A, 0x203E, 0,
    16, 0xFE4B, 0x203E, 0,
    16, 0xFE4C, 0x203E, 0,
    16, 0xFE4D, 0x005F, 0,
    16, 0xFE4E, 0x005F, 0,
    16, 0xFE4F, 0x005F, 0,
    14, 0xFE50, 0x002C, 0,
    14, 0xFE51, 0x3001, 0,
    14, 0xFE52, 0x002E, 0,
    14, 0xFE54, 0x003B, 0,
    14, 0xFE55, 0x003A, 0,
    14, 0xFE56, 0x003F, 0,
    14, 0xFE57, 0x0021, 0,
    14, 0xFE58, 0x2014, 0,
    14, 0xFE59, 0x0028, 0,
    14, 0xFE5A, 0x0029, 0,
    14, 0xFE5B, 0x007B, 0,
    14, 0xFE5C, 0x007D, 0,
    14, 0xFE5D, 0x3014, 0,
    14, 0xFE5E, 0x3015, 0,
    14, 0xFE5F, 0x0023, 0,
    14, 0xFE60, 0x0026, 0,
    14, 0xFE61, 0x002A, 0,
    14, 0xFE62, 0x002B, 0,
    14, 0xFE63, 0x002D, 0,
    14, 0xFE64, 0x003C, 0,
    14, 0xFE65, 0x003E, 0,
    14, 0xFE66, 0x003D, 0,
    14, 0xFE68, 0x005C, 0,
    14, 0xFE69, 0x0024, 0,
    14, 0xFE6A, 0x0025, 0,
    14, 0xFE6B, 0x0040, 0,
    7, 0xFE70, 0x0020, 0x064B, 0,
    5, 0xFE71, 0x0640, 0x064B, 0,
    7, 0xFE72, 0x0020, 0x064C, 0,
    7, 0xFE74, 0x0020, 0x064D, 0,
    7, 0xFE76, 0x0020, 0x064E, 0,
    5, 0xFE77, 0x0640, 0x064E, 0,
    7, 0xFE78, 0x0020, 0x064F, 0,
    5, 0xFE79, 0x0640, 0x064F, 0,
    7, 0xFE7A, 0x0020, 0x0650, 0,
    5, 0xFE7B, 0x0640, 0x0650, 0,
    7, 0xFE7C, 0x0020, 0x0651, 0,
    5, 0xFE7D, 0x0640, 0x0651, 0,
    7, 0xFE7E, 0x0020, 0x0652, 0,
    5, 0xFE7F, 0x0640, 0x0652, 0,
    7, 0xFE80, 0x0621, 0,
    7, 0xFE81, 0x0622, 0,
    6, 0xFE82, 0x0622, 0,
    7, 0xFE83, 0x0623, 0,
    6, 0xFE84, 0x0623, 0,
    7, 0xFE85, 0x0624, 0,
    6, 0xFE86, 0x0624, 0,
    7, 0xFE87, 0x0625, 0,
    6, 0xFE88, 0x0625, 0,
    7, 0xFE89, 0x0626, 0,
    6, 0xFE8A, 0x0626, 0,
    4, 0xFE8B, 0x0626, 0,
    5, 0xFE8C, 0x0626, 0,
    7, 0xFE8D, 0x0627, 0,
    6, 0xFE8E, 0x0627, 0,
    7, 0xFE8F, 0x0628, 0,
    6, 0xFE90, 0x0628, 0,
    4, 0xFE91, 0x0628, 0,
    5, 0xFE92, 0x0628, 0,
    7, 0xFE93, 0x0629, 0,
    6, 0xFE94, 0x0629, 0,
    7, 0xFE95, 0x062A, 0,
    6, 0xFE96, 0x062A, 0,
    4, 0xFE97, 0x062A, 0,
    5, 0xFE98, 0x062A, 0,
    7, 0xFE99, 0x062B, 0,
    6, 0xFE9A, 0x062B, 0,
    4, 0xFE9B, 0x062B, 0,
    5, 0xFE9C, 0x062B, 0,
    7, 0xFE9D, 0x062C, 0,
    6, 0xFE9E, 0x062C, 0,
    4, 0xFE9F, 0x062C, 0,
    5, 0xFEA0, 0x062C, 0,
    7, 0xFEA1, 0x062D, 0,
    6, 0xFEA2, 0x062D, 0,
    4, 0xFEA3, 0x062D, 0,
    5, 0xFEA4, 0x062D, 0,
    7, 0xFEA5, 0x062E, 0,
    6, 0xFEA6, 0x062E, 0,
    4, 0xFEA7, 0x062E, 0,
    5, 0xFEA8, 0x062E, 0,
    7, 0xFEA9, 0x062F, 0,
    6, 0xFEAA, 0x062F, 0,
    7, 0xFEAB, 0x0630, 0,
    6, 0xFEAC, 0x0630, 0,
    7, 0xFEAD, 0x0631, 0,
    6, 0xFEAE, 0x0631, 0,
    7, 0xFEAF, 0x0632, 0,
    6, 0xFEB0, 0x0632, 0,
    7, 0xFEB1, 0x0633, 0,
    6, 0xFEB2, 0x0633, 0,
    4, 0xFEB3, 0x0633, 0,
    5, 0xFEB4, 0x0633, 0,
    7, 0xFEB5, 0x0634, 0,
    6, 0xFEB6, 0x0634, 0,
    4, 0xFEB7, 0x0634, 0,
    5, 0xFEB8, 0x0634, 0,
    7, 0xFEB9, 0x0635, 0,
    6, 0xFEBA, 0x0635, 0,
    4, 0xFEBB, 0x0635, 0,
    5, 0xFEBC, 0x0635, 0,
    7, 0xFEBD, 0x0636, 0,
    6, 0xFEBE, 0x0636, 0,
    4, 0xFEBF, 0x0636, 0,
    5, 0xFEC0, 0x0636, 0,
    7, 0xFEC1, 0x0637, 0,
    6, 0xFEC2, 0x0637, 0,
    4, 0xFEC3, 0x0637, 0,
    5, 0xFEC4, 0x0637, 0,
    7, 0xFEC5, 0x0638, 0,
    6, 0xFEC6, 0x0638, 0,
    4, 0xFEC7, 0x0638, 0,
    5, 0xFEC8, 0x0638, 0,
    7, 0xFEC9, 0x0639, 0,
    6, 0xFECA, 0x0639, 0,
    4, 0xFECB, 0x0639, 0,
    5, 0xFECC, 0x0639, 0,
    7, 0xFECD, 0x063A, 0,
    6, 0xFECE, 0x063A, 0,
    4, 0xFECF, 0x063A, 0,
    5, 0xFED0, 0x063A, 0,
    7, 0xFED1, 0x0641, 0,
    6, 0xFED2, 0x0641, 0,
    4, 0xFED3, 0x0641, 0,
    5, 0xFED4, 0x0641, 0,
    7, 0xFED5, 0x0642, 0,
    6, 0xFED6, 0x0642, 0,
    4, 0xFED7, 0x0642, 0,
    5, 0xFED8, 0x0642, 0,
    7, 0xFED9, 0x0643, 0,
    6, 0xFEDA, 0x0643, 0,
    4, 0xFEDB, 0x0643, 0,
    5, 0xFEDC, 0x0643, 0,
    7, 0xFEDD, 0x0644, 0,
    6, 0xFEDE, 0x0644, 0,
    4, 0xFEDF, 0x0644, 0,
    5, 0xFEE0, 0x0644, 0,
    7, 0xFEE1, 0x0645, 0,
    6, 0xFEE2, 0x0645, 0,
    4, 0xFEE3, 0x0645, 0,
    5, 0xFEE4, 0x0645, 0,
    7, 0xFEE5, 0x0646, 0,
    6, 0xFEE6, 0x0646, 0,
    4, 0xFEE7, 0x0646, 0,
    5, 0xFEE8, 0x0646, 0,
    7, 0xFEE9, 0x0647, 0,
    6, 0xFEEA, 0x0647, 0,
    4, 0xFEEB, 0x0647, 0,
    5, 0xFEEC, 0x0647, 0,
    7, 0xFEED, 0x0648, 0,
    6, 0xFEEE, 0x0648, 0,
    7, 0xFEEF, 0x0649, 0,
    6, 0xFEF0, 0x0649, 0,
    7, 0xFEF1, 0x064A, 0,
    6, 0xFEF2, 0x064A, 0,
    4, 0xFEF3, 0x064A, 0,
    5, 0xFEF4, 0x064A, 0,
    7, 0xFEF5, 0x0644, 0x0622, 0,
    6, 0xFEF6, 0x0644, 0x0622, 0,
    7, 0xFEF7, 0x0644, 0x0623, 0,
    6, 0xFEF8, 0x0644, 0x0623, 0,
    7, 0xFEF9, 0x0644, 0x0625, 0,
    6, 0xFEFA, 0x0644, 0x0625, 0,
    7, 0xFEFB, 0x0644, 0x0627, 0,
    6, 0xFEFC, 0x0644, 0x0627, 0,
    12, 0xFF01, 0x0021, 0,
    12, 0xFF02, 0x0022, 0,
    12, 0xFF03, 0x0023, 0,
    12, 0xFF04, 0x0024, 0,
    12, 0xFF05, 0x0025, 0,
    12, 0xFF06, 0x0026, 0,
    12, 0xFF07, 0x0027, 0,
    12, 0xFF08, 0x0028, 0,
    12, 0xFF09, 0x0029, 0,
    12, 0xFF0A, 0x002A, 0,
    12, 0xFF0B, 0x002B, 0,
    12, 0xFF0C, 0x002C, 0,
    12, 0xFF0D, 0x002D, 0,
    12, 0xFF0E, 0x002E, 0,
    12, 0xFF0F, 0x002F, 0,
    12, 0xFF10, 0x0030, 0,
    12, 0xFF11, 0x0031, 0,
    12, 0xFF12, 0x0032, 0,
    12, 0xFF13, 0x0033, 0,
    12, 0xFF14, 0x0034, 0,
    12, 0xFF15, 0x0035, 0,
    12, 0xFF16, 0x0036, 0,
    12, 0xFF17, 0x0037, 0,
    12, 0xFF18, 0x0038, 0,
    12, 0xFF19, 0x0039, 0,
    12, 0xFF1A, 0x003A, 0,
    12, 0xFF1B, 0x003B, 0,
    12, 0xFF1C, 0x003C, 0,
    12, 0xFF1D, 0x003D, 0,
    12, 0xFF1E, 0x003E, 0,
    12, 0xFF1F, 0x003F, 0,
    12, 0xFF20, 0x0040, 0,
    12, 0xFF21, 0x0041, 0,
    12, 0xFF22, 0x0042, 0,
    12, 0xFF23, 0x0043, 0,
    12, 0xFF24, 0x0044, 0,
    12, 0xFF25, 0x0045, 0,
    12, 0xFF26, 0x0046, 0,
    12, 0xFF27, 0x0047, 0,
    12, 0xFF28, 0x0048, 0,
    12, 0xFF29, 0x0049, 0,
    12, 0xFF2A, 0x004A, 0,
    12, 0xFF2B, 0x004B, 0,
    12, 0xFF2C, 0x004C, 0,
    12, 0xFF2D, 0x004D, 0,
    12, 0xFF2E, 0x004E, 0,
    12, 0xFF2F, 0x004F, 0,
    12, 0xFF30, 0x0050, 0,
    12, 0xFF31, 0x0051, 0,
    12, 0xFF32, 0x0052, 0,
    12, 0xFF33, 0x0053, 0,
    12, 0xFF34, 0x0054, 0,
    12, 0xFF35, 0x0055, 0,
    12, 0xFF36, 0x0056, 0,
    12, 0xFF37, 0x0057, 0,
    12, 0xFF38, 0x0058, 0,
    12, 0xFF39, 0x0059, 0,
    12, 0xFF3A, 0x005A, 0,
    12, 0xFF3B, 0x005B, 0,
    12, 0xFF3C, 0x005C, 0,
    12, 0xFF3D, 0x005D, 0,
    12, 0xFF3E, 0x005E, 0,
    12, 0xFF3F, 0x005F, 0,
    12, 0xFF40, 0x0060, 0,
    12, 0xFF41, 0x0061, 0,
    12, 0xFF42, 0x0062, 0,
    12, 0xFF43, 0x0063, 0,
    12, 0xFF44, 0x0064, 0,
    12, 0xFF45, 0x0065, 0,
    12, 0xFF46, 0x0066, 0,
    12, 0xFF47, 0x0067, 0,
    12, 0xFF48, 0x0068, 0,
    12, 0xFF49, 0x0069, 0,
    12, 0xFF4A, 0x006A, 0,
    12, 0xFF4B, 0x006B, 0,
    12, 0xFF4C, 0x006C, 0,
    12, 0xFF4D, 0x006D, 0,
    12, 0xFF4E, 0x006E, 0,
    12, 0xFF4F, 0x006F, 0,
    12, 0xFF50, 0x0070, 0,
    12, 0xFF51, 0x0071, 0,
    12, 0xFF52, 0x0072, 0,
    12, 0xFF53, 0x0073, 0,
    12, 0xFF54, 0x0074, 0,
    12, 0xFF55, 0x0075, 0,
    12, 0xFF56, 0x0076, 0,
    12, 0xFF57, 0x0077, 0,
    12, 0xFF58, 0x0078, 0,
    12, 0xFF59, 0x0079, 0,
    12, 0xFF5A, 0x007A, 0,
    12, 0xFF5B, 0x007B, 0,
    12, 0xFF5C, 0x007C, 0,
    12, 0xFF5D, 0x007D, 0,
    12, 0xFF5E, 0x007E, 0,
    13, 0xFF61, 0x3002, 0,
    13, 0xFF62, 0x300C, 0,
    13, 0xFF63, 0x300D, 0,
    13, 0xFF64, 0x3001, 0,
    13, 0xFF65, 0x30FB, 0,
    13, 0xFF66, 0x30F2, 0,
    13, 0xFF67, 0x30A1, 0,
    13, 0xFF68, 0x30A3, 0,
    13, 0xFF69, 0x30A5, 0,
    13, 0xFF6A, 0x30A7, 0,
    13, 0xFF6B, 0x30A9, 0,
    13, 0xFF6C, 0x30E3, 0,
    13, 0xFF6D, 0x30E5, 0,
    13, 0xFF6E, 0x30E7, 0,
    13, 0xFF6F, 0x30C3, 0,
    13, 0xFF70, 0x30FC, 0,
    13, 0xFF71, 0x30A2, 0,
    13, 0xFF72, 0x30A4, 0,
    13, 0xFF73, 0x30A6, 0,
    13, 0xFF74, 0x30A8, 0,
    13, 0xFF75, 0x30AA, 0,
    13, 0xFF76, 0x30AB, 0,
    13, 0xFF77, 0x30AD, 0,
    13, 0xFF78, 0x30AF, 0,
    13, 0xFF79, 0x30B1, 0,
    13, 0xFF7A, 0x30B3, 0,
    13, 0xFF7B, 0x30B5, 0,
    13, 0xFF7C, 0x30B7, 0,
    13, 0xFF7D, 0x30B9, 0,
    13, 0xFF7E, 0x30BB, 0,
    13, 0xFF7F, 0x30BD, 0,
    13, 0xFF80, 0x30BF, 0,
    13, 0xFF81, 0x30C1, 0,
    13, 0xFF82, 0x30C4, 0,
    13, 0xFF83, 0x30C6, 0,
    13, 0xFF84, 0x30C8, 0,
    13, 0xFF85, 0x30CA, 0,
    13, 0xFF86, 0x30CB, 0,
    13, 0xFF87, 0x30CC, 0,
    13, 0xFF88, 0x30CD, 0,
    13, 0xFF89, 0x30CE, 0,
    13, 0xFF8A, 0x30CF, 0,
    13, 0xFF8B, 0x30D2, 0,
    13, 0xFF8C, 0x30D5, 0,
    13, 0xFF8D, 0x30D8, 0,
    13, 0xFF8E, 0x30DB, 0,
    13, 0xFF8F, 0x30DE, 0,
    13, 0xFF90, 0x30DF, 0,
    13, 0xFF91, 0x30E0, 0,
    13, 0xFF92, 0x30E1, 0,
    13, 0xFF93, 0x30E2, 0,
    13, 0xFF94, 0x30E4, 0,
    13, 0xFF95, 0x30E6, 0,
    13, 0xFF96, 0x30E8, 0,
    13, 0xFF97, 0x30E9, 0,
    13, 0xFF98, 0x30EA, 0,
    13, 0xFF99, 0x30EB, 0,
    13, 0xFF9A, 0x30EC, 0,
    13, 0xFF9B, 0x30ED, 0,
    13, 0xFF9C, 0x30EF, 0,
    13, 0xFF9D, 0x30F3, 0,
    13, 0xFF9E, 0x3099, 0,
    13, 0xFF9F, 0x309A, 0,
    13, 0xFFA0, 0x3164, 0,
    13, 0xFFA1, 0x3131, 0,
    13, 0xFFA2, 0x3132, 0,
    13, 0xFFA3, 0x3133, 0,
    13, 0xFFA4, 0x3134, 0,
    13, 0xFFA5, 0x3135, 0,
    13, 0xFFA6, 0x3136, 0,
    13, 0xFFA7, 0x3137, 0,
    13, 0xFFA8, 0x3138, 0,
    13, 0xFFA9, 0x3139, 0,
    13, 0xFFAA, 0x313A, 0,
    13, 0xFFAB, 0x313B, 0,
    13, 0xFFAC, 0x313C, 0,
    13, 0xFFAD, 0x313D, 0,
    13, 0xFFAE, 0x313E, 0,
    13, 0xFFAF, 0x313F, 0,
    13, 0xFFB0, 0x3140, 0,
    13, 0xFFB1, 0x3141, 0,
    13, 0xFFB2, 0x3142, 0,
    13, 0xFFB3, 0x3143, 0,
    13, 0xFFB4, 0x3144, 0,
    13, 0xFFB5, 0x3145, 0,
    13, 0xFFB6, 0x3146, 0,
    13, 0xFFB7, 0x3147, 0,
    13, 0xFFB8, 0x3148, 0,
    13, 0xFFB9, 0x3149, 0,
    13, 0xFFBA, 0x314A, 0,
    13, 0xFFBB, 0x314B, 0,
    13, 0xFFBC, 0x314C, 0,
    13, 0xFFBD, 0x314D, 0,
    13, 0xFFBE, 0x314E, 0,
    13, 0xFFC2, 0x314F, 0,
    13, 0xFFC3, 0x3150, 0,
    13, 0xFFC4, 0x3151, 0,
    13, 0xFFC5, 0x3152, 0,
    13, 0xFFC6, 0x3153, 0,
    13, 0xFFC7, 0x3154, 0,
    13, 0xFFCA, 0x3155, 0,
    13, 0xFFCB, 0x3156, 0,
    13, 0xFFCC, 0x3157, 0,
    13, 0xFFCD, 0x3158, 0,
    13, 0xFFCE, 0x3159, 0,
    13, 0xFFCF, 0x315A, 0,
    13, 0xFFD2, 0x315B, 0,
    13, 0xFFD3, 0x315C, 0,
    13, 0xFFD4, 0x315D, 0,
    13, 0xFFD5, 0x315E, 0,
    13, 0xFFD6, 0x315F, 0,
    13, 0xFFD7, 0x3160, 0,
    13, 0xFFDA, 0x3161, 0,
    13, 0xFFDB, 0x3162, 0,
    13, 0xFFDC, 0x3163, 0,
    12, 0xFFE0, 0x00A2, 0,
    12, 0xFFE1, 0x00A3, 0,
    12, 0xFFE2, 0x00AC, 0,
    12, 0xFFE3, 0x00AF, 0,
    12, 0xFFE4, 0x00A6, 0,
    12, 0xFFE5, 0x00A5, 0,
    12, 0xFFE6, 0x20A9, 0,
    13, 0xFFE8, 0x2502, 0,
    13, 0xFFE9, 0x2190, 0,
    13, 0xFFEA, 0x2191, 0,
    13, 0xFFEB, 0x2192, 0,
    13, 0xFFEC, 0x2193, 0,
    13, 0xFFED, 0x25A0, 0,
    13, 0xFFEE, 0x25CB, 0,

};

static const Q_UINT16 di_00[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 6,
    11, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    16, 0, 0, 0, 0, 0, 0, 0,
    20, 0, 25, 0, 0, 0, 0, 29,
    0, 0, 34, 38, 42, 47, 0, 0,
    51, 56, 60, 0, 64, 70, 76, 0,
    82, 87, 92, 97, 102, 107, 0, 112,
    117, 122, 127, 132, 137, 142, 147, 152,
    0, 157, 162, 167, 172, 177, 182, 0,
    0, 187, 192, 197, 202, 207, 0, 0,
    212, 217, 222, 227, 232, 237, 0, 242,
    247, 252, 257, 262, 267, 272, 277, 282,
    0, 287, 292, 297, 302, 307, 312, 0,
    0, 317, 322, 327, 332, 337, 0, 342,
};

static const Q_UINT16 di_01[] = {
    347, 352, 357, 362, 367, 372, 377, 382,
    387, 392, 397, 402, 407, 412, 417, 422,
    0, 0, 427, 432, 437, 442, 447, 452,
    457, 462, 467, 472, 477, 482, 487, 492,
    497, 502, 507, 512, 517, 522, 0, 0,
    527, 532, 537, 542, 547, 552, 557, 562,
    567, 0, 572, 577, 582, 587, 592, 597,
    0, 602, 607, 612, 617, 622, 627, 632,
    637, 0, 0, 642, 647, 652, 657, 662,
    667, 672, 0, 0, 677, 682, 687, 692,
    697, 702, 0, 0, 707, 712, 717, 722,
    727, 732, 737, 742, 747, 752, 757, 762,
    767, 772, 777, 782, 787, 792, 0, 0,
    797, 802, 807, 812, 817, 822, 827, 832,
    837, 842, 847, 852, 857, 862, 867, 872,
    877, 882, 887, 892, 897, 902, 907, 912,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    916, 921, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 926,
    931, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 936, 941, 946, 951,
    956, 961, 966, 971, 976, 981, 986, 991,
    996, 1001, 1006, 1011, 1016, 1021, 1026, 1031,
    1036, 1041, 1046, 1051, 1056, 0, 1061, 1066,
    1071, 1077, 1083, 1088, 0, 0, 1093, 1098,
    1103, 1108, 1113, 1118, 1123, 1128, 1133, 1138,
    1143, 1148, 1153, 1158, 1163, 1168, 0, 0,
    0, 0, 1173, 1178, 1183, 1188, 1193, 1198,
};

static const Q_UINT16 di_02[] = {
    1203, 1208, 1213, 1218, 1223, 1228, 1233, 1238,
    1243, 1248, 1253, 1258, 1263, 1268, 1273, 1278,
    1283, 1288, 1293, 1298, 1303, 1308, 1313, 1318,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1323, 1327, 1331, 1335, 1339, 1343, 1347, 1351,
    1355, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1359, 1364, 1369, 1374, 1379, 1384, 0, 0,
    1389, 1393, 1397, 1401, 1405, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_03[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1409, 1413, 0, 1417, 1421, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1426, 0, 0, 0,
    0, 0, 1430, 0, 0, 0, 1435, 0,
    0, 0, 0, 0, 1439, 1444, 1449, 1454,
    1458, 1463, 1468, 0, 1473, 0, 1478, 1483,
    1488, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1493, 1498, 1503, 1508, 1513, 1518,
    1523, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1528, 1533, 1538, 1543, 1548, 0,
    0, 0, 0, 1553, 1558, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_04[] = {
    0, 1563, 0, 1568, 0, 0, 0, 1573,
    0, 0, 0, 0, 1578, 0, 1583, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1588, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1593, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1598, 0, 1603, 0, 0, 0, 1608,
    0, 0, 0, 0, 1613, 0, 1618, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1623, 1628,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1633, 1638, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1643, 1648, 1653, 1658, 0, 0, 1663, 1668,
    0, 0, 1673, 1678, 1683, 1688, 1693, 1698,
    0, 0, 1703, 1708, 1713, 1718, 1723, 1728,
    0, 0, 1733, 1738, 0, 0, 1743, 1748,
    1753, 1758, 1763, 1768, 1773, 1778, 0, 0,
    1783, 1788, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_05[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1793,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_06[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_09[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1798, 0, 0, 0, 0, 0, 0,
    0, 1803, 0, 0, 1808, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1813, 1818, 1823, 1828, 1833, 1838, 1843, 1848,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1853, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1858, 1863, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1868, 1873, 0, 1878,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0A[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1883, 1888, 1893, 1898, 0, 1903, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0B[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1908, 0, 0, 1913, 1918, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1923, 1928, 0, 1933,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1938, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1943, 1948, 1953, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0C[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1958, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1963, 0, 0, 0, 0, 0, 0, 1968,
    1973, 0, 1978, 1983, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0D[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1988, 1993, 1998, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2003, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2008, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2013, 2018, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_0F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2023, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2028, 0, 0,
    0, 0, 2033, 0, 0, 0, 0, 2038,
    0, 0, 0, 0, 2043, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2048, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2053, 0, 2058, 2063, 2068,
    2073, 2078, 0, 0, 0, 0, 0, 0,
    0, 2083, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2088, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2093, 0, 0,
    0, 0, 2098, 0, 0, 0, 0, 2103,
    0, 0, 0, 0, 2108, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2113, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_11[] = {
    0, 2118, 0, 0, 2123, 0, 0, 0,
    2128, 0, 2133, 0, 0, 2138, 0, 0,
    0, 0, 0, 2143, 2148, 2153, 2158, 2163,
    2168, 2173, 2178, 2183, 2188, 2193, 2198, 2203,
    2208, 2213, 2218, 2224, 2230, 2236, 2242, 2248,
    2253, 2258, 2263, 2268, 2273, 2279, 2284, 2289,
    2294, 2299, 2304, 2309, 2315, 2321, 2326, 2331,
    2336, 2341, 2346, 2351, 0, 2356, 0, 2361,
    0, 2366, 2371, 2376, 2381, 2386, 2391, 2396,
    2401, 2406, 2411, 2416, 0, 2421, 0, 2426,
    0, 2431, 2436, 2441, 0, 0, 2446, 2451,
    2456, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2461, 0, 2466, 0, 2471, 0,
    2476, 0, 2481, 2486, 2492, 0, 0, 2497,
    2502, 2508, 0, 0, 2513, 0, 2518, 2523,
    2528, 2533, 2538, 2543, 2548, 2553, 2558, 2563,
    2568, 2573, 2578, 2583, 2588, 2593, 2598, 2603,
    2608, 2613, 2618, 2623, 2629, 2634, 2639, 2644,
    2649, 2654, 2659, 2664, 2669, 2674, 2679, 2684,
    2689, 2694, 2699, 2704, 2709, 2714, 0, 2719,
    2724, 2729, 2734, 0, 0, 0, 0, 0,
    0, 2739, 2744, 0, 2749, 2754, 0, 0,
    2759, 2764, 2769, 2774, 2779, 2784, 2789, 0,
    0, 2794, 0, 2799, 0, 0, 0, 0,
    0, 0, 0, 2804, 2809, 2815, 2820, 2825,
    2830, 2835, 2840, 2845, 2850, 2856, 2861, 2866,
    2872, 2877, 2883, 2889, 2895, 2901, 2907, 2913,
    2918, 2923, 2928, 2933, 2938, 2943, 2948, 2954,
    2959, 2964, 2969, 2974, 2979, 2984, 2989, 2994,
    2999, 3004, 3009, 0, 3014, 3019, 3025, 3030,
    0, 3035, 3040, 3045, 3050, 3055, 3060, 3065,
    3070, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_1E[] = {
    3075, 3080, 3085, 3090, 3095, 3100, 3105, 3110,
    3115, 3120, 3125, 3130, 3135, 3140, 3145, 3150,
    3155, 3160, 3165, 3170, 3175, 3180, 3185, 3190,
    3195, 3200, 3205, 3210, 3215, 3220, 3225, 3230,
    3235, 3240, 3245, 3250, 3255, 3260, 3265, 3270,
    3275, 3280, 3285, 3290, 3295, 3300, 3305, 3310,
    3315, 3320, 3325, 3330, 3335, 3340, 3345, 3350,
    3355, 3360, 3365, 3370, 3375, 3380, 3385, 3390,
    3395, 3400, 3405, 3410, 3415, 3420, 3425, 3430,
    3435, 3440, 3445, 3450, 3455, 3460, 3465, 3470,
    3475, 3480, 3485, 3490, 3495, 3500, 3505, 3510,
    3515, 3520, 3525, 3530, 3535, 3540, 3545, 3550,
    3555, 3560, 3565, 3570, 3575, 3580, 3585, 3590,
    3595, 3600, 3605, 3610, 3615, 3620, 3625, 3630,
    3635, 3640, 3645, 3650, 3655, 3660, 3665, 3670,
    3675, 3680, 3685, 3690, 3695, 3700, 3705, 3710,
    3715, 3720, 3725, 3730, 3735, 3740, 3745, 3750,
    3755, 3760, 3765, 3770, 3775, 3780, 3785, 3790,
    3795, 3800, 3805, 3810, 3815, 3820, 3825, 3830,
    3835, 3840, 3845, 3850, 0, 0, 0, 0,
    3855, 3860, 3865, 3870, 3875, 3880, 3885, 3890,
    3895, 3900, 3905, 3910, 3915, 3920, 3925, 3930,
    3935, 3940, 3945, 3950, 3955, 3960, 3965, 3970,
    3975, 3980, 3985, 3990, 3995, 4000, 4005, 4010,
    4015, 4020, 4025, 4030, 4035, 4040, 4045, 4050,
    4055, 4060, 4065, 4070, 4075, 4080, 4085, 4090,
    4095, 4100, 4105, 4110, 4115, 4120, 4125, 4130,
    4135, 4140, 4145, 4150, 4155, 4160, 4165, 4170,
    4175, 4180, 4185, 4190, 4195, 4200, 4205, 4210,
    4215, 4220, 4225, 4230, 4235, 4240, 4245, 4250,
    4255, 4260, 4265, 4270, 4275, 4280, 4285, 4290,
    4295, 4300, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_1F[] = {
    4305, 4310, 4315, 4320, 4325, 4330, 4335, 4340,
    4345, 4350, 4355, 4360, 4365, 4370, 4375, 4380,
    4385, 4390, 4395, 4400, 4405, 4410, 0, 0,
    4415, 4420, 4425, 4430, 4435, 4440, 0, 0,
    4445, 4450, 4455, 4460, 4465, 4470, 4475, 4480,
    4485, 4490, 4495, 4500, 4505, 4510, 4515, 4520,
    4525, 4530, 4535, 4540, 4545, 4550, 4555, 4560,
    4565, 4570, 4575, 4580, 4585, 4590, 4595, 4600,
    4605, 4610, 4615, 4620, 4625, 4630, 0, 0,
    4635, 4640, 4645, 4650, 4655, 4660, 0, 0,
    4665, 4670, 4675, 4680, 4685, 4690, 4695, 4700,
    0, 4705, 0, 4710, 0, 4715, 0, 4720,
    4725, 4730, 4735, 4740, 4745, 4750, 4755, 4760,
    4765, 4770, 4775, 4780, 4785, 4790, 4795, 4800,
    4805, 4810, 4814, 4819, 4823, 4828, 4832, 4837,
    4841, 4846, 4850, 4855, 4859, 4864, 0, 0,
    4868, 4873, 4878, 4883, 4888, 4893, 4898, 4903,
    4908, 4913, 4918, 4923, 4928, 4933, 4938, 4943,
    4948, 4953, 4958, 4963, 4968, 4973, 4978, 4983,
    4988, 4993, 4998, 5003, 5008, 5013, 5018, 5023,
    5028, 5033, 5038, 5043, 5048, 5053, 5058, 5063,
    5068, 5073, 5078, 5083, 5088, 5093, 5098, 5103,
    5108, 5113, 5118, 5123, 5128, 0, 5133, 5138,
    5143, 5148, 5153, 5158, 5162, 5167, 5172, 5176,
    5181, 5186, 5191, 5196, 5201, 0, 5206, 5211,
    5216, 5221, 5225, 5230, 5234, 5239, 5244, 5249,
    5254, 5259, 5264, 5269, 0, 0, 5273, 5278,
    5283, 5288, 5293, 5298, 0, 5302, 5307, 5312,
    5317, 5322, 5327, 5332, 5336, 5341, 5346, 5351,
    5356, 5361, 5366, 5371, 5375, 5380, 5385, 5389,
    0, 0, 5393, 5398, 5403, 0, 5408, 5413,
    5418, 5423, 5427, 5432, 5436, 5441, 5445, 0,
};

static const Q_UINT16 di_20[] = {
    5450, 5454, 5458, 5462, 5466, 5470, 5474, 5478,
    5482, 5486, 5490, 0, 0, 0, 0, 0,
    0, 5494, 0, 0, 0, 0, 0, 5498,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 5503, 5507, 5512, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 5518, 5523, 0, 5529, 5534,
    0, 0, 0, 0, 5540, 0, 5545, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5550, 0, 0, 0, 5554, 5558, 5562, 5566,
    5570, 5574, 5578, 5582, 5586, 5590, 5594, 5598,
    5602, 5606, 5610, 5614, 5618, 5622, 5626, 5630,
    5634, 5638, 5642, 5646, 5650, 5654, 5658, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5662, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_21[] = {
    5667, 5673, 5679, 5683, 0, 5688, 5694, 5700,
    0, 5704, 5709, 5713, 5717, 5721, 5725, 5729,
    5733, 5737, 5741, 5745, 0, 5749, 5753, 0,
    0, 5758, 5762, 5766, 5770, 5774, 0, 0,
    5778, 5783, 5789, 0, 5794, 0, 5798, 0,
    5802, 0, 5806, 5810, 5814, 5818, 0, 5822,
    5826, 5830, 0, 5834, 5838, 5842, 5846, 5850,
    5854, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 5858, 5864, 5870, 5876, 5882,
    5888, 5894, 5900, 5906, 5912, 5918, 5924, 5930,
    5935, 5939, 5944, 5950, 5955, 5959, 5964, 5970,
    5977, 5982, 5986, 5991, 5997, 6001, 6005, 6009,
    6013, 6017, 6022, 6028, 6033, 6037, 6042, 6048,
    6055, 6060, 6064, 6069, 6075, 6079, 6083, 6087,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_22[] = {
    0, 0, 0, 0, 6091, 0, 0, 0,
    0, 6096, 0, 0, 6101, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6106, 0, 6111, 0,
    0, 0, 0, 0, 6116, 6121, 0, 6127,
    6132, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6138, 0, 0, 6143, 0, 0, 6148,
    0, 6153, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6158, 0, 6163, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 6168, 6173, 6178,
    6183, 6188, 0, 0, 6193, 6198, 0, 0,
    6203, 6208, 0, 0, 0, 0, 0, 0,
    6213, 6218, 0, 0, 6223, 6228, 0, 0,
    6233, 6238, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6243, 6248, 6253, 6258,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6263, 6268, 6273, 6278, 0, 0, 0, 0,
    0, 0, 6283, 6288, 6293, 6298, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_23[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6303, 6307, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_24[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    6311, 6315, 6319, 6323, 6327, 6331, 6335, 6339,
    6343, 6347, 6352, 6357, 6362, 6367, 6372, 6377,
    6382, 6387, 6392, 6397, 6402, 6408, 6414, 6420,
    6426, 6432, 6438, 6444, 6450, 6456, 6463, 6470,
    6477, 6484, 6491, 6498, 6505, 6512, 6519, 6526,
    6533, 6538, 6543, 6548, 6553, 6558, 6563, 6568,
    6573, 6578, 6584, 6590, 6596, 6602, 6608, 6614,
    6620, 6626, 6632, 6638, 6644, 6650, 6656, 6662,
    6668, 6674, 6680, 6686, 6692, 6698, 6704, 6710,
    6716, 6722, 6728, 6734, 6740, 6746, 6752, 6758,
    6764, 6770, 6776, 6782, 6788, 6794, 6800, 6804,
    6808, 6812, 6816, 6820, 6824, 6828, 6832, 6836,
    6840, 6844, 6848, 6852, 6856, 6860, 6864, 6868,
    6872, 6876, 6880, 6884, 6888, 6892, 6896, 6900,
    6904, 6908, 6912, 6916, 6920, 6924, 6928, 6932,
    6936, 6940, 6944, 6948, 6952, 6956, 6960, 6964,
    6968, 6972, 6976, 6980, 6984, 6988, 6992, 6996,
    7000, 7004, 7008, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_30[] = {
    7012, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 7016, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7020, 0, 7025, 0,
    7030, 0, 7035, 0, 7040, 0, 7045, 0,
    7050, 0, 7055, 0, 7060, 0, 7065, 0,
    7070, 0, 7075, 0, 0, 7080, 0, 7085,
    0, 7090, 0, 0, 0, 0, 0, 0,
    7095, 7100, 0, 7105, 7110, 0, 7115, 7120,
    0, 7125, 7130, 0, 7135, 7140, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7145, 0, 0, 0,
    0, 0, 0, 7150, 7155, 0, 7160, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7165, 0, 7170, 0,
    7175, 0, 7180, 0, 7185, 0, 7190, 0,
    7195, 0, 7200, 0, 7205, 0, 7210, 0,
    7215, 0, 7220, 0, 0, 7225, 0, 7230,
    0, 7235, 0, 0, 0, 0, 0, 0,
    7240, 7245, 0, 7250, 7255, 0, 7260, 7265,
    0, 7270, 7275, 0, 7280, 7285, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7290, 0, 0, 7295,
    7300, 7305, 7310, 0, 0, 0, 7315, 0,
};

static const Q_UINT16 di_31[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7320, 7324, 7328, 7332, 7336, 7340, 7344,
    7348, 7352, 7356, 7360, 7364, 7368, 7372, 7376,
    7380, 7384, 7388, 7392, 7396, 7400, 7404, 7408,
    7412, 7416, 7420, 7424, 7428, 7432, 7436, 7440,
    7444, 7448, 7452, 7456, 7460, 7464, 7468, 7472,
    7476, 7480, 7484, 7488, 7492, 7496, 7500, 7504,
    7508, 7512, 7516, 7520, 7524, 7528, 7532, 7536,
    7540, 7544, 7548, 7552, 7556, 7560, 7564, 7568,
    7572, 7576, 7580, 7584, 7588, 7592, 7596, 7600,
    7604, 7608, 7612, 7616, 7620, 7624, 7628, 7632,
    7636, 7640, 7644, 7648, 7652, 7656, 7660, 7664,
    7668, 7672, 7676, 7680, 7684, 7688, 7692, 0,
    0, 0, 7696, 7700, 7704, 7708, 7712, 7716,
    7720, 7724, 7728, 7732, 7736, 7740, 7744, 7748,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_32[] = {
    7752, 7758, 7764, 7770, 7776, 7782, 7788, 7794,
    7800, 7806, 7812, 7818, 7824, 7830, 7836, 7843,
    7850, 7857, 7864, 7871, 7878, 7885, 7892, 7899,
    7906, 7913, 7920, 7927, 7934, 0, 0, 0,
    7941, 7947, 7953, 7959, 7965, 7971, 7977, 7983,
    7989, 7995, 8001, 8007, 8013, 8019, 8025, 8031,
    8037, 8043, 8049, 8055, 8061, 8067, 8073, 8079,
    8085, 8091, 8097, 8103, 8109, 8115, 8121, 8127,
    8133, 8139, 8145, 8151, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    8157, 8161, 8165, 8169, 8173, 8177, 8181, 8185,
    8189, 8193, 8197, 8201, 8205, 8209, 8213, 8218,
    8223, 8228, 8233, 8238, 8243, 8248, 8253, 8258,
    8263, 8268, 8273, 8278, 0, 0, 0, 0,
    8283, 8287, 8291, 8295, 8299, 8303, 8307, 8311,
    8315, 8319, 8323, 8327, 8331, 8335, 8339, 8343,
    8347, 8351, 8355, 8359, 8363, 8367, 8371, 8375,
    8379, 8383, 8387, 8391, 8395, 8399, 8403, 8407,
    8411, 8415, 8419, 8423, 8427, 8431, 8435, 8439,
    8443, 8447, 8451, 8455, 8459, 8463, 8467, 8471,
    8475, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    8479, 8484, 8489, 8494, 8499, 8504, 8509, 8514,
    8519, 8524, 8530, 8536, 0, 0, 0, 0,
    8542, 8546, 8550, 8554, 8558, 8562, 8566, 8570,
    8574, 8578, 8582, 8586, 8590, 8594, 8598, 8602,
    8606, 8610, 8614, 8618, 8622, 8626, 8630, 8634,
    8638, 8642, 8646, 8650, 8654, 8658, 8662, 8666,
    8670, 8674, 8678, 8682, 8686, 8690, 8694, 8698,
    8702, 8706, 8710, 8714, 8718, 8722, 8726, 0,
};

static const Q_UINT16 di_33[] = {
    8730, 8737, 8744, 8751, 8757, 8764, 8770, 8776,
    8784, 8791, 8797, 8803, 8809, 8816, 8823, 8829,
    8835, 8840, 8846, 8853, 8860, 8865, 8873, 8882,
    8890, 8896, 8904, 8912, 8919, 8925, 8931, 8937,
    8944, 8952, 8959, 8965, 8971, 8977, 8982, 8987,
    8992, 8997, 9003, 9009, 9017, 9023, 9030, 9038,
    9044, 9049, 9054, 9062, 9069, 9077, 9083, 9091,
    9096, 9102, 9108, 9114, 9120, 9126, 9133, 9139,
    9144, 9150, 9156, 9162, 9169, 9175, 9181, 9187,
    9195, 9202, 9207, 9215, 9220, 9227, 9234, 9240,
    9246, 9252, 9259, 9264, 9270, 9277, 9282, 9290,
    9296, 9301, 9306, 9311, 9316, 9321, 9326, 9331,
    9336, 9341, 9346, 9352, 9358, 9364, 9370, 9376,
    9382, 9388, 9394, 9400, 9406, 9412, 9418, 9424,
    9430, 9436, 9442, 9447, 9452, 9458, 9463, 0,
    0, 0, 0, 9468, 9473, 9478, 9483, 9488,
    9495, 9500, 9505, 9510, 9515, 9520, 9525, 9530,
    9535, 9541, 9548, 9553, 9558, 9563, 9568, 9573,
    9578, 9583, 9589, 9595, 9601, 9607, 9612, 9617,
    9622, 9627, 9632, 9637, 9642, 9647, 9652, 9657,
    9663, 9669, 9674, 9680, 9686, 9692, 9697, 9703,
    9709, 9716, 9721, 9727, 9733, 9739, 9745, 9753,
    9762, 9767, 9772, 9777, 9782, 9787, 9792, 9797,
    9802, 9807, 9812, 9817, 9822, 9827, 9832, 9837,
    9842, 9847, 9852, 9859, 9864, 9869, 9874, 9881,
    9887, 9892, 9897, 9902, 9907, 9912, 9917, 9922,
    9927, 9932, 9937, 9943, 9948, 9953, 9959, 9965,
    9970, 9977, 9983, 9988, 9993, 9998, 0, 0,
    10003, 10008, 10013, 10018, 10023, 10028, 10033, 10038,
    10043, 10048, 10054, 10060, 10066, 10072, 10078, 10084,
    10090, 10096, 10102, 10108, 10114, 10120, 10126, 10132,
    10138, 10144, 10150, 10156, 10162, 10168, 10174, 0,
};

static const Q_UINT16 di_F9[] = {
    10180, 10184, 10188, 10192, 10196, 10200, 10204, 10208,
    10212, 10216, 10220, 10224, 10228, 10232, 10236, 10240,
    10244, 10248, 10252, 10256, 10260, 10264, 10268, 10272,
    10276, 10280, 10284, 10288, 10292, 10296, 10300, 10304,
    10308, 10312, 10316, 10320, 10324, 10328, 10332, 10336,
    10340, 10344, 10348, 10352, 10356, 10360, 10364, 10368,
    10372, 10376, 10380, 10384, 10388, 10392, 10396, 10400,
    10404, 10408, 10412, 10416, 10420, 10424, 10428, 10432,
    10436, 10440, 10444, 10448, 10452, 10456, 10460, 10464,
    10468, 10472, 10476, 10480, 10484, 10488, 10492, 10496,
    10500, 10504, 10508, 10512, 10516, 10520, 10524, 10528,
    10532, 10536, 10540, 10544, 10548, 10552, 10556, 10560,
    10564, 10568, 10572, 10576, 10580, 10584, 10588, 10592,
    10596, 10600, 10604, 10608, 10612, 10616, 10620, 10624,
    10628, 10632, 10636, 10640, 10644, 10648, 10652, 10656,
    10660, 10664, 10668, 10672, 10676, 10680, 10684, 10688,
    10692, 10696, 10700, 10704, 10708, 10712, 10716, 10720,
    10724, 10728, 10732, 10736, 10740, 10744, 10748, 10752,
    10756, 10760, 10764, 10768, 10772, 10776, 10780, 10784,
    10788, 10792, 10796, 10800, 10804, 10808, 10812, 10816,
    10820, 10824, 10828, 10832, 10836, 10840, 10844, 10848,
    10852, 10856, 10860, 10864, 10868, 10872, 10876, 10880,
    10884, 10888, 10892, 10896, 10900, 10904, 10908, 10912,
    10916, 10920, 10924, 10928, 10932, 10936, 10940, 10944,
    10948, 10952, 10956, 10960, 10964, 10968, 10972, 10976,
    10980, 10984, 10988, 10992, 10996, 11000, 11004, 11008,
    11012, 11016, 11020, 11024, 11028, 11032, 11036, 11040,
    11044, 11048, 11052, 11056, 11060, 11064, 11068, 11072,
    11076, 11080, 11084, 11088, 11092, 11096, 11100, 11104,
    11108, 11112, 11116, 11120, 11124, 11128, 11132, 11136,
    11140, 11144, 11148, 11152, 11156, 11160, 11164, 11168,
    11172, 11176, 11180, 11184, 11188, 11192, 11196, 11200,
};

static const Q_UINT16 di_FA[] = {
    11204, 11208, 11212, 11216, 11220, 11224, 11228, 11232,
    11236, 11240, 11244, 11248, 11252, 11256, 0, 0,
    11260, 0, 11264, 0, 0, 11268, 11272, 11276,
    11280, 11284, 11288, 11292, 11296, 11300, 11304, 0,
    11308, 0, 11312, 0, 0, 11316, 11320, 0,
    0, 0, 11324, 11328, 11332, 11336, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 di_FB[] = {
    11340, 11345, 11350, 11355, 11361, 11367, 11372, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 11377, 11382, 11387, 11392, 11397,
    0, 0, 0, 0, 0, 0, 0, 11402,
    11407, 11411, 11415, 11419, 11423, 11427, 11431, 11435,
    11439, 11443, 11447, 11452, 11457, 11462, 11467, 11472,
    11477, 11482, 11487, 11492, 11497, 11502, 11507, 0,
    11512, 11517, 11522, 11527, 11532, 0, 11537, 0,
    11542, 11547, 0, 11552, 11557, 0, 11562, 11567,
    11572, 11577, 11582, 11587, 11592, 11597, 11602, 11607,
    11612, 11616, 11620, 11624, 11628, 11632, 11636, 11640,
    11644, 11648, 11652, 11656, 11660, 11664, 11668, 11672,
    11676, 11680, 11684, 11688, 11692, 11696, 11700, 11704,
    11708, 11712, 11716, 11720, 11724, 11728, 11732, 11736,
    11740, 11744, 11748, 11752, 11756, 11760, 11764, 11768,
    11772, 11776, 11780, 11784, 11788, 11792, 11796, 11800,
    11804, 11808, 11812, 11816, 11820, 11824, 11828, 11832,
    11836, 11840, 11844, 11848, 11852, 11856, 11860, 11864,
    11868, 11872, 11876, 11880, 11884, 11888, 11892, 11896,
    11900, 11904, 11908, 11912, 11916, 11920, 11924, 11928,
    11932, 11936, 11940, 11944, 11948, 11952, 11956, 11960,
    11964, 11968, 11972, 11976, 11980, 11984, 11988, 11992,
    11996, 12000, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 12004, 12008, 12012, 12016, 12020,
    12024, 12028, 12032, 12036, 12040, 12044, 12048, 12052,
    12056, 12060, 12064, 12068, 12072, 12076, 12080, 12084,
    12088, 12092, 12096, 12101, 12106, 12111, 12116, 12121,
    12126, 12131, 12136, 12141, 12146, 12151, 12156, 12161,
    12166, 12171, 12176, 12181, 12186, 12190, 12194, 12198,
};

static const Q_UINT16 di_FC[] = {
    12202, 12207, 12212, 12217, 12222, 12227, 12232, 12237,
    12242, 12247, 12252, 12257, 12262, 12267, 12272, 12277,
    12282, 12287, 12292, 12297, 12302, 12307, 12312, 12317,
    12322, 12327, 12332, 12337, 12342, 12347, 12352, 12357,
    12362, 12367, 12372, 12377, 12382, 12387, 12392, 12397,
    12402, 12407, 12412, 12417, 12422, 12427, 12432, 12437,
    12442, 12447, 12452, 12457, 12462, 12467, 12472, 12477,
    12482, 12487, 12492, 12497, 12502, 12507, 12512, 12517,
    12522, 12527, 12532, 12537, 12542, 12547, 12552, 12557,
    12562, 12567, 12572, 12577, 12582, 12587, 12592, 12597,
    12602, 12607, 12612, 12617, 12622, 12627, 12632, 12637,
    12642, 12647, 12652, 12657, 12662, 12667, 12672, 12678,
    12684, 12690, 12696, 12702, 12708, 12713, 12718, 12723,
    12728, 12733, 12738, 12743, 12748, 12753, 12758, 12763,
    12768, 12773, 12778, 12783, 12788, 12793, 12798, 12803,
    12808, 12813, 12818, 12823, 12828, 12833, 12838, 12843,
    12848, 12853, 12858, 12863, 12868, 12873, 12878, 12883,
    12888, 12893, 12898, 12903, 12908, 12913, 12918, 12923,
    12928, 12933, 12938, 12943, 12948, 12953, 12958, 12963,
    12968, 12973, 12978, 12983, 12988, 12993, 12998, 13003,
    13008, 13013, 13018, 13023, 13028, 13033, 13038, 13043,
    13048, 13053, 13058, 13063, 13068, 13073, 13078, 13083,
    13088, 13093, 13098, 13103, 13108, 13113, 13118, 13123,
    13128, 13133, 13138, 13143, 13148, 13153, 13158, 13163,
    13168, 13173, 13178, 13183, 13188, 13193, 13198, 13203,
    13208, 13213, 13218, 13223, 13228, 13233, 13238, 13243,
    13248, 13253, 13258, 13263, 13268, 13273, 13278, 13283,
    13288, 13293, 13298, 13303, 13308, 13313, 13318, 13323,
    13328, 13333, 13338, 13343, 13348, 13353, 13358, 13363,
    13368, 13373, 13378, 13383, 13388, 13393, 13398, 13403,
    13408, 13413, 13418, 13424, 13430, 13436, 13441, 13446,
    13451, 13456, 13461, 13466, 13471, 13476, 13481, 13486,
};

static const Q_UINT16 di_FD[] = {
    13491, 13496, 13501, 13506, 13511, 13516, 13521, 13526,
    13531, 13536, 13541, 13546, 13551, 13556, 13561, 13566,
    13571, 13576, 13581, 13586, 13591, 13596, 13601, 13606,
    13611, 13616, 13621, 13626, 13631, 13636, 13641, 13646,
    13651, 13656, 13661, 13666, 13671, 13676, 13681, 13686,
    13691, 13696, 13701, 13706, 13711, 13716, 13721, 13726,
    13731, 13736, 13741, 13746, 13751, 13756, 13761, 13766,
    13771, 13776, 13781, 13786, 13791, 13796, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    13801, 13807, 13813, 13819, 13825, 13831, 13837, 13843,
    13849, 13855, 13861, 13867, 13873, 13879, 13885, 13891,
    13897, 13903, 13909, 13915, 13921, 13927, 13933, 13939,
    13945, 13951, 13957, 13963, 13969, 13975, 13981, 13987,
    13993, 13999, 14005, 14011, 14017, 14023, 14029, 14035,
    14041, 14047, 14053, 14059, 14065, 14071, 14077, 14083,
    14089, 14095, 14101, 14107, 14113, 14119, 14125, 14131,
    14137, 14143, 14149, 14155, 14161, 14167, 14173, 14179,
    0, 0, 14185, 14191, 14197, 14203, 14209, 14215,
    14221, 14227, 14233, 14239, 14245, 14251, 14257, 14263,
    14269, 14275, 14281, 14287, 14293, 14299, 14305, 14311,
    14317, 14323, 14329, 14335, 14341, 14347, 14353, 14359,
    14365, 14371, 14377, 14383, 14389, 14395, 14401, 14407,
    14413, 14419, 14425, 14431, 14437, 14443, 14449, 14455,
    14461, 14467, 14473, 14479, 14485, 14491, 14497, 14503,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    14509, 14515, 14521, 14528, 14535, 14542, 14549, 14556,
    14563, 14570, 14576, 14597, 0, 0, 0, 0,
};

static const Q_UINT16 di_FE[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    14608, 14612, 14616, 14620, 14624, 14628, 14632, 14636,
    14640, 14644, 14648, 14652, 14656, 14660, 14664, 14668,
    14672, 14676, 14680, 14684, 14688, 0, 0, 0,
    0, 14692, 14696, 14700, 14704, 14708, 14712, 14716,
    14720, 14724, 14728, 0, 14732, 14736, 14740, 14744,
    14748, 14752, 14756, 14760, 14764, 14768, 14772, 14776,
    14780, 14784, 14788, 14792, 14796, 14800, 14804, 0,
    14808, 14812, 14816, 14820, 0, 0, 0, 0,
    14824, 14829, 14834, 0, 14839, 0, 14844, 14849,
    14854, 14859, 14864, 14869, 14874, 14879, 14884, 14889,
    14894, 14898, 14902, 14906, 14910, 14914, 14918, 14922,
    14926, 14930, 14934, 14938, 14942, 14946, 14950, 14954,
    14958, 14962, 14966, 14970, 14974, 14978, 14982, 14986,
    14990, 14994, 14998, 15002, 15006, 15010, 15014, 15018,
    15022, 15026, 15030, 15034, 15038, 15042, 15046, 15050,
    15054, 15058, 15062, 15066, 15070, 15074, 15078, 15082,
    15086, 15090, 15094, 15098, 15102, 15106, 15110, 15114,
    15118, 15122, 15126, 15130, 15134, 15138, 15142, 15146,
    15150, 15154, 15158, 15162, 15166, 15170, 15174, 15178,
    15182, 15186, 15190, 15194, 15198, 15202, 15206, 15210,
    15214, 15218, 15222, 15226, 15230, 15234, 15238, 15242,
    15246, 15250, 15254, 15258, 15262, 15266, 15270, 15274,
    15278, 15282, 15286, 15290, 15294, 15298, 15302, 15306,
    15310, 15314, 15318, 15322, 15326, 15330, 15334, 15338,
    15342, 15346, 15350, 15354, 15358, 15362, 15367, 15372,
    15377, 15382, 15387, 15392, 15397, 0, 0, 0,
};

static const Q_UINT16 di_FF[] = {
    0, 15402, 15406, 15410, 15414, 15418, 15422, 15426,
    15430, 15434, 15438, 15442, 15446, 15450, 15454, 15458,
    15462, 15466, 15470, 15474, 15478, 15482, 15486, 15490,
    15494, 15498, 15502, 15506, 15510, 15514, 15518, 15522,
    15526, 15530, 15534, 15538, 15542, 15546, 15550, 15554,
    15558, 15562, 15566, 15570, 15574, 15578, 15582, 15586,
    15590, 15594, 15598, 15602, 15606, 15610, 15614, 15618,
    15622, 15626, 15630, 15634, 15638, 15642, 15646, 15650,
    15654, 15658, 15662, 15666, 15670, 15674, 15678, 15682,
    15686, 15690, 15694, 15698, 15702, 15706, 15710, 15714,
    15718, 15722, 15726, 15730, 15734, 15738, 15742, 15746,
    15750, 15754, 15758, 15762, 15766, 15770, 15774, 0,
    0, 15778, 15782, 15786, 15790, 15794, 15798, 15802,
    15806, 15810, 15814, 15818, 15822, 15826, 15830, 15834,
    15838, 15842, 15846, 15850, 15854, 15858, 15862, 15866,
    15870, 15874, 15878, 15882, 15886, 15890, 15894, 15898,
    15902, 15906, 15910, 15914, 15918, 15922, 15926, 15930,
    15934, 15938, 15942, 15946, 15950, 15954, 15958, 15962,
    15966, 15970, 15974, 15978, 15982, 15986, 15990, 15994,
    15998, 16002, 16006, 16010, 16014, 16018, 16022, 16026,
    16030, 16034, 16038, 16042, 16046, 16050, 16054, 16058,
    16062, 16066, 16070, 16074, 16078, 16082, 16086, 16090,
    16094, 16098, 16102, 16106, 16110, 16114, 16118, 16122,
    16126, 16130, 16134, 16138, 16142, 16146, 16150, 0,
    0, 0, 16154, 16158, 16162, 16166, 16170, 16174,
    0, 0, 16178, 16182, 16186, 16190, 16194, 16198,
    0, 0, 16202, 16206, 16210, 16214, 16218, 16222,
    0, 0, 16226, 16230, 16234, 0, 0, 0,
    16238, 16242, 16246, 16250, 16254, 16258, 16262, 0,
    16266, 16270, 16274, 16278, 16282, 16286, 16290, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 *decomposition_info [256] = {
    di_00, di_01, di_02, di_03, di_04, di_05, di_06, di_06,
    di_06, di_09, di_0A, di_0B, di_0C, di_0D, di_0E, di_0F,
    di_06, di_11, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_1E, di_1F,
    di_20, di_21, di_22, di_23, di_24, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_30, di_31, di_32, di_33, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_F9, di_FA, di_FB, di_FC, di_FD, di_FE, di_FF,
};
// 63050 bytes

static const Q_UINT16 ligature_map [] = {
    0,
    12672, 12678, 12684, 12690, 12696, 12702, 14824, 14834, 14839, 14844, 14854, 14864, 14874, 14884, 0,
    6173, 0,
    6158, 0,
    6178, 0,
    1071, 87, 92, 97, 102, 107, 347, 357, 367, 981, 82, 1203, 1213, 3075, 3855, 3865, 0,
    3085, 3095, 3105, 0,
    112, 377, 387, 397, 407, 0,
    417, 3125, 3135, 3145, 3155, 3165, 0,
    117, 122, 127, 132, 427, 437, 447, 457, 467, 1223, 1233, 3195, 3205, 3975, 3985, 3995, 0,
    3225, 0,
    477, 487, 497, 507, 1093, 1163, 3235, 0,
    517, 3245, 3255, 3265, 3275, 3285, 0,
    137, 142, 147, 152, 527, 537, 547, 557, 567, 991, 1243, 1253, 3295, 4055, 4065, 0,
    582, 0,
    592, 1103, 3315, 3325, 3335, 0,
    602, 612, 622, 3345, 3365, 3375, 0,
    3385, 3395, 3405, 0,
    157, 642, 652, 662, 3415, 3425, 3435, 3445, 0,
    162, 167, 172, 177, 182, 677, 687, 697, 916, 1001, 1113, 1263, 1273, 4075, 4085, 0,
    3495, 3505, 0,
    707, 717, 727, 1283, 1293, 3515, 3525, 3545, 0,
    737, 747, 757, 767, 3555, 3565, 0,
    777, 787, 3605, 3615, 3625, 3635, 0,
    187, 192, 197, 202, 797, 807, 817, 827, 837, 847, 926, 1011, 1303, 1313, 3645, 3655, 3665, 4195, 4205, 0,
    3695, 3705, 0,
    857, 3715, 3725, 3735, 3745, 3755, 0,
    3765, 3775, 0,
    207, 867, 877, 3785, 4265, 4275, 4285, 4295, 0,
    882, 892, 902, 3795, 3805, 3815, 0,
    1077, 217, 222, 227, 232, 237, 352, 362, 372, 986, 212, 1208, 1218, 3080, 3860, 3870, 0,
    3090, 3100, 3110, 0,
    242, 382, 392, 402, 412, 0,
    422, 3130, 3140, 3150, 3160, 3170, 0,
    247, 252, 257, 262, 432, 442, 452, 462, 472, 1228, 1238, 3200, 3210, 3980, 3990, 4000, 0,
    3230, 0,
    482, 492, 502, 512, 1098, 1168, 3240, 0,
    522, 3250, 3260, 3270, 3280, 3290, 3825, 0,
    267, 272, 277, 282, 532, 542, 552, 562, 996, 1248, 1258, 3300, 4060, 4070, 0,
    587, 1143, 0,
    597, 1108, 3320, 3330, 3340, 0,
    607, 617, 627, 3350, 3370, 3380, 0,
    3390, 3400, 3410, 0,
    287, 647, 657, 667, 3420, 3430, 3440, 3450, 0,
    292, 297, 302, 307, 312, 682, 692, 702, 921, 1006, 1118, 1268, 1278, 4080, 4090, 0,
    3500, 3510, 0,
    712, 722, 732, 1288, 1298, 3520, 3530, 3550, 0,
    742, 752, 762, 772, 3560, 3570, 0,
    782, 792, 3610, 3620, 3630, 3640, 3830, 0,
    317, 322, 327, 332, 802, 812, 822, 832, 842, 852, 931, 1016, 1308, 1318, 3650, 3660, 3670, 4200, 4210, 0,
    3700, 3710, 0,
    862, 3720, 3730, 3740, 3750, 3760, 3835, 0,
    3770, 3780, 0,
    337, 342, 872, 3790, 3840, 4270, 4280, 4290, 4300, 0,
    887, 897, 907, 3800, 3810, 3820, 0,
    6138, 0,
    1444, 5186, 5380, 0,
    3875, 3885, 3895, 3905, 3915, 0,
    1061, 0,
    1173, 0,
    1083, 1183, 0,
    3115, 0,
    4005, 4015, 4025, 4035, 4045, 0,
    3305, 0,
    4095, 4105, 4115, 4125, 4135, 0,
    3455, 3465, 0,
    1193, 0,
    1021, 1031, 1041, 1051, 0,
    3880, 3890, 3900, 3910, 3920, 0,
    1066, 0,
    1178, 0,
    1088, 1188, 0,
    3120, 0,
    4010, 4020, 4030, 4040, 4050, 0,
    3310, 0,
    4100, 4110, 4120, 4130, 4140, 0,
    3460, 3470, 0,
    1198, 0,
    1026, 1036, 1046, 1056, 0,
    3925, 3935, 3945, 3955, 3965, 0,
    3930, 3940, 3950, 3960, 3970, 0,
    3175, 3185, 0,
    3180, 3190, 0,
    3215, 0,
    3220, 0,
    3475, 3485, 0,
    3480, 3490, 0,
    3575, 0,
    3580, 0,
    3585, 0,
    3590, 0,
    3675, 0,
    3680, 0,
    3685, 0,
    3690, 0,
    3850, 0,
    4145, 4155, 4165, 4175, 4185, 0,
    4150, 4160, 4170, 4180, 4190, 0,
    4215, 4225, 4235, 4245, 4255, 0,
    4220, 4230, 4240, 4250, 4260, 0,
    1133, 0,
    1123, 0,
    1128, 0,
    1138, 0,
    1421, 0,
    1449, 4345, 4350, 5143, 5148, 5153, 5162, 0,
    1458, 4415, 4420, 5216, 0,
    1463, 4485, 4490, 5225, 5234, 0,
    1468, 1493, 4565, 4570, 5283, 5288, 5293, 0,
    1473, 4635, 4640, 5418, 0,
    5375, 0,
    1478, 1498, 4705, 5356, 5361, 5366, 0,
    1483, 4765, 4770, 5427, 5436, 0,
    5128, 0,
    5201, 0,
    1503, 4305, 4310, 4805, 5108, 5113, 5123, 5133, 0,
    1508, 4385, 4390, 4814, 0,
    1513, 4445, 4450, 4823, 5196, 5206, 0,
    1518, 1528, 4525, 4530, 4832, 5254, 5259, 5273, 0,
    1538, 4605, 4610, 4841, 0,
    5336, 5341, 0,
    1533, 1543, 4665, 4670, 4850, 5317, 5322, 5346, 0,
    1548, 4725, 4730, 4859, 5398, 5408, 0,
    1488, 5264, 5278, 0,
    1523, 5327, 5351, 0,
    5403, 0,
    1553, 1558, 0,
    1573, 0,
    1643, 1653, 0,
    1568, 0,
    1563, 1663, 0,
    1633, 1683, 0,
    1693, 0,
    1588, 1703, 1713, 0,
    1578, 0,
    1723, 0,
    1583, 1743, 1753, 1763, 0,
    1773, 0,
    1783, 0,
    1648, 1658, 0,
    1603, 0,
    1598, 1668, 0,
    1638, 1688, 0,
    1698, 0,
    1593, 1708, 1718, 0,
    1613, 0,
    1728, 0,
    1618, 1748, 1758, 1768, 0,
    1778, 0,
    1788, 0,
    1608, 0,
    1623, 0,
    1628, 0,
    1673, 0,
    1678, 0,
    1733, 0,
    1738, 0,
    11467, 11472, 11477, 0,
    11482, 11592, 0,
    11487, 0,
    11492, 0,
    11497, 0,
    11502, 11587, 0,
    11507, 0,
    11512, 0,
    11517, 0,
    11522, 0,
    11527, 11597, 0,
    11532, 0,
    11537, 0,
    11542, 0,
    11547, 0,
    11552, 0,
    11557, 11602, 0,
    11562, 0,
    11567, 0,
    11572, 0,
    11447, 11452, 11577, 0,
    11582, 0,
    11402, 0,
    14894, 0,
    14898, 14902, 0,
    14906, 14910, 0,
    14914, 14918, 0,
    14922, 14926, 0,
    12096, 12101, 12106, 12111, 12116, 12121, 12126, 12131, 12136, 12141, 12146, 12151, 12156, 12161, 12166, 12171, 12176, 12181, 12202, 12207, 12212, 12217, 12222, 12708, 12713, 12718, 12723, 12728, 12733, 12963, 12968, 12973, 12978, 12983, 13323, 13328, 14930, 14934, 14938, 14942, 0,
    14521, 14528, 13791, 13796, 14946, 14950, 0,
    14257, 14473, 12237, 12242, 12247, 12252, 12738, 12743, 12748, 12753, 12758, 12763, 12988, 12993, 12998, 13003, 13008, 13333, 13338, 12227, 12232, 14954, 14958, 14962, 14966, 0,
    14970, 14974, 0,
    13801, 13807, 13813, 13819, 13825, 13831, 13837, 13843, 14263, 14269, 14275, 14281, 14287, 14293, 13018, 13023, 13028, 13033, 13348, 13343, 12257, 12262, 12267, 12272, 12277, 12282, 12768, 12773, 12778, 12783, 12788, 12793, 13013, 14978, 14982, 14986, 14990, 0,
    12287, 12292, 12297, 12302, 12798, 12803, 12808, 12813, 12818, 12823, 13038, 13353, 13358, 14994, 14998, 15002, 15006, 0,
    14597, 14449, 13849, 13855, 14299, 14305, 14311, 12307, 12312, 13043, 13048, 13496, 13501, 13636, 13641, 15010, 15014, 15018, 15022, 0,
    13861, 13867, 14455, 13053, 13058, 13486, 13491, 13631, 13626, 12317, 12322, 15026, 15030, 15034, 15038, 0,
    12327, 12332, 12337, 13063, 13068, 13506, 13511, 13646, 13651, 15042, 15046, 15050, 15054, 0,
    15058, 15062, 0,
    12657, 15066, 15070, 0,
    14549, 12662, 15074, 15078, 0,
    15082, 15086, 0,
    13873, 13879, 13885, 13891, 13897, 13903, 13909, 13915, 14317, 14497, 13466, 13471, 13561, 13606, 13611, 13701, 13736, 13751, 13756, 13761, 12342, 12347, 12352, 12357, 13073, 13078, 13083, 13088, 13363, 13368, 15090, 15094, 15098, 15102, 0,
    13939, 13945, 13951, 13957, 13963, 13969, 13975, 14329, 13556, 13616, 13621, 13676, 13681, 13686, 13691, 13696, 13716, 13721, 13726, 13731, 13741, 13766, 13771, 13776, 13373, 13378, 13476, 13481, 13536, 13541, 13546, 13551, 15106, 15110, 15114, 15118, 0,
    14576, 14542, 14570, 13927, 13921, 13933, 14323, 14491, 14509, 12362, 12367, 13093, 13098, 13103, 13516, 13521, 13566, 13661, 13706, 13656, 15122, 15126, 15130, 15134, 0,
    13981, 13987, 13993, 14335, 13108, 13113, 13118, 13123, 13526, 13531, 13571, 13666, 13671, 13711, 12372, 12377, 12382, 12387, 15138, 15142, 15146, 15150, 0,
    13999, 14005, 14011, 14017, 13436, 13441, 13576, 13581, 13781, 13746, 12392, 12397, 13128, 15154, 15158, 15162, 15166, 0,
    12402, 13133, 13786, 15170, 15174, 15178, 15182, 0,
    14556, 14485, 14023, 14029, 14035, 14041, 14401, 12407, 12412, 13138, 13143, 13446, 13451, 13586, 13591, 15186, 15190, 15194, 15198, 0,
    14047, 14053, 14059, 13148, 13153, 13456, 13461, 13601, 13596, 12417, 12422, 15202, 15206, 15210, 15214, 0,
    13418, 13424, 13430, 14829, 14849, 14859, 14869, 14879, 14889, 0,
    14065, 14071, 14467, 12442, 12447, 12452, 12828, 12833, 13158, 13163, 13168, 13173, 12427, 12432, 12437, 15218, 15222, 15226, 15230, 0,
    14389, 14515, 14083, 14077, 14377, 12457, 12462, 12467, 12472, 12838, 12843, 13178, 13183, 15234, 15238, 15242, 15246, 0,
    14407, 14431, 14479, 12492, 12497, 12502, 12507, 12512, 12848, 12853, 12858, 12863, 12868, 13188, 13193, 13198, 13203, 13208, 13383, 13388, 12477, 12482, 12487, 15250, 15254, 15258, 15262, 0,
    14437, 14089, 14095, 14101, 14107, 14113, 14119, 14125, 14131, 14137, 14341, 14347, 14395, 14425, 12517, 12522, 12527, 12532, 12537, 12542, 12873, 12878, 12883, 13213, 13218, 13223, 13228, 13233, 13393, 15362, 15367, 15372, 15377, 15382, 15387, 15392, 15397, 15266, 15270, 15274, 15278, 0,
    14535, 14143, 14149, 14155, 14161, 14167, 14173, 14179, 14185, 14371, 14419, 14461, 12547, 12552, 12557, 12562, 12567, 12572, 12888, 12893, 13238, 13243, 13248, 13253, 15282, 15286, 15290, 15294, 0,
    14203, 14209, 14215, 14221, 14227, 14233, 14239, 14383, 14413, 14443, 14503, 12923, 13258, 13263, 13268, 13273, 13278, 13398, 13403, 12577, 12582, 12587, 12592, 12597, 12602, 12898, 12903, 12908, 12913, 12918, 15298, 15302, 15306, 15310, 0,
    14191, 14197, 12612, 12617, 12622, 13283, 13293, 13288, 12607, 15314, 15318, 15322, 15326, 0,
    14563, 15330, 15334, 0,
    12667, 12928, 12088, 12092, 15338, 15342, 0,
    14245, 14251, 14353, 14359, 14365, 12652, 12933, 12938, 12943, 12948, 12953, 12958, 13298, 13303, 13308, 13313, 13318, 13408, 13413, 12627, 12632, 12637, 12642, 12647, 15346, 15350, 15354, 15358, 0,
    11612, 11616, 0,
    12044, 0,
    11700, 11704, 11708, 11712, 0,
    11668, 11672, 11676, 11680, 0,
    11620, 11624, 11628, 11632, 0,
    11636, 11640, 11644, 11648, 0,
    11684, 11688, 11692, 11696, 0,
    11652, 11656, 11660, 11664, 0,
    11764, 11768, 11772, 11776, 0,
    11748, 11752, 11756, 11760, 0,
    11780, 11784, 11788, 11792, 0,
    11796, 11800, 11804, 11808, 0,
    11836, 11840, 0,
    11820, 11824, 0,
    11812, 11816, 0,
    11828, 11832, 0,
    11852, 11856, 0,
    11844, 11848, 0,
    11716, 11720, 11724, 11728, 0,
    11732, 11736, 11740, 11744, 0,
    11860, 11864, 11868, 11872, 0,
    12004, 12008, 12012, 12016, 0,
    11876, 11880, 11884, 11888, 0,
    11908, 11912, 11916, 11920, 0,
    11892, 11896, 11900, 11904, 0,
    11924, 11928, 0,
    11932, 11936, 11940, 11944, 0,
    11972, 11976, 11980, 11984, 0,
    11948, 11952, 0,
    11956, 11960, 11964, 11968, 0,
    12056, 12060, 0,
    12028, 12032, 0,
    12020, 12024, 0,
    12036, 12040, 0,
    12064, 12068, 0,
    12048, 12052, 0,
    12186, 12190, 12194, 12198, 0,
    12072, 12076, 12080, 12084, 0,
    11988, 11992, 0,
    11996, 12000, 0,
    1813, 0,
    1818, 0,
    1823, 0,
    1828, 0,
    1833, 0,
    1838, 0,
    1798, 0,
    1843, 0,
    1848, 0,
    1803, 0,
    1808, 0,
    1868, 0,
    1873, 0,
    1853, 0,
    1878, 0,
    1858, 1863, 0,
    1883, 0,
    1888, 0,
    1893, 0,
    1898, 0,
    1903, 0,
    1923, 0,
    1928, 0,
    1933, 0,
    1908, 1913, 1918, 0,
    1938, 0,
    1943, 1953, 0,
    1948, 0,
    1958, 0,
    1963, 0,
    1968, 1973, 1978, 0,
    1983, 0,
    1988, 1998, 0,
    1993, 0,
    2003, 0,
    2008, 0,
    2048, 0,
    2023, 0,
    2028, 0,
    2033, 0,
    2038, 0,
    2043, 0,
    2058, 0,
    2053, 0,
    2068, 0,
    2078, 0,
    2083, 0,
    2113, 0,
    2088, 0,
    2093, 0,
    2098, 0,
    2103, 0,
    2108, 0,
    2063, 0,
    2073, 0,
    3355, 0,
    3360, 0,
    3535, 0,
    3540, 0,
    3595, 0,
    3600, 0,
    4315, 4325, 4335, 4868, 0,
    4320, 4330, 4340, 4873, 0,
    4878, 0,
    4883, 0,
    4888, 0,
    4893, 0,
    4898, 0,
    4903, 0,
    4355, 4365, 4375, 4908, 0,
    4360, 4370, 4380, 4913, 0,
    4918, 0,
    4923, 0,
    4928, 0,
    4933, 0,
    4938, 0,
    4943, 0,
    4395, 4405, 0,
    4400, 4410, 0,
    4425, 4435, 0,
    4430, 4440, 0,
    4455, 4465, 4475, 4948, 0,
    4460, 4470, 4480, 4953, 0,
    4958, 0,
    4963, 0,
    4968, 0,
    4973, 0,
    4978, 0,
    4983, 0,
    4495, 4505, 4515, 4988, 0,
    4500, 4510, 4520, 4993, 0,
    4998, 0,
    5003, 0,
    5008, 0,
    5013, 0,
    5018, 0,
    5023, 0,
    4535, 4545, 4555, 0,
    4540, 4550, 4560, 0,
    4575, 4585, 4595, 0,
    4580, 4590, 4600, 0,
    4615, 4625, 0,
    4620, 4630, 0,
    4645, 4655, 0,
    4650, 4660, 0,
    4675, 4685, 4695, 0,
    4680, 4690, 4700, 0,
    4710, 4715, 4720, 0,
    4735, 4745, 4755, 5028, 0,
    4740, 4750, 4760, 5033, 0,
    5038, 0,
    5043, 0,
    5048, 0,
    5053, 0,
    5058, 0,
    5063, 0,
    4775, 4785, 4795, 5068, 0,
    4780, 4790, 4800, 5073, 0,
    5078, 0,
    5083, 0,
    5088, 0,
    5093, 0,
    5098, 0,
    5103, 0,
    5118, 0,
    5191, 0,
    5393, 0,
    5138, 0,
    5239, 5244, 5249, 0,
    5211, 0,
    5413, 0,
    5302, 5307, 5312, 0,
    6091, 0,
    6096, 0,
    6101, 0,
    6106, 0,
    6111, 0,
    6143, 0,
    6148, 0,
    6153, 0,
    6168, 0,
    6163, 0,
    6183, 0,
    6188, 0,
    6193, 0,
    6198, 0,
    6203, 0,
    6208, 0,
    6213, 0,
    6218, 0,
    6263, 0,
    6268, 0,
    6223, 0,
    6228, 0,
    6233, 0,
    6238, 0,
    6273, 0,
    6278, 0,
    6243, 0,
    6248, 0,
    6253, 0,
    6258, 0,
    6283, 0,
    6288, 0,
    6293, 0,
    6298, 0,
    7145, 0,
    7020, 0,
    7025, 0,
    7030, 0,
    7035, 0,
    7040, 0,
    7045, 0,
    7050, 0,
    7055, 0,
    7060, 0,
    7065, 0,
    7070, 0,
    7075, 0,
    7080, 0,
    7085, 0,
    7090, 0,
    7095, 7100, 0,
    7105, 7110, 0,
    7115, 7120, 0,
    7125, 7130, 0,
    7135, 7140, 0,
    7160, 0,
    7290, 0,
    7165, 0,
    7170, 0,
    7175, 0,
    7180, 0,
    7185, 0,
    7190, 0,
    7195, 0,
    7200, 0,
    7205, 0,
    7210, 0,
    7215, 0,
    7220, 0,
    7225, 0,
    7230, 0,
    7235, 0,
    7240, 7245, 0,
    7250, 7255, 0,
    7260, 7265, 0,
    7270, 7275, 0,
    7280, 7285, 0,
    7295, 0,
    7300, 0,
    7305, 0,
    7310, 0,
    7315, 0,
    11457, 11462, 0,

};

static const Q_UINT16 li_00[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 16, 18, 20, 0,
    0, 22, 39, 43, 49, 56, 73, 75,
    83, 90, 106, 108, 114, 121, 125, 134,
    150, 0, 153, 162, 169, 176, 196, 199,
    206, 209, 218, 0, 0, 0, 0, 0,
    0, 225, 242, 246, 252, 259, 276, 278,
    286, 294, 309, 312, 318, 325, 329, 338,
    354, 0, 357, 366, 373, 381, 401, 404,
    412, 415, 425, 0, 0, 0, 432, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    434, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 438, 0, 444, 446, 448, 451,
    0, 0, 453, 0, 0, 0, 0, 459,
    0, 0, 0, 0, 461, 467, 0, 0,
    470, 0, 0, 0, 472, 0, 0, 0,
    0, 0, 477, 0, 483, 485, 487, 490,
    0, 0, 492, 0, 0, 0, 0, 498,
    0, 0, 0, 0, 500, 506, 0, 0,
    509, 0, 0, 0, 511, 0, 0, 0,
};

static const Q_UINT16 li_01[] = {
    0, 0, 516, 522, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 528, 531, 534, 536, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 538, 541, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 544, 546, 0, 0, 0, 0,
    548, 550, 0, 0, 0, 0, 0, 0,
    552, 554, 556, 558, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 560,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    562, 568, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 574,
    580, 0, 0, 0, 0, 0, 0, 586,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 588, 590, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_02[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 592, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_03[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    594, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 596, 0, 0, 0, 604, 0, 609,
    0, 615, 0, 0, 0, 0, 0, 623,
    0, 628, 0, 0, 0, 630, 0, 0,
    0, 637, 0, 0, 643, 0, 645, 0,
    0, 647, 0, 0, 0, 656, 0, 661,
    0, 668, 0, 0, 0, 0, 0, 677,
    0, 682, 0, 0, 0, 685, 0, 0,
    0, 694, 701, 705, 0, 0, 709, 0,
    0, 0, 711, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_04[] = {
    0, 0, 0, 0, 0, 0, 714, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    716, 0, 0, 719, 0, 721, 724, 727,
    729, 0, 733, 0, 0, 0, 735, 0,
    0, 0, 0, 737, 0, 0, 0, 742,
    0, 0, 0, 744, 0, 0, 0, 0,
    746, 0, 0, 749, 0, 751, 754, 757,
    759, 0, 763, 0, 0, 0, 765, 0,
    0, 0, 0, 767, 0, 0, 0, 772,
    0, 0, 0, 774, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 776, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 778, 780, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    782, 784, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    786, 788, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_05[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    790, 794, 797, 799, 801, 803, 806, 0,
    808, 810, 812, 814, 817, 0, 819, 0,
    821, 823, 0, 825, 827, 0, 830, 832,
    834, 836, 840, 0, 0, 0, 0, 0,
    0, 0, 842, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_06[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 844, 846, 849, 852, 855, 858, 899,
    906, 932, 935, 973, 991, 1011, 1027, 1041,
    1044, 1048, 1053, 1056, 1091, 1128, 1153, 1176,
    1194, 1202, 1222, 0, 0, 0, 0, 0,
    1238, 1248, 1268, 1286, 1314, 1356, 1385, 1420,
    1434, 1438, 1445, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1474, 0, 0, 0, 0, 0, 1477,
    0, 1479, 1484, 1489, 0, 0, 1494, 1499,
    1504, 0, 0, 1509, 1514, 0, 1519, 1524,
    1529, 0, 0, 0, 1532, 1535, 1538, 0,
    0, 1541, 0, 0, 0, 0, 0, 0,
    1544, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1547, 0, 1552, 0,
    0, 1557, 0, 0, 0, 1562, 0, 1567,
    0, 1572, 0, 1577, 0, 0, 0, 0,
    0, 0, 1582, 1585, 0, 0, 1590, 0,
    1595, 1598, 0, 0, 0, 1603, 1606, 1609,
    1612, 1615, 0, 1618, 1621, 0, 0, 0,
    1626, 0, 1631, 1634, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_09[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1637, 1639, 1641,
    0, 0, 0, 0, 1643, 0, 0, 0,
    0, 1645, 1647, 0, 0, 0, 0, 0,
    1649, 0, 0, 1651, 0, 0, 0, 1653,
    1655, 0, 0, 1657, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1659, 1661, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1663, 0, 0, 1665,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1667,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0A[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1670, 1672,
    0, 0, 0, 0, 1674, 0, 0, 0,
    0, 1676, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1678, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0B[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1680, 1682, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1684,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1686,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1690, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1692, 1695,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0C[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1697, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1699,
    0, 0, 0, 0, 0, 0, 1701, 0,
    0, 0, 1705, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0D[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1707, 1710,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1712, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1714, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_0F[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1716, 0, 1718, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1720, 0, 0, 0,
    0, 1722, 0, 0, 0, 0, 1724, 0,
    0, 0, 0, 1726, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1728, 1730, 0, 0, 0, 1732, 0,
    1734, 0, 0, 0, 0, 0, 0, 0,
    1736, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1738, 0, 1740, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1742, 0, 0, 0,
    0, 1744, 0, 0, 0, 0, 1746, 0,
    0, 0, 0, 1748, 0, 0, 0, 0,
    0, 0, 1750, 1752, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_1E[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1754, 1756,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1758, 1760, 0, 0, 0, 0,
    0, 0, 1762, 1764, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_1F[] = {
    1766, 1771, 1776, 1778, 1780, 1782, 1784, 1786,
    1788, 1793, 1798, 1800, 1802, 1804, 1806, 1808,
    1810, 1813, 0, 0, 0, 0, 0, 0,
    1816, 1819, 0, 0, 0, 0, 0, 0,
    1822, 1827, 1832, 1834, 1836, 1838, 1840, 1842,
    1844, 1849, 1854, 1856, 1858, 1860, 1862, 1864,
    1866, 1870, 0, 0, 0, 0, 0, 0,
    1874, 1878, 0, 0, 0, 0, 0, 0,
    1882, 1885, 0, 0, 0, 0, 0, 0,
    1888, 1891, 0, 0, 0, 0, 0, 0,
    1894, 1898, 0, 0, 0, 0, 0, 0,
    0, 1902, 0, 0, 0, 0, 0, 0,
    1906, 1911, 1916, 1918, 1920, 1922, 1924, 1926,
    1928, 1933, 1938, 1940, 1942, 1944, 1946, 1948,
    1950, 0, 0, 0, 1952, 0, 0, 0,
    0, 0, 0, 0, 1954, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1956, 0,
    0, 0, 0, 0, 0, 0, 0, 1958,
    0, 0, 0, 0, 0, 0, 1962, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1964, 0,
    0, 0, 0, 0, 0, 0, 1966, 0,
};

static const Q_UINT16 li_22[] = {
    0, 0, 0, 1970, 0, 0, 0, 0,
    1972, 0, 0, 1974, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1976, 0, 1978, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1980, 0, 1982, 0, 0,
    1984, 0, 0, 0, 0, 1986, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1988, 0, 0, 1990, 1992, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1994, 1996, 0, 0, 1998, 2000,
    0, 0, 2002, 2004, 2006, 2008, 0, 0,
    0, 0, 2010, 2012, 0, 0, 2014, 2016,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2018, 2020, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2022, 0, 0, 0, 0, 0,
    2024, 2026, 0, 2028, 0, 0, 0, 0,
    0, 0, 2030, 2032, 2034, 2036, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 li_30[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2038, 0,
    0, 0, 0, 2040, 0, 2042, 0, 2044,
    0, 2046, 0, 2048, 0, 2050, 0, 2052,
    0, 2054, 0, 2056, 0, 2058, 0, 2060,
    0, 2062, 0, 0, 2064, 0, 2066, 0,
    2068, 0, 0, 0, 0, 0, 0, 2070,
    0, 0, 2073, 0, 0, 2076, 0, 0,
    2079, 0, 0, 2082, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2085, 0, 0,
    0, 0, 0, 0, 0, 0, 2087, 0,
    0, 0, 0, 2089, 0, 2091, 0, 2093,
    0, 2095, 0, 2097, 0, 2099, 0, 2101,
    0, 2103, 0, 2105, 0, 2107, 0, 2109,
    0, 2111, 0, 0, 2113, 0, 2115, 0,
    2117, 0, 0, 0, 0, 0, 0, 2119,
    0, 0, 2122, 0, 0, 2125, 0, 0,
    2128, 0, 0, 2131, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2134,
    2136, 2138, 2140, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 2142, 0, 0,
};

static const Q_UINT16 li_FB[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2144, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 *ligature_info [256] = {
    li_00, li_01, li_02, li_03, li_04, li_05, li_06, di_06,
    di_06, li_09, li_0A, li_0B, li_0C, li_0D, li_0E, li_0F,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, li_1E, li_1F,
    di_06, di_06, li_22, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    li_30, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, di_06, di_06, di_06, di_06, di_06,
    di_06, di_06, di_06, li_FB, di_06, di_06, di_06, di_06,
};
// 15044 bytes

// END OF GENERATED DATA

// The following are generated too, no script yet.

static const Q_UINT8 dir_0 [] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 8, 7, 8, 7, 7, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 7, 7, 7, 8,
    9, 10, 10, 0, 0, 0, 10, 10,
    138, 138, 10, 0, 6, 0, 6, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 6, 10, 138, 10, 138, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 138, 10, 138, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 138, 10, 138, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    9, 10, 0, 0, 0, 0, 10, 10,
    10, 10, 0, 138, 10, 10, 10, 10,
    0, 0, 2, 2, 10, 0, 10, 10,
    10, 2, 0, 138, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_2 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_3 [] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 10, 0,
    0, 0, 0, 0, 10, 10, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_4 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_5 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 0, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 0, 10, 10, 10, 1, 10,
    1, 10, 10, 1, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_6 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 1,
    0, 1, 33, 33, 33, 33, 17, 33,
    17, 33, 17, 17, 17, 17, 17, 33,
    33, 33, 33, 17, 17, 17, 17, 17,
    17, 17, 17, 0, 0, 0, 0, 0,
    49, 17, 17, 17, 17, 17, 17, 17,
    33, 33, 17, 10, 10, 10, 10, 10,
    10, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 0, 5, 5, 1, 0, 0,
    10, 65, 33, 33, 65, 33, 33, 33,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    33, 33, 33, 33, 33, 33, 33, 33,
    33, 33, 33, 33, 33, 33, 33, 33,
    33, 33, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    0, 0, 17, 17, 17, 17, 17, 0,
    33, 17, 33, 33, 33, 33, 33, 33,
    33, 33, 33, 33, 17, 33, 17, 0,
    17, 17, 33, 33, 1, 65, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 1, 1, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_9 [] = {
    0, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 10, 0, 0, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 0, 0, 0, 0, 10, 0, 0,
    0, 10, 10, 10, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 10, 0, 0, 0,
    0, 10, 10, 10, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_a [] = {
    0, 0, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 10, 0, 0, 0,
    0, 10, 10, 0, 0, 0, 0, 10,
    10, 0, 0, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 10, 0, 0, 0,
    0, 10, 10, 10, 10, 10, 0, 10,
    10, 0, 0, 0, 0, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_b [] = {
    0, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 10, 0, 0, 10,
    0, 10, 10, 10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_c [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 10, 10,
    10, 0, 0, 0, 0, 0, 10, 10,
    10, 0, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 10, 0,
    0, 0, 0, 0, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_d [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_e [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 0, 0, 10, 10, 10, 10,
    10, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 0, 0, 10, 10, 10, 10,
    10, 10, 0, 10, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_f [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 0, 10,
    0, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    10, 10, 10, 10, 10, 0, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 0, 10,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    0, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_1f [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 0, 10,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 10, 0,
};

static const Q_UINT8 dir_20 [] = {
    9, 9, 9, 9, 9, 9, 9, 6,
    9, 9, 9, 9, 10, 10, 0, 1,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    7, 7, 0, 1, 10, 0, 1, 0,
    0, 0, 0, 0, 0, 10, 10, 10,
    10, 138, 138, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 138, 138, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 10, 10, 10, 10, 10,
    2, 0, 0, 0, 2, 2, 2, 2,
    2, 2, 0, 0, 10, 138, 138, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 0, 0, 10, 138, 138, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_21 [] = {
    10, 10, 0, 10, 10, 10, 10, 0,
    10, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 10, 0, 10, 10,
    0, 0, 0, 0, 0, 0, 10, 10,
    10, 10, 10, 10, 0, 10, 0, 10,
    0, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_22 [] = {
    10, 138, 138, 138, 138, 10, 10, 10,
    138, 138, 138, 138, 138, 138, 10, 10,
    10, 138, 0, 0, 10, 138, 138, 10,
    10, 10, 138, 138, 138, 138, 10, 138,
    138, 138, 138, 10, 138, 10, 138, 10,
    10, 10, 10, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 10, 10,
    10, 138, 10, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 10, 10, 10,
    10, 10, 138, 138, 138, 138, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 138,
    138, 10, 138, 10, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 10, 10, 138,
    138, 138, 138, 10, 10, 10, 10, 10,
    138, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 138, 138, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 10, 10, 10, 10, 10, 138, 138,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 138, 138, 138, 138, 138, 10, 10,
    138, 138, 10, 10, 10, 10, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 138, 138, 138, 138, 10, 10,
    138, 138, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_23 [] = {
    10, 0, 10, 10, 10, 10, 10, 10,
    138, 138, 138, 138, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    138, 138, 10, 10, 10, 10, 10, 10,
    10, 138, 138, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_24 [] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_25 [] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_26 [] = {
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 0, 0, 0,
    0, 0, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_27 [] = {
    0, 10, 10, 10, 10, 0, 10, 10,
    10, 10, 0, 0, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 0, 10, 0, 10,
    10, 10, 10, 0, 0, 0, 10, 0,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_30 [] = {
    9, 10, 10, 10, 10, 10, 0, 0,
    138, 138, 138, 138, 138, 138, 138, 138,
    138, 138, 10, 10, 138, 138, 138, 138,
    138, 138, 138, 138, 10, 10, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 10, 10, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT8 dir_fb [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 10, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 0, 1, 0,
    1, 1, 0, 1, 1, 0, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    65, 65, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 33, 33, 33, 33, 33, 33,
    33, 33, 33, 33, 33, 33, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 33, 33, 17, 17,
    17, 17, 17, 17, 17, 17, 33, 33,
    33, 33, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 17, 17, 17, 17, 33,
    33, 33, 33, 33, 33, 33, 33, 33,
    33, 33, 33, 33, 17, 17, 17, 17,
    1, 1, 33, 33, 65, 65, 33, 33,
    33, 33, 33, 33, 33, 33, 17, 17,
    17, 1, 1, 1, 17, 17, 17, 17,
};

static const Q_UINT8 dir_fc [] = {
    17, 17, 17, 33, 17, 17, 17, 17,
    17, 33, 17, 17, 17, 17, 17, 33,
    17, 17, 17, 33, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 33, 17, 17, 17, 33, 17, 33,
    17, 17, 17, 17, 17, 33, 17, 17,
    17, 17, 17, 33, 17, 17, 17, 17,
    17, 33, 17, 17, 17, 17, 17, 33,
    17, 17, 17, 33, 17, 17, 17, 17,
    17, 33, 17, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 33, 33, 17, 17,
    33, 17, 33, 33, 17, 17, 33, 17,
    33, 33, 17, 17, 33, 17, 33, 33,
    17, 17, 33, 17, 33, 17, 33, 17,
    33, 17, 17, 33, 17, 17, 33, 17,
    33, 17, 33, 33, 17, 17, 33, 17,
    1, 33, 33, 17, 17, 33, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 1, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 1, 1, 1, 33, 17, 33,
    17, 33, 17, 33, 17, 33, 17, 33,
};

static const Q_UINT8 dir_fd [] = {
    17, 33, 17, 33, 17, 33, 17, 33,
    17, 17, 17, 17, 17, 33, 33, 33,
    33, 33, 17, 33, 17, 33, 17, 33,
    17, 33, 17, 33, 17, 33, 17, 33,
    17, 33, 17, 33, 17, 17, 17, 17,
    17, 33, 33, 33, 33, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 1, 1, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 33, 17, 17, 33, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 33, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    33, 17, 17, 33, 17, 17, 17, 17,
    17, 17, 33, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    0, 0, 17, 17, 17, 17, 33, 17,
    17, 33, 17, 33, 17, 17, 17, 17,
    33, 17, 33, 17, 33, 17, 33, 33,
    33, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    33, 33, 17, 33, 33, 17, 17, 17,
    17, 33, 17, 17, 0, 0, 0, 0,
};

static const Q_UINT8 dir_fe [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 0, 0, 0,
    0, 10, 10, 10, 10, 10, 10, 10,
    6, 10, 6, 0, 10, 6, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 0,
    10, 10, 0, 0, 10, 10, 10, 0,
    10, 0, 0, 10, 0, 0, 0, 0,
    1, 1, 1, 0, 1, 0, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1,
    1, 33, 33, 33, 33, 33, 33, 33,
    33, 17, 17, 17, 17, 33, 33, 17,
    17, 17, 17, 33, 33, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 33, 33, 33, 33, 33, 33, 33,
    33, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 17, 17, 17,
    17, 17, 17, 17, 17, 33, 33, 33,
    33, 17, 17, 17, 17, 33, 33, 33,
    33, 33, 33, 33, 33, 0, 0, 10,
};

static const Q_UINT8 dir_ff [] = {
    0, 10, 10, 0, 0, 0, 10, 10,
    10, 10, 10, 0, 6, 0, 6, 0,
    2, 2, 2, 2, 2, 2, 2, 2,
    2, 2, 6, 10, 10, 10, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 10, 10, 10,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 10, 10, 10, 10, 0,
    0, 10, 10, 10, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 10, 10, 0, 0, 0,
    10, 10, 10, 10, 10, 10, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 10, 10, 10, 10,
};

static const Q_UINT8 *direction_info [256] = {
    dir_0, 0, dir_2, dir_3, dir_4, dir_5, dir_6, 0,
    0, dir_9, dir_a, dir_b, dir_c, dir_d, dir_e, dir_f,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, dir_1f,
    dir_20, dir_21, dir_22, dir_23, dir_24, dir_25, dir_26, dir_27,
    0, 0, 0, 0, 0, 0, 0, 0,
    dir_30, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, dir_fb, dir_fc, dir_fd, dir_fe, dir_ff,
};


static const Q_UINT16 case_0 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7a, 0, 0, 0, 0, 0,
    0, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5a, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x0, 0, 0,
    0, 0, 0x0, 0, 0, 0, 0, 0,
    0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
    0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
    0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0,
    0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0x0,
    0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
    0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
    0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0,
    0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0x178,
};

static const Q_UINT16 case_1 [] = {
    0x101, 0x100, 0x103, 0x102, 0x105, 0x104, 0x107, 0x106,
    0x109, 0x108, 0x10b, 0x10a, 0x10d, 0x10c, 0x10f, 0x10e,
    0x111, 0x110, 0x113, 0x112, 0x115, 0x114, 0x117, 0x116,
    0x119, 0x118, 0x11b, 0x11a, 0x11d, 0x11c, 0x11f, 0x11e,
    0x121, 0x120, 0x123, 0x122, 0x125, 0x124, 0x127, 0x126,
    0x129, 0x128, 0x12b, 0x12a, 0x12d, 0x12c, 0x12f, 0x12e,
    0x69, 0x49, 0x133, 0x132, 0x135, 0x134, 0x137, 0x136,
    0x0, 0x13a, 0x139, 0x13c, 0x13b, 0x13e, 0x13d, 0x140,
    0x13f, 0x142, 0x141, 0x144, 0x143, 0x146, 0x145, 0x148,
    0x147, 0x0, 0x14b, 0x14a, 0x14d, 0x14c, 0x14f, 0x14e,
    0x151, 0x150, 0x153, 0x152, 0x155, 0x154, 0x157, 0x156,
    0x159, 0x158, 0x15b, 0x15a, 0x15d, 0x15c, 0x15f, 0x15e,
    0x161, 0x160, 0x163, 0x162, 0x165, 0x164, 0x167, 0x166,
    0x169, 0x168, 0x16b, 0x16a, 0x16d, 0x16c, 0x16f, 0x16e,
    0x171, 0x170, 0x173, 0x172, 0x175, 0x174, 0x177, 0x176,
    0xff, 0x17a, 0x179, 0x17c, 0x17b, 0x17e, 0x17d, 0x53,
    0x0, 0x253, 0x183, 0x182, 0x185, 0x184, 0x254, 0x188,
    0x187, 0x256, 0x257, 0x18c, 0x18b, 0x0, 0x1dd, 0x259,
    0x25b, 0x192, 0x191, 0x260, 0x263, 0x3d9, 0x269, 0x268,
    0x199, 0x198, 0x51, 0x0, 0x26f, 0x272, 0x0, 0x275,
    0x1a1, 0x1a0, 0x1a3, 0x1a2, 0x1a5, 0x1a4, 0x280, 0x1a8,
    0x1a7, 0x283, 0, 0x0, 0x1ad, 0x1ac, 0x288, 0x1b0,
    0x1af, 0x28a, 0x28b, 0x1b4, 0x1b3, 0x1b6, 0x1b5, 0x292,
    0x1b9, 0x1b8, 0x0, 0, 0x1bd, 0x1bc, 0, 0,
    0, 0, 0, 0, 0x1c6, 0, 0x1c4, 0x1c9,
    0, 0x1c7, 0x1cc, 0, 0x1ca, 0x1ce, 0x1cd, 0x1d0,
    0x1cf, 0x1d2, 0x1d1, 0x1d4, 0x1d3, 0x1d6, 0x1d5, 0x1d8,
    0x1d7, 0x1da, 0x1d9, 0x1dc, 0x1db, 0x18e, 0x1df, 0x1de,
    0x1e1, 0x1e0, 0x1e3, 0x1e2, 0x1e5, 0x1e4, 0x1e7, 0x1e6,
    0x1e9, 0x1e8, 0x1eb, 0x1ea, 0x1ed, 0x1ec, 0x1ef, 0x1ee,
    0x0, 0x1f3, 0, 0x1f1, 0x1f5, 0x1f4, 0, 0,
    0, 0, 0x1fb, 0x1fa, 0x1fd, 0x1fc, 0x1ff, 0x1fe,
};

static const Q_UINT16 case_2 [] = {
    0x201, 0x200, 0x203, 0x202, 0x205, 0x204, 0x207, 0x206,
    0x209, 0x208, 0x20b, 0x20a, 0x20d, 0x20c, 0x20f, 0x20e,
    0x211, 0x210, 0x213, 0x212, 0x215, 0x214, 0x217, 0x216,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0x0, 0x0, 0x0, 0x181, 0x186, 0x0, 0x189, 0x18a,
    0x0, 0x18f, 0x0, 0x190, 0x0, 0x0, 0x0, 0x0,
    0x193, 0x0, 0x0, 0x194, 0x0, 0x0, 0x631, 0x579,
    0x197, 0x196, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19c,
    0x0, 0x0, 0x19d, 0x0, 0x0, 0x19f, 0x0, 0x0,
    0x0, 0x0, 0x7e1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1a6, 0x0, 0x0, 0x1a9, 0x0, 0x0, 0x0, 0x0,
    0x1ae, 0x0, 0x1b1, 0x1b2, 0x0, 0xa21, 0x971, 0x0,
    0x0, 0x0, 0x1b7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_3 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x3ac, 0,
    0x3ad, 0x3ae, 0x3af, 0, 0x3cc, 0, 0x3cd, 0x3ce,
    0x0, 0x3b1, 0x3b2, 0x3b3, 0x3b4, 0x3b5, 0x3b6, 0x3b7,
    0x3b8, 0x3b9, 0x3ba, 0x3bb, 0x3bc, 0x3bd, 0x3be, 0x3bf,
    0x3c0, 0x3c1, 0, 0x3c3, 0x3c4, 0x3c5, 0x3c6, 0x3c7,
    0x3c8, 0x3c9, 0x3ca, 0x3cb, 0x386, 0x388, 0x389, 0x38a,
    0x0, 0x391, 0x392, 0x393, 0x394, 0x395, 0x396, 0x397,
    0x398, 0x399, 0x39a, 0x39b, 0x39c, 0x39d, 0x39e, 0x39f,
    0x3a0, 0x3a1, 0x3a3, 0x3a3, 0x3a4, 0x3a5, 0x3a6, 0x3a7,
    0x3a8, 0x3a9, 0x3aa, 0x3ab, 0x38c, 0x38e, 0x38f, 0,
    0x392, 0x398, 0x0, 0x0, 0x0, 0x3a6, 0x3a0, 0,
    0, 0, 0x0, 0, 0x0, 0, 0x0, 0,
    0x0, 0, 0x3e3, 0x3e2, 0x3e5, 0x3e4, 0x3e7, 0x3e6,
    0x3e9, 0x3e8, 0x3eb, 0x3ea, 0x3ed, 0x3ec, 0x3ef, 0x3ee,
    0x39a, 0x3a1, 0x3a3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_4 [] = {
    0, 0x451, 0x452, 0x453, 0x454, 0x455, 0x456, 0x457,
    0x458, 0x459, 0x45a, 0x45b, 0x45c, 0, 0x45e, 0x45f,
    0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
    0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
    0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
    0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f,
    0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
    0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
    0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
    0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
    0, 0x401, 0x402, 0x403, 0x404, 0x405, 0x406, 0x407,
    0x408, 0x409, 0x40a, 0x40b, 0x40c, 0, 0x40e, 0x40f,
    0x461, 0x460, 0x463, 0x462, 0x465, 0x464, 0x467, 0x466,
    0x469, 0x468, 0x46b, 0x46a, 0x46d, 0x46c, 0x46f, 0x46e,
    0x471, 0x470, 0x473, 0x472, 0x475, 0x474, 0x477, 0x476,
    0x479, 0x478, 0x47b, 0x47a, 0x47d, 0x47c, 0x47f, 0x47e,
    0x481, 0x480, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0x491, 0x490, 0x493, 0x492, 0x495, 0x494, 0x497, 0x496,
    0x499, 0x498, 0x49b, 0x49a, 0x49d, 0x49c, 0x49f, 0x49e,
    0x4a1, 0x4a0, 0x4a3, 0x4a2, 0x4a5, 0x4a4, 0x4a7, 0x4a6,
    0x4a9, 0x4a8, 0x4ab, 0x4aa, 0x4ad, 0x4ac, 0x4af, 0x4ae,
    0x4b1, 0x4b0, 0x4b3, 0x4b2, 0x4b5, 0x4b4, 0x4b7, 0x4b6,
    0x4b9, 0x4b8, 0x4bb, 0x4ba, 0x4bd, 0x4bc, 0x4bf, 0x4be,
    0, 0x4c2, 0x4c1, 0x4c4, 0x4c3, 0, 0, 0x4c8,
    0x4c7, 0, 0, 0x4cc, 0x4cb, 0, 0, 0,
    0x4d1, 0x4d0, 0x4d3, 0x4d2, 0x4d5, 0x4d4, 0x4d7, 0x4d6,
    0x4d9, 0x4d8, 0x4db, 0x4da, 0x4dd, 0x4dc, 0x4df, 0x4de,
    0x4e1, 0x4e0, 0x4e3, 0x4e2, 0x4e5, 0x4e4, 0x4e7, 0x4e6,
    0x4e9, 0x4e8, 0x4eb, 0x4ea, 0, 0, 0x4ef, 0x4ee,
    0x4f1, 0x4f0, 0x4f3, 0x4f2, 0x4f5, 0x4f4, 0, 0,
    0x4f9, 0x4f8, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_5 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x561, 0x562, 0x563, 0x564, 0x565, 0x566, 0x567,
    0x568, 0x569, 0x56a, 0x56b, 0x56c, 0x56d, 0x56e, 0x56f,
    0x570, 0x571, 0x572, 0x573, 0x574, 0x575, 0x576, 0x577,
    0x578, 0x579, 0x57a, 0x57b, 0x57c, 0x57d, 0x57e, 0x57f,
    0x580, 0x581, 0x582, 0x583, 0x584, 0x585, 0x586, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x531, 0x532, 0x533, 0x534, 0x535, 0x536, 0x537,
    0x538, 0x539, 0x53a, 0x53b, 0x53c, 0x53d, 0x53e, 0x53f,
    0x540, 0x541, 0x542, 0x543, 0x544, 0x545, 0x546, 0x547,
    0x548, 0x549, 0x54a, 0x54b, 0x54c, 0x54d, 0x54e, 0x54f,
    0x550, 0x551, 0x552, 0x553, 0x554, 0x555, 0x556, 0x0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_10 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0x10d0, 0x10d1, 0x10d2, 0x10d3, 0x10d4, 0x10d5, 0x10d6, 0x10d7,
    0x10d8, 0x10d9, 0x10da, 0x10db, 0x10dc, 0x10dd, 0x10de, 0x10df,
    0x10e0, 0x10e1, 0x10e2, 0x10e3, 0x10e4, 0x10e5, 0x10e6, 0x10e7,
    0x10e8, 0x10e9, 0x10ea, 0x10eb, 0x10ec, 0x10ed, 0x10ee, 0x10ef,
    0x10f0, 0x10f1, 0x10f2, 0x10f3, 0x10f4, 0x10f5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_1e [] = {
    0x1e01, 0x1e00, 0x1e03, 0x1e02, 0x1e05, 0x1e04, 0x1e07, 0x1e06,
    0x1e09, 0x1e08, 0x1e0b, 0x1e0a, 0x1e0d, 0x1e0c, 0x1e0f, 0x1e0e,
    0x1e11, 0x1e10, 0x1e13, 0x1e12, 0x1e15, 0x1e14, 0x1e17, 0x1e16,
    0x1e19, 0x1e18, 0x1e1b, 0x1e1a, 0x1e1d, 0x1e1c, 0x1e1f, 0x1e1e,
    0x1e21, 0x1e20, 0x1e23, 0x1e22, 0x1e25, 0x1e24, 0x1e27, 0x1e26,
    0x1e29, 0x1e28, 0x1e2b, 0x1e2a, 0x1e2d, 0x1e2c, 0x1e2f, 0x1e2e,
    0x1e31, 0x1e30, 0x1e33, 0x1e32, 0x1e35, 0x1e34, 0x1e37, 0x1e36,
    0x1e39, 0x1e38, 0x1e3b, 0x1e3a, 0x1e3d, 0x1e3c, 0x1e3f, 0x1e3e,
    0x1e41, 0x1e40, 0x1e43, 0x1e42, 0x1e45, 0x1e44, 0x1e47, 0x1e46,
    0x1e49, 0x1e48, 0x1e4b, 0x1e4a, 0x1e4d, 0x1e4c, 0x1e4f, 0x1e4e,
    0x1e51, 0x1e50, 0x1e53, 0x1e52, 0x1e55, 0x1e54, 0x1e57, 0x1e56,
    0x1e59, 0x1e58, 0x1e5b, 0x1e5a, 0x1e5d, 0x1e5c, 0x1e5f, 0x1e5e,
    0x1e61, 0x1e60, 0x1e63, 0x1e62, 0x1e65, 0x1e64, 0x1e67, 0x1e66,
    0x1e69, 0x1e68, 0x1e6b, 0x1e6a, 0x1e6d, 0x1e6c, 0x1e6f, 0x1e6e,
    0x1e71, 0x1e70, 0x1e73, 0x1e72, 0x1e75, 0x1e74, 0x1e77, 0x1e76,
    0x1e79, 0x1e78, 0x1e7b, 0x1e7a, 0x1e7d, 0x1e7c, 0x1e7f, 0x1e7e,
    0x1e81, 0x1e80, 0x1e83, 0x1e82, 0x1e85, 0x1e84, 0x1e87, 0x1e86,
    0x1e89, 0x1e88, 0x1e8b, 0x1e8a, 0x1e8d, 0x1e8c, 0x1e8f, 0x1e8e,
    0x1e91, 0x1e90, 0x1e93, 0x1e92, 0x1e95, 0x1e94, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1e60, 0, 0, 0, 0,
    0x1ea1, 0x1ea0, 0x1ea3, 0x1ea2, 0x1ea5, 0x1ea4, 0x1ea7, 0x1ea6,
    0x1ea9, 0x1ea8, 0x1eab, 0x1eaa, 0x1ead, 0x1eac, 0x1eaf, 0x1eae,
    0x1eb1, 0x1eb0, 0x1eb3, 0x1eb2, 0x1eb5, 0x1eb4, 0x1eb7, 0x1eb6,
    0x1eb9, 0x1eb8, 0x1ebb, 0x1eba, 0x1ebd, 0x1ebc, 0x1ebf, 0x1ebe,
    0x1ec1, 0x1ec0, 0x1ec3, 0x1ec2, 0x1ec5, 0x1ec4, 0x1ec7, 0x1ec6,
    0x1ec9, 0x1ec8, 0x1ecb, 0x1eca, 0x1ecd, 0x1ecc, 0x1ecf, 0x1ece,
    0x1ed1, 0x1ed0, 0x1ed3, 0x1ed2, 0x1ed5, 0x1ed4, 0x1ed7, 0x1ed6,
    0x1ed9, 0x1ed8, 0x1edb, 0x1eda, 0x1edd, 0x1edc, 0x1edf, 0x1ede,
    0x1ee1, 0x1ee0, 0x1ee3, 0x1ee2, 0x1ee5, 0x1ee4, 0x1ee7, 0x1ee6,
    0x1ee9, 0x1ee8, 0x1eeb, 0x1eea, 0x1eed, 0x1eec, 0x1eef, 0x1eee,
    0x1ef1, 0x1ef0, 0x1ef3, 0x1ef2, 0x1ef5, 0x1ef4, 0x1ef7, 0x1ef6,
    0x1ef9, 0x1ef8, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_1f [] = {
    0x1f08, 0x1f09, 0x1f0a, 0x1f0b, 0x1f0c, 0x1f0d, 0x1f0e, 0x1f0f,
    0x1f00, 0x1f01, 0x1f02, 0x1f03, 0x1f04, 0x1f05, 0x1f06, 0x1f07,
    0x1f18, 0x1f19, 0x1f1a, 0x1f1b, 0x1f1c, 0x1f1d, 0, 0,
    0x1f10, 0x1f11, 0x1f12, 0x1f13, 0x1f14, 0x1f15, 0, 0,
    0x1f28, 0x1f29, 0x1f2a, 0x1f2b, 0x1f2c, 0x1f2d, 0x1f2e, 0x1f2f,
    0x1f20, 0x1f21, 0x1f22, 0x1f23, 0x1f24, 0x1f25, 0x1f26, 0x1f27,
    0x1f38, 0x1f39, 0x1f3a, 0x1f3b, 0x1f3c, 0x1f3d, 0x1f3e, 0x1f3f,
    0x1f30, 0x1f31, 0x1f32, 0x1f33, 0x1f34, 0x1f35, 0x1f36, 0x1f37,
    0x1f48, 0x1f49, 0x1f4a, 0x1f4b, 0x1f4c, 0x1f4d, 0, 0,
    0x1f40, 0x1f41, 0x1f42, 0x1f43, 0x1f44, 0x1f45, 0, 0,
    0x0, 0x1f59, 0x0, 0x1f5b, 0x0, 0x1f5d, 0x0, 0x1f5f,
    0, 0x1f51, 0, 0x1f53, 0, 0x1f55, 0, 0x1f57,
    0x1f68, 0x1f69, 0x1f6a, 0x1f6b, 0x1f6c, 0x1f6d, 0x1f6e, 0x1f6f,
    0x1f60, 0x1f61, 0x1f62, 0x1f63, 0x1f64, 0x1f65, 0x1f66, 0x1f67,
    0x1fba, 0x1fbb, 0x1fc8, 0x1fc9, 0x1fca, 0x1fcb, 0x1fda, 0x1fdb,
    0x1ff8, 0x1ff9, 0x1fea, 0x1feb, 0x1ffa, 0x1ffb, 0, 0,
    0x1f88, 0x1f89, 0x1f8a, 0x1f8b, 0x1f8c, 0x1f8d, 0x1f8e, 0x1f8f,
    0x1f80, 0x1f81, 0x1f82, 0x1f83, 0x1f84, 0x1f85, 0x1f86, 0x1f87,
    0x1f98, 0x1f99, 0x1f9a, 0x1f9b, 0x1f9c, 0x1f9d, 0x1f9e, 0x1f9f,
    0x1f90, 0x1f91, 0x1f92, 0x1f93, 0x1f94, 0x1f95, 0x1f96, 0x1f97,
    0x1fa8, 0x1fa9, 0x1faa, 0x1fab, 0x1fac, 0x1fad, 0x1fae, 0x1faf,
    0x1fa0, 0x1fa1, 0x1fa2, 0x1fa3, 0x1fa4, 0x1fa5, 0x1fa6, 0x1fa7,
    0x1fb8, 0x1fb9, 0x0, 0x1fbc, 0x0, 0, 0x0, 0x0,
    0x1fb0, 0x1fb1, 0x1f70, 0x1f71, 0x1fb3, 0, 0x399, 0,
    0, 0, 0x0, 0x1fcc, 0x0, 0, 0x0, 0x0,
    0x1f72, 0x1f73, 0x1f74, 0x1f75, 0x1fc3, 0, 0, 0,
    0x1fd8, 0x1fd9, 0x0, 0x0, 0, 0, 0x0, 0x0,
    0x1fd0, 0x1fd1, 0x1f76, 0x1f77, 0, 0, 0, 0,
    0x1fe8, 0x1fe9, 0x0, 0x0, 0x0, 0x1fec, 0x0, 0x0,
    0x1fe0, 0x1fe1, 0x1f7a, 0x1f7b, 0x1fe5, 0, 0, 0,
    0, 0, 0x0, 0x1ffc, 0x0, 0, 0x0, 0x0,
    0x1f78, 0x1f79, 0x1f7c, 0x1f7d, 0x1ff3, 0, 0, 0,
};

static const Q_UINT16 case_20 [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_21 [] = {
    0, 0, 0x0, 0, 0, 0, 0, 0x0,
    0, 0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0, 0x0, 0, 0,
    0x761, 0x0, 0x0, 0x0, 0x0, 0x0, 0, 0,
    0, 0, 0, 0, 0x0, 0, 0x0, 0,
    0x0, 0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0, 0x0, 0x0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_fb [] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 case_ff [] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0xff41, 0xff42, 0xff43, 0xff44, 0xff45, 0xff46, 0xff47,
    0xff48, 0xff49, 0xff4a, 0xff4b, 0xff4c, 0xff4d, 0xff4e, 0xff4f,
    0xff50, 0xff51, 0xff52, 0xff53, 0xff54, 0xff55, 0xff56, 0xff57,
    0xff58, 0xff59, 0xff5a, 0, 0, 0, 0, 0,
    0, 0xff21, 0xff22, 0xff23, 0xff24, 0xff25, 0xff26, 0xff27,
    0xff28, 0xff29, 0xff2a, 0xff2b, 0xff2c, 0xff2d, 0xff2e, 0xff2f,
    0xff30, 0xff31, 0xff32, 0xff33, 0xff34, 0xff35, 0xff36, 0xff37,
    0xff38, 0xff39, 0xff3a, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};

static const Q_UINT16 *case_info [256] = {

    case_0, case_1, case_2, case_3, case_4, case_5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    case_10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, case_1e, case_1f,
    case_20, case_21, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, case_fb, 0, 0, 0, case_ff,
};

static const Q_INT8 num_0 [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, 2, 3, -1, -1, -1, -1,
    -1, 1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_6 [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_9 [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_b [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_d [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_e [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_f [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_20 [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, -1, -1, -1, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 num_ff [] = {
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static const Q_INT8 *decimal_info [256] = {
     num_0, 0, 0, 0, 0, 0, num_6, 0,
     0, num_9, num_9, num_b, num_9, num_d, num_e, num_f,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     num_20, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0, 0, num_ff,
};


/*
 * ----------------------------------------------------------------------
 * End of unicode tables
 * ----------------------------------------------------------------------
 */




static
int ucstrcmp( const QString &as, const QString &bs )
{
    const QChar *a = as.unicode();
    const QChar *b = bs.unicode();
    if ( a == b )
	return 0;
    if ( a == 0 )
       return 1;
    if ( b == 0 )
       return -1;
    int l=QMIN(as.length(),bs.length());
    while ( l-- && *a == *b )
	a++,b++;
    if ( l==-1 )
	return ( as.length()-bs.length() );
    return a->unicode() - b->unicode();
}
static
int ucstrncmp( const QChar *a, const QChar *b, int l )
{
    while ( l-- && *a == *b )
	a++,b++;
    if ( l==-1 )
	return 0;
    return *a - *b;
}
static
int ucstrnicmp( const QChar *a, const QChar *b, int l )
{
    while ( l-- && a->lower() == b->lower() )
	a++,b++;
    if ( l==-1 )
	return 0;
    QChar al = a->lower();
    QChar bl = b->lower();
    return al.row() == bl.row() ? al.cell() - bl.cell() : al.row() - bl.row();
}


/*!
  \class QChar qstring.h
  \brief A Unicode character.

  A QChar is a simple 16-bit value representing a Unicode character.
  Most C++ compilers will process them much as they would a "short int".

  QChar values are normally used in combination with QString.

  They can be trivially constructed from:
   <dl>
    <dt>\c char
      <dd>the char is assumed to be a Latin-1 character,
	    for example QChar('Q') is the Unicode character U0051
	    and QChar('t') is the Unicode character U0074.
    <dt>\c short
      <dd>the MSB is the high-order byte (row) of the Unicode character,
	    for example QChar(ushort(0x6817)) is the Unicode character
	    U6817 meaning <em>kuri</em> - chestnut tree - in Japanese.
    <dt>\c char, \c char
      <dd>the characters are LSB and MSB respectively,
	    for example QChar(0x25,0x04) is the Unicode character U0425
	    which is the Cyrillic letter YA which looks like a mirrored R.
   </dl>
*/

/*!
  \fn bool QChar::isNull() const
  Returns TRUE if the charaters is the unicode character 0x0000,
  ie. ASCII NUL.
*/

/*!
  \fn uchar QChar::cell () const
  Returns the cell (least significant byte) of the Unicode character.
*/
/*!
  \fn uchar QChar::row () const
  Returns the row (most significant byte) of the Unicode character.
*/
/*!
  \fn uchar& QChar::cell ()
  Returns a reference to the cell (least significant byte) of the Unicode character.
*/
/*!
  \fn uchar& QChar::row ()
  Returns a reference to the row (most significant byte) of the Unicode character.
*/

/*!
  Returns whether the character is a printable character.  This is
  and character of category Cc or Cn.  Note that this gives no indication
  of whether the character is available in some font.
*/
bool QChar::isPrint() const
{
    Category c = category();
    return !(c == Other_Control || c == Other_NotAssigned);
}

/*!
  Returns whether the character is a separator
  character (Separator_* categories).
*/
bool QChar::isSpace() const
{
    if( !row() )
	if( cell() >= 9 && cell() <=13 ) return TRUE;
    Category c = category();
    return c >= Separator_Space && c <= Separator_Paragraph;
}

/*!
  Returns whether the character is a mark (Mark_* categories).
*/
bool QChar::isMark() const
{
    Category c = category();
    return c >= Mark_NonSpacing && c <= Mark_Enclosing;
}

/*!
  Returns whether the character is puntuation (Punctuation_* categories).
*/
bool QChar::isPunct() const
{
    Category c = category();
    return (c >= Punctuation_Connector && c <= Punctuation_Other);
}

/*!
  Returns whether the character is a letter (Letter_* categories).
*/
bool QChar::isLetter() const
{
    Category c = category();
    return (c >= Letter_Uppercase && c <= Letter_Other);
}

/*!
  Returns whether the character is a number (of any sort - Number_* categories).

  \sa isDigit()
*/
bool QChar::isNumber() const
{
    Category c = category();
    return c >= Number_DecimalDigit && c <= Number_Other;
}

/*!
  Returns whether the character is a decimal digit (Number_DecimalDigit).
  */
bool QChar::isDigit() const
{
    return (category() == Number_DecimalDigit);
}

/*!
  Returns the numeric value of the digit, or -1 if the character is not
  a digit.
*/
int QChar::digitValue() const
{
    const Q_INT8 *dec_row = decimal_info[row()];
    if( !dec_row ) return -1;
    return decimal_info[row()][cell()];
}

/*!
  Returns the character category.
  See the Unicode Standard for details.
*/
QChar::Category QChar::category() const
{
    return (Category) unicode_info[row()][cell()];
}

/*!
  Returns the characters directionality.
  See the Unicode Standard for details.
*/
QChar::Direction QChar::direction() const
{
  const Q_UINT8 *rowp = direction_info[row()];
  if(!rowp) return QChar::DirL;
  return (Direction) ( *(rowp+cell()) &0xf );
}

/*!
  This function is not supported (it may change to use Unicode
  character classes).

  Returns information about the joining properties of the
  character (needed for arabic).
*/
QChar::Joining QChar::joining() const
{
  const Q_UINT8 *rowp = direction_info[row()];
  if(!rowp) return QChar::OtherJoining;
  return (Joining) ((*(rowp+cell()) >> 4) &0x7);
}


/*!
  Returns whether the character is a mirrored character (one that
  should be reversed if the text direction is reversed).
*/
bool QChar::mirrored() const
{
  const Q_UINT8 *rowp = direction_info[row()];
  if(!rowp) return FALSE;
  return *(rowp+cell())>128;
}

/*!
  Decomposes a character into its parts. Returns QString::null if
  no decomposition exists.
*/
QString QChar::decomposition() const
{
    const Q_UINT16 *r = decomposition_info[row()];
    if(!r) return QString::null;

    Q_UINT16 pos = r[cell()];
    if(!pos) return QString::null;
    pos+=2;

    QString s;
    Q_UINT16 c;
    while((c = decomposition_map[pos++]) != 0) s += QChar(c);

    return s;
}

/*!
  Returns the tag defining the composition of the character.
  Returns QChar::Single if no decomposition exists.
*/
QChar::Decomposition QChar::decompositionTag() const
{
  const Q_UINT16 *r = decomposition_info[row()];
  if(!r) return QChar::Single;

  Q_UINT16 pos = r[cell()];
  if(!pos) return QChar::Single;

  return (QChar::Decomposition) decomposition_map[pos];
}

/*!
  Returns the lowercase equivalent if the character is uppercase,
  or the character itself otherwise.
*/
QChar QChar::lower() const
{
    if(category() != Letter_Uppercase) return *this;
    Q_UINT16 lower = *(case_info[row()]+cell());
    if(lower == 0) return *this;
    return lower;
}

/*!
  Returns the uppercase equivalent if the character is lowercase,
  or the character itself otherwise.
*/
QChar QChar::upper() const
{
    if(category() != Letter_Lowercase) return *this;
    Q_UINT16 upper = *(case_info[row()]+cell());
    if(upper == 0) return *this;
    return upper;
}

/*!
  \fn QChar::operator char() const

  Returns the Latin1 character equivalent to the QChar,
  or 0.  This is mainly useful for non-internationalized software.

  \sa unicode()
*/

/*!
  \fn ushort QChar::unicode() const

  Returns the numeric Unicode value equal to the QChar.  Normally, you
  should use QChar objects as they are equivalent, but for some low-level
  tasks (eg. indexing into an array of Unicode information), this function
  is useful.
*/

// small class used internally in QString::Compose()
class QLigature
{
public:
    QLigature( QChar c );

    Q_UINT16 first() { cur = ligatures; return cur ? *cur : 0; }
    Q_UINT16 next() { return cur && *cur ? *(cur++) : 0; }
    Q_UINT16 current() { return cur ? *cur : 0; }

    int match(QString & str, unsigned int index);
    QChar head();
    QChar::Decomposition tag();

private:
    Q_UINT16 *ligatures;
    Q_UINT16 *cur;
};

QLigature::QLigature( QChar c )
{
    const Q_UINT16 *r = ligature_info[c.row()];
    if( !r )
	ligatures = 0;
    else
    {
	const Q_UINT16 pos = r[c.cell()];
	ligatures = (Q_UINT16 *)&(ligature_map[pos]);
    }
    cur = ligatures;
}

QChar QLigature::head()
{
    if(current())
	return QChar(decomposition_map[current()+1]);

    return QChar::null;
}

QChar::Decomposition QLigature::tag()
{
    if(current())
	return (QChar::Decomposition) decomposition_map[current()];
	
    return QChar::Canonical;
}

int QLigature::match(QString & str, unsigned int index)
{
    unsigned int i=index;
	
    if(!current()) return 0;
	
    Q_UINT16 lig = current() + 2;
    Q_UINT16 ch;

    while ((i < str.length()) && (ch = decomposition_map[lig])) {
	if (str[(int)i] != QChar(ch))
	    return 0;
	i++; lig++;
    }
	
    if (!decomposition_map[lig])
    {
	return i-index;
    }
    return 0;
}

// this function is just used in QString::compose()
static inline QChar::Decomposition format(QChar ch, QString & str,
					  int index, int len)
{
    unsigned int l = index + len;
    unsigned int r = index;

    bool left = FALSE, right = FALSE;

    switch (ch.joining()) {
    case QChar::Dual:
	left = ((l < str.length()) &&
		((str[(int)l].joining() == QChar::Dual) ||
		 (str[(int)l].joining() == QChar::Right)));
	// fall through
    case QChar::Right:
	if (r > 0) {
	    r--;
	    right = (str[(int)r].joining() == QChar::Dual);
	}
	break;
    default:
	break;
    }
	
	
    if (left && right)
	return QChar::Medial;
    if (left)
	return QChar::Initial;
    if (right)
	return QChar::Final;
	
    return QChar::Isolated;
} // format()

/*
  QString::compose() and visual() were developed by Gordon Tisher
  <tisher@uniserve.ca>, with input from Lars Knoll <knoll@mpi-hd.mpg.de>,
  who developed the unicode data tables.
*/
/*!
  Note that this function is not supported in Qt 2.0, and is merely
  for experimental and illustrative purposes.  It is mainly of interest
  to those experimenting with Arabic and other composition-rich texts.

  Applies possible ligatures to a QString, useful when composition-rich
  text requires rendering with glyph-poor fonts, but also
  makes compositions such as QChar(0x0041) ('A') and QChar(0x0308)
  (Unicode accent diaresis) giving QChar(0x00c4) (German A Umlaut).
*/
void QString::compose()
{
    unsigned int index=0, len;

    QChar code, head;

    QArray<QChar> dia;

    while (index < length())
    {
	code = at(index);
	
	QLigature ligature(code);
	ligature.first();
	while(ligature.current())
	{
	    if ((len = ligature.match(*this, index)) != 0)
	    {
		head = ligature.head();

		// joining info is only needed for arabic
		if (!head.joining() ||
		    ligature.tag() == format(head, *this, index, len))
		{
		    // replace letter
		    replace(index, len, QChar(head));
		    break;
		}
	    }
	    ligature.next();
	}
	
	index++;
    }
}

static QChar LRM ((ushort)0x200e);
static QChar RLM ((ushort)0x200f);
static QChar LRE ((ushort)0x202a);
static QChar RLE ((ushort)0x202b);
static QChar RLO ((ushort)0x202e);
static QChar LRO ((ushort)0x202d);
static QChar PDF ((ushort)0x202c);

static inline bool is_arabic(unsigned short x) {
    return (((x >= 0x0600) && (x <= 0x07bf)) ||
	    ((x >= 0xfb50) && (x <= 0xfdff)) ||
	    ((x >= 0xfe70) && (x <= 0xfeff)));
}

static inline bool is_neutral(unsigned short dir) {
  return ((dir == QChar::DirB) ||
		  (dir == QChar::DirS) ||
		  (dir == QChar::DirWS) ||
		  (dir == QChar::DirON));
}

/*!
  This function returns the basic directionality of the string (QChar::DirR for
  right to left and QChar::DirL for left to right). Useful to find the right
  alignment.
  */
QChar::Direction QString::basicDirection()
{
    // find base direction
    unsigned int pos = 0;
    while ((pos < length()) &&
	   (at(pos) != RLE) &&
	   (at(pos) != LRE) &&
	   (at(pos) != RLO) &&
	   (at(pos) != LRO) &&
	   (at(pos).direction() > 1)) // not R and not L
	pos++;
	
    if ((at(pos).direction() == QChar::DirR) ||
	(at(pos) == RLE) ||
	(at(pos) == RLO))
	return QChar::DirR;

    return QChar::DirL;
}

// reverses part of the QChar array to get visual ordering
// called from QString::visual()
//
static unsigned int reverse(QString &chars, unsigned char *level,
		     unsigned int a, unsigned int b)
{
    unsigned int c = a;
    unsigned char lev = level[c];

    while ((c < b) && (level[c] >= lev)) {
	if (level[c] > lev)
	    c = reverse(chars, level, c, b);
	c++;
    }
	
    if (lev > 0) {
	QChar temp;
	unsigned int d = a, e = c-1;
	while (d < e) {
	    temp = chars[(int)d];
	    chars[(int)d] = chars[(int)e];
	    chars[(int)e] = temp;
			
	    d++; e--;
	}
    }

    return c;
}

// small class used for the ordering algorithm in QString::visual()
class QBidiState {
public:
    unsigned char level;
    signed   char override;
	
    QBidiState(unsigned char l, signed char o) : level(l), override(o) {};
};

// matrix for resolving neutral types

#define NEG1 (QChar::Direction)(-1)

static QChar::Direction resolv[5][5] =
{
	{ NEG1,         QChar::DirR, QChar::DirL, QChar::DirEN, QChar::DirAN },
	{ QChar::DirR,  QChar::DirR, NEG1,        QChar::DirR,  QChar::DirR  },
	{ QChar::DirL,  NEG1,        QChar::DirL, QChar::DirL,  NEG1         },
	{ QChar::DirEN, QChar::DirR, QChar::DirL, QChar::DirEN, QChar::DirR  },
	{ QChar::DirAN, QChar::DirR, NEG1,        NEG1,         QChar::DirAN }
};

/*!
  This function returns the QString ordered visually. Useful for
  painting the string or when transforming to a visually ordered
  encoding.
  */
QString QString::visual(int index, int len)
{
    // #### This needs much more optimizing - it is called for
    // #### every text operation.

    unsigned char *level;
    QChar::Direction *dir;
    unsigned char base = 0;

    unsigned int l = length();

    // check bounds
    if (len == -1)
	len = length()-index;
    if ((uint)index > l)
	return QString::null;

    // find base direction
    unsigned int pos = 0;
    while ((pos < length()) &&
	   (at(pos) != RLE) &&
	   (at(pos) != LRE) &&
	   (at(pos) != RLO) &&
	   (at(pos) != LRO) &&
	   (at(pos).direction() > 1)) // not R and not L
	pos++;
	
    if ((pos < length()) &&
	    ((at(pos).direction() == QChar::DirR) ||
	    (at(pos) == RLE) ||
	    (at(pos) == RLO)))
	base = 1;

    // is there any BiDi char at all?
    if ( base == 0 && pos == l ) {
	return mid(index, len);
    }


    level = new uchar[l];
    dir   = new QChar::Direction[l];

    // explicit override pass
    //unsigned int code_count = 0;
	
    QStack<QBidiState> stack;
    stack.setAutoDelete(TRUE);

    unsigned char    clevel   = base;
    signed char      override = -1;

    for (pos = 0; pos < l; pos++) {
		
	if (at(pos) == RLE) {
	    //code_count++;
	    stack.push(new QBidiState(clevel, override));
	    if (clevel < 254)
		clevel += 1 + clevel % 2;
	    override = -1;
	}
	else if (at(pos) == LRE) {
	    //code_count++;
	    stack.push(new QBidiState(clevel, override));
	    if (clevel < 254)
		clevel += 2 - clevel % 2;
	    override = -1;
	}
	else if (at(pos) == RLO) {
	    //code_count++;
	    stack.push(new QBidiState(clevel, override));
	    if (clevel < 254)
		clevel += 1 + clevel % 2;
	    override = QChar::DirR;
	}
	else if (at(pos) == LRO) {
	    //code_count++;
	    stack.push(new QBidiState(clevel, override));
	    if (clevel < 254)
		clevel += 2 - clevel % 2;
	    override = QChar::DirL;
	}
	else if (at(pos) == PDF) {
	    //code_count++;
	    if (!stack.isEmpty()) {
		override = stack.top()->override;
		clevel   = stack.top()->level;
		stack.remove();
	    }
	}

	// TODO: catch block separators (newlines, paras, etc.)

	level[pos] = clevel;
	if (override != -1)
	    dir[pos] = (QChar::Direction) override;
	else
	    dir[pos] = at(pos).direction();
    }
	
    // weak type pass
    for (pos = 0; pos < l; pos++) {

	int i;

	switch (at(pos).direction()) {
	case QChar::DirEN:
	    i   = pos-1;
	    while ((i >= 0) &&
		   !(at(i).direction() == QChar::DirAN) &&
		   !((at(i).direction() == QChar::DirR) &&
		     is_arabic(at(i).unicode())) &&
		   !(at(i).direction() == QChar::DirB))
		i--;
			
	    if ((i >= 0) &&
		((at(i).direction() == QChar::DirAN) ||
		 is_arabic(at(i).unicode())))
		dir[pos] = QChar::DirAN;
			
	    break;
	case QChar::DirES:
	case QChar::DirCS:
	    if ((pos > 0) && (pos < l-1) &&
		(dir[pos-1] == dir[pos+1]))
		dir[pos] = dir[pos-1];
	    else
		dir[pos] = QChar::DirON;
			
	    break;
	case QChar::DirET:
	    if (((pos > 0) && (dir[pos-1] == QChar::DirEN)) ||
		((pos < l-1) && (dir[pos+1] == QChar::DirEN)))
		dir[pos] = QChar::DirEN;
	    else
		dir[pos] = QChar::DirON;
			
	    break;
	default:
	    break;
	}
    }
	
    // neutral type pass
    for (pos = 0; pos < l; pos++) {
	  QChar::Direction left,right; // declaring l here shadowed previous l
		
	if (is_neutral(dir[pos])) {
	    if (pos > 0)
		left = dir[pos-1];
	    else
		left = (base == 0 ? QChar::DirL : QChar::DirR);

	    int i = pos;
			
	    while ((i < (int)l-1) && is_neutral(dir[i+1]))
		i++;
			
	    if (i < (int)l-1)
		right = dir[i+1];
	    else
		right = (base == 0 ? QChar::DirL : QChar::DirR);
			
	    for (int j=pos; j <= i; j++) {
		  int a = 1, b = 1;
		  while ((a < 5) && (left != resolv[0][a]))
			a++;
		  while ((b < 5) && (right != resolv[0][b]))
			b++;
		  if ((a == 5) || (b == 5))
			dir[j] = (base == 0 ? QChar::DirL : QChar::DirR);
		  else
			dir[j] = resolv[a][b];
		
		  if (dir[j] == (QChar::Direction)(-1))
			dir[j] = (base == 0 ? QChar::DirL : QChar::DirR);
	    }
	}
    }
	
    // implicit level pass
    QChar::Direction prec = (base == 0 ? QChar::DirL : QChar::DirR);
	
    for (pos = 0; pos < l; pos++) {
	if (level[pos] % 2) {
	    switch (dir[pos]) {
	    case QChar::DirL:
	    case QChar::DirAN:
	    case QChar::DirEN:
		level[pos] += 1;
		break;
	    default:
		break;
	    }
	} else {
	    switch (dir[pos]) {
	    case QChar::DirL:
				// do nothing
		break;
	    case QChar::DirR:
		level[pos] += 1;
		break;
	    case QChar::DirEN:
		if (prec == QChar::DirL)
		    continue;
				// fall through
	    case QChar::DirAN:
		level[pos] += 2;
		break;
	    default:
		break;
	    }
	}
		
	prec = dir[pos];
    }
	
	// now do the work!
	QString ret(*this);
    reverse(ret, level, index, index+len);

    delete [] level;
    delete [] dir;

    return ret;
}


// These macros are used for efficient allocation of QChar strings.
// IMPORTANT! If you change these, make sure you also change the 
// "delete unicode" statement in ~QStringData() in qstring.h correspondingly!

#define QT_ALLOC_QCHAR_VEC( N ) (QChar*) new char[ 2*( N ) ]
#define QT_DELETE_QCHAR_VEC( P ) delete[] ((char*)( P ))


/*!
  This utility function converts the 8-bit string
  \a ba to Unicode, returning the result.

  The caller is responsible for deleting the return value with delete[].
*/

QChar* QString::asciiToUnicode( const QByteArray& ba, uint* len )
{
    int l = 0;
    while ( l < (int)ba.size() && ba[l] )
	l++;
    char* str = ba.data();
    QChar *uc = new QChar[ l ];	  // Can't use macro, since function is public
    QChar *result = uc;
    if ( len )
	*len = l;
    while (l--)
	*uc++ = *str++;
    return result;
}

static QChar* internalAsciiToUnicode( const QByteArray& ba, uint* len )
{
    int l = 0;
    while ( l < (int)ba.size() && ba[l] )
	l++;
    char* str = ba.data();
    QChar *uc = QT_ALLOC_QCHAR_VEC( l );
    QChar *result = uc;
    if ( len )
	*len = l;
    while (l--)
	*uc++ = *str++;
    return result;
}

/*!
  This utility function converts the NUL-terminated 8-bit string
  \a str to Unicode, returning the result and setting \a len to
  the length of the Unicode string.

  The caller is responsible for deleting the return value with delete[].
*/

QChar* QString::asciiToUnicode( const char *str, uint* len, uint maxlen )
{
    QChar* result = 0;
    uint l = 0;
    if ( str ) {
	if ( maxlen != (uint)-1 ) {
	    while (str[l] && l < maxlen)
		l++;
	} else {
	    // Faster?
	    l = strlen(str);
	}
	QChar *uc = new QChar[ l ]; // Can't use macro since function is public
	result = uc;
	uint i = l;
	while ( i-- )
	    *uc++ = *str++;
    }
    if ( len )
	*len = l;
    return result;
}

static QChar* internalAsciiToUnicode( const char *str, uint* len,
				      uint maxlen = (uint)-1 )
{
    QChar* result = 0;
    uint l = 0;
    if ( str ) {
	if ( maxlen != (uint)-1 ) {
	    while (str[l] && l < maxlen)
		l++;
	} else {
	    // Faster?
	    l = strlen(str);
	}
	QChar *uc = QT_ALLOC_QCHAR_VEC( l );
	result = uc;
	uint i = l;
	while ( i-- )
	    *uc++ = *str++;
    }
    if ( len )
	*len = l;
    return result;
}

/*!
  This utility function converts \a l 16-bit characters from
  \a uc to ASCII, returning a NUL-terminated string.

  The caller is responsible for deleting the string with delete[].
*/
char* QString::unicodeToAscii(const QChar *uc, uint l)
{
    if (!uc) {
	return 0;
    }
    char *a = new char[l+1];
    char *result = a;
    while (l--)
	*a++ = *uc++;
    *a = '\0';
    return result;
}

/*****************************************************************************
  QString member functions
 *****************************************************************************/

/*!
  \class QString qstring.h

  \brief The QString class provides an abstraction of Unicode text and
          the classic C zero-terminated char array (<var>char*</var>).

  \ingroup tools
  \ingroup shared

  QString uses implicit
  \link shclass.html sharing\endlink, and so it is very efficient
  and easy to use.

  In all QString methods that take <var>const char*</var> parameters,
  the <var>const char*</var> is interpreted as a classic C-style
  0-terminated ASCII string. It is legal for the <var>const
  char*</var> parameter to be 0. The results are undefined if the
  <var>const char*</var> string is not 0-terminated. Functions that
  copy classic C strings into a QString will not copy the terminating
  0-character. The QChar array of the QString (as returned by
  unicode()) is not terminated by a null.

  A QString that has not been assigned to anything is \a null, i.e. both
  the length and data pointer is 0. A QString that references the empty
  string ("", a single '\0' char) is \a empty.	Both null and empty
  QStrings are legal parameters to the methods. Assigning <var>const char
  * 0</var> to QString gives a null QString.

  Note that if you find that you are mixing usage of QCString, QString,
  and QByteArray, this causes lots of unnecessary copying and might
  indicate that the true nature of the data you are dealing with is
  uncertain.  If the data is NUL-terminates 8-bit data, use QCString;
  if it is unterminated (ie. contains NULs) 8-bit daya, use QByteArray;
  if it is text, use QString.

  \sa \link shclass.html Shared classes\endlink
*/

Q_EXPORT QStringData *QString::shared_null = 0;
QT_STATIC_CONST_IMPL QString QString::null;
QT_STATIC_CONST_IMPL QChar QChar::null;
QT_STATIC_CONST_IMPL QChar QChar::replacement((ushort)0xfffd);
QT_STATIC_CONST_IMPL QChar QChar::byteOrderMark((ushort)0xfeff);
QT_STATIC_CONST_IMPL QChar QChar::byteOrderSwapped((ushort)0xfffe);

QStringData* QString::makeSharedNull()
{
    return shared_null=new QStringData;
}

// Uncomment this to get some useful statistics.
// #define Q2HELPER(x) x

#ifdef Q2HELPER
static int stat_construct_charstar=0;
static int stat_construct_charstar_size=0;
static int stat_construct_null=0;
static int stat_construct_int=0;
static int stat_construct_int_size=0;
static int stat_construct_ba=0;
static int stat_get_ascii=0;
static int stat_get_ascii_size=0;
static int stat_copy_on_write=0;
static int stat_copy_on_write_size=0;
static int stat_fast_copy=0;
void Q_EXPORT qt_qstring_stats()
{
	qDebug("construct_charstar = %d (%d chars)", stat_construct_charstar, stat_construct_charstar_size);
	qDebug("construct_null = %d", stat_construct_null);
	qDebug("construct_int = %d (%d chars)", stat_construct_int, stat_construct_int_size);
	qDebug("construct_ba = %d", stat_construct_ba);
	qDebug("get_ascii = %d (%d chars)", stat_get_ascii, stat_get_ascii_size);
	qDebug("copy_on_write = %d (%d chars)", stat_copy_on_write, stat_copy_on_write_size);
	qDebug("fast_copy = %d", stat_fast_copy);
}
#else
#define Q2HELPER(x)
#endif

/*!
  \fn QString::QString()

  Constructs a null string.
  \sa isNull()
*/

/*!
  Constructs a string containing the one character \a ch.
*/
QString::QString( QChar ch )
{
    d = new QStringData( QT_ALLOC_QCHAR_VEC( 1 ), 1, 1 );
    d->unicode[0] = ch;
}

/*!
  Constructs an implicitly-shared copy of \a s.
*/
QString::QString( const QString &s ) :
    d(s.d)
{
    Q2HELPER(stat_fast_copy++);
    d->ref();
}

/*!
  Private function.

  Constructs a string with preallocated space for \a size characters.

  The string is empty.

  \sa isNull()
*/

QString::QString( int size, bool /*dummy*/ )
{
    if ( size ) {
	Q2HELPER(stat_construct_int++);
	int l = size;
	Q2HELPER(stat_construct_int_size+=l);
	QChar* uc = QT_ALLOC_QCHAR_VEC( l );
	d = new QStringData( uc, 0, l );
    } else {
	Q2HELPER(stat_construct_null++);
	d = shared_null ? shared_null : shared_null=new QStringData;
	d->ref();
    }
}

/*!
  Constructs a string that is a deep copy of \a ba interpreted as
  a classic C string.
*/

QString::QString( const QByteArray& ba )
{
    Q2HELPER(stat_construct_ba++);
    uint l;
    QChar *uc = internalAsciiToUnicode(ba,&l);
    d = new QStringData(uc,l,l);
}

/*!
  Constructs a string that is a deep copy of the
  first \a length QChar in the array \a unicode.

  \sa QString::make()
*/

QString::QString( const QChar* unicode, uint length )
{
  if ( !unicode ) {
    d = shared_null ? shared_null : makeSharedNull();
  }
  else {
    QChar* uc = QT_ALLOC_QCHAR_VEC( length );
    memcpy(uc, unicode, length*sizeof(QChar));
    d = new QStringData(uc,length,length);
  }
}

/*!
  Constructs a string that is a deep copy of \a str, interpreted as a
  classic C string.

  If \a str is 0 a null string is created.

  This is a cast constructor, but it is perfectly safe: converting a Latin1
  const char* to QString preserves all the information.
  You can disable this constructor by
  defining QT_NO_CAST_ASCII when you compile your applications.
  You can also make QString objects by using fromLatin1(), or
  fromLocal8Bit(), fromUtf8(), or whatever encoding is appropriate for
  the 8-bit data you have.

  \sa isNull()
*/

QString::QString( const char *str )
{
    Q2HELPER(stat_construct_charstar++);
    uint l;
    QChar *uc = internalAsciiToUnicode(str,&l);
    Q2HELPER(stat_construct_charstar_size+=l);
    d = new QStringData(uc,l,l);
}


/*!
  Deallocates any space reserved solely by this QString.
*/

void QString::real_detach()
{
    setLength( length() );
}

void QString::deref()
{
    if ( d->deref() ) {
	delete d;
	d = 0; // helps debugging
    }
}

void QStringData::deleteSelf()
{
    delete this;
}

/*!
  \fn QString& QString::operator=( QChar c )
  Sets the string to contain just the single character \a c.
*/

/*!
  \fn QString& QString::operator=( char c )
  Sets the string to contain just the single character \a c.
*/

/*!
  Assigns a shallow copy of \a s to this string and returns a
  reference to this string.
*/
QString &QString::operator=( const QString &s )
{
    Q2HELPER(stat_fast_copy++);
    s.d->ref();
    deref();
    d = s.d;
    return *this;
}

/*!
  Assigns a deep copy of \a cs, interpretted a classic C string, to
  this string and returns a reference to this string.
*/
QString &QString::operator=( const QCString& cs )
{
    deref();
    uint l;
    QChar *uc = internalAsciiToUnicode(cs,&l);
    d = new QStringData(uc,l,l);
    return *this;
}


/*!
  Assigns a deep copy of \a str, interpretted a classic C string to
  this string and returns a reference to this string.

  If \a str is 0 a null string is created.

  \sa isNull()
*/
QString &QString::operator=( const char *str )
{
    deref();
    uint l;
    QChar *uc = internalAsciiToUnicode(str,&l);
    d = new QStringData(uc,l,l);
    return *this;
}


/*!
  \fn bool QString::isNull() const

  Returns TRUE if the string is null.
  A null string is also an empty string.

  Example:
  \code
    QString a;		// a.unicode() == 0,  a.length() == 0
    QString b == "";	// b.unicode() == "", b.length() == 0
    a.isNull();		// TRUE, because a.unicode() == 0
    a.isEmpty();	// TRUE, because a.length() == 0
    b.isNull();		// FALSE, because b.unicode() != 0
    b.isEmpty();	// TRUE, because b.length() == 0
  \endcode

  \sa isEmpty(), length()
*/

/*!
  \fn bool QString::isEmpty() const

  Returns TRUE if the string is empty, i.e. if length() == 0.
  An empty string is not always a null string.

  See example in isNull().

  \sa isNull(), length()
*/

/*!
  \fn uint QString::length() const

  Returns the length of the string.

  Null strings and empty strings have zero length.

  \sa isNull(), isEmpty()
*/

/*!
  Truncates the string at position \a newLen. If newLen is less than the
  current length, this is equivalent to setLength( newLen ). Otherwise,
  nothing happens.

  Example:
  \code
    QString s = "truncate this string";
    s.truncate( 5 );				// s == "trunc"
  \endcode

  In Qt 1.x, it was possible to "truncate" a string to a longer
  length.  This is no longer possible.

  \sa setLength()
*/

void QString::truncate( uint newLen )
{
    if ( newLen < d->len )
	setLength( newLen );
}

/*!
  Ensures that at least \a newLen characters are allocated, and sets the
  length to \a newLen. Will detach. New space is \e not defined.

  If \a newLen is 0, this string becomes empty, unless this string is null,
  in which case it remains null.

  \sa truncate(), isNull(), isEmpty()
*/

void QString::setLength( uint newLen )
{
    if ( d->count != 1 || newLen > d->maxl || 		// detach, grow, or
	 ( newLen*4 < d->maxl && d->maxl > 4 ) ) {	// shrink
	Q2HELPER(stat_copy_on_write++);
	Q2HELPER(stat_copy_on_write_size+=d->len);
	uint newMax = 4;
	while ( newMax < newLen )
	    newMax *= 2;
	QChar* nd = QT_ALLOC_QCHAR_VEC( newMax );
	uint len = QMIN( d->len, newLen );
	if ( d->unicode )
	    memcpy( nd, d->unicode, sizeof(QChar)*len );
	deref();
	d = new QStringData( nd, newLen, newMax );
    } else {
	d->len = newLen;
	d->dirtyascii = 1;
    }
}

/*!
  Returns a string equal to this one, but with the first
  occurrence of <tt>%<em>digit</em></tt> replaced by the
  text \a a.  This is particularly useful for translations,
  as it allows the order of the replacements to be controlled by the
  translator.  For example:

  \code
    label.setText( tr("I have %1 to your %2").arg(mine).arg(yours) );
  \endcode

  If there is no <tt>%<em>digit</em></tt> pattern, a warning message
  (qWarning()) is printed and the text as appended with a space at the
  end of the string.  This is error-recovery and should not be occur
  in correct code.

  \a fieldwidth is the minimum amount of space the text will be padded
  to.  A positive value produces right-aligned text, while a negative
  value produces left aligned text.

  \sa QObject::tr()
*/
QString QString::arg(const QString& a, int fieldwidth) const
{
    int pos, len;
    QString r = *this;

    if ( !findArg(pos,len) ) {
	qWarning("Argument missing");
	// Make sure the text at least appears SOMEWHERE
	r += ' ';
	pos = r.length();
	len = 0;
    }

    r.replace(pos,len,a);
    if ( fieldwidth < 0 ) {
	QString s;
	while ( (uint)-fieldwidth > a.length() ) {
	    s += ' ';
	    fieldwidth++;
	}
	r.insert(pos+a.length(),s);
    } else if ( fieldwidth ) {
	QString s;
	while ( (uint)fieldwidth > a.length() ) {
	    s += ' ';
	    fieldwidth--;
	}
	r.insert(pos,s);

    }
    return r;
}

/*!
  Returns a string equal to this one, but with the first
  occurrence of <tt>%<em>digit</em></tt> replaced by the
  integer value \a in base \a base (defaults to decimal).

  The value is converted to \a base notation (default is decimal).
  The base must be a value from 2 to 36.

  See arg(const QString&,int) for more details.
*/
QString QString::arg(long a, int fieldwidth, int base) const
{
    QString n;
    n.setNum(a,base);
    return arg(n,fieldwidth);
}

/*!
  Returns a string equal to this one, but with the first
  occurrence of <tt>%<em>digit</em></tt> replaced by the
  unsigned integer value \a in base \a base (defaults to decimal).

  The value is converted to \a base notation (default is decimal).
  The base must be a value from 2 to 36.

  See arg(const QString&,int) for more details.
*/
QString QString::arg(ulong a, int fieldwidth, int base) const
{
    QString n;
    n.setNum(a,base);
    return arg(n,fieldwidth);
}

/*!
  \fn QString QString::arg(int a, int fieldwidth, int base) const

  See QString::arg(long a, int fieldwidth, int base).
*/

/*!
  \fn QString QString::arg(uint a, int fieldwidth, int base) const

  See QString::arg(ulong a, int fieldwidth, int base).
*/

/*!
  \fn QString QString::arg(short a, int fieldwidth, int base) const

  See QString::arg(long a, int fieldwidth, int base).
*/

/*!
  \fn QString QString::arg(ushort a, int fieldwidth, int base) const

  See QString::arg(ulong a, int fieldwidth, int base).
*/


/*!
  Returns a string equal to this one, but with the first
  occurrence of <tt>%<em>digit</em></tt> replaced by the
  character \a a.

  See arg(const QString&,int) for more details.
*/
QString QString::arg(char a, int fieldwidth) const
{
    QString c;
    c += a;
    return arg(c,fieldwidth);
}

/*!
  Returns a string equal to this one, but with the first
  occurrence of <tt>%<em>digit</em></tt> replaced by the
  character \a a.

  See arg(const QString&,int) for more details.
*/
QString QString::arg(QChar a, int fieldwidth) const
{
    QString c;
    c += a;
    return arg(c,fieldwidth);
}

/*!
  Returns a string equal to this one, but with the first
  occurrence of <tt>%<em>digit</em></tt> replaced by the
  value \a a.

  See arg(const QString&,int) for more details.
*/
QString QString::arg(double a, int fieldwidth, char fmt, int prec) const
{
    QString dec;
    dec.setNum(a,fmt,prec);
    return arg(dec,fieldwidth);
}


/*!
  Just 1-digit arguments.
*/
bool QString::findArg(int& pos, int& len) const
{
    char lowest=0;
    for (uint i=0; i<length(); i++) {
	if ( at(i) == '%' && i+1<length() ) {
	    char dig = at(i+1);
	    if ( dig >= '0' && dig <= '9' ) {
		if ( !lowest || dig < lowest ) {
		    lowest = dig;
		    pos = i;
		    len = 2;
		}
	    }
	}
    }
    return lowest != 0;
}

/*!
  Safely builds a formatted string from a format string and an
  arbitrary list of arguments.  The format string supports all
  the escape sequences of printf() in the standard C library.

  The %s escape sequence expects a
  \link utf8() UTF-8\endlink encoded string.
  For typesafe string building,
  with full Unicode support, you can use QTextOStream like this:

  \code
    QString str;
    QString s = ...;
    int x = ...;
    QTextOStream(&str) << s << " : " << x;
  \endcode

  For \link QObject::tr() translations,\endlink especially if the
  strings contains more than one escape sequence, you should consider
  using the arg() function instead.  This allows the order of the
  replacements to be controlled by the translator, and has Unicode
  support.

  \sa arg(const QString&,int)
*/

QString &QString::sprintf( const char* cformat, ... )
{
    va_list ap;
    va_start( ap, cformat );

    if ( !cformat ) {
	// Qt 1.x compat
	*this = QString::fromLatin1("");
	return *this;
    }
    QString format = QString::fromLatin1(cformat);

    static QRegExp escape(
	QString::fromLatin1("%#?0?-? ?\\+?'?[0-9*]*\\.?[0-9*]*h?l?L?q?Z?"));

    QString result;
    uint last=0;

    int len=0;
    int pos;
    while ( 1 ) {
	pos=escape.match( format, last, &len );
	// Non-escaped text
	if ( pos > (int)last ) {
	    result += format.mid(last,pos-last);
//debug("%d UNESCAPED from %d = %s",pos-last,last,format.mid(last,pos-last).latin1());
	}
	if ( pos < 0 ) {
	    // The rest
//debug("THE REST = %s",format.mid(last).latin1());
	    if ( last < format.length() )
		result += format.mid(last);
	    break;
	}
	last = pos + len + 1;

	// Escape
	QString f = format.mid(pos,len);
//debug("fmt=%s",f.latin1());
	uint width, decimals;
	int params=0;
	int wpos = f.find('*');
	if ( wpos >= 0 ) {
	    params++;
	    width = va_arg(ap, int);
//debug("pwidth=%d",width);
	    if ( f.find('*',wpos+1) >= 0 ) {
		decimals = va_arg(ap, int);
//debug("pdec=%d",decimals);
		params++;
	    } else {
		decimals = 0;
	    }
	} else {
	    decimals = width = 0;
	}
	QString replacement;
	if ( format[pos+len] == 's' ||
	     format[pos+len] == 'S' ||
	     format[pos+len] == 'c' )
	{
	    bool rightjust = ( f.find('-') < 0 );
	    // Yes, %-5s really means left adjust in sprintf
//if ( rightjust ) debug("rightjust");

	    if ( wpos < 0 ) {
		QRegExp num(QString::fromLatin1("[0-9]+"));
		int nlen;
		int p = num.match(f,0,&nlen);
		if ( p >= 0 ) {
		    width = f.mid(p,nlen).toInt();
		    /* not used
		    p = num.match(f,p+1,&nlen);
		    if ( p >= 0 ) {
			decimals = f.mid(p,nlen).toInt();
		    }
		    */
		}
	    }

	    if ( format[pos+len] == 's' ) {
		QString s = QString::fromUtf8(va_arg(ap, char*));
		replacement = s;
	    } else {
		int ch = va_arg(ap, int);
		replacement = QChar((ushort)ch);
	    }
	    if ( replacement.length() < width ) {
		replacement = rightjust
		    ? replacement.rightJustify(width)
		    : replacement.leftJustify(width);
	    }
//debug("rep=%s",replacement.latin1());
	} else if ( format[pos+len] == '%' ) {
	    replacement = '%';
	} else if ( format[pos+len] == 'n' ) {
	    int* n = va_arg(ap, int*);
	    *n = result.length();
	} else {
	    char in[64], out[128];
	    strncpy(in,f.latin1(),63);
	    char fch = format[pos+len].latin1();
	    in[f.length()] = fch;
	    switch ( fch ) {
	      case 'd': case 'i': case 'o': case 'u': case 'x': case 'X': {
		int value = va_arg(ap, int);
		switch (params) {
		  case 0: ::sprintf( out, in, value ); break;
		  case 1: ::sprintf( out, in, width, value ); break;
		  case 2: ::sprintf( out, in, width, decimals, value ); break;
		}
	      } break;
	      case 'e': case 'E': case 'f': case 'g': {
		double value = va_arg(ap, double);
		switch (params) {
		  case 0: ::sprintf( out, in, value ); break;
		  case 1: ::sprintf( out, in, width, value ); break;
		  case 2: ::sprintf( out, in, width, decimals, value ); break;
		}
	      } break;
	      case 'p': {
		void* value = va_arg(ap, void*);
		switch (params) {
		  case 0: ::sprintf( out, in, value ); break;
		  case 1: ::sprintf( out, in, width, value ); break;
		  case 2: ::sprintf( out, in, width, decimals, value ); break;
		}
	      } break;
	    }
//debug("  %s -> %s",in,out);
	    replacement = QString::fromLatin1(out);
	}
//debug("%s%c -> %s",f.latin1(),(char)format[pos+len],replacement.latin1());
	result += replacement;
//debug("now %s",result.latin1());
    }
    *this = result;

    va_end( ap );
    return *this;
}

/*!
  Fills the string with \a len characters of value \a c.

  If \a len is negative, the current string length is used.
*/

void QString::fill( QChar c, int len )
{
    if ( len < 0 )
	len = length();
    if ( len == 0 ) {
	*this = "";
    } else {
	deref();
	QChar * nd = QT_ALLOC_QCHAR_VEC( len );
	d = new QStringData(nd,len,len);
	while (len--) *nd++ = c;
    }
}


/*!
  \fn QString QString::copy() const

  \obsolete

  Returns a deep copy of this string.

  Doing this is redundant in Qt 2.x, since QString is implicitly
  shared, and so will automatically be deeply copied as necessary.
*/

/*!
  Finds the first occurrence of the character \a c, starting at
  position \a index.

  The search is case sensitive if \a cs is TRUE, or case insensitive
  if \a cs is FALSE.

  Returns the position of \a c, or -1 if \a c could not be found.
*/

int QString::find( QChar c, int index, bool cs ) const
{
    if ( (uint)index >= length() )		// index outside string
	return -1;
    register const QChar *uc;
    uc = unicode()+index;
    int n = length()-index;
    if ( cs ) {
	while ( n-- && *uc != c )
	    uc++;
    } else {
	c = c.lower();
	while ( n-- && uc->lower() != c )
	    uc++;
    }
    if ( uint(uc - unicode()) >= length() )
	return -1;
    return (int)(uc - unicode());
}

/*!
  Finds the first occurrence of the string \a str, starting at position
  \a index.

  The search is case sensitive if \a cs is TRUE, or case insensitive if \a
  cs is FALSE.

  Returns the position of \a str, or -1 if \a str could not be found.
*/

int QString::find( const QString& str, int index, bool cs ) const
{
    if ( (uint)index >= length() )		// index outside string
	return -1;
    register const QChar *uc;
    uc = unicode()+index;
    uint n = length()-index+1;
    uint strl = str.length();
    if ( cs ) {
	while ( n-- > strl && ucstrncmp(uc,str.d->unicode,strl) )
	    uc++;
    } else {
	while ( n-- > strl && ucstrnicmp(uc,str.d->unicode,strl) )
	    uc++;
    }
    return uc - unicode() <= int(length()-strl) ? int(uc - unicode()) : -1;
}

/*!
  \fn int QString::findRev( const char* str, int index ) const

  Equivalent to findRev(QString(str), index).
*/

/*!
  \fn int QString::find( const char* str, int index ) const

  Equivalent to find(QString(str), index).
*/

/*!
  Finds the first occurrence of the character \a c, starting at
  position \a index and searching backwards. If \a index is negative,
  the search starts at the end.

  The search is case sensitive if \a cs is TRUE, or case insensitive if \a
  cs is FALSE.

  Returns the position of \a c, or -1 if \a c could not be found.
*/

int QString::findRev( QChar c, int index, bool cs ) const
{
    QString t( c );
    return findRev( t, index, cs );
}

/*!
  Finds the first occurrence of the string \a str, starting at
  position \a index and searching backwards. If \a index is negative,
  the search starts at the end.

  The search is case sensitive if \a cs is TRUE, or case insensitive if \e
  cs is FALSE.

  Returns the position of \a str, or -1 if \a str could not be found.
*/

int QString::findRev( const QString& str, int index, bool cs ) const
{
    uint slen = str.length();
    if ( !slen )
	return index;
    if ( index < 0 )				// neg index ==> start from end
	index = length()-slen;
    else if ( (uint)index > length() )		// bad index
	return -1;
    else if ( (uint)index == length() )		// bad index, but accept it
	index--;
    else if ( (uint)(index + slen) > length() ) // str would be too long
	index = length() - slen;
    if ( index < 0 )
	return -1;

    register const QChar *uc = unicode() + index;
    if ( cs ) {					// case sensitive
	for ( int i=index; i>=0; i-- )
	    if ( ucstrncmp(uc--,str.unicode(),slen)==0 )
		return i;
    } else {					// case insensitive
	for ( int i=index; i>=0; i-- )
	    if ( ucstrnicmp(uc--,str.unicode(),slen)==0 )
		return i;
    }
    return -1;
}


/*!
  Returns the number of times the character \a c occurs in the string.

  The match is case sensitive if \a cs is TRUE, or case insensitive if \a cs
  if FALSE.
*/

int QString::contains( QChar c, bool cs ) const
{
    int count = 0;
    const QChar *uc = unicode();
    if ( !uc )
	return 0;
    int n = length();
    if ( cs ) {					// case sensitive
	while ( n-- )
	    if ( *uc++ == c )
		count++;
    } else {					// case insensitive
	c = c.lower();
	while ( n-- ) {
	    if ( uc->lower() == c )
		count++;
	    uc++;
	}
    }
    return count;
}

/*!
  \overload
*/
int QString::contains( const char* str, bool cs ) const
{
    return contains(QString(str),cs);
}

/*!
  \overload int QString::contains (char c, bool cs) const
*/

/*!
  \overload int QString::find (char c, int index, bool cs) const

*/

/*!
  \overload int QString::findRev (char c, int index, bool cs) const

*/

/*!
  Returns the number of times \a str occurs in the string.

  The match is case sensitive if \a cs is TRUE, or case insensitive if \e
  cs if FALSE.

  This function counts overlapping substrings, for example, "banana"
  contains two occurrences of "ana".

  \sa findRev()
*/

int QString::contains( const QString &str, bool cs ) const
{
    int count = 0;
    const QChar *uc = unicode();
    if ( !uc )
	return 0;
    int len = str.length();
    int n = length();
    while ( n-- ) {				// counts overlapping strings
	// ### Doesn't account for length of this - searches over "end"
	if ( cs ) {
	    if ( ucstrncmp( uc, str.unicode(), len ) == 0 )
		count++;
	} else {
	    if ( ucstrnicmp(uc, str.unicode(), len) == 0 )
		count++;
	}
	uc++;
    }
    return count;
}

/*!
  Returns a substring that contains the \a len leftmost characters
  of the string.

  The whole string is returned if \a len exceeds the length of the
  string.


  Example:
  \code
    QString s = "Pineapple";
    QString t = s.left( 4 );			// t == "Pine"
  \endcode

  \sa right(), mid(), isEmpty()
*/

QString QString::left( uint len ) const
{
    if ( isEmpty() ) {
	return QString();
    } else if ( len == 0 ) {			// ## just for 1.x compat:
	return QString::fromLatin1("");
    } else if ( len > length() ) {
	return *this;
    } else {
	QString s( len, TRUE );
	memcpy( s.d->unicode, d->unicode, len*sizeof(QChar) );
	s.d->len = len;
	return s;
    }
}

/*!
  Returns a substring that contains the \a len rightmost characters
  of the string.

  The whole string is returned if \a len exceeds the length of the
  string.

  Example:
  \code
    QString s = "Pineapple";
    QString t = s.right( 5 );			// t == "apple"
  \endcode

  \sa left(), mid(), isEmpty()
*/

QString QString::right( uint len ) const
{
    if ( isEmpty() || len == 0 ) {
	return QString();
    } else {
	uint l = length();
	if ( len > l )
	    len = l;
	QString s( len, TRUE );
	memcpy( s.d->unicode, d->unicode+(l-len), len*sizeof(QChar) );
	s.d->len = len;
	return s;
    }
}

/*!
  Returns a substring that contains the \a len characters of this
  string, starting at position \a index.

  Returns a null string if the string is empty or \a index is out
  of range.  Returns the whole string from \a index if \a index+len exceeds
  the length of the string.

  Example:
  \code
    QString s = "Two pineapples";
    QString t = s.mid( 4, 4 );			// t == "pine"
  \endcode

  \sa left(), right()
*/

QString QString::mid( uint index, uint len ) const
{
    uint slen = length();
    if ( isEmpty() || index >= slen || len == 0 ) {
	return QString();
    } else {
	if ( len > slen-index )
	    len = slen - index;
	if ( index == 0 && len == length() )
	    return *this;
	register const QChar *p = unicode()+index;
	QString s( len, TRUE );
	memcpy( s.d->unicode, p, len*sizeof(QChar) );
	s.d->len = len;
	return s;
    }
}

/*!
  Returns a string of length \a width that contains this
  string and padded by the \a fill character.

  If the length of the string exceeds \a width and \a truncate is FALSE,
  then the returned string is a copy of the string.
  If the length of the string exceeds \a width and \a truncate is TRUE,
  then the returned string is a left(\a width).

  Example:
  \code
    QString s("apple");
    QString t = s.leftJustify(8, '.');		// t == "apple..."
  \endcode

  \sa rightJustify()
*/

QString QString::leftJustify( uint width, QChar fill, bool truncate ) const
{
    QString result;
    int len = length();
    int padlen = width - len;
    if ( padlen > 0 ) {
	result.setLength(len+padlen);
	if ( len )
	    memcpy( result.d->unicode, unicode(), sizeof(QChar)*len );
	QChar* uc = result.d->unicode + len;
	while (padlen--)
	    *uc++ = fill;
    } else {
	if ( truncate )
	    result = left( width );
	else
	    result = *this;
    }
    return result;
}

/*!
  Returns a string of length \a width that contains pad
  characters followed by the string.

  If the length of the string exceeds \a width and \a truncate is FALSE,
  then the returned string is a copy of the string.
  If the length of the string exceeds \a width and \a truncate is TRUE,
  then the returned string is a left(\a width).

  Example:
  \code
    QString s("pie");
    QString t = s.rightJustify(8, '.');		// t == ".....pie"
  \endcode

  \sa leftJustify()
*/

QString QString::rightJustify( uint width, QChar fill, bool truncate ) const
{
    QString result;
    int len = length();
    int padlen = width - len;
    if ( padlen > 0 ) {
	result.setLength( len+padlen );
	QChar* uc = result.d->unicode;
	while (padlen--)
	    *uc++ = fill;
	if ( len )
	    memcpy( uc, unicode(), sizeof(QChar)*len );
    } else {
	if ( truncate )
	    result = left( width );
	else
	    result = *this;
    }
    return result;
}

/*!
  Returns a new string that is the string converted to lower case.

  Example:
  \code
    QString s("TeX");
    QString t = s.lower();			// t == "tex"
  \endcode

  \sa upper()
*/

QString QString::lower() const
{
    QString s(*this);
    int l=length();
    s.real_detach(); // could do this only when we find a change
    register QChar *p=s.d->unicode;
    if ( p ) {
	while ( l-- ) {
	    *p = p->lower();
	    p++;
	}
    }
    return s;
}

/*!
  Returns a new string that is the string converted to upper case.

  Example:
  \code
    QString s("TeX");
    QString t = s.upper();			// t == "TEX"
  \endcode

  \sa lower()
*/

QString QString::upper() const
{
    QString s(*this);
    int l=length();
    s.real_detach(); // could do this only when we find a change
    register QChar *p=s.d->unicode;
    if ( p ) {
	while ( l-- ) {
	    *p = p->upper();
	    p++;
	}
    }
    return s;
}


/*!
  Returns a new string that has white space removed from the start and the end.

  White space means any character for which QChar::isSpace() returns
  TRUE. This includes ASCII characters 9 (TAB), 10 (LF), 11 (VT), 12
  (FF), 13 (CR), and 32 (Space).

  Example:
  \code
    QString s = " space ";
    QString t = s.stripWhiteSpace();		// t == "space"
  \endcode

  \sa simplifyWhiteSpace()
*/

QString QString::stripWhiteSpace() const
{
    if ( isEmpty() )				// nothing to do
	return *this;
    if ( !at(0).isSpace() && !at(length()-1).isSpace() )
	return *this;

    register const QChar *s = unicode();
    QString result;

    int start = 0;
    int end = length() - 1;
    while ( start<=end && s[start].isSpace() )	// skip white space from start
	start++;
    if ( start > end ) {			// only white space
	return result;
    }
    while ( end && s[end].isSpace() )		// skip white space from end
	end--;
    int l = end - start + 1;
    result.setLength( l );
    if ( l )
	memcpy( result.d->unicode, &s[start], sizeof(QChar)*l );
    return result;
}


/*!
  Returns a new string that has white space removed from the start and the end,
  plus any sequence of internal white space replaced with a single space
  (ASCII 32).

  White space means any character for which QChar::isSpace() returns
  TRUE. This includes ASCII characters 9 (TAB), 10 (LF), 11 (VT), 12
  (FF), 13 (CR), and 32 (Space).

  \code
    QString s = "  lots\t of\nwhite    space ";
    QString t = s.simplifyWhiteSpace();		// t == "lots of white space"
  \endcode

  \sa stripWhiteSpace()
*/

QString QString::simplifyWhiteSpace() const
{
    if ( isEmpty() )				// nothing to do
	return *this;
    QString result;
    result.setLength( length() );
    const QChar *from = unicode();
    const QChar *fromend = from+length();
    int outc=0;
    QChar *to	= result.d->unicode;
    while ( TRUE ) {
	while ( from!=fromend && from->isSpace() )
	    from++;
	while ( from!=fromend && !from->isSpace() )
	    to[outc++] = *from++;
	if ( from!=fromend )
	    to[outc++] = ' ';
	else
	    break;
    }
    if ( outc > 0 && to[outc-1] == ' ' )
	outc--;
    result.truncate( outc );
    return result;
}


/*!
  Insert \a s into the string before position \a index.

  If \a index is beyond the end of the string, the string is extended with
  spaces (ASCII 32) to length \a index and \a s is then appended.

  \code
    QString s = "I like fish";
    s.insert( 2, "don't ");			// s == "I don't like fish"
    s = "x";
    s.insert( 3, "yz" );			// s == "x  yz"
  \endcode
*/

QString &QString::insert( uint index, const QString &s )
{
    // the sub function takes care of &s == this case.
    return insert( index, s.unicode(), s.length() );
}

/*!
  Insert \a len units of QChar data from \a s into the string before
  position \a index.
*/

QString &QString::insert( uint index, const QChar* s, uint len )
{
    if ( len == 0 )
	return *this;
    uint olen = length();
    int nlen = olen + len;

    int df = d->unicode - s;
    if ( df >= 0 && (uint)df < d->maxl ) {
	// Part of me - take a copy.
	QChar *tmp = QT_ALLOC_QCHAR_VEC( len );
	memcpy(tmp,s,len*sizeof(QChar));
	insert(index,tmp,len);
	QT_DELETE_QCHAR_VEC( tmp );
	return *this;
    }

    if ( index >= olen ) {			// insert after end of string
	setLength( nlen+index-olen );
	int n = index-olen;
	QChar* uc = d->unicode+olen;
	while (n--)
	    *uc++ = ' ';
	memcpy( d->unicode+index, s, sizeof(QChar)*len );
    } else {					// normal insert
	setLength( nlen );
	memmove( d->unicode+index+len, unicode()+index,
		 sizeof(QChar)*(olen-index) );
	memcpy( d->unicode+index, s, sizeof(QChar)*len );
    }
    return *this;
}

/*!
  Insert \a c into the string at (before) position \a index and returns
  a reference to the string.

  If \a index is beyond the end of the string, the string is extended with
  spaces (ASCII 32) to length \a index and \a c is then appended.

  Example:
  \code
    QString s = "Ys";
    s.insert( 1, 'e' );				// s == "Yes"
    s.insert( 3, '!');				// s == "Yes!"
  \endcode

  \sa remove(), replace()
*/

QString &QString::insert( uint index, QChar c )	// insert char
{
    QString s( c );
    return insert( index, s );
}

/*!
  \overload QString& QString::insert( uint index, char c )
*/

/*!
  \fn QString &QString::prepend( const QString &s )

  Prepend \a s to the string. Equivalent to insert(0,s).

  \sa insert()
*/

/*!
  \fn QString& QString::prepend( char ch )
  Prepends \a ch to the string and returns a reference to the result.

  \sa insert()
 */


/*!
  Removes \a len characters starting at position \a index from the
  string and returns a reference to the string.

  If \a index is too big, nothing happens.  If \a index is valid, but
  \a len is too large, the rest of the string is removed.

  \code
    QString s = "Montreal";
    s.remove( 1, 4 );
    // s == "Meal"
  \endcode

  \sa insert(), replace()
*/

QString &QString::remove( uint index, uint len )
{
    uint olen = length();
    if ( index + len >= olen ) {		// range problems
	if ( index < olen ) {			// index ok
	    setLength( index );
	}
    } else if ( len != 0 ) {
	real_detach();
	memmove( d->unicode+index, d->unicode+index+len,
		 sizeof(QChar)*(olen-index-len) );
	setLength( olen-len );
    }
    return *this;
}

/*!
  Replaces \a len characters starting at position \a index from the
  string with \a s, and returns a reference to the string.

  If \a index is too big, nothing is deleted and \a s is inserted at the
  end of the string.  If \a index is valid, but \a len is too large, \e
  str replaces the rest of the string.

  \code
    QString s = "Say yes!";
    s.replace( 4, 3, "NO" );			// s == "Say NO!"
  \endcode

  \sa insert(), remove()
*/

QString &QString::replace( uint index, uint len, const QString &s )
{
    return replace( index, len, s.unicode(), s.length() );
}


/*!
  Replaces \a len characters starting at position \a index by
  \a slen units ot QChar data from \a s, and returns a reference to the string.

  \sa insert(), remove()
*/

QString &QString::replace( uint index, uint len, const QChar* s, uint slen )
{
    if ( len == slen && index + len <= length() ) {
	// Optimized common case: replace without size change
	real_detach();
	memcpy( d->unicode+index, s, len*sizeof(QChar) );
    } else {
	int df = d->unicode - s;
	if ( df >= 0 && (uint)df < d->maxl ) {
	    // Part of me - take a copy.
	    QChar *tmp = QT_ALLOC_QCHAR_VEC( slen );
	    memcpy(tmp,s,slen*sizeof(QChar));
	    replace(index,len,tmp,slen);
	    QT_DELETE_QCHAR_VEC( tmp );
	    return *this;
	}

	remove( index, len );
	insert( index, s, slen );
    }
    return *this;
}



/*!
  Finds the first occurrence of the regular expression \a rx, starting at
  position \a index.

  Returns the position of the next match, or -1 if \a rx was not found.
*/

int QString::find( const QRegExp &rx, int index ) const
{
    if ( (uint)index >= length() )
	return -1;
    else
	return rx.match( *this, index );
}

/*!
  Finds the first occurrence of the regular expression \a rx, starting at
  position \a index and searching backwards. If \a index is negative,
  the search starts at the end of this string.

  Returns the position of the next match (backwards), or -1 if \a rx was not
  found.
*/

int QString::findRev( const QRegExp &rx, int index ) const
{
    if ( index < 0 )				// neg index ==> start from end
	index = length() - 1;
    else if ( (uint)index >= length() )		// bad index
	return -1;
    while( index >= 0 ) {
	if ( rx.match( *this, index ) == index )
	    return index;
	index--;
    }
    return -1;
}

/*!
  Counts the number of overlapping occurrences of \a rx in the string.

  Example:
  \code
    QString s = "banana and panama";
    QRegExp r = QRegExp("a[nm]a", TRUE, FALSE);
    s.contains( r );				// 4 matches
  \endcode

  \sa find(), findRev()
*/

int QString::contains( const QRegExp &rx ) const
{
    if ( isEmpty() )
	return 0;
    int count = 0;
    int index = -1;
    int len = length();
    while ( index < len-1 ) {			// count overlapping matches
	index = rx.match( *this, index+1 );
	if ( index < 0 )
	    break;
	count++;
    }
    return count;
}


/*!
  Replaces every occurrence of \a rx in the string with \a str.
  Returns a reference to the string.

  Examples:
  \code
    QString s = "banana";
    s.replace( QRegExp("a.*a"), "" );		// becomes "b"

    QString s = "banana";
    s.replace( QRegExp("^[bn]a"), " " );	// becomes " nana"

    QString s = "banana";
    s.replace( QRegExp("^[bn]a"), "" );		// NOTE! becomes ""
  \endcode

*/

QString &QString::replace( const QRegExp &rx, const QString &str )
{
    if ( isEmpty() )
	return *this;
    int index = 0;
    int slen  = str.length();
    int len;
    while ( index < (int)length() ) {
	index = rx.match( *this, index, &len, FALSE );
	if ( index >= 0 ) {
	    replace( index, len, str );
	    index += slen;
	    if ( !len )
		break;	// Avoid infinite loop on 0-length matches, e.g. [a-z]*
	}
	else
	    break;
    }
    return *this;
}

static bool
ok_in_base( QChar c, int base )
{
    if ( base <= 10 )
	return c.isDigit() && c.digitValue() < base;
    else
	return c.isDigit() || (c >= 'a' && c < char('a'+base-10))
	                   || (c >= 'A' && c < char('A'+base-10));
}

/*!
  Returns the string converted to a <code>long</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all, or if
  it has trailing garbage.
*/

long QString::toLong( bool *ok, int base ) const
{
    const QChar *p = unicode();
    long val=0;
    int l = length();
    const long max_mult = INT_MAX / base;
    bool is_ok = FALSE;
    int neg = 0;
    if ( !p )
	goto bye;
    while ( l && p->isSpace() )			// skip leading space
	l--,p++;
    if ( l && *p == '-' ) {
	l--;
	p++;
	neg = 1;
    } else if ( *p == '+' ) {
	l--;
	p++;
    }

    // NOTE: toULong() code is similar
    if ( !l || !ok_in_base(*p,base) )
	goto bye;
    while ( l && ok_in_base(*p,base) ) {
	l--;
	int dv;
	if ( p->isDigit() ) {
	    dv = p->digitValue();
	} else {
	    if ( *p >= 'a' && *p <= 'z' )
		dv = *p - 'a' + 10;
	    else
		dv = *p - 'A' + 10;
	}
	if ( val > max_mult || (val == max_mult && dv > (INT_MAX%base)+neg) )
	    goto bye;
	val = base*val + dv;
	p++;
    }
    if ( neg )
	val = -val;
    while ( l && p->isSpace() )			// skip trailing space
	l--,p++;
    if ( !l )
	is_ok = TRUE;
bye:
    if ( ok )
	*ok = is_ok;
    return is_ok ? val : 0;
}

/*!
  Returns the string converted to an <code>unsigned long</code>
  value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all,
  or if it has trailing garbage.
*/

ulong QString::toULong( bool *ok, int base ) const
{
    const QChar *p = unicode();
    ulong val=0;
    int l = length();
    const ulong max_mult = 429496729;
    bool is_ok = FALSE;
    if ( !p )
	goto bye;
    while ( l && p->isSpace() )			// skip leading space
	l--,p++;
    if ( *p == '+' )
	l--,p++;

    // NOTE: toLong() code is similar
    if ( !l || !ok_in_base(*p,base) )
	goto bye;
    while ( l && ok_in_base(*p,base) ) {
	l--;
	uint dv;
	if ( p->isDigit() ) {
	    dv = p->digitValue();
	} else {
	    if ( *p >= 'a' && *p <= 'z' )
		dv = *p - 'a' + 10;
	    else
		dv = *p - 'A' + 10;
	}
	if ( val > max_mult || (val == max_mult && dv > (UINT_MAX%base)) )
	    goto bye;
	val = base*val + dv;
	p++;
    }

    while ( l && p->isSpace() )			// skip trailing space
	l--,p++;
    if ( !l )
	is_ok = TRUE;
bye:
    if ( ok )
	*ok = is_ok;
    return is_ok ? val : 0;
}

/*!
  Returns the string converted to a <code>short</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all, or if
  it has trailing garbage.
*/

short QString::toShort( bool *ok, int base ) const
{
    long v = toLong( ok, base );
    if ( ok && *ok && (v < -32768 || v > 32767) ) {
	*ok = FALSE;
	v = 0;
    }
    return (short)v;
}

/*!
  Returns the string converted to an <code>unsigned short</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all, or if
  it has trailing garbage.
*/

ushort QString::toUShort( bool *ok, int base ) const
{
    ulong v = toULong( ok, base );
    if ( ok && *ok && (v > 65535) ) {
	*ok = FALSE;
	v = 0;
    }
    return (ushort)v;
}


/*!
  Returns the string converted to a <code>int</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all,
  or if it has trailing garbage.
*/

int QString::toInt( bool *ok, int base ) const
{
    return (int)toLong( ok, base );
}

/*!
  Returns the string converted to an <code>unsigned int</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all,
  or if it has trailing garbage.
*/

uint QString::toUInt( bool *ok, int base ) const
{
    return (uint)toULong( ok, base );
}

/*!
  Returns the string converted to a <code>double</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no conceivable
  errors, and FALSE if the string is not a number at all, or if it has
  trailing garbage.
*/

double QString::toDouble( bool *ok ) const
{
    char *end;
    const char *a = latin1();
    double val = strtod( a ? a : "", &end );
    if ( ok )
	*ok = ( a && *a && ( end == 0 || *end == '\0' ) );
    return val;
}

/*!
  Returns the string converted to a <code>float</code> value.

  If \a ok is non-null, \a *ok is set to TRUE if there are no
  conceivable errors, and FALSE if the string is not a number at all,
  or if it has trailing garbage.
*/

float QString::toFloat( bool *ok ) const
{
    return (float)toDouble( ok );
}


/*!
  Sets the string to the printed value of \a n and returns a
  reference to the string.

  The value is converted to \a base notation (default is decimal).
  The base must be a value from 2 to 36.
*/

QString &QString::setNum( long n, int base )
{
#if defined(CHECK_RANGE)
    if ( base < 2 || base > 36 ) {
	qWarning( "QString::setNum: Invalid base %d", base );
	base = 10;
    }
#endif
    char buf[65];
    register char *p = &buf[64];
    bool neg;
    if ( n < 0 ) {
	neg = TRUE;
	if ( n == INT_MIN ) {
	    // Cannot always negate this special case
	    QString s1, s2;
	    s1.setNum(n/base);
	    s2.setNum((-(n+base))%base);
	    *this = s1 + s2;
	    return *this;
	}
	n = -n;
    } else {
	neg = FALSE;
    }
    *p = '\0';
    do {
	*--p = "0123456789abcdefghijklmnopqrstuvwxyz"[((int)(n%base))];
	n /= base;
    } while ( n );
    if ( neg )
	*--p = '-';
    return *this = QString::fromLatin1(p);
}

/*!
  Sets the string to the printed unsigned value of \a n and
  returns a reference to the string.

  The value is converted to \a base notation (default is decimal).
  The base must be a value from 2 to 36.
*/

QString &QString::setNum( ulong n, int base )
{
#if defined(CHECK_RANGE)
    if ( base < 2 || base > 36 ) {
	qWarning( "QString::setNum: Invalid base %d", base );
	base = 10;
    }
#endif
    char buf[65];
    register char *p = &buf[64];
    *p = '\0';
    do {
	*--p = "0123456789abcdefghijklmnopqrstuvwxyz"[((int)(n%base))];
	n /= base;
    } while ( n );
    return *this = QString::fromLatin1(p);
}

/*!
  \fn QString &QString::setNum( int n, int base )
  Sets the string to the printed value of \a n and returns a reference
  to the string.
*/

/*!
  \fn QString &QString::setNum( uint n, int base )
  Sets the string to the printed unsigned value of \a n and returns a
  reference to the string.
*/

/*!
  \fn QString &QString::setNum( short n, int base )
  Sets the string to the printed value of \a n and returns a reference
  to the string.
*/

/*!
  \fn QString &QString::setNum( ushort n, int base )
  Sets the string to the printed unsigned value of \a n and returns a
  reference to the string.
*/

/*!
  Sets the string to the printed value of \a n.

  \arg \a f is the format specifier: 'f', 'F', 'e', 'E', 'g', 'G' (same
  as sprintf()).
  \arg \a prec is the precision.

  Returns a reference to the string.
*/

QString &QString::setNum( double n, char f, int prec )
{
#if defined(CHECK_RANGE)
    if ( !(f=='f' || f=='F' || f=='e' || f=='E' || f=='g' || f=='G') ) {
	qWarning( "QString::setNum: Invalid format char '%c'", f );
	f = 'f';
    }
#endif
    char format[20];
    register char *fs = format;			// generate format string
    *fs++ = '%';				//   "%.<prec>l<f>"
    if ( prec >= 0 ) {
	if ( prec > 99 )
	    prec = 99;
	*fs++ = '.';
	if ( prec >= 10 ) {
	    *fs++ = prec / 10 + '0';
	    *fs++ = prec % 10 + '0';
	} else {
	    *fs++ = prec + '0';
	}
    }
    *fs++ = 'l';
    *fs++ = f;
    *fs = '\0';
    return sprintf( format, n );
}

/*!
  \fn QString &QString::setNum( float n, char f, int prec )
  Sets the string to the printed value of \a n.

  \arg \a f is the format specifier: 'f', 'F', 'e', 'E', 'g', 'G' (same
  as sprintf()).
  \arg \a prec is the precision.

  Returns a reference to the string.
*/


/*!
  A convenience factory function that returns a string representation
  of the number \a n.

  \sa setNum()
 */
QString QString::number( long n, int base )
{
    QString s;
    s.setNum( n, base );
    return s;
}

/*!
  A convenience factory function that returns a string representation
  of the number \a n.

  \sa setNum()
 */
QString QString::number( ulong n, int base )
{
    QString s;
    s.setNum( n, base );
    return s;
}

/*!
  A convenience factory function that returns a string representation
  of the number \a n.

  \sa setNum()
 */
QString QString::number( int n, int base )
{
    QString s;
    s.setNum( n, base );
    return s;
}

/*!
  A convenience factory function that returns a string representation
  of the number \a n.

  \sa setNum()
 */
QString QString::number( uint n, int base )
{
    QString s;
    s.setNum( n, base );
    return s;
}

/*!
  A convenience factory function that returns a string representation
  of the number \a n.

  \arg \a f is the format specifier: 'f', 'F', 'e', 'E', 'g', 'G' (same
  as sprintf()).
  \arg \a prec is the precision.

  \sa setNum()
 */
QString QString::number( double n, char f, int prec )
{
    QString s;
    s.setNum( n, f, prec );
    return s;
}


/*! \obsolete

  Sets the character at position \a index to \a c and expands the
  string if necessary, filling with spaces.

  This method is redundant in Qt 2.x, because operator[] will
  expand the string as necessary, if you are assigning a value.
*/

void QString::setExpand( uint index, QChar c )
{
    int spaces = index - d->len;
    at(index) = c;
    while (spaces-->0)
	d->unicode[--index]=' ';
}


/*!
  \fn const char* QString::data() const

  \obsolete

  Returns a pointer to a 0-terminated classic C string.

  In Qt 1.x, this returned a char* allowing direct manipulation of the
  string as a sequence of bytes.  In Qt 2.x where QString is a Unicode
  string, char* conversion constructs a temporary string, and hence
  direct character operations are meaningless.
*/

/*!
  \fn bool QString::operator!() const
  Returns TRUE if it is a null string, otherwise FALSE.  Thus
  you can write:

\code
  QString name = getName();
  if ( !name )
    name = "Rodney";
\endcode

  Note that if you say:

\code
  QString name = getName();
  if ( name )
    doSomethingWith(name);
\endcode

  Then this will call <tt>operator const char*()</tt>, which will do what
  you want, but rather inefficiently - you may wish to define the macro
  QT_NO_ASCII_CAST when writing code which you wish to strictly remain
  Unicode-clean.

  When you want the above semantics, use <tt>!isNull()</tt>
  or even <tt>!!</tt>:

\code
  QString name = getName();
  if ( !!name )
    doSomethingWith(name);
\endcode
*/


/*!
  \fn QString& QString::append( const QString& str )
  Appends \a str to the string and returns a reference to the result.
  Equivalent to operator+=().
 */

/*!
  \fn QString& QString::append( char ch )
  Appends \a ch to the string and returns a reference to the result.
  Equivalent to operator+=().
 */

/*!
  Appends \a str to the string and returns a reference to the string.
*/
QString& QString::operator+=( const QString &str )
{
    uint len1 = length();
    uint len2 = str.length();
    if ( len2 ) {
	setLength(len1+len2);
	memcpy( d->unicode+len1, str.unicode(), sizeof(QChar)*len2 );
    }
    return *this;
}

/*!
  Appends \a c to the string and returns a reference to the string.
*/

QString &QString::operator+=( QChar c )
{
    setLength(length()+1);
    d->unicode[length()-1] = c;
    return *this;
}

/*!
  Appends \a c to the string and returns a reference to the string.
*/

QString &QString::operator+=( char c )
{
    setLength(length()+1);
    d->unicode[length()-1] = c;
    return *this;
}

/*!
  Returns a Latin-1 representation of the string. Note that the returned
  value is undefined if the string contains non-Latin-1 characters.  If you
  want to convert strings into formats other than Unicode, see the
  QTextCodec classes.

  This function is mainly useful for boot-strapping legacy code to
  use Unicode.

  The result remains valid so long as one unmodified
  copy of the string exists.

  \sa utf8(), local8Bit()
*/
const char* QString::latin1() const
{
    if ( d->ascii ) {
	if ( d->dirtyascii )
	    delete [] d->ascii;
	else
	    return d->ascii;
    }
    Q2HELPER(stat_get_ascii++);
    Q2HELPER(stat_get_ascii_size+=d->len);
    d->ascii = unicodeToAscii( d->unicode, d->len );
    d->dirtyascii = 0;
    return d->ascii;
}

const char* QString::ascii() const
{
    return latin1();
}

/*!
  Returns the string encoded in UTF8 format.

  See QTextCodec for more diverse coding/decoding of Unicode strings.

  \sa QString::fromUtf8(), local8Bit()
*/
QCString QString::utf8() const
{
    static QTextCodec* codec = QTextCodec::codecForMib(106);
    return codec
	    ? codec->fromUnicode(*this)
	    : QCString(latin1());
}

/*!
  Returns the unicode string decoded from the
  first \a len bytes of \a utf8.  If \a len is -1 (the default), the
  length of \a utf8 is used.  If trailing partial characters are in
  \a utf8, they are ignored.

  See QTextCodec for more diverse coding/decoding of Unicode strings.
*/
QString QString::fromUtf8(const char* utf8, int len)
{
    static QTextCodec* codec = QTextCodec::codecForMib(106);
    if ( len < 0 ) len = strlen(utf8);
    return codec
	    ? codec->toUnicode(utf8, len)
	    : QString::fromLatin1(utf8, len);
}

/*!
  Creates a QString from Latin1 text.  This is the same as the
  QString(const char*) constructor, but you can make that constructor
  invisible if you compile with the define QT_NO_CAST_ASCII, in which
  case you can explicitly create a QString from Latin-1 text using
  this function.
*/
QString QString::fromLatin1(const char* chars, int len)
{
    uint l;
    QChar *uc;
    if ( len < 0 ) {
	uc = internalAsciiToUnicode(chars,&l);
    } else {
	uc = internalAsciiToUnicode(chars,&l,len);
    }
    return QString(new QStringData(uc,l,l), TRUE);
}

/*!
  \fn const QChar* QString::unicode() const

  Returns the Unicode representation of the string.  The result
  remains valid until the string is modified.
*/

/*!
  Returns the string encoded in a locale-specific format.  On X11, this
  is the QTextCodec::codecForLocale().  On Windows, it is a system-defined
  encoding.

  See QTextCodec for more diverse coding/decoding of Unicode strings.

  \sa QString::fromLocal8Bit(), local8Bit(), utf8()
*/
QCString QString::local8Bit() const
{
#ifdef _WS_X11_
    static QTextCodec* codec = QTextCodec::codecForLocale();
    return codec
	    ? codec->fromUnicode(*this)
	    : QCString(latin1());
#else
    return qt_winQString2MB( *this );
#endif
}

/*!
  Returns the unicode string decoded from the
  first \a len bytes of \a local8Bit.  If \a len is -1 (the default), the
  length of \a local8Bit is used.  If trailing partial characters are in
  \a local8Bit, they are ignored.

  \a local8Bit is assumed to be encoded in a locale-specific format.

  See QTextCodec for more diverse coding/decoding of Unicode strings.
*/
QString QString::fromLocal8Bit(const char* local8Bit, int len)
{
#ifdef _WS_X11_
    static QTextCodec* codec = QTextCodec::codecForLocale();
    if ( len < 0 ) len = strlen(local8Bit);
    return codec
	    ? codec->toUnicode(local8Bit, len)
	    : QString::fromLatin1(local8Bit,len);
#else
    if ( len >= 0 ) {
	QCString s(local8Bit,len+1);
	return qt_winMB2QString(s);
    }
    return qt_winMB2QString( local8Bit );
#endif
}

/*!
  \fn QString::operator const char *() const

  Returns latin1().  Be sure to see the warnings documented there.
  Note that for new code which you wish to be strictly Unicode-clean,
  you can define the macro QT_NO_ASCII_CAST when compiling your code
  to hide this function so that automatic casts are not done.  This
  has the added advantage that you catch the programming error
  described under operator!().
*/

/*!
  \fn QChar QString::at( uint ) const

  Returns the character at \a i, or 0 if \a i is beyond the length
  of the string.

  Note: If this QString is not const or const&, the non-const at()
  will be used instead, which will expand the string if \a i is beyond
  the length of the string.
*/

/*!
  \fn QChar QString::constref(uint i) const
  Equivalent to at(i), this returns the QChar at \a i by value.

  \sa ref()
*/

/*!
  \fn QChar& QString::ref(uint i)
  Returns the QChar at \a i by reference.

  \sa constref()
*/

/*!
  \fn QChar QString::operator[](int) const

  Returns the character at \a i, or QChar::null if \a i is beyond the
  length of the string.

  Note: If this QString is not const or const&, the non-const operator[]
  will be used instead, which will expand the string if \a i is beyond
  the length of the string.
*/

/*!
  \fn QCharRef QString::operator[](int)

  Returns an object that references the character at \a i.
  This reference
  can then be assigned to, or otherwise used immediately, but
  becomes invalid once further modifications are made to the string.
  The QCharRef internal class can be used much like a constant QChar, but
  if you assign to it, you change the original string (which enlarges
  and detaches itself). You will get compilation errors if you try to
  use the result as anything but a QChar.
*/

/*!
  \fn QCharRef QString::at( uint i )
  Returns a reference to the character at \a i, expanding
  the string with QChar::null if necessary.  The resulting reference
  can then be assigned to, or otherwise used immediately, but
  becomes invalid once further modifications are made to the string.
*/

/*!
  Internal chunk of code to handle the
  uncommon cases of at() above.
*/
void QString::subat( uint i )
{
    uint olen = d->len;
    if ( i >= olen ) {
	setLength( i+1 );		// i is index; i+1 is needed length
	for ( uint j=olen; j<=i; j++ )
	    d->unicode[j] = QChar::null;
    } else {
	// Just be sure to detach
	real_detach();
    }
}


/*****************************************************************************
  QString stream functions
 *****************************************************************************/

/*!
  \relates QString
  Writes a string to the stream.

  Output format: [length (Q_UINT32) data...]
*/

QDataStream &operator<<( QDataStream &s, const QString &str )
{
    if ( s.version() == 1 ) {
	QCString l( str.latin1() );
	s << l;
    }
    else {
	const char* ub = (const char*)str.unicode();
	if ( QChar::networkOrdered() ==
		(s.byteOrder()==QDataStream::BigEndian) ) {
	    s.writeBytes( ub, sizeof(QChar)*str.length() );
	} else {
	    static const uint auto_size = 1024;
	    char t[auto_size];
	    char *b;
	    if ( str.length()*2 > auto_size ) {
		b = new char[str.length()*2];
	    } else {
		b = t;
	    }
	    int l = str.length();
	    char *c=b;
	    while ( l-- ) {
		*c++ = ub[1];
		*c++ = ub[0];
		ub+=2;
	    }
	    s.writeBytes( b, sizeof(QChar)*str.length() );
	    if ( str.length()*2 > auto_size )
		delete [] b;
	}
    }
    return s;
}

/*!
  \relates QString
  Reads a string from the stream.
*/

QDataStream &operator>>( QDataStream &s, QString &str )
{
    if ( s.version() == 1 ) {
	QCString l;
	s >> l;
	str = QString( l );
    }
    else {
	Q_UINT32 bytes;
	s >> bytes;					// read size of string
	str.setLength( bytes/2 );
	if ( bytes > 0 ) {				// not null array
	    char* b = (char*)str.d->unicode;
	    s.readRawBytes( b, bytes );
	    if ( QChar::networkOrdered() !=
		    (s.byteOrder()==QDataStream::BigEndian) ) {
		bytes /= 2;
		while ( bytes-- ) {
		    char c = b[0];
		    b[0] = b[1];
		    b[1] = c;
		    b += 2;
		}
	    }
	} else {
	    str = "";
	}
    }
    return s;
}

/*!
  \fn int QString::compare (const QString & s1, const QString & s2)

  Compare \a s1 to \a s2 returning an integer less than, equal to, or
  greater than zero if s1 is, respectively, lexically less than, equal to,
  or greater than s2.
*/

/*!
  Compares this string to \a s, returning an integer less than, equal to, or
  greater than zero if it is, respectively, lexically less than, equal to,
  or greater than \a s.
*/
int QString::compare( const QString& s ) const
{
    return ucstrcmp(*this,s);
}

bool operator==( const QString &s1, const QString &s2 )
{
    return (s1.length() == s2.length()) && s1.isNull() == s2.isNull() &&
	   (memcmp((char*)s1.unicode(),(char*)s2.unicode(),s1.length()*2) ==0);
}

bool operator!=( const QString &s1, const QString &s2 )
{ return !(s1==s2); }

bool operator<( const QString &s1, const QString &s2 )
{ return ucstrcmp(s1,s2) < 0; }

bool operator<=( const QString &s1, const QString &s2 )
{ return ucstrcmp(s1,s2) <= 0; }

bool operator>( const QString &s1, const QString &s2 )
{ return ucstrcmp(s1,s2) > 0; }

bool operator>=( const QString &s1, const QString &s2 )
{ return ucstrcmp(s1,s2) >= 0; }


bool operator==( const QString &s1, const char *s2 )
{ return s1==QString(s2); }

bool operator==( const char *s1, const QString &s2 )
{ return QString(s1)==s2; }

bool operator!=( const QString &s1, const char *s2 )
{ return !(s1==s2); }

bool operator!=( const char *s1, const QString &s2 )
{ return !(s1==s2); }

bool operator<( const QString &s1, const char *s2 )
{ return ucstrcmp(s1,s2) < 0; }

bool operator<( const char *s1, const QString &s2 )
{ return ucstrcmp(s1,s2) < 0; }

bool operator<=( const QString &s1, const char *s2 )
{ return ucstrcmp(s1,s2) <= 0; }

bool operator<=( const char *s1, const QString &s2 )
{ return ucstrcmp(s1,s2) <= 0; }

bool operator>( const QString &s1, const char *s2 )
{ return ucstrcmp(s1,s2) > 0; }

bool operator>( const char *s1, const QString &s2 )
{ return ucstrcmp(s1,s2) > 0; }

bool operator>=( const QString &s1, const char *s2 )
{ return ucstrcmp(s1,s2) >= 0; }

bool operator>=( const char *s1, const QString &s2 )
{ return ucstrcmp(s1,s2) >= 0; }


/*****************************************************************************
  Documentation for related functions
 *****************************************************************************/

/*!
  \fn bool operator==( const QString &s1, const QString &s2 )
  \relates QString
  Returns TRUE if the two strings are equal, or FALSE if they are different.
  A null string is different from an empty, non-null string.  

  Equivalent to <code>strcmp(s1,s2) == 0</code>.
*/

/*!
  \fn bool operator==( const QString &s1, const char *s2 )
  \relates QString
  Returns TRUE if the two strings are equal, or FALSE if they are different.

  Equivalent to <code>strcmp(s1,s2) == 0</code>.
*/

/*!
  \fn bool operator==( const char *s1, const QString &s2 )
  \relates QString
  Returns TRUE if the two strings are equal, or FALSE if they are different.

  Equivalent to <code>strcmp(s1,s2) == 0</code>.
*/

/*!
  \fn bool operator!=( const QString &s1, const QString &s2 )
  \relates QString
  Returns TRUE if the two strings are different, or FALSE if they are equal.

  Equivalent to <code>strcmp(s1,s2) != 0</code>.
*/

/*!
  \fn bool operator!=( const QString &s1, const char *s2 )
  \relates QString
  Returns TRUE if the two strings are different, or FALSE if they are equal.

  Equivalent to <code>strcmp(s1,s2) != 0</code>.
*/

/*!
  \fn bool operator!=( const char *s1, const QString &s2 )
  \relates QString
  Returns TRUE if the two strings are different, or FALSE if they are equal.

  Equivalent to <code>strcmp(s1,s2) != 0</code>.
*/

/*!
  \fn bool operator<( const QString &s1, const char *s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically less than \a s2, otherwise FALSE.

  Equivalent to <code>strcmp(s1,s2) \< 0</code>.
*/

/*!
  \fn bool operator<( const char *s1, const QString &s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically less than \a s2, otherwise FALSE.

  Equivalent to <code>strcmp(s1,s2) \< 0</code>.
*/

/*!
  \fn bool operator<=( const QString &s1, const char *s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically less than or equal to \a s2,
  otherwise FALSE.

  Equivalent to <code>strcmp(s1,s2) \<= 0</code>.
*/

/*!
  \fn bool operator<=( const char *s1, const QString &s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically less than or equal to \a s2,
  otherwise FALSE.

  Equivalent to <code>strcmp(s1,s2) \<= 0</code>.
*/

/*!
  \fn bool operator>( const QString &s1, const char *s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically greater than \a s2, otherwise FALSE.

  Equivalent to <code>strcmp(s1,s2) \> 0</code>.
*/

/*!
  \fn bool operator>( const char *s1, const QString &s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically greater than \a s2, otherwise FALSE.

  Equivalent to <code>strcmp(s1,s2) \> 0</code>.
*/

/*!
  \fn bool operator>=( const QString &s1, const char *s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically greater than or equal to \a s2,
  otherwise FALSE.

  Equivalent to <code>strcmp(s1,s2) \>= 0</code>.
*/

/*!
  \fn bool operator>=( const char *s1, const QString &s2 )
  \relates QString
  Returns TRUE if \a s1 is alphabetically greater than or equal to \a s2,
  otherwise FALSE.

  Equivalent to <code>strcmp(s1,s2) \>= 0</code>.
*/

/*!
  \fn QString operator+( const QString &s1, const QString &s2 )
  \relates QString
  Returns the concatenated string of s1 and s2.
*/

/*!
  \fn QString operator+( const QString &s1, const char *s2 )
  \relates QString
  Returns the concatenated string of s1 and s2.
*/

/*!
  \fn QString operator+( const char *s1, const QString &s2 )
  \relates QString
  Returns the concatenated string of s1 and s2.
*/

/*!
  \fn QString operator+( const QString &s, char c )
  \relates QString
  Returns the concatenated string of s and c.
*/

/*!
  \fn QString operator+( char c, const QString &s )
  \relates QString
  Returns the concatenated string of c and s.
*/



/*****************************************************************************
  QConstString member functions
 *****************************************************************************/

/*!
  \class QConstString qstring.h
  \brief A QString which uses constant Unicode data.

  In order to minimize copying, highly optimized applications
  can use QConstString to provide a QString-compatible object
  from existing Unicode data.  The Unicode data must exist
  for the entire lifetime of the QConstString object.
*/

/*!
  Creates a QConstString that uses the first \a length Unicode
  characters in the array \a unicode.  Any attempt to modify
  copies of the string will cause it to create a copy of the
  data, thus it remains forever unmodified.
*/
QConstString::QConstString( QChar* unicode, uint length ) :
    QString(new QStringData(unicode, length, length),TRUE)
{
}

/*!
  Destroys the QConstString, creating a copy of the data if
  other strings are still using it.
*/
QConstString::~QConstString()
{
    if ( d->count > 1 ) {
        QChar* cp = QT_ALLOC_QCHAR_VEC( d->len );
        memcpy( cp, d->unicode, d->len*sizeof(QChar) );
        d->unicode = cp;
    } else {
        d->unicode = 0;
    }

    // The original d->unicode is now unlinked.
}

/*!
  \fn const QString& QConstString::string() const

  Returns a constant string referencing the data passed during
  construction.
*/


#if defined(_OS_WIN32_)

#include <windows.h>

/*!
  Returns a static Windows TCHAR* from a QString, possibly adding NUL.

  The lifetime of the return value is until the next call to this function.
*/
const void* qt_winTchar(const QString& str_in, bool addnul)
{
    // So that the return value lives long enough.
    static QString str;
    str = str_in;

#ifdef UNICODE
    static uint buflen = 256;
    static TCHAR *buf = new TCHAR[buflen];

    const QChar* uc = str.unicode();

#define EXTEND if (str.length() > buflen) { delete buf; buf = new TCHAR[buflen=str.length()+1]; }

#if defined(_WS_X11_) || defined(_OS_WIN32_BYTESWAP_)
    EXTEND
    for ( int i=str.length(); i--; )
	buf[i] = uc[i].row() << 8 | uc[i].cell();
    if ( addnul )
	buf[str.length()] = 0;
#else
    // Same endianness of TCHAR
    if ( addnul ) {
	EXTEND
	memcpy(buf,uc,sizeof(TCHAR)*str.length());
	buf[str.length()] = 0;
    } else {
	return uc;
    }
#endif
    return buf;
#undef EXTEND

#else
    return str.latin1();
#endif
}

/*!
  Makes a new null terminated Windows TCHAR* from a QString.
*/
void* qt_winTchar_new(const QString& str)
{
    TCHAR* result = new TCHAR[str.length()+1];
    memcpy(result, qt_winTchar(str,FALSE), sizeof(TCHAR)*str.length());
    result[str.length()] = 0;
    return result;
}

/*!
  Makes a QString from a Windows TCHAR*.
*/
QString qt_winQString(void* tc)
{
#ifdef UNICODE

    int len=0;
    while ( ((TCHAR*)tc)[len] )
	len++;
#if defined(_WS_X11_) || defined(_OS_WIN32_BYTESWAP_)
    QString r;
    for ( int i=0; i<len; i++ )
	r += QChar(((TCHAR*)tc)[i]&0xff,((TCHAR*)tc)[i]>>8);
    return r;
#else
    // Same endianness of TCHAR
    return QString((QChar*)tc,len);
#endif
#undef EXTEND
#else
    return (TCHAR*)tc;
#endif
}

QCString qt_winQString2MB( const QString& s, int uclen )
{
    if ( uclen < 0 )
	uclen = s.length();
    BOOL used_def;
    QCString mb(4096);
    int len;
    while ( !(len=WideCharToMultiByte(CP_ACP, 0, (const WCHAR*)s.unicode(), uclen,
		mb.data(), mb.size()-1, 0, &used_def)) )
    {
	int r = GetLastError();
	if ( r == ERROR_INSUFFICIENT_BUFFER ) {
	    mb.resize(1+WideCharToMultiByte( CP_ACP, 0,
				(const WCHAR*)s.unicode(), uclen,
				0, 0, 0, &used_def));
		// and try again...
	} else {
	    // Fail.
	    qWarning("WideCharToMultiByte cannot convert multibyte text (error %d): %s (UTF8)",
		r, s.utf8().data());
	    break;
	}
    }
    mb[len]='\0';
    return mb;
}

// WATCH OUT: mblen must include the NUL (or just use -1)
QString qt_winMB2QString( const char* mb, int mblen )
{
    if ( !mb || !mblen )
        return QString();
    const int wclen_auto = 4096;
    WCHAR wc_auto[wclen_auto];
    int wclen = wclen_auto;
    WCHAR *wc = wc_auto;
    int len;
    while ( !(len=MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED,
		mb, mblen, wc, wclen )) )
    {
	int r = GetLastError();
	if ( r == ERROR_INSUFFICIENT_BUFFER ) {
	    if ( wc != wc_auto ) {
		qWarning("Size changed in MultiByteToWideChar");
		break;
	    } else {
		wclen = MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED,
				    mb, mblen, 0, 0 );
		wc = new WCHAR[wclen];
		// and try again...
	    }
	} else {
	    // Fail.
	    qWarning("MultiByteToWideChar cannot convert multibyte text");
	    break;
	}
    }
    if ( len <= 0 )
      return QString();
    QString s( (QChar*)wc, len-1 ); // len-1: we don't want terminator
    if ( wc != wc_auto )
	delete [] wc;
    return s;
}



#endif // _OS_WIN32_

