/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998, 1999  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_romvideo.h,v 1.2 1999/12/09 22:31:53 hercules Exp $";
#endif

#ifndef _SDL_romvideo_h
#define _SDL_romvideo_h

#include <Quickdraw.h>
#include <Palettes.h>
#include <Menus.h>

#include "SDL_video.h"
#include "SDL_sysvideo.h"

/* Hidden "this" pointer for the video functions */
#define _THIS	SDL_VideoDevice *this

/* Global QuickDraw data */
extern QDGlobals *theQD;

/* Private display data */
struct SDL_PrivateVideoData {
	GDevice **SDL_Display;
	WindowRef SDL_Window;
	SDL_Rect **SDL_modelist;
	CTabHandle SDL_CTab;
	PaletteHandle SDL_CPal;

	/* For saving and restoring the menu bar */
	short mBarHeight;

	/* Region to contain the mouse pointer */
	RgnHandle cursregion;

	/* A handle to the Apple Menu */
	MenuRef apple_menu;
};
/* Old variable names */
#define SDL_Display		(this->hidden->SDL_Display)
#define SDL_Window		(this->hidden->SDL_Window)
#define SDL_modelist		(this->hidden->SDL_modelist)
#define SDL_CTab		(this->hidden->SDL_CTab)
#define SDL_CPal		(this->hidden->SDL_CPal)
#define mBarHeight		(this->hidden->mBarHeight)
#define cursregion		(this->hidden->cursregion)
#define apple_menu		(this->hidden->apple_menu)

#endif /* _SDL_romvideo_h */
