/* $Id: XdbPrintResources.c,v 1.3 1999/10/26 08:27:36 amai Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <Xm/ScrolledWP.h>
#include <Xm/ListP.h>

#ifndef List_ItemCount
#define List_ItemCount(w) \
    (((XmListWidget)(w))->list.itemCount)

#define List_SelectedItemCount(w) \
    (((XmListWidget)(w))->list.selectedItemCount)

#define List_VisibleItemCount(w) \
    (((XmListWidget)(w))->list.visibleItemCount)

#define List_LastSetVizCount(w) \
    (((XmListWidget)(w))->list.LastSetVizCount)

#define List_Items(w) \
    (((XmListWidget)(w))->list.items)

#define List_SelectedItems(w) \
    (((XmListWidget)(w))->list.selectedItems)

#define List_SelectedIndices(w) \
    (((XmListWidget)(w))->list.selectedIndices)

#define List_MarginHeight(w) \
    (((XmListWidget)(w))->list.margin_height)

#define List_MarginWidth(w) \
    (((XmListWidget)(w))->list.margin_width)

#define List_SizePolicy(w) \
    (((XmListWidget)(w))->list.SizePolicy)

#define List_ItemSpacing(w) \
    (((XmListWidget)(w))->list.ItemSpacing)

#define List_Spacing(w) \
    (((XmListWidget)(w))->list.spacing)

#define List_SBDisplayPolicy(w) \
    (((XmListWidget)(w))->list.ScrollBarDisplayPolicy)

#define List_SelectionPolicy(w) \
    (((XmListWidget)(w))->list.SelectionPolicy)

#define List_BaseX(w) \
    (((XmListWidget)(w))->list.BaseX)

#define List_BaseY(w) \
    (((XmListWidget)(w))->list.BaseY)

#endif

char *scrollBarDisplayPolicy(int p)
{
   switch(p)
   {
      case XmAS_NEEDED:
         return "XmAS_NEEDED";
      case XmSTATIC:
         return "XmSTATIC";
   }
   return "???";
}

char *selectionPolicy(int p)
{
   switch(p)
   {
      case XmSINGLE_SELECT:
         return "XmSINGLE_SELECT";
      case XmMULTIPLE_SELECT:
         return "XmMULTIPLE_SELECT";
      case XmEXTENDED_SELECT:
         return "XmEXTENDED_SELECT";
      case XmBROWSE_SELECT:
         return "XmBROWSE_SELECT";
   }
   return "???";
}

char *listSizePolicy(int p)
{
   switch(p)
   {
      case XmCONSTANT:
         return "XmCONSTANT";
      case XmVARIABLE:
         return "XmVARIABLE";
      case XmRESIZE_IF_POSSIBLE:
         return "XmRESIZE_IF_POSSIBLE";
   }
   return "???";
}

void XdbPrintListResources(Widget w)
{
  fprintf(stderr,"List Resource(s):\n");
#if 0
  fprintf(stderr,"spacing(%d)\n",  List_Spacing(w));
  fprintf(stderr,"BaseX(%d)\n",(int) List_BaseX(w));
  fprintf(stderr,"BaseY(%d)\n",(int) List_BaseY(w));
#endif
  fprintf(stderr,"ItemSpacing(%d)\n", List_ItemSpacing(w));
  fprintf(stderr,"margin_width(%d)\n", List_MarginWidth(w));
  fprintf(stderr,"margin_height(%d)\n", List_MarginHeight(w));
  fprintf(stderr,"itemCount(%d)\n", List_ItemCount(w));
  fprintf(stderr,"selectedItemCount(%d)\n", List_SelectedItemCount(w));
  fprintf(stderr,"visibleItemCount(%d)\n", List_VisibleItemCount(w));
  fprintf(stderr,"LastSetVizCount(%d)\n", List_LastSetVizCount(w));
  fprintf(stderr,"SelectionPolicy(%s)\n",selectionPolicy(List_SelectionPolicy(w)));
  fprintf(stderr,"ScrollBarDisplayPolicy(%s)\n",scrollBarDisplayPolicy(List_SBDisplayPolicy(w)));
  fprintf(stderr,"SizePolicy(%s)\n",listSizePolicy(List_SizePolicy(w)));
}

void XdbPrintResources(Widget w)
{
   if (XmIsList(w))
   {
      XdbPrintListResources(w);
   }
}

