/*
 * Copyright(c) 1992 Bell Communications Research, Inc. (Bellcore)
 *                        All rights reserved
 * Permission to use, copy, modify and distribute this material for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of Bellcore not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * Bellcore.
 *
 * BELLCORE MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL BELLCORE OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES RELAT-
 * ING TO THE SOFTWARE.
 *
 * $Id: caption.c,v 1.1 1999/08/04 21:24:03 danny Exp $
 */

#ifdef HAVE_CONFIG_H
#include <XbaeConfig.h>
#endif

#include <Xbae/Caption.h>
#include <Xm/DialogS.h>
#include <Xm/TextF.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>

/*
 * Some examples of Captions use
 */

void popupCaptionTextF(), popupCaptionFrame(), popupCaptionToggle();

int
main(argc, argv)
int argc;
char *argv[];
{
    Widget toplevel, rc, button;
    XtAppContext app;
#ifdef USE_EDITRES
    extern void _XEditResCheckMessages();
#endif

    toplevel = XtVaAppInitialize(&app, "Caption",
				 NULL, 0,
				 &argc, argv,
				 NULL,
				 NULL);
#ifdef USE_EDITRES
    XtAddEventHandler( toplevel, (EventMask)0, True,
                       _XEditResCheckMessages, NULL);
#endif
    

    rc = XtVaCreateManagedWidget("rc",
				 xmRowColumnWidgetClass, toplevel,
				 NULL);

    button = XtVaCreateManagedWidget("button1",
				     xmPushButtonWidgetClass, rc,
				     NULL);
    XtAddCallback(button, XmNactivateCallback, popupCaptionTextF,
		  (XtPointer)"caption1");
    button = XtVaCreateManagedWidget("button2",
				     xmPushButtonWidgetClass, rc,
				     NULL);
    XtAddCallback(button, XmNactivateCallback, popupCaptionFrame,
		  (XtPointer)"caption2");
    button = XtVaCreateManagedWidget("button3",
				     xmPushButtonWidgetClass, rc,
				     NULL);
    XtAddCallback(button, XmNactivateCallback, popupCaptionFrame,
		  (XtPointer)"caption3");
    button = XtVaCreateManagedWidget("button4",
				     xmPushButtonWidgetClass, rc,
				     NULL);
    XtAddCallback(button, XmNactivateCallback, popupCaptionTextF,
		  (XtPointer)"caption4");
    button = XtVaCreateManagedWidget("button5",
				     xmPushButtonWidgetClass, rc,
				     NULL);
    XtAddCallback(button, XmNactivateCallback, popupCaptionToggle, NULL);
    
    XtRealizeWidget(toplevel);
    XtAppMainLoop(app);

    return 0;
}

/* ARGSUSED */
void
popupCaptionTextF(w, name, call_data)
Widget w;
String name;
XtPointer call_data;
{
    Widget shell, cw;

    shell = XtCreatePopupShell(name,
			       xmDialogShellWidgetClass, w,
			       NULL, 0);
    
    cw = XtCreateWidget("cw",
			xbaeCaptionWidgetClass, shell,
			NULL, 0);

    XtVaCreateManagedWidget("text",
			    xmTextFieldWidgetClass, cw,
			    NULL);

    XtManageChild(cw);
}

/* ARGSUSED */
void
popupCaptionFrame(w, name, call_data)
Widget w;
String name;
XtPointer call_data;
{
    Widget shell, form, cw, frame, rc;
    int i;

    shell = XtCreatePopupShell(name,
			       xmDialogShellWidgetClass, w,
			       NULL, 0);

    form = XtCreateWidget("form",
			  xmFormWidgetClass, shell,
			  NULL, 0);
    cw = XtVaCreateManagedWidget("cw",
				 xbaeCaptionWidgetClass, form,
				 NULL);
    frame = XtVaCreateManagedWidget("frame",
				    xmFrameWidgetClass, cw,
				    NULL);
    rc = XtVaCreateManagedWidget("rc",
				 xmRowColumnWidgetClass, frame,
				 NULL);
    for (i = 0; i < 3; i++)
	XtVaCreateManagedWidget("button",
				xmPushButtonWidgetClass, rc,
				NULL);

    XtManageChild(form);
}

/* ARGSUSED */
void
popupCaptionToggle(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
    Widget shell, form, cw, frame, rc;
    int i;

    shell = XtCreatePopupShell("caption5",
			       xmDialogShellWidgetClass, w,
			       NULL, 0);

    form = XtCreateWidget("form",
				   xmFormWidgetClass, shell,
				   NULL, 0);

    cw = XtVaCreateManagedWidget("cw1",
				 xbaeCaptionWidgetClass, form,
				 NULL);
    frame = XtVaCreateManagedWidget("frame",
				    xmFrameWidgetClass, cw,
				    NULL);
    rc = XmCreateRadioBox(frame, "rc", NULL, 0);
    XtManageChild(rc);

    for (i = 0; i < 4; i++)
	XtVaCreateManagedWidget("button",
				xmToggleButtonWidgetClass, rc,
				NULL);


    cw = XtVaCreateManagedWidget("cw2",
				 xbaeCaptionWidgetClass, form,
				 NULL);
    frame = XtVaCreateManagedWidget("frame",
				    xmFrameWidgetClass, cw,
				    NULL);
    rc = XmCreateRadioBox(frame, "rc", NULL, 0);
    XtManageChild(rc);

    for (i = 0; i < 4; i++)
	XtVaCreateManagedWidget("button",
				xmToggleButtonWidgetClass, rc,
				NULL);

    XtManageChild(form);
}

