/* 
   PrintfScannerHandler.m

   Copyright (C) 1995, 1996, 1997 Ovidiu Predescu and Mircea Oancea.
   All rights reserved.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>

   This file is part of the Foundation Extensions Library.

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies and that both that
   copyright notice and this permission notice appear in supporting
   documentation.

   We disclaim all warranties with regard to this software, including all
   implied warranties of merchantability and fitness, in no event shall
   we be liable for any special, indirect or consequential damages or any
   damages whatsoever resulting from loss of use, data or profits, whether in
   an action of contract, negligence or other tortious action, arising out of
   or in connection with the use or performance of this software.
*/

#include <stdarg.h>
#include <stdio.h>
#import <Foundation/NSString.h>

#include <extensions/FormatScanner.h>
#include <extensions/PrintfScannerHandler.h>

@implementation PrintfScannerHandler

- init
{
    [super init];

    specHandler['d'] = [self methodForSelector:@selector(convertInt:scanner:)];
    specHandler['i'] = [self methodForSelector:@selector(convertInt:scanner:)];
    specHandler['o'] = [self methodForSelector:@selector(convertInt:scanner:)];
    specHandler['x'] = [self methodForSelector:@selector(convertInt:scanner:)];
    specHandler['X'] = [self methodForSelector:@selector(convertInt:scanner:)];
    specHandler['u'] = [self methodForSelector:@selector(convertInt:scanner:)];
    specHandler['c']
	    = [self methodForSelector:@selector(convertChar:scanner:)];
    specHandler['s']
	    = [self methodForSelector:@selector(convertString:scanner:)];
    specHandler['f']
	    = [self methodForSelector:@selector(convertFloat:scanner:)];
    specHandler['e']
	    = [self methodForSelector:@selector(convertFloat:scanner:)];
    specHandler['E']
	    = [self methodForSelector:@selector(convertFloat:scanner:)];
    specHandler['g']
	    = [self methodForSelector:@selector(convertFloat:scanner:)];
    specHandler['G']
	    = [self methodForSelector:@selector(convertFloat:scanner:)];
    specHandler['p']
	    = [self methodForSelector:@selector(convertPointer:scanner:)];
    return self;
}

- (NSString*)convertInt:(va_list*)pInt scanner:(FormatScanner*)scanner
{
    char buffer[256];
    sprintf(buffer, [scanner currentSpecifier], va_arg(*pInt, int));
    return [NSString stringWithCString:buffer];
}

- (NSString*)convertChar:(va_list*)pChar scanner:(FormatScanner*)scanner
{
    char buffer[256];
    sprintf(buffer, [scanner currentSpecifier], va_arg(*pChar, char));
    return [NSString stringWithCString:buffer];
}

- (NSString*)convertString:(va_list*)pString scanner:(FormatScanner*)scanner
{
    char* string = va_arg(*pString, char*);
    return string ? [NSString stringWithCString:string] : @"";
}

- (NSString*)convertFloat:(va_list*)pFloat scanner:(FormatScanner*)scanner
{
    char buffer[256];
    sprintf(buffer, [scanner currentSpecifier], va_arg(*pFloat, double));
    return [NSString stringWithCString:buffer];
}

- (NSString*)convertPointer:(va_list*)pPointer scanner:(FormatScanner*)scanner
{
    char buffer[256];
    sprintf(buffer, [scanner currentSpecifier], va_arg(*pPointer, void*));
    return [NSString stringWithCString:buffer];
}

@end /* PrintfScannerHandler */


@implementation FSObjectFormat

- init
{
    [super init];
    specHandler['@']
	    = [self methodForSelector:@selector(convertObject:scanner:)];
    return self;
}

- (NSString*)convertObject:(va_list*)pId scanner:scanner
{
    id object = va_arg(*pId, id);
    return [object description];
}

@end /* FSObjectFormat */
