/********************************************************************************
*                                                                               *
*                      P r o g r e s s B a r   W i d g e t                      *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* Contributed by: Jonathan Bush                                                 *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXProgressBar.cpp,v 1.2 1999/11/04 23:37:19 jeroen Exp $                 *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXComposite.h"
#include "FXLabel.h"
#include "FXProgressBar.h"


/*
  Notes:
  - Reduced flicker by not drawing background at all.
  - Reduced flicker by setting clip rectangle to only redraw interior.
  - Progress bar has a target, as it can send update messages.
*/


/*******************************************************************************/

    
// Map
FXDEFMAP(FXProgressBar) FXProgressBarMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXProgressBar::onPaint),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXProgressBar::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETINTVALUE,FXProgressBar::onCmdSetIntValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETINTVALUE,FXProgressBar::onCmdGetIntValue),
  };


// Object implementation
FXIMPLEMENT(FXProgressBar,FXFrame,FXProgressBarMap,ARRAYNUMBER(FXProgressBarMap))    

  

// Make progress bar
FXProgressBar::FXProgressBar(FXComposite* p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
  FXFrame(p,opts,x,y,w,h,pl,pr,pt,pb){
  target=tgt;
  message=sel;
  progress=0;
  total=100;
  barsize=5;
  font=getApp()->normalFont;
  barBGColor=getApp()->backColor;
  barColor=FXRGB(0,0,255);
  textNumColor=FXRGB(0,0,255);
  textAltColor=FXRGB(255,255,255);
  backColor=barBGColor;
  }


// Get minimum width
FXint FXProgressBar::getDefaultWidth(){
  FXint w=barsize;
  if(options&PROGRESSBAR_PERCENTAGE){
    w=font->getTextWidth("100%",4);
    if(w<barsize) w=barsize;
    }
  return w+padleft+padright+border;  
  }


// Get minimum height
FXint FXProgressBar::getDefaultHeight(){
  FXint h=barsize;
  if(options&PROGRESSBAR_PERCENTAGE){
    h=font->getFontHeight();
    if(h<barsize) h=barsize;
    }
  return h+padtop+padbottom+border;  
  }


// Create window
void FXProgressBar::create(){ 
  FXFrame::create();
  font->create();
  }


// Detach window
void FXProgressBar::detach(){ 
  FXFrame::detach();
  font->detach();
  }


// Update progress value from a message
long FXProgressBar::onCmdSetValue(FXObject*,FXSelector,void* ptr){
  setProgress((FXuint)(long)ptr);
  return 1;
  }


// Set value
long FXProgressBar::onCmdSetIntValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetIntValue: NULL pointer.\n",getClassName()); }
  setProgress(*((FXint*)ptr));
  return 1;
  }


// Get value 
long FXProgressBar::onCmdGetIntValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdGetIntValue: NULL pointer.\n",getClassName()); }
  *((FXint*)ptr)=getProgress();
  return 1;
  }


// Draw the progress bar
long FXProgressBar::onPaint(FXObject*,FXSelector,void *ptr){
  FXEvent *event=(FXEvent*)ptr;
  FXDCWindow dc(this,event);
  FXint percent,barlength,barfilled,tx,ty,tw,th,n;
  FXchar numtext[5];
  
  // Just draw the frame, not the background
  drawFrame(dc,0,0,width,height);
    
  // Vertical
  if(options&PROGRESSBAR_VERTICAL){
    
    // If total is 0, it's 100%
    barlength=height-border-border;
    barfilled=barlength;
    percent=100;
    if(total!=0){
      barfilled=(FXuint) (((double)progress * (double)barlength) / (double)total);
      percent=(FXuint) (((double)progress * 100.0) / (double)total);
      }
    
    // Draw completed bar
    if(0<barfilled){
      dc.setForeground(barColor);
      dc.fillRectangle(border,height-border-barfilled,width-(border<<1),barfilled);
      }
    
    // Draw uncompleted bar
    if(barfilled<barlength){
      dc.setForeground(barBGColor);
      dc.fillRectangle(border,border,width-(border<<1),barlength-barfilled);
      }
    
    // Draw text 
    if(options&PROGRESSBAR_PERCENTAGE){
      sprintf(numtext,"%d%%",percent);
      n=strlen(numtext);
      tw=font->getTextWidth(numtext,n);
      th=font->getFontHeight();
      ty=(height-th)/2+font->getFontAscent();
      tx=(width-tw)/2;
      if(height-border-barfilled>ty){           // In upper side
        dc.setForeground(textNumColor);
        dc.drawText(tx,ty,numtext,n);
        }
      else if(ty-th>height-border-barfilled){   // In lower side
        dc.setForeground(textAltColor);
        dc.drawText(tx,ty,numtext,n);
        }
      else{                                     // In between!
        dc.setForeground(textAltColor);
        dc.setClipRectangle(border,height-border-barfilled,width-(border<<1),barfilled);
        dc.drawText(tx,ty,numtext,n);
        dc.setForeground(textNumColor);
        dc.setClipRectangle(border,border,width-(border<<1),barlength-barfilled);
        dc.drawText(tx,ty,numtext,n);
        dc.clearClipRectangle();
        }
      }
    }
  
  // Horizontal
  else{
    
    // If total is 0, it's 100%
    barlength=width-border-border;
    barfilled=barlength;
    percent=100;
    if(total!=0){
      barfilled=(FXuint) (((double)progress * (double)barlength) / (double)total);
      percent=(FXuint) (((double)progress * 100.0) / (double)total);
      }
    
    // Draw completed bar
    if(0<barfilled){
      dc.setForeground(barColor);
      dc.fillRectangle(border,border,barfilled,height-(border<<1));
      }
    
    // Draw uncompleted bar
    if(barfilled<barlength){
      dc.setForeground(barBGColor);
      dc.fillRectangle(border+barfilled,border,barlength-barfilled,height-(border<<1));
      }
    
    // Draw text 
    if(options&PROGRESSBAR_PERCENTAGE){
      sprintf(numtext,"%d%%",percent);
      n=strlen(numtext);
      tw=font->getTextWidth(numtext,n);
      th=font->getFontHeight();
      ty=(height-th)/2+font->getFontAscent();
      tx=(width-tw)/2;
      if(border+barfilled<=tx){           // In right side
        dc.setForeground(textNumColor);
        dc.drawText(tx,ty,numtext,n);
        }
      else if(tx+tw<=border+barfilled){   // In left side
        dc.setForeground(textAltColor);
        dc.drawText(tx,ty,numtext,n);
        }
      else{                               // In between!
        dc.setForeground(textAltColor);
        dc.setClipRectangle(border,border,barfilled,height);
        dc.drawText(tx,ty,numtext,n);
        dc.setForeground(textNumColor);
        dc.setClipRectangle(border+barfilled,border,barlength-barfilled,height);
        dc.drawText(tx,ty,numtext,n);
        dc.clearClipRectangle();
        }
      }
    }
  return 1;
  }
    

// Set amount of progress made
void FXProgressBar::setProgress(FXuint value){ 
  if(value!=progress){
    progress=value; 
    if(progress>total) progress=total; 
    update(border,border,width-(border<<1),height-(border<<1)); 
    getApp()->flush();
    }
  }


// Increment amount of progress
void FXProgressBar::increment(FXuint value){ 
  if(value!=0){
    progress+=value; 
    if(progress>total) progress=total;
    update(border,border,width-(border<<1),height-(border<<1)); 
    getApp()->flush();
    }
  }


// Set total amount to completion
void FXProgressBar::setTotal(FXuint value){
  if(value!=total){
    total=value;
    update(border,border,width-(border<<1),height-(border<<1));
    getApp()->flush();
    }
  }


// Change bar color
void FXProgressBar::setBarColor(FXColor clr){  
  barColor=clr;  
  update(border,border,width-(border<<1),height-(border<<1)); 
  }


// Change bar background color
void FXProgressBar::setBarBGColor(FXColor clr){  
  barBGColor=clr;  
  update(border,border,width-(border<<1),height-(border<<1)); 
  }


// Change text foreground color
void FXProgressBar::setTextColor(FXColor clr) {   
  textNumColor=clr;   
  update();
  }


// Change alternate text color
void FXProgressBar::setTextAltColor(FXColor clr) {  
  textAltColor=clr;   
  update();
  }


// Hide percentage display
void FXProgressBar::hideNumber(){ 
  if(options&PROGRESSBAR_PERCENTAGE){
    options&=~PROGRESSBAR_PERCENTAGE;
    recalc();
    update();
    }
  }


// Show percentage display
void FXProgressBar::showNumber(){ 
  if(!(options&PROGRESSBAR_PERCENTAGE)){
    options|=PROGRESSBAR_PERCENTAGE;
    recalc();
    update();
    }
  }


void FXProgressBar::setBarSize(FXint size){
  if(size<1){ fxerror("%s::setBarSize: zero or negative barsize specified.\n",getClassName()); }
  if(barsize!=size){
    barsize=size;
    recalc();
    update();
    }
  }


// Change the font
void FXProgressBar::setFont(FXFont *fnt){
  if(!fnt){ fxerror("%s::setFont: NULL font specified.\n",getClassName()); }
  if(font!=fnt){
    font=fnt;
    recalc();
    update();
    }
  }


// Destroy
FXProgressBar::~FXProgressBar(){
  font=(FXFont*)-1;
  }

  
