/********************************************************************************
*                                                                               *
*                     FOX Definitions, Types, and Macros                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: fxdefs.h,v 1.14 1999/11/18 07:39:36 jeroen Exp $                         *
********************************************************************************/
#ifndef FXDEFS_H
#define FXDEFS_H


/********************************  Definitions  ********************************/

// Truth values
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef MAYBE
#define MAYBE 2
#endif
#ifndef NULL
#define NULL 0
#endif

#ifndef PI 
#define PI      3.1415926535897932384626433833
#endif

// Euler constant
#define EULER   2.7182818284590452353602874713

// Multiplier for degrees to radians
#define DTOR    0.0174532925199432957692369077

// Multipier for radians to degrees
#define RTOD    57.295779513082320876798154814


// Path separator
#ifdef WIN32
#define PATHSEP '\\'
#define PATHSEPSTRING "\\"
#define PATHLISTSEP ';'
#define PATHLISTSEPSTRING ";"
#else
#define PATHSEP '/'
#define PATHSEPSTRING "/"
#define PATHLISTSEP ':'
#define PATHLISTSEPSTRING ":"
#endif


// For Windows
#ifdef _DEBUG
#ifndef DEBUG
#define DEBUG
#endif
#endif
#ifdef _NDEBUG
#ifndef NDEBUG
#define NDEBUG
#endif
#endif


// Shared library support
#ifdef WIN32
#ifdef FOXDLL
#ifdef FOXDLL_EXPORTS
#define FXAPI __declspec(dllexport)
#else
#define FXAPI __declspec(dllimport)
#endif
#endif
#endif

#ifndef FXAPI
#define FXAPI
#endif


// FOX System Defined Selector Types 
enum FXSelType {
  SEL_NONE,
  SEL_KEYPRESS,                       // Key
  SEL_KEYRELEASE,            
  SEL_LEFTBUTTONPRESS,                // Buttons
  SEL_LEFTBUTTONRELEASE,     
  SEL_MIDDLEBUTTONPRESS,
  SEL_MIDDLEBUTTONRELEASE,
  SEL_RIGHTBUTTONPRESS,
  SEL_RIGHTBUTTONRELEASE,
  SEL_MOTION,                         // Mouse motion
  SEL_ENTER,
  SEL_LEAVE,
  SEL_FOCUSIN,
  SEL_FOCUSOUT,
  SEL_KEYMAP, 
  SEL_UNGRABBED,                      // Lost the grab (Windows)
  SEL_PAINT,                          // Must repaint window
  SEL_CREATE,                
  SEL_DESTROY,               
  SEL_UNMAP,
  SEL_MAP,
  SEL_CONFIGURE,                      // Resize
  SEL_SELECTION_LOST,                 // Widget lost selection    
  SEL_SELECTION_GAINED,               // Widget gained selection
  SEL_SELECTION_REQUEST,              // Inquire selection data
  SEL_RAISED,                
  SEL_LOWERED,               
  SEL_CLOSE,                          // Close window
  SEL_CLOSEALL,                       // Close all windows
  SEL_DELETE,                         // Delete window
  SEL_MINIMIZE,                       // Iconified
  SEL_RESTORE,                        // No longer iconified or maximized
  SEL_MAXIMIZE,                       // Maximized
  SEL_UPDATE,                         // GUI update
  SEL_COMMAND,                        // GUI command
  SEL_CLICKED,                        // Clicked
  SEL_DOUBLECLICKED,                  // Double-clicked
  SEL_TRIPLECLICKED,                  // Triple-clicked
  SEL_CHANGED,                        // GUI changed
  SEL_DESELECTED,                     // Deselected
  SEL_SELECTED,                       // Selected
  SEL_INSERTED,                       // Inserted
  SEL_DELETED,                        // Deleted
  SEL_OPENED,                         // Opened
  SEL_CLOSED,                         // Closed
  SEL_EXPANDED,                       // Expanded
  SEL_COLLAPSED,                      // Collapsed
  SEL_BEGINDRAG,                      // Start a drag
  SEL_ENDDRAG,                        // End a drag
  SEL_DRAGGED,                        // Dragged
  SEL_LASSOED,                        // Lassoed
  SEL_TIMEOUT,                        // Timeout occurred
  SEL_SIGNAL,                         // Signal received
  SEL_CLIPBOARD_LOST,                 // Widget lost clipboard
  SEL_CLIPBOARD_GAINED,               // Widget gained clipboard
  SEL_CLIPBOARD_REQUEST,              // Inquire clipboard data
  SEL_CHORE,                          // Background chore
  SEL_FOCUS_SELF,                     // Focus on widget itself
  SEL_FOCUS_RIGHT,                    // Focus movements
  SEL_FOCUS_LEFT,            
  SEL_FOCUS_DOWN,            
  SEL_FOCUS_UP,  
  SEL_FOCUS_HOME,
  SEL_FOCUS_END,            
  SEL_FOCUS_NEXT,            
  SEL_FOCUS_PREV,
  SEL_DND_ENTER,                      // Drag action entering potential drop target
  SEL_DND_LEAVE,                      // Drag action leaving potential drop target
  SEL_DND_DROP,                       // Drop on drop target
  SEL_DND_MOTION,                     // Drag position changed over potential drop target
  SEL_DND_REQUEST,                    // Inquire drag and drop data
  SEL_ACTIVATE,                       // Activate through mouse or keyboard
  SEL_DEACTIVATE,                     // Deactivate through mouse or keyboard
  SEL_UNCHECK_OTHER,                  // Sent by child to parent to uncheck other children
  SEL_UNCHECK_RADIO,                  // Sent by parent to uncheck radio children
  SEL_IO_READ,                        // Read activity on a pipe
  SEL_IO_WRITE,                       // Write activity on a pipe
  SEL_IO_EXCEPT,                      // Except activity on a pipe
  SEL_LAST                            // Last message
  };


// FOX Keyboard/Button states
enum FXModifierMasks {
  SHIFTMASK        = 0x001,
  CAPSLOCKMASK     = 0x002,
  CONTROLMASK      = 0x004,
  ALTMASK          = 0x008,
  NUMLOCKMASK      = 0x010,
  SCROLLLOCKMASK   = 0x0E0,           // This seems to vary
  LEFTBUTTONMASK   = 0x100,
  MIDDLEBUTTONMASK = 0x200,
  RIGHTBUTTONMASK  = 0x400
  };


// FOX Mouse Buttons
enum FXMouseButton {
  LEFTBUTTON       = 1,
  MIDDLEBUTTON     = 2,
  RIGHTBUTTON      = 3
  };


// FOX Crossing Modes
enum FXCrossingMode {
  CROSSINGNORMAL,
  CROSSINGGRAB,
  CROSSINGUNGRAB
  };


// FOX Visibility Modes
enum FXVisibility {
  VISIBILITYTOTAL,
  VISIBILITYPARTIAL,
  VISIBILITYNONE
  };


// Drawing (BITBLT) functions
enum FXFunction {
  BLT_CLR,
  BLT_SRC_AND_DST,
  BLT_SRC_AND_NOT_DST,
  BLT_SRC,
  BLT_NOT_SRC_AND_DST,
  BLT_DST,
  BLT_SRC_XOR_DST,
  BLT_SRC_OR_DST,
  BLT_NOT_SRC_AND_NOT_DST,
  BLT_NOT_SRC_XOR_DST,
  BLT_NOT_DST,
  BLT_SRC_OR_NOT_DST,
  BLT_NOT_SRC,
  BLT_NOT_SRC_OR_DST,
  BLT_NOT_SRC_OR_NOT_DST,
  BLT_SET
  };


// Line Styles
enum FXLineStyle {
  LINE_SOLID,
  LINE_ONOFF_DASH,
  LINE_DOUBLE_DASH
  };


// Line Cap Styles
enum FXCapStyle {
  CAP_NOT_LAST,
  CAP_BUTT,
  CAP_ROUND,
  CAP_PROJECTING
  };


// Line Join Styles
enum FXJoinStyle {
  JOIN_MITER,
  JOIN_ROUND,
  JOIN_BEVEL
  };


// Fill Styles
enum FXFillStyle {
  FILL_SOLID,
  FILL_TILED,
  FILL_STIPPLED,
  FILL_OPAQUESTIPPLED
  };


// Fill Rules
enum FXFillRule {
  RULE_EVEN_ODD,
  RULE_WINDING
  };

    
// Stipple/dither patterns
enum FXStipplePattern {
  STIPPLE_0         = 0,
  STIPPLE_NONE      = 0,
  STIPPLE_BLACK     = 0,            // All ones
  STIPPLE_1         = 1,
  STIPPLE_2         = 2,
  STIPPLE_3         = 3,
  STIPPLE_4         = 4,
  STIPPLE_5         = 5,
  STIPPLE_6         = 6,
  STIPPLE_7         = 7,
  STIPPLE_8         = 8,
  STIPPLE_GRAY      = 8,            // 50% gray
  STIPPLE_9         = 9,
  STIPPLE_10        = 10,
  STIPPLE_11        = 11,
  STIPPLE_12        = 12,
  STIPPLE_13        = 13,
  STIPPLE_14        = 14,
  STIPPLE_15        = 15,
  STIPPLE_16        = 16,
  STIPPLE_WHITE     = 16,           // All zeroes
  STIPPLE_HORZ      = 17,           // Horizontal hatch pattern
  STIPPLE_VERT      = 18,           // Vertical hatch pattern
  STIPPLE_CROSS     = 19,           // Cross-hatch pattern
  STIPPLE_DIAG      = 20,           // Diagonal // hatch pattern
  STIPPLE_REVDIAG   = 21,           // Reverse diagonal \\ hatch pattern
  STIPPLE_CROSSDIAG = 22            // Cross-diagonal hatch pattern
  };

    
// Options for fxfilematch
enum FXFileMatchOptions {
  FILEMATCH_FILE_NAME   = 1,        // No wildcard can ever match `/'
  FILEMATCH_NOESCAPE    = 2,        // Backslashes don't quote special chars
  FILEMATCH_PERIOD      = 4,        // Leading `.' is matched only explicitly
  FILEMATCH_LEADING_DIR = 8,        // Ignore `/...' after a match
  FILEMATCH_CASEFOLD    = 16        // Compare without regard to case
  };


// Drag and drop actions
enum FXDragAction {
  DRAG_REJECT  = 0,                 // Reject all drop actions
  DRAG_ACCEPT  = 1,                 // Accept any drop action
  DRAG_COPY    = 2,                 // Copy
  DRAG_MOVE    = 3,                 // Move
  DRAG_LINK    = 4                  // Link
  };
  

// Origin of data
enum FXDNDOrigin {
  FROM_UNKNOWN    = 0,              // Unknown selection type
  FROM_SELECTION  = 1,              // Primary selection
  FROM_CLIPBOARD  = 2,              // Clipboard
  FROM_DRAGNDROP  = 3               // Drag and drop source
  };
  

// File input modes for addInput
enum FXInputMode {
  INPUT_NONE   = 0,                 // Inactive
  INPUT_READ   = 1,                 // Read input fd
  INPUT_WRITE  = 2,                 // Write input fd
  INPUT_EXCEPT = 4                  // Except input fd
  };

  
// Exponent display
enum FXExponent {
  EXP_NEVER,                        // Never use exponential notation
  EXP_AUTO,                         // Use exponential notation if needed
  EXP_ALWAYS                        // Always use exponential notation
  };

  
// Font style hints which influence the matcher
enum FXFontHint {
  FONTPITCH_DEFAULT    = 0,         // Default pitch
  FONTPITCH_FIXED      = 1,         // Fixed pitch, mono-spaced
  FONTPITCH_VARIABLE   = 2,         // Variable pitch, proportional spacing
  FONTHINT_DONTCARE    = 0,         // Don't care which font
  FONTHINT_DECORATIVE  = 4,         // Fancy fonts
  FONTHINT_MODERN      = 8,         // Monospace typewriter font
  FONTHINT_ROMAN       = 16,        // Variable width times-like font, serif
  FONTHINT_SCRIPT      = 32,        // Script or cursive
  FONTHINT_SWISS       = 64,        // Helvetica/swiss type font, sans-serif
  FONTHINT_SYSTEM      = 128,       // System font
  FONTHINT_X11         = 256,       // X11 Font string
  FONTHINT_SCALABLE    = 512,       // Scalable fonts
  FONTHINT_POLYMORPHIC = 1024       // Polymorphic fonts
  };
  

// Font slant 
enum FXFontSlant {
  FONTSLANT_DONTCARE        = 0,
  FONTSLANT_REGULAR         = 1,
  FONTSLANT_ITALIC          = 2,
  FONTSLANT_OBLIQUE         = 3,
  FONTSLANT_REVERSE_ITALIC  = 4,
  FONTSLANT_REVERSE_OBLIQUE = 5 
  };


// Font character set encoding
enum FXFontEncoding {
  FONTENCODING_DEFAULT     = 0,
  FONTENCODING_ISO_8859_1  = 1,
  FONTENCODING_ISO_8859_2  = 2,
  FONTENCODING_ISO_8859_3  = 3,
  FONTENCODING_ISO_8859_4  = 4,
  FONTENCODING_ISO_8859_5  = 5,
  FONTENCODING_ISO_8859_6  = 6,
  FONTENCODING_ISO_8859_7  = 7,
  FONTENCODING_ISO_8859_8  = 8,
  FONTENCODING_ISO_8859_11 = 11,
  FONTENCODING_KOI_8       = 12,
  FONTENCODING_USASCII     = FONTENCODING_ISO_8859_1,
  FONTENCODING_EASTEUROPE  = FONTENCODING_ISO_8859_2,
  FONTENCODING_TURKISH     = FONTENCODING_ISO_8859_3,
  FONTENCODING_BALTIC      = FONTENCODING_ISO_8859_4,
  FONTENCODING_RUSSIAN     = FONTENCODING_ISO_8859_5,
  FONTENCODING_ARABIC      = FONTENCODING_ISO_8859_6,
  FONTENCODING_GREEK       = FONTENCODING_ISO_8859_7,
  FONTENCODING_HEBREW      = FONTENCODING_ISO_8859_8,
  FONTENCODING_THAI        = FONTENCODING_ISO_8859_11
  };


// Font weight
enum FXFontWeight {
  FONTWEIGHT_DONTCARE = 0,
  FONTWEIGHT_LIGHT    = 300,
  FONTWEIGHT_NORMAL   = 400,
  FONTWEIGHT_REGULAR  = 400,
  FONTWEIGHT_MEDIUM   = 500,
  FONTWEIGHT_DEMIBOLD = 600,
  FONTWEIGHT_BOLD     = 700,
  FONTWEIGHT_BLACK    = 900
  };


// Font relative setwidth
enum FXFontSetWidth {
  FONTSETWIDTH_DONTCARE       = 0,
  FONTSETWIDTH_ULTRACONDENSED = 10,
  FONTSETWIDTH_EXTRACONDENSED = 20,
  FONTSETWIDTH_CONDENSED      = 30,
  FONTSETWIDTH_SEMICONDENSED  = 40,
  FONTSETWIDTH_MEDIUM         = 50,
  FONTSETWIDTH_SEMIEXPANDED   = 60,
  FONTSETWIDTH_EXPANDED       = 70,
  FONTSETWIDTH_EXTRAEXPANDED  = 80,
  FONTSETWIDTH_ULTRAEXPANDED  = 90
  };

    
// Printer flags
enum FXPrintFlags {
  PRINT_DEST_PAPER        = 0,    // Send print to paper
  PRINT_DEST_FILE         = 1,    // Send print to file
  PRINT_PAGES_ALL         = 0,    // Print all pages
  PRINT_PAGES_EVEN        = 2,    // Print even pages only
  PRINT_PAGES_ODD         = 4,    // Print odd pages only
  PRINT_PAGES_RANGE       = 8,    // Print range of pages
  PRINT_COLLATE_NORMAL    = 0,    // Normal collate order
  PRINT_COLLATE_REVERSED  = 16,   // Reversed collate order
  PRINT_PORTRAIT          = 0,    // Portrait orientation
  PRINT_LANDSCAPE         = 32,   // Landscape orientation
  PRINT_BLACKANDWHITE     = 0,    // Black and white output
  PRINT_COLOR             = 64,   // Color output
  PRINT_NOBOUNDS          = 128   // Must determine bounding box
  };


// Printer media size
enum FXMediaSize {
  MEDIA_CUSTOM            = 0,    // Custom paper size
  MEDIA_USLETTER          = 1,    // US Letter size
  MEDIA_LEGAL             = 2,    // US Legal size
  MEDIA_A4                = 3,    // A4
  MEDIA_ENVELOPE          = 4     // #10 Envelope
  };

  
/*********************************  Typedefs  **********************************/


class FXObject;
class FXStream;

// Streamable types; these are fixed size!
typedef unsigned char          FXuchar;
typedef char                   FXchar;
typedef FXuchar                FXbool;
typedef unsigned short         FXushort;
typedef short                  FXshort;
typedef unsigned int           FXuint;
typedef int                    FXint;
typedef float                  FXfloat;
typedef double                 FXdouble;
typedef FXObject              *FXObjectPtr;
#if defined(_MSC_VER) || defined(__BCPLUSPLUS__) || defined(__TCPLUSPLUS__)
#define FX_LONG 
typedef unsigned __int64       FXulong;
typedef __int64                FXlong;
#elif defined(__GNUG__) || defined(__GNUC__)
#define FX_LONG 
typedef unsigned long long int FXulong;
typedef long long int          FXlong;
#endif


// Handle to something in server
#ifndef FX_NATIVE_WIN32
typedef unsigned int           FXID;
#else
typedef void*                  FXID;
#endif

// Server time
typedef FXuint                 FXTime;

// Pixel type (could be color index)
typedef unsigned long          FXPixel;

// RGBA pixel value
typedef FXuint                 FXColor;

// Hot key
typedef FXuint                 FXHotKey;

// Drag type
#ifndef FX_NATIVE_WIN32
typedef FXID                   FXDragType;
#else
typedef FXushort               FXDragType;
#endif

// Raw event type
#ifndef FX_NATIVE_WIN32
union _XEvent;
typedef _XEvent                FXRawEvent;
#else
struct tagMSG; 
typedef tagMSG                 FXRawEvent;
#endif

/*******************************************************************************/

// Below are defines and such which REALLY should not polute the
// official FOX name space; i.e. applications should probably NOT
// be able to see the names below at all.  
// NOTE: It's OK to have platform-dependent definitions of official FOX
// names; its just NOT OK to have one set of defs for one platform, and
// another set of defs for another.

// Opaque X-Window types
#ifndef X_PROTOCOL
struct Display;
struct Visual;
struct XVisualInfo;
struct XImage;
typedef struct _XGC *GC;
#endif

/* Opaque MS-Windows types */
#if defined(WIN32) && !defined(_WINDOWS_) && !defined(_WINDOWS_H)

#ifndef STRICT
#define STRICT		/* Prefer strict type-checking */
#endif

#ifndef DECLARE_HANDLE
#if defined(_MSC_VER) || defined(__BORLANDC__)
/* Copy definitions for strict type-checking from winnt.h */
typedef void *HANDLE;
#define DECLARE_HANDLE(name) struct name##__; typedef struct name##__ *name
#else
/* Definitions from Anders Norlander's win32api headers */
typedef void *HANDLE;
#define DECLARE_HANDLE(name) typedef struct name##__{int i;} *name
#endif
#endif /* !defined(DECLARE_HANDLE) */

DECLARE_HANDLE(HBITMAP);
DECLARE_HANDLE(HBRUSH);
DECLARE_HANDLE(HDC);
typedef HANDLE HDWP;
DECLARE_HANDLE(HFONT);
DECLARE_HANDLE(HINSTANCE);
DECLARE_HANDLE(HKEY);
DECLARE_HANDLE(HPALETTE);
DECLARE_HANDLE(HPEN);
DECLARE_HANDLE(HSZ);
DECLARE_HANDLE(HWND);

#undef DECLARE_HANDLE

#ifndef CALLBACK
#define CALLBACK __stdcall
#endif

#ifndef VOID
#define VOID		void
typedef char		CHAR;
typedef char		*PSTR;
typedef int		INT;
typedef short		SHORT;
typedef long		LONG;
#endif
typedef unsigned int	UINT;
typedef unsigned short	WORD;
typedef unsigned long	DWORD;
typedef UINT		WPARAM;
typedef LONG		LPARAM;
typedef LONG		LRESULT;

struct tagEXTLOGPEN; typedef struct tagEXTLOGPEN EXTLOGPEN;
struct tagLOGBRUSH; typedef struct tagLOGBRUSH LOGBRUSH;
//struct tagMSG; typedef struct tagMSG MSG;
struct tagPIXELFORMATDESCRIPTOR; typedef struct tagPIXELFORMATDESCRIPTOR PIXELFORMATDESCRIPTOR;
struct tagRECT; typedef struct tagRECT RECT;
struct _FILETIME; typedef struct _FILETIME FILETIME;

#endif /* WIN32 && !_WINDOWS_ && !_WINDOWS_H */


/********************************  Structures  *********************************/


// Named color
struct FXNamedColor {
  FXchar* name;                     // Color name
  FXuchar r,g,b;                    // RGB value of color
  };
  

// Modal loop invocation
struct FXInvocation {
  FXInvocation *upper;              // Upper invocation
  FXID          window;             // Window to match
  FXbool        done;               // True if higher invocation is done
  FXint         code;               // Return code
  };
  

// Rectangle
struct FXRectangle { FXshort x,y,w,h; };

// Point
struct FXPoint { FXshort x,y; };

// Line segment
struct FXSegment { FXshort x1,y1,x2,y2; };

// Arc
struct FXArc { FXshort x,y,w,h,a,b; };


// Font style
struct FXFontDesc {
  FXchar	  face[32];               // Face name
  FXuint	  size;                   // Size in deci-points
  FXuint	  weight;                 // Weight [light, normal, bold, ...]
  FXuint	  slant;                  // Slant [normal, italic, oblique, ...]
  FXuint          encoding;               // Encoding of character set
  FXuint	  setwidth;               // Set width [normal, condensed, expanded, ...]
  FXuint	  flags;                  // Flags
  };

  
// Describes printer
struct FXPrinter {
  FXchar   name[512];                     // Printer name
  FXuint   firstpage;                     // First page that can be printed
  FXuint   lastpage;                      // Last page that can be printed
  FXuint   currentpage;                   // Current page to print
  FXuint   frompage;                      // On output, this is the first page to print
  FXuint   topage;                        // On output, last page to print
  FXuint   mediasize;                     // Media size [MEDIA_USLETTER etc]
  FXdouble mediawidth;                    // Width of paper in points [1/72 of an inch]
  FXdouble mediaheight;                   // Height of paper in points
  FXdouble leftmargin;                    // Left margin
  FXdouble rightmargin;                   // Right margin
  FXdouble topmargin;                     // Top margin
  FXdouble bottommargin;                  // Bottom margin
  FXuint   numcopies;                     // Number of copies
  FXuint   flags;                         // Flags
  };


// FOX Event 
struct FXEvent {
  FXuint      type;           // Event type
  FXID        window;         // Window
  FXTime      time;           // Time of last event
  FXint       win_x;          // Window-relative x-coord
  FXint       win_y;          // Window-relative y-coord
  FXint       root_x;         // Root x-coord
  FXint       root_y;         // Root y-coord
  FXuint      state;          // Keyboard/Modifier state
  FXuint      code;           // Button, Keysym, or mode; DDE Source
  FXint       last_x;         // Window-relative x-coord of previous mouse location
  FXint       last_y;         // Window-relative y-coord of previous mouse location
  FXint       click_x;        // Window-relative x-coord of mouse button press
  FXint       click_y;        // Window-relative y-coord of mouse press
  FXTime      click_time;     // Time of mouse button press
  FXuint      click_button;   // Mouse button pressed
  FXID        click_window;   // Window of mouse button press
  FXint       click_count;    // Click-count
  FXbool      moved;          // Moved cursor since press
  FXRectangle rect;           // Rectangle
  FXbool      synthetic;      // True if synthetic expose event
  FXID        requestor;      // Window requesting data
  FXID        property;       // Property for request
  FXDragType  target;         // Target drag type
  FXDNDOrigin origin;         // DND Origin type
  };


#ifdef FX_NATIVE_WIN32

// Drag and Drop Context:- 
// This may disappear in the future, as the Win32 implementation
// of FOX DND evolves. So don't get too attached to it ;)
struct FXDragContext {
  HWND		target;		    // Drop target window handle
  FXTime	time;		    // Original event time
  FXushort	action;		    // Suggested action (copy, move, etc.)
  FXbool	accepts;
  FXbool	wantUpdates;
  FXRectangle	rect;
  FXuint	numTypes;
  FXuint	ddeSize;
  };

#endif



/**********************************  Macros  ***********************************/

  
// Abolute value
#define FXABS(val) (((val)>=0)?(val):-(val))

// Min and Max
#define FXMAX(a,b) (((a)>(b))?(a):(b))
#define FXMIN(a,b) (((a)>(b))?(b):(a))

// Min of three
#define FXMIN3(x,y,z) ((x)<(y)?FXMIN(x,z):FXMIN(y,z))

// Max of three
#define FXMAX3(x,y,z) ((x)>(y)?FXMAX(x,z):FXMAX(y,z))

// Return minimum and maximum of a, b
#define FXMINMAX(lo,hi,a,b) ((a)<(b)?((lo)=(a),(hi)=(b)):((lo)=(b),(hi)=(a)))

// Offset of member in a structure 
#define STRUCTOFFSET(str,member) (((char *)(&(((str *)0)->member)))-((char *)0))

// Number of elements in a static array 
#define ARRAYNUMBER(array) (sizeof(array)/sizeof(array[0]))

// Container class of a member class 
#define CONTAINER(ptr,str,mem) ((str*)(((char*)(ptr))-STRUCTOFFSET(str,mem)))

// Make int out of two shorts 
#define MKUINT(l,h) ((unsigned int)(((unsigned short)(l))|(((unsigned int)((unsigned short)(h)))<<16)))

// Get type from selector
#define SELTYPE(s) (((unsigned int)(s))>>16)

// Get ID from selector
#define SELID(s) ((unsigned int)((unsigned short)(s)))

// Make RGBA color
#define FXRGBA(r,g,b,a) (((FXuint)(FXuchar)(r)) | ((FXuint)(FXuchar)(g)<<8) | ((FXuint)(FXuchar)(b)<<16) | ((FXuint)(FXuchar)(a)<<24))

// Make RGB color
#define FXRGB(r,g,b) (((FXuint)(FXuchar)(r)) | ((FXuint)(FXuchar)(g)<<8) | ((FXuint)(FXuchar)(b)<<16) | 0xff000000)

// Get alpha value from RGBA color
#define FXALPHAVAL(rgba)   ((FXuchar)((FXuint)(rgba)>>24))

// Get blue value from RGBA color
#define FXBLUEVAL(rgba) ((FXuchar)((FXuint)(rgba)>>16))

// Get green value from RGBA color
#define FXGREENVAL(rgba)  ((FXuchar)((FXuint)(rgba)>>8))

// Get red value from RGBA color
#define FXREDVAL(rgba) ((FXuchar)(rgba))

// Get component value of RGBA color
#define FXRGBACOMPVAL(rgba,comp) ((FXuchar)((rgba)>>((comp)<<3)))


// Assertion
#ifndef NDEBUG
#define FXASSERT(exp) ((exp)?((void)0):(void)fxassert(#exp,__FILE__,__LINE__))
#else
#define FXASSERT(exp) ((void)0)
#endif


// Tracing; use like: FXTRACE((10,"The value of x=%d\n",x)).
// Setting fxTraceLevel to N will cause all trace statements with
// trace levels greater than or equal to N to be blocked; trace
// statements with levels below N will be printed.
// Thus, fxTraceLevel equal to 0 will block all trace statements.
#ifndef NDEBUG
#define FXTRACE(arguments) fxtrace arguments
#else
#define FXTRACE(arguments) ((void)0)
#endif


// Memory allocation
#define FXMALLOC(ptr,type,no)     (fxmalloc((void **)(ptr),sizeof(type)*(no)))
#define FXCALLOC(ptr,type,no)     (fxcalloc((void **)(ptr),sizeof(type)*(no)))
#define FXRESIZE(ptr,type,no)     (fxresize((void **)(ptr),sizeof(type)*(no)))
#define FXFREE(ptr)               (fxfree((void **)(ptr)))


/**********************************  Globals  **********************************/

// Allocate memory
extern FXAPI FXint fxmalloc(void** ptr,unsigned long size);

// Allocate cleaned memory
extern FXAPI FXint fxcalloc(void** ptr,unsigned long size);

// Resize memory
extern FXAPI FXint fxresize(void** ptr,unsigned long size);

// Free memory, resets ptr to NULL afterward
extern FXAPI void fxfree(void** ptr);

// String duplicate
extern FXAPI FXchar *fxstrdup(const FXchar* str);

// Case independent compare
extern FXAPI int fxstrcasecmp(const FXchar* s1,const FXchar* s2);

// Error routine
extern FXAPI void fxerror(const char* format,...);

// Warning routine
extern FXAPI void fxwarning(const char* format,...);

// Log message to [typically] stderr
extern FXAPI void fxmessage(const char* format,...);

// Assert failed routine:- usually not called directly but called through FXASSERT
extern FXAPI void fxassert(const char* expression,const char* filename,unsigned int lineno);

// Trace printout routine:- usually not called directly but called through FXTRACE
extern FXAPI void fxtrace(unsigned int level,const char* format,...);

// Sleep n microseconds
extern FXAPI void fxsleep(unsigned int n);

// Key character value of keysym + modifier state
extern FXAPI FXchar fxkeyval(FXuint code,FXuint state=0);

// Match a file name with a pattern
extern FXAPI FXint fxfilematch(const char *pattern,const char *string,FXuint flags=(FILEMATCH_NOESCAPE|FILEMATCH_FILE_NAME));

// Parse for accelerator key codes in a string
extern FXAPI FXHotKey fxparseaccel(const FXchar* s);

// Parse for hot key codes in a string
extern FXAPI FXHotKey fxparsehotkey(const FXchar* s);

// Locate hot key underline offset from begin of string
extern FXAPI FXint fxfindhotkeyoffset(const FXchar* s);

// Get highlight color
extern FXAPI FXColor makeHiliteColor(FXColor clr);

// Get shadow color
extern FXAPI FXColor makeShadowColor(FXColor clr);

// Get user name from uid
extern FXAPI FXchar* fxgetusername(FXchar* result,FXuint uid);

// Get group name from gid
extern FXAPI FXchar* fxgetgroupname(FXchar* result,FXuint gid);

// Get permissions string from mode
extern FXAPI FXchar* fxgetpermissions(FXchar* result,FXuint mode);

// Return TRUE iff s is a prefix of t
extern FXAPI FXbool fxprefix(const FXchar* s,const FXchar* t);

// Return TRUE iff s is a suffix of t
extern FXAPI FXbool fxsuffix(const FXchar* s, const FXchar* t);

// Expand ~ in filenames; using HOME environment variable
extern FXAPI FXchar* fxexpand(FXchar* result,const FXchar* name);

// Construct a full pathname from the given directory and file name
extern FXAPI FXchar* fxpathname(FXchar* result,const FXchar* dirname,const FXchar* filename);

// Return the directory part of pathname
extern FXAPI FXchar* fxdirpart(FXchar* result,const FXchar* pathname);

// Return the file title, i.e. filename less extension part of pathname
extern FXAPI FXchar* fxfiletitle(FXchar* result,const FXchar* pathname);

// Return the filename part of pathname
extern FXAPI FXchar* fxfilepart(FXchar* result,const FXchar* pathname);

// Return the file extension part of pathname
extern FXAPI FXchar* fxfileext(FXchar* result,const FXchar* pathname);

// Check whether a file exists
extern FXAPI FXbool fxexists(const FXchar *name);

// Check whether its a directory
extern FXAPI FXbool fxisdir(const FXchar *name);

// Check whether its a file
extern FXAPI FXbool fxisfile(const FXchar *name);

// Create a unique numbered backup file name for the given pathname 
extern FXAPI FXchar* fxbakname(FXchar* result,const FXchar* pathname);

// Check whether two files are identical (refer to the same inode)
extern FXAPI FXbool fxidentical(const FXchar *name1,const FXchar *name2);

// Split a string into substrings delimited by a given character
extern FXAPI FXchar *fxsplit(FXchar*& s,FXchar c);

// Return the shortest path equivalent to pathname (remove . and ..)
extern FXAPI FXchar *fxshortestpath(FXchar *result,const FXchar *pathname);

// Return directory one level above given one
extern FXAPI FXchar* fxupdir(FXchar* result,const FXchar *dirname);

// Translate filename to an absolute pathname; ~ in filename is expanded,
// and if the resulting pathname is still relative, basename is prepended
extern FXAPI FXchar *fxabspath(FXchar *result,const FXchar *basename,const FXchar *filename);

// Test if path is the toplevel directory
extern FXAPI FXbool fxistopdir(const FXchar* path);

// Get current working directory
extern FXAPI FXchar* fxgetcurrentdir(FXchar *result);

// Make a directory
extern FXAPI FXint fxmkdir(const FXchar *pathname,FXuint mode);

// Get home directory
extern FXAPI FXchar* fxgethomedir(FXchar *result);

// Search path for file name. A ~ in path is expanded. If name is absolute
// it is returned unchanged. Otherwise the absolute name is returned in
// result. If name is not found on path, NULL is returned. 
extern FXAPI FXchar *fxsearchpath(FXchar *result,const FXchar *path,const FXchar *name);

// Get process id
extern FXAPI FXint fxgetpid();

// Get RGB value from color name
extern FXAPI FXColor fxcolorfromname(const FXchar* colorname);

// Get name of (closest) color to RGB
extern FXAPI FXchar* fxnamefromcolor(FXchar *colorname,FXColor rgb);

// Load a gif file from a stream
extern FXAPI FXbool fxloadGIF(FXStream& store,FXuchar*& data,FXColor& transp,FXint& width,FXint& height);

// Save a gif file to a stream
extern FXAPI FXbool fxsaveGIF(FXStream& store,const FXuchar *data,FXColor transp,FXint width,FXint height);

// Load a bmp file from a stream
extern FXAPI FXbool fxloadBMP(FXStream& store,FXuchar*& data,FXColor& transp,FXint& width,FXint& height);

// Save a bmp file to a stream
extern FXAPI FXbool fxsaveBMP(FXStream& store,const FXuchar *data,FXColor transp,FXint width,FXint height);

// Load a jpeg from a stream
extern FXAPI FXbool fxloadJPEG(FXStream& store,FXuchar*& data,FXColor& transp,FXint& width,FXint& height,FXint& quality);

// Save a jpeg to a stream
extern FXAPI FXbool fxsaveJPEG(FXStream& store,const FXuchar* data,FXColor transp,FXint width,FXint height,FXint quality);

// Convert RGB to HSV
extern FXAPI void fxrgb_to_hsv(FXfloat& h,FXfloat& s,FXfloat& v,FXfloat r,FXfloat g,FXfloat b);

// Convert HSV to RGB
extern FXAPI void fxhsv_to_rgb(FXfloat& r,FXfloat& g,FXfloat& b,FXfloat h,FXfloat s,FXfloat v);

// Parse font description
extern FXAPI FXbool fxparsefontdesc(FXFontDesc& fontdesc,const FXchar* string);

// Unparse font description
extern FXAPI FXbool fxunparsefontdesc(FXchar *string,const FXFontDesc& fontdesc);

// Calculate a hash value from a string
extern FXAPI FXint fxstrhash(const FXchar* str);

// Reverse bits
extern FXAPI const FXuchar fxbitreverse[256];

// List of color names
extern FXAPI const FXNamedColor fxcolornames[];

// Number of color names
extern FXAPI const FXuint fxnumcolornames;

// Controls tracing level
extern FXAPI unsigned int fxTraceLevel;

#endif
