/********************************************************************************
*                                                                               *
*                   T o g g l e    B u t t o n    W i d g e t                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXToggleButton.h,v 1.2 1999/09/20 22:12:57 jeroen Exp $                  *
********************************************************************************/
#ifndef FXTOGGLEBUTTON_H
#define FXTOGGLEBUTTON_H



// Button flags
enum FXToggleButtonStyle {
  TOGGLEBUTTON_AUTOGRAY = 0x00800000,
  TOGGLEBUTTON_AUTOHIDE = 0x01000000,
  TOGGLEBUTTON_TOOLBAR  = 0x02000000
  };


// Your basic button
class FXAPI FXToggleButton : public FXLabel {
  FXDECLARE(FXToggleButton)
protected:
  FXString  altlabel; 
  FXIcon   *alticon;
  FXHotKey  althotkey;
  FXint     althotoff;
  FXuchar   oldstate;
  FXuchar   state;
  FXString  tip;
  FXString  help;
  FXString  alttip;
  FXString  althelp;
protected:
  FXToggleButton();
private:
  FXToggleButton(const FXToggleButton&);
  FXToggleButton& operator=(const FXToggleButton&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onUpdate(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onActivate(FXObject*,FXSelector,void*);
  long onDeactivate(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onHotKeyPress(FXObject*,FXSelector,void*);
  long onHotKeyRelease(FXObject*,FXSelector,void*);
  long onCheck(FXObject*,FXSelector,void*);
  long onUncheck(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);
  long onCmdGetIntValue(FXObject*,FXSelector,void*);
public:
  FXToggleButton(FXComposite* p,const FXString& text1,const FXString& text2,FXIcon* icon1=NULL,FXIcon* icon2=NULL,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_RAISED|FRAME_THICK|JUSTIFY_NORMAL|ICON_BEFORE_TEXT,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual void create();
  virtual void detach();
  virtual void enable();
  virtual void disable();
  virtual FXbool canFocus() const;
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  void setAltText(const FXString& text);
  FXString getAltText() const { return altlabel; }
  void setAltIcon(FXIcon* ic);
  FXIcon* getAltIcon() const { return alticon; }
  void setState(FXuint s=TRUE);
  FXuint getState() const { return state; }
  void setHelpText(const FXString& text);
  FXString getHelpText() const { return help; }
  void setAltHelpText(const FXString& text);
  FXString getAltHelpText() const { return althelp; }
  void setTipText(const FXString& text);
  FXString getTipText() const { return tip; }
  void setAltTipText(const FXString& text);
  FXString getAltTipText() const { return alttip; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXToggleButton();
  };

  
#endif
