/********************************************************************************
*                                                                               *
*                           S l i d e r   W i d g e t                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXSlider.h,v 1.5 1999/11/09 23:58:37 jeroen Exp $                        *
********************************************************************************/
#ifndef FXSLIDER_H
#define FXSLIDER_H


// Default sizes looks nice
#define SLIDERBAR_SIZE   5
#define SLIDERHEAD_SIZE  7


// Sliderbar options
enum FXSliderStyle {
 SLIDER_HORIZONTAL  = 0,
 SLIDER_VERTICAL    = 0x00008000,
 SLIDER_ARROW_UP    = 0x00010000,
 SLIDER_ARROW_DOWN  = 0x00020000,
 SLIDER_ARROW_LEFT  = SLIDER_ARROW_UP,
 SLIDER_ARROW_RIGHT = SLIDER_ARROW_DOWN,
 SLIDER_INSIDE_BAR  = 0x00040000 
 };
 
 
  
// Scroll bar
class FXAPI FXSlider : public FXFrame {
  FXDECLARE(FXSlider)
protected:
  FXTimer      *timer;
  FXint         range[2];                         // Reported data range
  FXColor       slotColor;
  FXint         headpos;
  FXint         headsize;
  FXint         slotsize;
  FXint         dragpoint;
  FXint         incr;
  FXint         pos;                              // Reported data position
  FXString      help;                             // Help string
  FXString      tip;                              // Tip string
protected:
  FXSlider();
  virtual void layout();
  void drawSliderHead(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
private:
  FXSlider(const FXSlider&);
  FXSlider &operator=(const FXSlider&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMiddleBtnPress(FXObject*,FXSelector,void*);
  long onMiddleBtnRelease(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onTimeInc(FXObject*,FXSelector,void*);
  long onTimeDec(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);
  long onCmdGetIntValue(FXObject*,FXSelector,void*);
  long onCmdSetRealValue(FXObject*,FXSelector,void*);
  long onCmdGetRealValue(FXObject*,FXSelector,void*);
  long onCmdSetIntRange(FXObject*,FXSelector,void*);
  long onCmdGetIntRange(FXObject*,FXSelector,void*);
  long onCmdSetRealRange(FXObject*,FXSelector,void*);
  long onCmdGetRealRange(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);
public:
  enum{
    ID_AUTOINC=FXFrame::ID_LAST,
    ID_AUTODEC,
    ID_LAST
    };
public:
  FXSlider(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=0,FXint pr=0,FXint pt=0,FXint pb=0);
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  virtual void enable();
  virtual void disable();
  void setRange(FXint lo,FXint hi);
  void getRange(FXint& lo,FXint& hi) const { lo=range[0]; hi=range[1]; }
  void setPosition(FXint p);
  FXint getPosition() const { return pos; }
  FXuint getSliderStyle() const;
  void setSliderStyle(FXuint opts);
  FXint getHeadSize() const { return headsize; }
  void setHeadSize(FXint hs);
  FXint getSlotSize() const { return slotsize; }
  void setSlotSize(FXint bs);
  FXint getIncrement() const { return incr; }
  void setIncrement(FXint inc);
  FXColor getSlotColor() const { return slotColor; }
  FXColor getHiliteColor() const { return hiliteColor; }
  FXColor getShadowColor() const { return shadowColor; }
  FXColor getBorderColor() const { return borderColor; }
  FXColor getBaseColor() const { return baseColor; }
  void setSlotColor(FXColor clr);
  void setHiliteColor(FXColor clr);
  void setShadowColor(FXColor clr);
  void setBorderColor(FXColor clr);
  void setBaseColor(FXColor clr);
  void autoSlideInc();
  void autoSlideDec();
  void stopAutoSlide();
  FXbool isAutoSliding();
  void setHelpText(const FXString& text);
  FXString getHelpText() const { return help; }
  void setTipText(const FXString& text);
  FXString getTipText() const { return tip; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXSlider();
  };

  
#endif
