/********************************************************************************
*                                                                               *
*                          H e a d e r   W i d g e t                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXHeader.h,v 1.5 1999/11/09 23:58:37 jeroen Exp $                        *
********************************************************************************/
#ifndef FXHEADER_H
#define FXHEADER_H


  
enum FXHeaderStyle {
  HEADER_NORMAL     = 0,              // Default is non-clickable
  HEADER_BUTTON     = 0x00008000,     // Button style can be clicked
  HEADER_TRACKING   = 0x00010000      // Tracks continuously while moving
  };
  

// Header item
class FXAPI FXHeaderItem : public FXObject {
  FXDECLARE(FXHeaderItem)
  friend class FXHeader;
protected:
  FXString  label;
  FXIcon   *icon;
  FXint     size;
  void     *data;
protected:
  FXHeaderItem(){}
  virtual void draw(const FXHeader* header,FXDC& dc,FXint x,FXint y,FXint w,FXint h);
public:
  FXHeaderItem(const FXString& text,FXIcon* ic=NULL,FXint s=0,void* ptr=NULL):label(text),icon(ic),size(s),data(ptr){}
  void setText(const FXString& txt){ label=txt; }
  FXString getText() const { return label; }
  void setIcon(FXIcon* icn){ icon=icn; }
  FXIcon* getIcon() const { return icon; }
  void setData(void* ptr){ data=ptr; }
  void* getData() const { return data; }
  virtual FXint getWidth(const FXHeader* header) const;
  virtual FXint getHeight(const FXHeader* header) const;
  virtual void create();
  virtual void detach();
  virtual void destroy();
  virtual ~FXHeaderItem(){}
  };

  
// Splitter window 
class FXAPI FXHeader : public FXFrame {
  FXDECLARE(FXHeader)
protected:
  FXHeaderItem **items;
  FXint          nitems;
  FXColor        textColor;
  FXbool         state;
  FXFont*        font;
  FXint          active;
  FXint          activex;
  FXint          activew;
  FXint          off;
protected:
  FXHeader();
  void drawSplit(FXint pos);
  virtual FXHeaderItem *createItem(const FXString& text,FXIcon* icon,FXint size,void* ptr);
  virtual void layout();
private:
  FXHeader(const FXHeader&);
  FXHeader &operator=(const FXHeader&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
public:
  FXHeader(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual void create();
  virtual void detach();
  FXint getNumItems() const { return nitems; }
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  FXHeaderItem *retrieveItem(FXint index) const;
  FXint appendItem(FXHeaderItem* item);
  FXint appendItem(const FXString& text,FXIcon *icon=NULL,FXint size=0,void* ptr=NULL);
  void removeItem(FXint index);
  void clearItems();
  FXint getItemAt(FXint offset) const;
  void setItemText(FXint index,const FXString& text);
  FXString getItemText(FXint index) const;
  void setItemIcon(FXint index,FXIcon* icon);
  FXIcon* getItemIcon(FXint index) const;
  void setItemSize(FXint index,FXint size);
  FXint getItemSize(FXint index) const;
  FXint getItemOffset(FXint index) const;
  void setItemData(FXint index,void* ptr);
  void* getItemData(FXint index) const;
  void setFont(FXFont* fnt);
  FXFont* getFont() const { return font; }
  FXColor getTextColor() const { return textColor; }
  void setTextColor(FXColor clr);
  void setHeaderStyle(FXuint style);
  FXuint getHeaderStyle() const;
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXHeader();
  };


#endif
