/********************************************************************************
*                                                                               *
*                        F i l e    L i s t   W i d g e t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXFileList.h,v 1.4 1999/11/16 18:29:25 jeroen Exp $                      *
********************************************************************************/
#ifndef FXFILELIST_H
#define FXFILELIST_H


struct FXFileAssoc;                   // File association
class  FXFileDict;                    // Dictionary of file associations



// File List options
enum FXFileListStyle {
  FILELIST_SHOWHIDDEN  = 0x10000000,  // Show hidden files or directories
  FILELIST_SHOWDIRS    = 0x20000000   // Show only directories
  };
  


// File item
class FXAPI FXFileItem : public FXIconItem {
  FXDECLARE(FXFileItem)
  friend class FXFileList;
protected:
  FXFileAssoc *assoc;                       // File association record
  long         size;                        // File size
  long         date;                        // File time
protected:
  FXFileItem():assoc(NULL),size(0),date(0){}
protected:
  enum{
    FOLDER     = 32,                        // Directory item
    EXECUTABLE = 64,                        // Executable item
    SYMLINK    = 128,                       // Symbolic linked item
    CHARDEV    = 256,                       // Character special item
    BLOCKDEV   = 512,                       // Block special item
    FIFO       = 1024,                      // FIFO item
    SOCK       = 2048                       // Socket item
    };
public:
  FXFileItem(const FXString& text,FXIcon* bi=NULL,FXIcon* mi=NULL,void* ptr=NULL):FXIconItem(text,bi,mi,ptr),assoc(NULL),size(0),date(0){}
  FXbool isDirectory() const { return (state&FOLDER)!=0; }
  FXbool isExecutable() const { return (state&EXECUTABLE)!=0; }
  FXbool isSymlink() const { return (state&SYMLINK)!=0; }
  FXbool isChardev() const { return (state&CHARDEV)!=0; }
  FXbool isBlockdev() const { return (state&BLOCKDEV)!=0; }
  FXbool isFifo() const { return (state&FIFO)!=0; }
  FXbool isSocket() const { return (state&SOCK)!=0; }
  FXFileAssoc* getAssoc() const { return assoc; }
  long getSize() const { return size; }
  long getDate() const { return date; }
  };


// File List object
class FXAPI FXFileList : public FXIconList {
  FXDECLARE(FXFileList)
protected:
  FXString     directory;             // Current directory
  FXFileDict  *associations;          // Association table
  FXString     pattern;               // Pattern of file names
  FXuint       matchmode;             // File wildcard match mode
  FXint        timestamp;             // Time when last refreshed
  FXTimer     *refresh;               // Refresh timer
  FXGIFIcon   *big_folder;            // Big folder icon
  FXGIFIcon   *mini_folder;           // Mini folder icon
  FXGIFIcon   *big_doc;               // Big document icon
  FXGIFIcon   *mini_doc;              // Mini document icon
  FXGIFIcon   *big_app;               // Big application icon
  FXGIFIcon   *mini_app;              // Mini application icon
protected:
  FXFileList();
  FXint getFilenameItem(const FXchar *filename) const;
  virtual FXIconItem *createItem(const FXString& text,FXIcon *big,FXIcon* mini,void* ptr);
  void listDirectory();
private:
  FXFileList(const FXFileList&);
  FXFileList &operator=(const FXFileList&);
public:
  long onRefresh(FXObject*,FXSelector,void*);
  long onDNDEnter(FXObject*,FXSelector,void*);
  long onDNDLeave(FXObject*,FXSelector,void*);
  long onDNDMotion(FXObject*,FXSelector,void*);
  long onDNDDrop(FXObject*,FXSelector,void*);
  long onDNDRequest(FXObject*,FXSelector,void*);
  long onSelectionRequest(FXObject*,FXSelector,void* ptr);
  long onBeginDrag(FXObject*,FXSelector,void*);
  long onEndDrag(FXObject*,FXSelector,void*);
  long onDragged(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdGetStringValue(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
  long onCmdDirectoryUp(FXObject*,FXSelector,void*);
  long onUpdDirectoryUp(FXObject*,FXSelector,void*);
  long onCmdDirectoryNew(FXObject*,FXSelector,void*);
  long onUpdDirectoryNew(FXObject*,FXSelector,void*);
  long onCmdSortByName(FXObject*,FXSelector,void*);
  long onUpdSortByName(FXObject*,FXSelector,void*);
  long onCmdSortByType(FXObject*,FXSelector,void*);
  long onUpdSortByType(FXObject*,FXSelector,void*);
  long onCmdSortBySize(FXObject*,FXSelector,void*);
  long onUpdSortBySize(FXObject*,FXSelector,void*);
  long onCmdSortByTime(FXObject*,FXSelector,void*);
  long onUpdSortByTime(FXObject*,FXSelector,void*);
  long onCmdSortByUser(FXObject*,FXSelector,void*);
  long onUpdSortByUser(FXObject*,FXSelector,void*);
  long onCmdSortByGroup(FXObject*,FXSelector,void*);
  long onUpdSortByGroup(FXObject*,FXSelector,void*);
  long onCmdSortReverse(FXObject*,FXSelector,void*);
  long onUpdSortReverse(FXObject*,FXSelector,void*);
  long onCmdSetPattern(FXObject*,FXSelector,void*);
  long onUpdSetPattern(FXObject*,FXSelector,void*);
  long onCmdSetDirectory(FXObject*,FXSelector,void*);
  long onUpdSetDirectory(FXObject*,FXSelector,void*);
  long onCmdToggleHidden(FXObject*,FXSelector,void*);
  long onUpdToggleHidden(FXObject*,FXSelector,void*);
  long onCmdShowHidden(FXObject*,FXSelector,void*);
  long onUpdShowHidden(FXObject*,FXSelector,void*);
  long onCmdHideHidden(FXObject*,FXSelector,void*);
  long onUpdHideHidden(FXObject*,FXSelector,void*);
  long onCmdHeader(FXObject*,FXSelector,void*);
public:
  static FXint cmpFName(const FXIconItem* pa,const FXIconItem* pb);
  static FXint cmpRName(const FXIconItem* pa,const FXIconItem* pb);
  static FXint cmpFType(const FXIconItem* pa,const FXIconItem* pb);
  static FXint cmpRType(const FXIconItem* pa,const FXIconItem* pb);
  static FXint cmpFSize(const FXIconItem* pa,const FXIconItem* pb);
  static FXint cmpRSize(const FXIconItem* pa,const FXIconItem* pb);
  static FXint cmpFTime(const FXIconItem* pa,const FXIconItem* pb);
  static FXint cmpRTime(const FXIconItem* pa,const FXIconItem* pb);
  static FXint cmpFUser(const FXIconItem* pa,const FXIconItem* pb);
  static FXint cmpRUser(const FXIconItem* pa,const FXIconItem* pb);
  static FXint cmpFGroup(const FXIconItem* pa,const FXIconItem* pb);
  static FXint cmpRGroup(const FXIconItem* pa,const FXIconItem* pb);
public:
  enum {
    ID_SORT_BY_NAME=FXIconList::ID_LAST,
    ID_SORT_BY_TYPE,
    ID_SORT_BY_SIZE,
    ID_SORT_BY_TIME,
    ID_SORT_BY_USER,
    ID_SORT_BY_GROUP,
    ID_SORT_REVERSE,
    ID_DIRECTORY_UP,
    ID_DIRECTORY_NEW,
    ID_SET_PATTERN,
    ID_SET_DIRECTORY,
    ID_SHOW_HIDDEN,
    ID_HIDE_HIDDEN,
    ID_TOGGLE_HIDDEN,
    ID_REFRESH,
    ID_LAST
    };
public:
  FXFileList(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  virtual void create();
  virtual void detach();
  virtual void destroy();
  void setCurrentFile(const FXString& file);
  FXString getCurrentFile() const;
  void setDirectory(const FXString& path);
  FXString getDirectory() const { return directory; }
  void setPattern(const FXString& ptrn);
  FXString getPattern() const { return pattern; }
  FXbool isItemDirectory(FXint index) const;
  FXbool isItemFile(FXint index) const;
  FXbool isItemExecutable(FXint index) const;
  FXString getItemFilename(FXint index) const;
  FXString getItemPathname(FXint index) const;
  FXFileAssoc* getItemAssoc(FXint index) const;
  FXuint getMatchMode() const { return matchmode; }
  void setMatchMode(FXuint mode);
  FXbool showHiddenFiles() const;
  void showHiddenFiles(FXbool shown);
  FXbool showOnlyDirectories() const;
  void showOnlyDirectories(FXbool shown);
  void setAssociations(FXFileDict* assoc);
  FXFileDict* getAssociations() const { return associations; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXFileList();
  };


#endif
