/********************************************************************************
*                                                                               *
*                       D r a g   C o r n e r   W i d g e t                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXDragCorner.h,v 1.2 1999/09/20 22:12:56 jeroen Exp $                    *
********************************************************************************/
#ifndef FXDRAGCORNER_H
#define FXDRAGCORNER_H


// Drag corner
class FXAPI FXDragCorner : public FXWindow {
  FXDECLARE(FXDragCorner)
protected:
  FXColor hiliteColor;
  FXColor shadowColor;
  FXint   oldw;
  FXint   oldh;
  FXint   xoff;
  FXint   yoff;
protected:
  FXDragCorner();
private:
  FXDragCorner(const FXDragCorner&);
  FXDragCorner &operator=(const FXDragCorner&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
public:
  FXDragCorner(FXComposite* p);
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  FXColor getHiliteColor() const { return hiliteColor; }
  FXColor getShadowColor() const { return shadowColor; }
  void setHiliteColor(FXColor clr);
  void setShadowColor(FXColor clr);
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  };



#endif
