/********************************************************************************
*                                                                               *
*                        F i l e    L i s t   O b j e c t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXOldFileList.cpp,v 1.3 1999/11/16 18:29:24 jeroen Exp $                 *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXLabel.h"
#include "FXButton.h"
#include "FXComposite.h"
#include "FXCanvas.h"
#include "FXShell.h"
#include "FXScrollbar.h"
#include "FXScrollWindow.h"
#include "FXFileDict.h"
#include "FXOldHeader.h"
#include "FXOldIconList.h"
#include "FXOldFileList.h"




/*
  Notes:
  - Fix (at least) hard-wired icons 
  - When an item is selected, we should acquire selection; so if another
    application does a paste, it will get the full pathname.
  - Of course, vice versa a paste of a dirname in the FXOldFileList should
    switch it to the directory...
  - Instead of FXIconItems, callbacks should pass filename.
  - Translate onClicked etc into opened/launched, etc messages
  - ID_SETSTRINGVALUE etc messages so we can connect text fields with
    FXOldFileList...
  - Clipboard of filenames.
  - Clipboard, DND, etc. support.
*/


#define REFRESHINTERVAL     1000
#define REFRESHINTERVALLONG 15000


/*******************************************************************************/

/* Generated by reswrap from file bigapp.gif */
const unsigned char bigapp[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0x00,0x00,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x80,0xff,0xff,0xff,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x03,
  0x82,0x08,0xba,0xdc,0xfe,0x2c,0xc8,0x49,0xab,0xbd,0x53,0x84,0xc1,0xbb,0xff,0x60,
  0x38,0x04,0xda,0x40,0x9c,0x68,0xaa,0xae,0x2c,0xb9,0xb1,0x70,0xca,0x09,0xf3,0xec,
  0x9a,0x71,0x5c,0x0f,0x34,0x7f,0xe7,0x31,0x81,0x70,0x38,0xbc,0x89,0x8e,0xc8,0x51,
  0x09,0xc3,0x6c,0x2a,0x37,0x81,0x82,0x74,0x4a,0xad,0x5a,0xab,0xcf,0xd1,0x75,0xcb,
  0x95,0x66,0xa3,0xdd,0x30,0xf5,0x2b,0x2e,0x17,0xc8,0xe6,0x30,0x3a,0xcd,0x5d,0xb3,
  0xaf,0xee,0x37,0xf6,0x06,0x96,0x5b,0xe3,0x76,0x2f,0x3d,0x7f,0xdf,0xf3,0xc7,0x7e,
  0x7f,0x7a,0x4b,0x82,0x53,0x78,0x79,0x87,0x76,0x89,0x72,0x8b,0x6f,0x59,0x49,0x90,
  0x1f,0x2e,0x4d,0x94,0x4c,0x44,0x97,0x98,0x99,0x9a,0x43,0x10,0x9d,0x9e,0x9f,0xa0,
  0xa1,0x00,0x09,0x00,0x3b
  };

/* Generated by reswrap from file miniapp.gif */
const unsigned char miniapp[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x80,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x38,0x08,0xba,0xdc,0x10,0x30,0xca,0x09,0x85,0xbd,0xf8,0x86,0x11,0x44,0xf9,0x60,
  0xf8,0x6d,0x9d,0x58,0x10,0x03,0x8a,0x92,0x02,0xe5,0x72,0x02,0x21,0xcf,0xb4,0xcc,
  0xd6,0x38,0x71,0xe7,0xf4,0xce,0xdb,0xb0,0xdf,0xcc,0xf7,0x23,0xf2,0x48,0xae,0xd7,
  0x60,0xc9,0x6c,0x3a,0x07,0x8e,0xe8,0x22,0x01,0x00,0x3b
  };

/* Generated by reswrap from file bigdoc.gif */
const unsigned char bigdoc[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf2,0x00,0x00,0xbf,0xbf,0xbf,
  0x80,0x80,0x80,0xff,0xff,0xff,0x00,0x00,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x03,
  0x79,0x08,0x0a,0xd1,0xfe,0xf0,0xad,0x49,0x99,0xb8,0x38,0xeb,0x1b,0x46,0xad,0xc1,
  0x26,0x66,0x8d,0xf7,0x2d,0xe1,0x38,0x06,0x44,0x77,0x2a,0xa9,0xba,0x85,0xad,0xf9,
  0xc5,0x32,0x79,0xd5,0x27,0x9e,0x73,0x83,0xa0,0xf0,0xf6,0x93,0x11,0x6c,0x13,0x5f,
  0x31,0x73,0x24,0x2e,0x45,0x4d,0xd0,0x13,0x8a,0x44,0x4d,0x37,0x51,0x8a,0x72,0x9a,
  0x4d,0x5e,0x35,0x5d,0xeb,0x17,0x13,0x86,0x8d,0xc9,0x55,0xf3,0x59,0x50,0xb6,0xac,
  0xdb,0xdb,0x27,0x7c,0xcd,0x4e,0xbb,0xcf,0xf3,0xb7,0x3d,0xbe,0xcc,0xe3,0xf7,0x74,
  0x7e,0x63,0x82,0x5f,0x84,0x57,0x86,0x5c,0x80,0x7a,0x37,0x04,0x8d,0x8e,0x8f,0x90,
  0x91,0x8d,0x76,0x42,0x95,0x96,0x97,0x98,0x0b,0x09,0x00,0x3b
  };
  
  
/* Generated by reswrap from file minidoc.gif */
const unsigned char minidoc[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xbf,0xbf,0xbf,
  0x80,0x80,0x80,0xff,0xff,0xff,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x36,0x08,0x10,0xdc,0xae,0x70,0x89,0x49,0xe7,0x08,0x51,0x56,0x3a,0x04,0x86,0xc1,
  0x46,0x11,0x24,0x01,0x8a,0xd5,0x60,0x2a,0x21,0x6a,0xad,0x9a,0xab,0x9e,0xae,0x30,
  0xb3,0xb5,0x0d,0xb7,0xf2,0x9e,0xdf,0x31,0x14,0x90,0x27,0xf4,0xd5,0x86,0x83,0xa4,
  0x72,0x09,0x2c,0x39,0x9f,0xa6,0x04,0x00,0x3b
  };

  
/* Generated by reswrap from file bigfolder.gif */
const unsigned char bigfolder[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xff,0xff,0xff,0xff,0xff,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x80,
  0x80,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x03,
  0x83,0x08,0xba,0xdc,0xfe,0x30,0xca,0x49,0x6b,0x0c,0x38,0x67,0x0b,0x83,0xf8,0x20,
  0x18,0x70,0x8d,0x37,0x10,0x67,0x8a,0x12,0x23,0x09,0x98,0xab,0xaa,0xb6,0x56,0x40,
  0xdc,0x78,0xae,0x6b,0x3c,0x5f,0xbc,0xa1,0xa0,0x70,0x38,0x2c,0x14,0x60,0xb2,0x98,
  0x32,0x99,0x34,0x1c,0x05,0xcb,0x28,0x53,0xea,0x44,0x4a,0xaf,0xd3,0x2a,0x74,0xca,
  0xc5,0x6a,0xbb,0xe0,0xa8,0x16,0x4b,0x66,0x7e,0xcb,0xe8,0xd3,0x38,0xcc,0x46,0x9d,
  0xdb,0xe1,0x75,0xba,0xfc,0x9e,0x77,0xe5,0x70,0xef,0x33,0x1f,0x7f,0xda,0xe9,0x7b,
  0x7f,0x77,0x7e,0x7c,0x7a,0x56,0x85,0x4d,0x84,0x82,0x54,0x81,0x88,0x62,0x47,0x06,
  0x91,0x92,0x93,0x94,0x95,0x96,0x91,0x3f,0x46,0x9a,0x9b,0x9c,0x9d,0x9e,0x9a,0x2e,
  0xa1,0xa2,0x13,0x09,0x00,0x3b
  };
  
  

/* Generated by reswrap from file bigofolder.gif */
const unsigned char bigfolderopen[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x20,0x00,0x20,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x77,0x77,0x77,0xff,0xff,0xff,0xff,0xff,0x00,0xbb,0xbb,0xbb,0x00,0x00,0x00,0x80,
  0x80,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x03,
  0xa1,0x08,0xba,0x10,0xfe,0x8f,0xc9,0x49,0x83,0xb8,0x18,0x07,0xca,0xa5,0x1d,0x04,
  0x28,0x86,0xc4,0xd6,0x71,0x1f,0x39,0x8e,0xe6,0xc9,0xa4,0xab,0x4a,0x42,0xb4,0xe3,
  0x09,0x72,0x2c,0x66,0xfc,0x55,0xbc,0x02,0x5d,0x6e,0xb8,0x32,0xfc,0x14,0x16,0xa2,
  0x52,0x68,0x5c,0xc0,0x96,0xd0,0x41,0xd3,0x41,0xa8,0x5a,0xaf,0xd8,0xec,0x15,0x64,
  0xb4,0xf4,0xbe,0xe0,0x4c,0x21,0x20,0x1d,0x0b,0xcf,0xca,0x40,0x81,0xd0,0x8d,0xba,
  0x07,0xea,0x32,0xf9,0x1d,0x1d,0xb7,0xd1,0x78,0x99,0xfd,0x17,0xa0,0xe3,0xd5,0x53,
  0x79,0x82,0x25,0x05,0x53,0x7e,0x50,0x85,0x7c,0x83,0x82,0x89,0x48,0x8b,0x50,0x6a,
  0x47,0x7d,0x8f,0x67,0x91,0x8e,0x87,0x42,0x04,0x05,0x92,0x98,0x4a,0x9b,0x4e,0x9d,
  0x3a,0x4d,0x97,0x94,0x43,0xa3,0x0d,0x06,0xa9,0xaa,0xab,0xac,0xad,0xad,0x47,0x0a,
  0x9b,0xb2,0xb3,0xb4,0xb5,0xb6,0x2e,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,0xc0,
  0x13,0x09,0x00,0x3b
  };

/* Generated by reswrap from file minifolder.gif */
const unsigned char minifolder[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xc0,0xc0,0xc0,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x3b,0x08,0xba,0xdc,0x1b,0x10,0x3a,0x16,0xc4,0xb0,0x22,0x4c,0x50,0xaf,0xcf,0x91,
  0xc4,0x15,0x64,0x69,0x92,0x01,0x31,0x7e,0xac,0x95,0x8e,0x58,0x7b,0xbd,0x41,0x21,
  0xc7,0x74,0x11,0xef,0xb3,0x5a,0xdf,0x9e,0x1c,0x6f,0x97,0x03,0xba,0x7c,0xa1,0x64,
  0x48,0x05,0x20,0x38,0x9f,0x50,0xe8,0x66,0x4a,0x75,0x24,0x00,0x00,0x3b
  };

/* Generated by reswrap from file minifolderopen.gif */
const unsigned char minifolderopen[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x7f,0x7f,0x7f,0xff,0xff,0xff,0xd9,0xd9,0xd9,0xff,0xff,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x42,0x08,0xba,0xdc,0x2c,0x10,0xba,0x37,0x6a,0x15,0x13,0x88,0x41,0x4a,0x27,0x43,
  0x14,0x29,0x9b,0x67,0x82,0x56,0x18,0x68,0xdc,0xe9,0x12,0x42,0x20,0xce,0x62,0x11,
  0x6f,0x69,0x1e,0xc3,0x72,0xfb,0xb9,0xb2,0x18,0xeb,0x47,0xbc,0xad,0x4a,0xc4,0x93,
  0x6c,0xc5,0x7a,0x99,0x62,0x4c,0x1a,0x2d,0xc0,0x04,0x50,0xaf,0x58,0x6c,0x66,0xcb,
  0x6d,0x24,0x00,0x00,0x3b
  };


/*******************************************************************************/


// Map
FXDEFMAP(FXOldFileList) FXOldFileListMap[]={
  FXMAPFUNC(SEL_DRAGGED,0,FXOldFileList::onDragged),
  FXMAPFUNC(SEL_TIMEOUT,FXOldFileList::ID_REFRESH,FXOldFileList::onRefresh),
  FXMAPFUNC(SEL_DND_ENTER,0,FXOldFileList::onDNDEnter),
  FXMAPFUNC(SEL_DND_LEAVE,0,FXOldFileList::onDNDLeave),
  FXMAPFUNC(SEL_DND_DROP,0,FXOldFileList::onDNDDrop),
  FXMAPFUNC(SEL_DND_MOTION,0,FXOldFileList::onDNDMotion),
  FXMAPFUNC(SEL_DND_REQUEST,0,FXOldFileList::onDNDRequest),
  FXMAPFUNC(SEL_BEGINDRAG,0,FXOldFileList::onBeginDrag),
  FXMAPFUNC(SEL_ENDDRAG,0,FXOldFileList::onEndDrag),
  FXMAPFUNC(SEL_SELECTION_REQUEST,0,FXOldFileList::onSelectionRequest),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_DIRECTORY_UP,FXOldFileList::onUpdDirectoryUp),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_DIRECTORY_NEW,FXOldFileList::onUpdDirectoryNew),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_SORT_BY_NAME,FXOldFileList::onUpdSortByName),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_SORT_BY_TYPE,FXOldFileList::onUpdSortByType),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_SORT_BY_SIZE,FXOldFileList::onUpdSortBySize),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_SORT_BY_TIME,FXOldFileList::onUpdSortByTime),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_SORT_BY_USER,FXOldFileList::onUpdSortByUser),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_SORT_BY_GROUP,FXOldFileList::onUpdSortByGroup),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_SORT_REVERSE,FXOldFileList::onUpdSortReverse),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_SET_PATTERN,FXOldFileList::onUpdSetPattern),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_SET_DIRECTORY,FXOldFileList::onUpdSetDirectory),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_SHOW_HIDDEN,FXOldFileList::onUpdShowHidden),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_HIDE_HIDDEN,FXOldFileList::onUpdHideHidden),
  FXMAPFUNC(SEL_UPDATE,FXOldFileList::ID_TOGGLE_HIDDEN,FXOldFileList::onUpdToggleHidden),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_DIRECTORY_UP,FXOldFileList::onCmdDirectoryUp),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_DIRECTORY_NEW,FXOldFileList::onCmdDirectoryNew),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_SORT_BY_NAME,FXOldFileList::onCmdSortByName),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_SORT_BY_TYPE,FXOldFileList::onCmdSortByType),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_SORT_BY_SIZE,FXOldFileList::onCmdSortBySize),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_SORT_BY_TIME,FXOldFileList::onCmdSortByTime),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_SORT_BY_USER,FXOldFileList::onCmdSortByUser),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_SORT_BY_GROUP,FXOldFileList::onCmdSortByGroup),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_SORT_REVERSE,FXOldFileList::onCmdSortReverse),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_SET_PATTERN,FXOldFileList::onCmdSetPattern),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_SET_DIRECTORY,FXOldFileList::onCmdSetDirectory),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXOldFileList::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE,FXOldFileList::onCmdSetStringValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE,FXOldFileList::onCmdGetStringValue),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_SHOW_HIDDEN,FXOldFileList::onCmdShowHidden),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_HIDE_HIDDEN,FXOldFileList::onCmdHideHidden),
  FXMAPFUNC(SEL_COMMAND,FXOldFileList::ID_TOGGLE_HIDDEN,FXOldFileList::onCmdToggleHidden),
  };


// Object implementation
FXIMPLEMENT(FXOldFileList,FXOldIconList,FXOldFileListMap,ARRAYNUMBER(FXOldFileListMap))


// For serialization
FXOldFileList::FXOldFileList(){
  refresh=NULL;
  list=NULL;
  timestamp=0;
  };
  
  
// File List
FXOldFileList::FXOldFileList(FXComposite *p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXOldIconList(p,tgt,sel,opts,x,y,w,h),directory(PATHSEPSTRING),pattern("*"){
  header->addItemLast("Name",NULL,200,this,ID_SORT_BY_NAME);
  header->addItemLast("Type",NULL,100,this,ID_SORT_BY_TYPE);
  header->addItemLast("Size",NULL,60,this,ID_SORT_BY_SIZE);
  header->addItemLast("Modified Date",NULL,150,this,ID_SORT_BY_TIME);
  header->addItemLast("User",NULL,50,this,ID_SORT_BY_USER);
  header->addItemLast("Group",NULL,50,this,ID_SORT_BY_GROUP);
  header->addItemLast("Attributes",NULL,100);
  refresh=NULL;
  list=NULL;
  timestamp=0;
  big_folder=new FXGIFIcon(getApp(),bigfolder);
  mini_folder=new FXGIFIcon(getApp(),minifolder);
  big_doc=new FXGIFIcon(getApp(),bigdoc);
  mini_doc=new FXGIFIcon(getApp(),minidoc);
  big_app=new FXGIFIcon(getApp(),bigapp);
  mini_app=new FXGIFIcon(getApp(),miniapp);
  sortfunc=cmpFName;
  matchmode=FILEMATCH_FILE_NAME|FILEMATCH_PERIOD|FILEMATCH_NOESCAPE;
#ifdef WIN32
  matchmode|=FILEMATCH_CASEFOLD;
#endif
  associations=new FXFileDict(getApp());
  }


// Starts the timer
void FXOldFileList::create(){
  FXOldIconList::create();
  refresh=getApp()->addTimeout(REFRESHINTERVAL,this,ID_REFRESH);
  big_folder->create();
  mini_folder->create();
  big_doc->create();
  mini_doc->create();
  big_app->create();
  mini_app->create();
  listDirectory();
  sortItems();
  }


// Detach disconnects the icons
void FXOldFileList::detach(){
  big_folder->detach();
  mini_folder->detach();
  big_doc->detach();
  mini_doc->detach();
  big_app->detach();
  mini_app->detach();  
  FXOldIconList::detach();
  }


// Destroy zaps the icons
void FXOldFileList::destroy(){
  big_folder->destroy();
  mini_folder->destroy();
  big_doc->destroy();
  mini_doc->destroy();
  big_app->destroy();
  mini_app->destroy();  
  FXOldIconList::destroy();
  }


// Create item
FXOldIconItem* FXOldFileList::createItem(){ 
  FXOldFileItem *item=new FXOldFileItem;
#ifdef WIN32
  item->date=new FILETIME;
#endif
  return (FXOldIconItem*) item;
  }


// Destroy item
void FXOldFileList::deleteItem(FXOldIconItem* item){
#ifdef WIN32
  delete ((FXOldFileItem*)item)->date;
#endif
  delete ((FXOldFileItem*)item); 
  }


// Somebody wants our selection
long FXOldFileList::onSelectionRequest(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  FXchar name[MAXPATHLEN+1],*p;
  FXuchar *data; 
  
  // Try handle through base class first
  if(FXOldIconList::onSelectionRequest(sender,sel,ptr)) return 1;

  // Otherwise (most likely) its the string from this text we return
  // Strictly speaking, we should return ALL selected items, not just the current one
  if(event->target==stringType || event->target==textType){
    FXTRACE((100,"%s: Get selection string\n",getClassName()));
    if(currentitem && isItemSelected(currentitem)){
      FXCALLOC(&data,FXuchar,MAXPATHLEN+1);
      strcpy(name,currentitem->label.text());
      if((p=strchr(name,'\t'))) *p=0;
      fxpathname((FXchar*)data,directory.text(),name);
      setDNDData(event->origin,stringType,data,strlen((FXchar*)data));
      return 1;
      }
    }

  return 0;
  }


/*******************************************************************************/


// Handle drag-and-drop enter
long FXOldFileList::onDNDEnter(FXObject* sender,FXSelector sel,void* ptr){
  FXOldIconList::onDNDEnter(sender,sel,ptr);
//   FXuchar *data;
//   FXuint   len;
//   if(getDNDData(FROM_DRAGNDROP,FXOldFileList::targetType,data,len)){
// for(int i=0; i<len; i+=4){ FXTRACE((10,"type=%08x\n",*((FXDragType*)&data[i]))); }
// //     if(*((FXDragType*)data) == FXColorWell::colorType){
// //       acceptDrop(DRAG_COPY);
// //       return 1;
// //       }
//     }
  return 1;
  }


// Handle drag-and-drop leave
long FXOldFileList::onDNDLeave(FXObject* sender,FXSelector sel,void* ptr){
  FXOldIconList::onDNDLeave(sender,sel,ptr);
  return 1;
  }


// Handle drag-and-drop motion
long FXOldFileList::onDNDMotion(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  if(startAutoScroll(event->win_x,event->win_y,FALSE)) return 1;
  if(FXOldIconList::onDNDMotion(sender,sel,ptr)) return 1;
  
//   // No more messages while inside
//   setDragRectangle(0,0,width,height,FALSE);
//   
//       
//   // Is it a color being dropped?
//   if(offeredDNDType(FXColorWell::colorType)){
//     acceptDrop(DRAG_COPY);
//     return 1;
//     }
  return 0;
  }


// Handle drag-and-drop drop
long FXOldFileList::onDNDDrop(FXObject* sender,FXSelector sel,void* ptr){
  // Try handling it in base class first
  if(FXOldIconList::onDNDDrop(sender,sel,ptr)) return 1;
  
//   // Try handle here
//   if(getDNDData(FROM_DRAGNDROP,colorType,data,len)){
//     sscanf((char*)data,"#%02x%02x%02x%02x",&r,&g,&b,&a);
//     setRGBA(FXRGBA(r,g,b,a));
//     FXFREE(&data);
//     if(target) target->handle(this,MKUINT(message,SEL_COMMAND),(void*)rgba); 
//     return 1;
//     }
  return 0;
  }


// Somebody wants our dragged data
long FXOldFileList::onDNDRequest(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handle through base class first
  if(FXOldIconList::onDNDRequest(sender,sel,ptr)) return 1;

  // Find what type they wanted
  return 0;
  }



// Start a drag operation
long FXOldFileList::onBeginDrag(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handling it in base class first
  if(FXOldIconList::onBeginDrag(sender,sel,ptr)) return 1;
  
  FXTRACE((100,"%s::onBeginDrag %08x\n",getClassName(),this));
  return 1;
  }


// End drag operation
long FXOldFileList::onEndDrag(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handling it in base class first
  if(FXOldIconList::onEndDrag(sender,sel,ptr)) return 1;
  
  FXTRACE((100,"%s::onEndDrag %08x\n",getClassName(),this));
  return 1;
  }


// Dragged stuff around
long FXOldFileList::onDragged(FXObject* sender,FXSelector sel,void* ptr){
  
  // Try handling it in base class first
  if(FXOldIconList::onDragged(sender,sel,ptr)) return 1;
  
  FXTRACE((100,"%s::onDragged %08x\n",getClassName(),this));
//     // Change cursor
//     action=DRAG_COPY;
//     if(isDropTarget()) action=DRAG_MOVE;
//     if(event->state&CONTROLMASK) action=DRAG_COPY;
//     if(event->state&SHIFTMASK) action=DRAG_MOVE;
//     if(event->state&ALTMASK) action=DRAG_LINK;
//     handleDrag(event->root_x,event->root_y,action);
//     if(didAccept()!=DRAG_REJECT){
//       if(action==DRAG_MOVE)
//         setDragCursor(getApp()->dndMoveCursor);
//       else if(action==DRAG_LINK)
//         setDragCursor(getApp()->dndLinkCursor);
//       else
//         setDragCursor(getApp()->dndCopyCursor);
//       }
//     else{
//       setDragCursor(getApp()->dontdropCursor);
//       }
  return 1;
  }


/*******************************************************************************/


// Set value from a message
long FXOldFileList::onCmdSetValue(FXObject*,FXSelector,void* ptr){
  if(ptr){ setCurrentFile((const FXchar*)ptr); }
  return 1;
  }


// Set current directory from dir part of filename
long FXOldFileList::onCmdSetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetStringValue: NULL pointer.\n",getClassName()); }
  setCurrentFile(*((FXString*)ptr));
  return 1;
  }


// Get current file name (NULL if no current file)
long FXOldFileList::onCmdGetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdGetStringValue: NULL pointer.\n",getClassName()); }
  *((FXString*)ptr)=getCurrentFile();
  return 1;
  }


// Toggle hidden files display
long FXOldFileList::onCmdToggleHidden(FXObject*,FXSelector,void*){
  showHiddenFiles(!showHiddenFiles());
  return 1;
  }


// Update toggle hidden files widget
long FXOldFileList::onUpdToggleHidden(FXObject* sender,FXSelector,void*){
  if(showHiddenFiles())
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Show hidden files
long FXOldFileList::onCmdShowHidden(FXObject*,FXSelector,void*){
  showHiddenFiles(TRUE);
  return 1;
  }


// Update show hidden files widget
long FXOldFileList::onUpdShowHidden(FXObject* sender,FXSelector,void*){
  if(showHiddenFiles())
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Hide hidden files
long FXOldFileList::onCmdHideHidden(FXObject*,FXSelector,void*){
  showHiddenFiles(FALSE);
  return 1;
  }


// Update hide hidden files widget
long FXOldFileList::onUpdHideHidden(FXObject* sender,FXSelector,void*){
  if(!showHiddenFiles())
    sender->handle(this,MKUINT(ID_CHECK,SEL_COMMAND),NULL);
  else
    sender->handle(this,MKUINT(ID_UNCHECK,SEL_COMMAND),NULL);
  return 1;
  }


// Move up one level
long FXOldFileList::onCmdDirectoryUp(FXObject*,FXSelector,void*){
  FXchar dir[MAXPATHLEN+1];
  setDirectory(fxupdir(dir,directory.text()));
  return 1;
  }


// Determine if we can still go up more
long FXOldFileList::onUpdDirectoryUp(FXObject* sender,FXSelector,void* ptr){
  FXuint msg = fxistopdir(directory.text()) ? ID_DISABLE : ID_ENABLE;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Create new directory
long FXOldFileList::onCmdDirectoryNew(FXObject*,FXSelector,void*){
  return 1;
  }


// Currently not yet implemented
long FXOldFileList::onUpdDirectoryNew(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=ID_DISABLE;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Change pattern
long FXOldFileList::onCmdSetPattern(FXObject*,FXSelector,void* ptr){
  if(!ptr) return 0;
  setPattern((const char*)ptr);
  return 1;
  }


// Update pattern
long FXOldFileList::onUpdSetPattern(FXObject* sender,FXSelector,void*){
  sender->handle(this,MKUINT(FXWindow::ID_SETVALUE,SEL_COMMAND),(void*)pattern.text());
  return 1;
  }


// Change directory
long FXOldFileList::onCmdSetDirectory(FXObject*,FXSelector,void* ptr){
  if(!ptr) return 0;
  setDirectory((const char*)ptr);
  return 1;
  }


// Update directory
long FXOldFileList::onUpdSetDirectory(FXObject* sender,FXSelector,void*){
  sender->handle(this,MKUINT(FXWindow::ID_SETVALUE,SEL_COMMAND),(void*)directory.text());
  return 1;
  }


// Sort by name
long FXOldFileList::onCmdSortByName(FXObject*,FXSelector,void*){
  sortfunc=(sortfunc==cmpFName)?cmpRName:cmpFName;
  sortItems();
  return 1;
  }


// Update sender
long FXOldFileList::onUpdSortByName(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpFName || sortfunc==cmpRName)?ID_CHECK:ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Sort by type
long FXOldFileList::onCmdSortByType(FXObject*,FXSelector,void*){
  sortfunc=(sortfunc==cmpFType)?cmpRType:cmpFType;
  sortItems();
  return 1;
  }


// Update sender
long FXOldFileList::onUpdSortByType(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpFType || sortfunc==cmpRType)?ID_CHECK:ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Sort by size
long FXOldFileList::onCmdSortBySize(FXObject*,FXSelector,void*){
  sortfunc=(sortfunc==cmpFSize)?cmpRSize:cmpFSize;
  sortItems();
  return 1;
  }


// Update sender
long FXOldFileList::onUpdSortBySize(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpFSize || sortfunc==cmpRSize)?ID_CHECK:ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Sort by time
long FXOldFileList::onCmdSortByTime(FXObject*,FXSelector,void*){
  sortfunc=(sortfunc==cmpFTime)?cmpRTime:cmpFTime;
  sortItems();
  return 1;
  }


// Update sender
long FXOldFileList::onUpdSortByTime(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpFTime || sortfunc==cmpRTime)?ID_CHECK:ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Sort by user
long FXOldFileList::onCmdSortByUser(FXObject*,FXSelector,void*){
  sortfunc=(sortfunc==cmpFUser)?cmpRUser:cmpFUser;
  sortItems();
  return 1;
  }


// Update sender
long FXOldFileList::onUpdSortByUser(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpFUser || sortfunc==cmpRUser)?ID_CHECK:ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Sort by group
long FXOldFileList::onCmdSortByGroup(FXObject*,FXSelector,void*){
  sortfunc=(sortfunc==cmpFGroup)?cmpRGroup:cmpFGroup;
  sortItems();
  return 1;
  }


// Update sender
long FXOldFileList::onUpdSortByGroup(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpFGroup || sortfunc==cmpRGroup)?ID_CHECK:ID_UNCHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


// Reverse sort order
long FXOldFileList::onCmdSortReverse(FXObject*,FXSelector,void*){
  sortItems();
  return 1;
  }


// Update sender
long FXOldFileList::onUpdSortReverse(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=ID_UNCHECK;
  if(sortfunc==cmpRName) msg=ID_CHECK;
  if(sortfunc==cmpRType) msg=ID_CHECK;
  if(sortfunc==cmpRSize) msg=ID_CHECK;
  if(sortfunc==cmpRTime) msg=ID_CHECK;
  if(sortfunc==cmpRUser) msg=ID_CHECK;
  if(sortfunc==cmpRGroup) msg=ID_CHECK;
  sender->handle(this,MKUINT(msg,SEL_COMMAND),ptr);
  return 1;
  }


/*******************************************************************************/

// Compare file names
FXbool FXOldFileList::cmpFName(const FXOldIconItem* a,const FXOldIconItem* b){
  const char *p,*q;
  if((((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY) != (((FXOldFileItem*)b)->state&OLDFILEITEM_DIRECTORY)){ 
    return (((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY)==0;
    }
  p=((FXOldFileItem*)a)->label.text();
  q=((FXOldFileItem*)b)->label.text();
  while(1){
    if(*p > *q) return 1;
    if(*p < *q) return 0;
    if(*p=='\t') return 0;
    p++;
    q++;
    }
  return 0;
  }


// Compare file types
FXbool FXOldFileList::cmpFType(const FXOldIconItem* a,const FXOldIconItem* b){
  const char *p,*q;
  if((((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY) != (((FXOldFileItem*)b)->state&OLDFILEITEM_DIRECTORY)){
    return (((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY)==0;
    }
  p=strchr(((FXOldFileItem*)a)->label.text(),'\t')+1;
  q=strchr(((FXOldFileItem*)b)->label.text(),'\t')+1;
  while(1){
    if(*p > *q) return 1;
    if(*p < *q) return 0;
    if(*p=='\t') return 0;
    p++;
    q++;
    }
  return 0;
  }


// Compare file size
FXbool FXOldFileList::cmpFSize(const FXOldIconItem* a,const FXOldIconItem* b){
  if((((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY) != (((FXOldFileItem*)b)->state&OLDFILEITEM_DIRECTORY)){
    return (((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY)==0;
    }
  return ((long)((FXOldFileItem*)a)->size) > ((long)((FXOldFileItem*)b)->size);
  }


// Compare file time
FXbool FXOldFileList::cmpFTime(const FXOldIconItem* a,const FXOldIconItem* b){
  if((((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY) != (((FXOldFileItem*)b)->state&OLDFILEITEM_DIRECTORY)){
    return (((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY)==0;
    }
#ifndef WIN32
  return ((long)((FXOldFileItem*)a)->date) > ((long)((FXOldFileItem*)b)->date);
#else
  return CompareFileTime(((FXOldFileItem*)a)->date,((FXOldFileItem*)b)->date) > 0;
#endif
  }


// Compare file user
FXbool FXOldFileList::cmpFUser(const FXOldIconItem* a,const FXOldIconItem* b){
  const char *p,*q; int i;
  if((((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY) != (((FXOldFileItem*)b)->state&OLDFILEITEM_DIRECTORY)){
    return (((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY)==0;
    }
  for(p=((FXOldFileItem*)a)->label.text(),i=4; *p && i; i-=(*p++=='\t')); 
  for(q=((FXOldFileItem*)b)->label.text(),i=4; *q && i; i-=(*q++=='\t')); 
  while(1){
    if(*p > *q) return 1;
    if(*p < *q) return 0;
    if(*p=='\t') return 0;
    p++;
    q++;
    }
  return 0;
  }


// Compare file group
FXbool FXOldFileList::cmpFGroup(const FXOldIconItem* a,const FXOldIconItem* b){
  const char *p,*q; int i;
  if((((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY) != (((FXOldFileItem*)b)->state&OLDFILEITEM_DIRECTORY)){
    return (((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY)==0;
    }
  for(p=((FXOldFileItem*)a)->label.text(),i=5; *p && i; i-=(*p++=='\t')); 
  for(q=((FXOldFileItem*)b)->label.text(),i=5; *q && i; i-=(*q++=='\t')); 
  while(1){
    if(*p > *q) return 1;
    if(*p < *q) return 0;
    if(*p=='\t') return 0;
    p++;
    q++;
    }
  return 0;
  }

// Reversed compare file name
FXbool FXOldFileList::cmpRName(const FXOldIconItem* a,const FXOldIconItem* b){ 
  const char *p,*q;
  if((((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY) != (((FXOldFileItem*)b)->state&OLDFILEITEM_DIRECTORY)){
    return (((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY)==0;
    }
  p=((FXOldFileItem*)a)->label.text();
  q=((FXOldFileItem*)b)->label.text();
  while(1){
    if(*p < *q) return 1;
    if(*p > *q) return 0;
    if(*p=='\t') return 0;
    p++;
    q++;
    }
  return 0;
  }


// Reversed compare file type
FXbool FXOldFileList::cmpRType(const FXOldIconItem* a,const FXOldIconItem* b){ 
  const char *p,*q;
  if((((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY) != (((FXOldFileItem*)b)->state&OLDFILEITEM_DIRECTORY)){
    return (((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY)==0;
    }
  p=strchr(((FXOldFileItem*)a)->label.text(),'\t')+1;
  q=strchr(((FXOldFileItem*)b)->label.text(),'\t')+1;
  while(1){
    if(*p < *q) return 1;
    if(*p > *q) return 0;
    if(*p=='\t') return 0;
    p++;
    q++;
    }
  return 0;
  }


// Reversed compare file size
FXbool FXOldFileList::cmpRSize(const FXOldIconItem* a,const FXOldIconItem* b){ 
  if((((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY) != (((FXOldFileItem*)b)->state&OLDFILEITEM_DIRECTORY)){
    return (((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY)==0;
    }
  return ((long)((FXOldFileItem*)a)->size) < ((long)((FXOldFileItem*)b)->size);
  }


// Reversed compare file time
FXbool FXOldFileList::cmpRTime(const FXOldIconItem* a,const FXOldIconItem* b){ 
  if((((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY) != (((FXOldFileItem*)b)->state&OLDFILEITEM_DIRECTORY)){
    return (((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY)==0;
    }
#ifndef WIN32
  return ((long)((FXOldFileItem*)a)->date) < ((long)((FXOldFileItem*)b)->date);
#else
  return CompareFileTime(((FXOldFileItem*)a)->date,((FXOldFileItem*)b)->date) < 0;
#endif
  }


// Reversed compare file user
FXbool FXOldFileList::cmpRUser(const FXOldIconItem* a,const FXOldIconItem* b){ 
  const char *p,*q; int i;
  if((((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY) != (((FXOldFileItem*)b)->state&OLDFILEITEM_DIRECTORY)){
    return (((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY)==0;
    }
  for(p=((FXOldFileItem*)a)->label.text(),i=4; *p && i; i-=(*p++=='\t')); 
  for(q=((FXOldFileItem*)b)->label.text(),i=4; *q && i; i-=(*q++=='\t')); 
  while(1){
    if(*p < *q) return 1;
    if(*p > *q) return 0;
    if(*p=='\t') return 0;
    p++;
    q++;
    }
  return 0; 
  }


// Reversed compare file group
FXbool FXOldFileList::cmpRGroup(const FXOldIconItem* a,const FXOldIconItem* b){ 
  const char *p,*q; int i;
  if((((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY) != (((FXOldFileItem*)b)->state&OLDFILEITEM_DIRECTORY)){
    return (((FXOldFileItem*)a)->state&OLDFILEITEM_DIRECTORY)==0;
    }
  for(p=((FXOldFileItem*)a)->label.text(),i=5; *p && i; i-=(*p++=='\t')); 
  for(q=((FXOldFileItem*)b)->label.text(),i=5; *q && i; i-=(*q++=='\t')); 
  while(1){
    if(*p < *q) return 1;
    if(*p > *q) return 0;
    if(*p=='\t') return 0;
    p++;
    q++;
    }
  return 0; 
  }


/*******************************************************************************/


// Got refresh timeout
long FXOldFileList::onRefresh(FXObject*,FXSelector,void*){
  FXchar dir[MAXPATHLEN+1];
  FXuint interval=REFRESHINTERVAL;
  struct stat info;
  
  
  FXTRACE((400,"%s::onRefresh: %s\n",getClassName(),directory.text()));
  
  // Test if a change has occurred
  if(stat(directory.text(),&info)==0){
    if((timestamp!=info.st_mtime) || (info.st_mtime==0)){
      
      // File system does not support mod-time on directory:- we schedule 
      // next refresh in REFRESHINTERVALLONG ms instead of REFRESHINTERVAL ms
      if(info.st_mtime==0) interval=REFRESHINTERVALLONG;
      
      // Refresh contents
      if(listDirectory()){
        sortItems();
        recalc();
        }
      }
    
    // Last update time
    timestamp=info.st_mtime;
    }
  
  // Move to higher directory
  else{
    setDirectory(fxupdir(dir,directory.text()));
    }
  
  // Next refresh
  refresh=getApp()->addTimeout(interval,this,ID_REFRESH);
  return 1;
  }


// Set current filename
void FXOldFileList::setCurrentFile(const FXString& file){
  register const FXchar *f;
  if(file.empty()) return;

  // Perhaps switch directories first?
  f=strrchr(file.text(),PATHSEP);
  if(f){
    setDirectory(file);
    f++;
    }
  
  // No, just switch file
  else{ 
    f=file.text();
    }
  
  // Switch
  setCurrentItem(getFilenameItem(f));
  }


// Get pathname to current file (NULL if no current file)
FXString FXOldFileList::getCurrentFile() const {
  if(currentitem) return getItemPathname(currentitem);
  return FXString(NULL);
  }


//////////// No longer needed!!!
// Get item from file name
FXOldIconItem* FXOldFileList::getFilenameItem(const FXString& file) const {
  register FXOldIconItem* item;
  register FXuint len;
  if(file.text()==NULL){ fxerror("%s::getFilenameItem: empty file name specified.\n",getClassName()); }
  len=file.length();
  for(item=firstitem; item; item=item->next){
    if(strncmp(file.text(),item->label.text(),len)==0) return item;///////// WRONG!!!!!
    }
  return NULL;
  }



// Set directory being displayed
void FXOldFileList::setDirectory(const FXString& path){
  FXchar abspath[MAXPATHLEN+1];
  struct stat info;

  // Empty path:- ignore
  if(path.empty()) return;

  // Exactly equal already
  if(directory!=path){
    fxabspath(abspath,NULL,path.text());
    
    // Equal
    if(directory!=abspath){

      // Perhaps got trailing filename?
      while(!fxisdir(abspath)){
        if(fxistopdir(abspath)) break;      // This should not happen...
        fxupdir(abspath,abspath);
        }

      // Switch
      if(directory!=abspath){
        directory=abspath;
        FXTRACE((100,"directory=%s\n",directory.text()));
        removeAllItems();
        list=NULL;
        timestamp=0;
        if(stat(directory.text(),&info)==0){
          listDirectory();
          sortItems();
          timestamp=info.st_mtime;
          recalc();
          }
        }
      }
    }
  }


// Set the pattern to filter
void FXOldFileList::setPattern(const FXString& ptrn){
  if(ptrn.empty()) return;
  if(pattern!=ptrn){
    pattern=ptrn;
    timestamp=0;
    if(id()){
      listDirectory();
      sortItems();
      recalc();
      }
    }
  }


// Change file match mode
void FXOldFileList::setMatchMode(FXuint mode){
  if(matchmode!=mode){
    matchmode=mode;
    timestamp=0;
    listDirectory();
    sortItems();
    recalc();
    }
  }


// Return TRUE if showing hidden files
FXbool FXOldFileList::showHiddenFiles() const {
  return (options&OLDFILELIST_SHOWHIDDEN)!=0;
  }


// Change show hidden files mode
void FXOldFileList::showHiddenFiles(FXbool shown){
  FXuint opts=options;
  if(shown) opts|=OLDFILELIST_SHOWHIDDEN; else opts&=~OLDFILELIST_SHOWHIDDEN;
  if(opts!=options){
    options=opts;
    timestamp=0;
    listDirectory();
    sortItems();
    recalc();
    }
  }
  

// Compare till '\t'
static FXbool fileequal(const FXchar* a,const FXchar* b){
  register FXchar c1,c2;
  do{ c1=*a++; c2=*b++; }while(c1!='\0' && c1!='\t' && c1==c2);
  return (c1=='\0' || c1=='\t') && ((c2=='\0' || c2=='\t'));
  }


/*******************************************************************************/

// List directory
FXbool FXOldFileList::listDirectory(){
  FXchar grpid[64],usrid[64],atts[16],mod[32];
  FXchar pathname[MAXPATHLEN];
  FXchar fileinfo[2048];
  FXOldFileItem *after,*before,*item,*it;
  FXchar *pathtail,*name,*ext;
  FXFileAssoc *fileassoc;
  const FXchar *extension;
  FXbool changed=FALSE;
  FXIcon *big,*mini;
#ifndef WIN32
  struct dirent *dp;
  struct stat info;
  DIR *dirp;
  int islink;
#else
  WIN32_FIND_DATA ffData;
  HANDLE hFindFile;
  DWORD dwBinaryType;
#endif

  // Set path to stat with
  strcpy(pathname,directory.text());
  pathtail=pathname+strlen(pathname)-1;
  if(*pathtail!=PATHSEP) *++pathtail=PATHSEP;
  ++pathtail;

  // Build new insert-order list
  after=NULL;
  before=list;
  list=NULL;
  if(!firstitem) before=NULL;

#ifndef WIN32
  
  // Get directory stream pointer
  dirp=opendir(directory.text());
  
  // Managed to open directory
  if(dirp){
  
    // Loop over directory entries
    while((dp=readdir(dirp))!=NULL){
      name=dp->d_name;

      // A dot special file?
      if(name[0]=='.' && (name[1]==0 || (name[1]=='.' && name[2]==0))) continue;

      // Hidden file or directory normally not shown
      if(name[0]=='.' && !(options&OLDFILELIST_SHOWHIDDEN)) continue;

      // Build full pathname
      strcpy(pathtail,name);

      // Get file/link info
      if(lstat(pathname,&info)!=0) continue;

      // If its a link, get the info on file itself
      islink=S_ISLNK(info.st_mode);
      if(islink && stat(pathname,&info)!=0) continue;

      // Is it a directory or does it match the pattern?
      if(!S_ISDIR(info.st_mode) && !fxfilematch(pattern.text(),name,matchmode)) continue;
    
#else

  // Get file find handle and first file's info
  strcpy(pathtail,"*");
  hFindFile=FindFirstFile(pathname,&ffData);

  // No directory, so no files shown
  if(hFindFile!=INVALID_HANDLE_VALUE){

    // Loop over directory entries
    do{
      name=ffData.cFileName;

      // A dot special file?
      if(name[0]=='.' && (name[1]==0 || (name[1]=='.' && name[2]==0))) continue;

      // Build full pathname
      strcpy(pathtail,name);

      // Hidden file or directory normally not shown
      if((ffData.dwFileAttributes&FILE_ATTRIBUTE_HIDDEN) && !(options&OLDFILELIST_SHOWHIDDEN)) continue;

      // Is it a directory or does it match the pattern?
      if(!(ffData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY) && !fxfilematch(pattern.text(),name,matchmode)) continue;

#endif
    
      // Find place to add it; if found, zap all entries before item as they must have disappeared!!
      for(item=before; item; item=item->inext){
        if(fileequal(item->label.text(),name)){
          while(before!=item){
            it=before;
            before=before->inext;
            if(it->prev) it->prev->next=it->next; else firstitem=it->next;
            if(it->next) it->next->prev=it->prev; else lastitem=it->prev;
            if(currentitem==it) currentitem=NULL;
            if(anchoritem==it) anchoritem=NULL;
            changed=TRUE;
            deleteItem(it);
            }
          before=item->inext;
          if(before) before->iprev=NULL;
          item->inext=NULL;
          item->iprev=NULL;
          goto fnd;
          }
        }

      // Not found, add new item
      item=(FXOldFileItem*)createItem();
      item->prev=lastitem;
      item->next=NULL;
      item->iprev=NULL;
      item->inext=NULL;
      item->assoc=NULL;
      item->state=OLDFILEITEM_DRAGGABLE;
      item->size=0;
#ifndef WIN32
      item->date=0;
#else
      item->date->dwLowDateTime=0;
      item->date->dwHighDateTime=0;
#endif
      if(lastitem) item->prev->next=item; else firstitem=item;
      lastitem=item;
      changed=TRUE;
 
      // Next gets hung after this one
fnd:  item->iprev=after;
      if(after) after->inext=item; else list=item;
 
      // Fill item with updated information, if data has changed

#ifndef WIN32
    
      // Anything about the file changed?
      if((item->date!=info.st_mtime) || (info.st_mtime==0)){

        // Obtain user name
        fxgetusername(usrid,info.st_uid);

        // Obtain group name
        fxgetgroupname(grpid,info.st_gid);

        // Permissions
        fxgetpermissions(atts,info.st_mode);

        // Mod time
        strncpy(mod,ctime(&info.st_mtime)+4,20);
        mod[20]=0;

        // Item flags
        if(info.st_mode&(S_IXUSR|S_IXGRP|S_IXOTH)) item->state|=OLDFILEITEM_EXECUTABLE; else item->state&=~OLDFILEITEM_EXECUTABLE;
        if(S_ISDIR(info.st_mode)) item->state|=OLDFILEITEM_DIRECTORY; else item->state&=~OLDFILEITEM_DIRECTORY;
        if(S_ISLNK(info.st_mode)) item->state|=OLDFILEITEM_SYMLINK; else item->state&=~OLDFILEITEM_SYMLINK;
        if(S_ISCHR(info.st_mode)) item->state|=OLDFILEITEM_CHARDEV; else item->state&=~OLDFILEITEM_CHARDEV;
        if(S_ISBLK(info.st_mode)) item->state|=OLDFILEITEM_BLOCKDEV; else item->state&=~OLDFILEITEM_BLOCKDEV;
        if(S_ISFIFO(info.st_mode)) item->state|=OLDFILEITEM_FIFO; else item->state&=~OLDFILEITEM_FIFO;
        if(S_ISSOCK(info.st_mode)) item->state|=OLDFILEITEM_SOCK; else item->state&=~OLDFILEITEM_SOCK;

        fileassoc=NULL;

        // Is it a directory?
        if(item->state&OLDFILEITEM_DIRECTORY){
          big=big_folder;
          mini=mini_folder;
          extension="Folder";
          }

        // Some sort of document
        else{

          // Is it an executable?
          if(item->state&OLDFILEITEM_EXECUTABLE){
            big=big_app;
            mini=mini_app;
            extension="Application";
            }
          else{
            big=big_doc;
            mini=mini_doc;
            extension="Document";
            }

          // Try use association table
          if(associations){

            // Try find association for this file, starting with the 
            // whole filename, then successively smaller extensions.
            fileassoc=associations->associate(name);
            if(!fileassoc){
              ext=strchr(name,'.');
              while(ext){
                fileassoc=associations->associate(ext+1);
                if(fileassoc) break;
                ext=strchr(ext+1,'.');
                }
              }

            // If we have an association, grab the file type & icons
            if(fileassoc){
              extension=fileassoc->extension.text();
              if(fileassoc->mimetype.text()){ 
                if(fileassoc->dragtype==0){
                  fileassoc->dragtype=getApp()->registerDragType(fileassoc->mimetype.text()); 
                  }
                }
              if(fileassoc->bigicon){
                big=fileassoc->bigicon;
                big->create();
                }
              if(fileassoc->miniicon){
                mini=fileassoc->miniicon;
                mini->create();
                }
              }
            }
          }

        // Build File Info
#ifdef _GNU_SOURCE
        snprintf(fileinfo,sizeof(fileinfo),"%s\t%s\t%d\t%s\t%s\t%s\t%s",name,extension,info.st_size,mod,usrid,grpid,atts);
#else
        sprintf(fileinfo,"%s\t%s\t%d\t%s\t%s\t%s\t%s",name,extension,info.st_size,mod,usrid,grpid,atts);
#endif      

        // New label and icons
        item->label=fileinfo;
        item->icon=big;
        item->miniIcon=mini;

        // Size
        item->size=info.st_size;

        // Association
        item->assoc=fileassoc;

        // Mod-time
        item->date=info.st_mtime;

        // Info has changed
        changed=TRUE;
        }

#else
      
      // Anything about the file changed?
      if(CompareFileTime(item->date,&ffData.ftLastWriteTime)!=0){

        // Obtain user name (no Win95 equivalent?)
        strcpy(usrid,"user");

        // Obtain group name (no Win95 equivalent?)
        strcpy(grpid,"group");

        // Permissions
        strcpy(atts, "-rwxrwxrwx");

        // Is it a directory?
        if(ffData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY){
          atts[0]='d';
          }

        // Check if file is read-only
        if(ffData.dwFileAttributes&FILE_ATTRIBUTE_READONLY){
          atts[2]='-'; atts[5]='-'; atts[8]='-';
          }

        // Is it an executable file?
        if(!GetBinaryType(pathname,&dwBinaryType)){
          atts[3]='-'; atts[6]='-'; atts[9]='-';
          item->state&=~OLDFILEITEM_EXECUTABLE;
          }
        else{
          item->state|=OLDFILEITEM_EXECUTABLE;
          }

        // Mod time
        //strncpy(mod,ctime(&info.st_mtime)+4,20);///////////////// Wrong!!!
        //mod[20]=0;
        strcpy(mod,"Unknown");

        // Flags
        if(ffData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY) item->state|=OLDFILEITEM_DIRECTORY; else item->state&=~OLDFILEITEM_DIRECTORY;

        fileassoc=NULL;

        // Is it a directory?
        if(item->state&OLDFILEITEM_DIRECTORY){
          big=big_folder;
          mini=mini_folder;
          extension="Folder";
          }

        // Some sort of document
        else{

          // Is it an executable?
          if(item->state&OLDFILEITEM_EXECUTABLE){
            big=big_app;
            mini=mini_app;
            extension="Application";
            }
          else{
            big=big_doc;
            mini=mini_doc;
            extension="Document";
            }

          // Try use association table
          if(associations){

            // Try find association for this file, starting with the 
            // whole filename, then try the extension only.
            fileassoc=associations->associate(name);
            if(!fileassoc){
              ext=strchr(name,'.');
              if(ext){
                fileassoc=associations->associate(ext+1);
                }
              }

            // If we have an association, grab the file type & icons
            if(fileassoc){
              extension=fileassoc->extension.text();
              if(fileassoc->mimetype.text()){ 
                if(fileassoc->dragtype==0) fileassoc->dragtype=getApp()->registerDragType(fileassoc->mimetype.text()); 
                }
              if(fileassoc->bigicon){
                big=fileassoc->bigicon;
                big->create();
                }
              if(fileassoc->miniicon){
                mini=fileassoc->miniicon;
                mini->create();
                }
              }
            }
          }

        // Build File Info
        sprintf(fileinfo,"%s\t%s\t%d\t%s\t%s\t%s\t%s",name,extension,ffData.nFileSizeLow,mod,usrid,grpid,atts);

        // New label and icons
        item->label=fileinfo;
        item->icon=big;
        item->miniIcon=mini;

        // Size
        item->size=ffData.nFileSizeLow;

        // Association
        item->assoc=fileassoc;

        // Mod-time
        *item->date=ffData.ftLastWriteTime;

        // Info has changed
        changed=TRUE;
        }

#endif
    
      // Next one goes after this one
      after=item;
      } 
#ifdef WIN32
    while(FindNextFile(hFindFile,&ffData));
#endif
    
    // Close
#ifndef WIN32
    closedir(dirp);
#else
    FindClose(hFindFile);
#endif
    }
    
  // Wipe items remaining in list:- they have disappeared!!
  while(before){
    it=before;
    before=before->inext;
    if(it->prev) it->prev->next=it->next; else firstitem=it->next;
    if(it->next) it->next->prev=it->prev; else lastitem=it->prev;
    if(currentitem==it) currentitem=NULL;
    if(anchoritem==it) anchoritem=NULL;
    changed=TRUE;
    deleteItem(it);
    }

  return changed;
  }


// Is directory
FXbool FXOldFileList::isItemDirectory(const FXOldIconItem* item) const {
  if(item==NULL){ fxerror("%s::isItemDirectory: item is NULL.\n",getClassName()); }
  return (item->state&OLDFILEITEM_DIRECTORY)!=0;
  }


// Is file
FXbool FXOldFileList::isItemFile(const FXOldIconItem* item) const {
  if(item==NULL){ fxerror("%s::isItemFile: item is NULL.\n",getClassName()); }
  return (item->state&(OLDFILEITEM_DIRECTORY|OLDFILEITEM_CHARDEV|OLDFILEITEM_BLOCKDEV|OLDFILEITEM_FIFO|OLDFILEITEM_SOCK))==0;
  }


// Is executable
FXbool FXOldFileList::isItemExecutable(const FXOldIconItem* item) const {
  if(item==NULL){ fxerror("%s::isItemExecutable: item is NULL.\n",getClassName()); }
  return (item->state&OLDFILEITEM_EXECUTABLE)!=0;
  }


// Get file name from item
FXString FXOldFileList::getItemFilename(const FXOldIconItem* item) const {
  if(!item){ fxerror("%s::getItemFileName: item is NULL.\n",getClassName()); }
  return item->label.extract(0,'\t');
  }


// Get full pathname to item
FXString FXOldFileList::getItemPathname(const FXOldIconItem* item) const {
  if(!item){ fxerror("%s::getItemPathname: item is NULL.\n",getClassName()); }
  if(fxistopdir(directory.text())){
    return directory+item->label.extract(0,'\t');
    }
  return directory+PATHSEPSTRING+item->label.extract(0,'\t');
  }



// Get associations (if any) from the file
FXFileAssoc* FXOldFileList::getItemAssoc(const FXOldIconItem* item) const {
  if(!item){ fxerror("%s::getItemAssoc: item is NULL.\n",getClassName()); }
  return ((FXOldFileItem*)item)->assoc;
  }


// Change associations table
void FXOldFileList::setAssociations(FXFileDict* assocs){
  if(associations!=assocs){
    associations=assocs;
    if(id()){
      removeAllItems();
      list=NULL;
      timestamp=0;
      listDirectory();
      sortItems();
      recalc();
      }
    }
  }


// Save data
void FXOldFileList::save(FXStream& store) const {
  FXOldIconList::save(store);
  store << directory;
  store << pattern;
  store << associations;
  store << matchmode;
  store << big_folder;
  store << mini_folder;
  store << big_doc;
  store << mini_doc;
  store << big_app;
  store << mini_app;
  }
 

// Load data
void FXOldFileList::load(FXStream& store){ 
  FXOldIconList::load(store);
  store >> directory;   
  store >> pattern;     
  store >> associations;
  store >> matchmode;   
  store >> big_folder;  
  store >> mini_folder; 
  store >> big_doc;     
  store >> mini_doc;    
  store >> big_app;     
  store >> mini_app;    
  }


// Cleanup
FXOldFileList::~FXOldFileList(){
  removeAllItems();
  if(refresh) getApp()->removeTimeout(refresh);
  delete associations;
  delete big_folder;
  delete mini_folder;
  delete big_doc;
  delete mini_doc;
  delete big_app;
  delete mini_app;
  associations=(FXFileDict*)-1;
  big_folder=(FXGIFIcon*)-1;
  mini_folder=(FXGIFIcon*)-1;
  big_doc=(FXGIFIcon*)-1;
  mini_doc=(FXGIFIcon*)-1;
  big_app=(FXGIFIcon*)-1;
  mini_app=(FXGIFIcon*)-1;
  refresh=(FXTimer*)-1;
  }


