/********************************************************************************
*                                                                               *
*                       C o m b o   B o x   O b j e c t                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXOldComboBox.cpp,v 1.2 1999/09/21 18:02:58 jeroen Exp $                 *
********************************************************************************/
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXObjectList.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDrawable.h"
#include "FXFont.h"
#include "FXDC.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXLabel.h"
#include "FXTextField.h"
#include "FXButton.h"
#include "FXMenuButton.h"
#include "FXComposite.h"
#include "FXPacker.h"
#include "FXShell.h"
#include "FXPopup.h"
#include "FXScrollbar.h"
#include "FXScrollWindow.h"
#include "FXOldList.h"
#include "FXOldComboBox.h"


/*
  Notes:
  - Handling typed text:
    a) Pass string to target only.
    b) Pass string to target & add to list [begin, after/before current, or end].
    c) Pass string to target & replace current item's label.
  - FXOldComboBox is a text field which may be filled from an FXOldList.
  - FXOldComboBox is a text field which in turn may fill an FXOldList also.
  - In most other respects, it behaves like a FXTextField.
  - Need to catch up/down arrow keys.
  - Need to have mode to pass item* instead of char*.
  - Combobox turns OFF GUI Updating while being manipulated.
*/

#define OLDCOMBOBOX_INS_MASK   (OLDCOMBOBOX_REPLACE|OLDCOMBOBOX_INSERT_BEFORE|OLDCOMBOBOX_INSERT_AFTER|OLDCOMBOBOX_INSERT_FIRST|OLDCOMBOBOX_INSERT_LAST)
#define OLDCOMBOBOX_MASK       (OLDCOMBOBOX_STATIC|OLDCOMBOBOX_INS_MASK)



/*******************************************************************************/
  
// Map
FXDEFMAP(FXOldComboBox) FXOldComboBoxMap[]={
  FXMAPFUNC(SEL_FOCUS_UP,0,FXOldComboBox::onFocusUp),
  FXMAPFUNC(SEL_FOCUS_DOWN,0,FXOldComboBox::onFocusDown),
  FXMAPFUNC(SEL_CHANGED,0,FXOldComboBox::onChanged),
  FXMAPFUNC(SEL_COMMAND,0,FXOldComboBox::onCommand),
  FXMAPFUNC(SEL_UPDATE,FXOldComboBox::ID_TEXT,FXOldComboBox::onUpdFmText),
  FXMAPFUNC(SEL_CLICKED,FXOldComboBox::ID_LIST,FXOldComboBox::onListClicked),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,FXOldComboBox::ID_TEXT,FXOldComboBox::onTextButton),
  FXMAPFUNC(SEL_CHANGED,FXOldComboBox::ID_TEXT,FXOldComboBox::onTextChanged),
  FXMAPFUNC(SEL_COMMAND,FXOldComboBox::ID_TEXT,FXOldComboBox::onTextCommand),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXOldComboBox::onFwdToText),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETINTVALUE,FXOldComboBox::onFwdToText),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETREALVALUE,FXOldComboBox::onFwdToText),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE,FXOldComboBox::onFwdToText),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETINTVALUE,FXOldComboBox::onFwdToText),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETREALVALUE,FXOldComboBox::onFwdToText),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE,FXOldComboBox::onFwdToText),
  };


// Object implementation
FXIMPLEMENT(FXOldComboBox,FXPacker,FXOldComboBoxMap,ARRAYNUMBER(FXOldComboBoxMap))


// List box
FXOldComboBox::FXOldComboBox(FXComposite *p,FXint cols,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb):
  FXPacker(p,opts,x,y,w,h, 0,0,0,0, 0,0){
  flags|=FLAG_ENABLED;
  target=tgt;
  message=sel;
  text=new FXTextField(this,cols,this,FXOldComboBox::ID_TEXT,0, 0,0,0,0, pl,pr,pt,pb);
  if(options&OLDCOMBOBOX_STATIC) text->setEditable(FALSE);
  pane=new FXPopup(this,FRAME_LINE);
  list=new FXOldList(pane,this,FXOldComboBox::ID_LIST,OLDLIST_BROWSESELECT|OLDLIST_AUTOSELECT|LAYOUT_FILL_X|LAYOUT_FILL_Y|SCROLLERS_TRACK|HSCROLLER_NEVER);
  if(options&OLDCOMBOBOX_STATIC) list->setScrollStyle(SCROLLERS_TRACK|HSCROLLING_OFF);
  button=new FXMenuButton(this,NULL,NULL,pane,FRAME_RAISED|FRAME_THICK|MENUBUTTON_DOWN|MENUBUTTON_ATTACH_RIGHT, 0,0,0,0, 0,0,0,0);
  button->setXOffset(border);
  button->setYOffset(border);
  flags&=~FLAG_UPDATE;  // Never GUI update
  }


// Createwindow
void FXOldComboBox::create(){
  FXPacker::create();
  pane->create();
  }


// Detach window
void FXOldComboBox::detach(){
  FXPacker::detach();
  pane->detach();
  }


// Destroy window
void FXOldComboBox::destroy(){
  pane->destroy();
  FXPacker::destroy();
  }


// Enable the window
void FXOldComboBox::enable(){
  if(!(flags&FLAG_ENABLED)){
    FXPacker::enable();
    text->enable();
    button->enable();
    }
  }


// Disable the window
void FXOldComboBox::disable(){
  if(flags&FLAG_ENABLED){
    FXPacker::disable();
    text->disable();
    button->disable();
    }
  }


// Get default width
FXint FXOldComboBox::getDefaultWidth(){
  FXint ww,pw;
  ww=text->getDefaultWidth()+button->getDefaultWidth()+(border<<1);
  pw=pane->getDefaultWidth();
  return FXMAX(ww,pw);
  }


// Get default height
FXint FXOldComboBox::getDefaultHeight(){
  FXint th,bh;
  th=text->getDefaultHeight();
  bh=button->getDefaultHeight();
  return FXMAX(th,bh)+(border<<1);
  }


// Recalculate layout
void FXOldComboBox::layout(){
  FXint buttonWidth,textWidth,itemHeight;
  itemHeight=height-(border<<1);
  buttonWidth=button->getDefaultWidth();
  textWidth=width-buttonWidth-(border<<1);
  text->position(border,border,textWidth,itemHeight);
  button->position(border+textWidth,border,buttonWidth,itemHeight);
  FXint hh=list->getContentHeight();
  if(hh>120) hh=120;
  pane->resize(width,hh+2);
  flags&=~FLAG_DIRTY;
  }


// Forward GUI update of text field to target; but only if pane is not popped
long FXOldComboBox::onUpdFmText(FXObject*,FXSelector,void*){
  return target && !pane->shown() && target->handle(this,MKUINT(message,SEL_UPDATE),NULL);
  }


// Command handled in the text field
long FXOldComboBox::onFwdToText(FXObject* sender,FXSelector sel,void* ptr){
  return text->handle(sender,sel,ptr);
  }


// Changed
long FXOldComboBox::onChanged(FXObject*,FXSelector,void* ptr){
  if(target) target->handle(this,MKUINT(message,SEL_CHANGED),ptr);
  return 1;
  }


// Command
long FXOldComboBox::onCommand(FXObject*,FXSelector,void* ptr){
  if(target) target->handle(this,MKUINT(message,SEL_COMMAND),ptr);
  return 1;
  }


// Forward clicked message from list to target
long FXOldComboBox::onListClicked(FXObject*,FXSelector,void* ptr){
  FXOldListItem *item=(FXOldListItem*)ptr;
  FXTRACE((100,"%s::onListClicked\n",getClassName()));
  button->handle(this,MKUINT(ID_UNPOST,SEL_COMMAND),NULL);    // Unpost the list
  if(item){ 
    text->setText(item->label); 
    handle(this,MKUINT(0,SEL_COMMAND),(void*)item->label.text());
    }
  return 1;
  }


// Pressed left button in text field
long FXOldComboBox::onTextButton(FXObject*,FXSelector,void*){
  FXTRACE((100,"%s::onTextButton\n",getClassName()));
  if(options&OLDCOMBOBOX_STATIC){
    button->handle(this,MKUINT(ID_POST,SEL_COMMAND),NULL);    // Post the list
    return 1;
    }
  return 0;
  }


// Text has changed
long FXOldComboBox::onTextChanged(FXObject*,FXSelector,void* ptr){
  //FXOldListItem *item;
  FXTRACE((100,"%s::onTextChanged: %s\n",getClassName(),(char*)ptr));
  //item=list->findItem((FXchar*)ptr,strlen((FXchar*)ptr));
  //if(item) printf("item = %s\n",item->label.text());
  handle(this,MKUINT(0,SEL_CHANGED),ptr);
  return 1;
  }


// Text has changed
long FXOldComboBox::onTextCommand(FXObject*,FXSelector,void* ptr){
  FXOldListItem *item=getCurrentItem();
  FXTRACE((100,"%s::onTextCommand: %s\n",getClassName(),(char*)ptr));
  if(!(options&OLDCOMBOBOX_STATIC)){
    switch(options&OLDCOMBOBOX_INS_MASK){
      case OLDCOMBOBOX_REPLACE:
        if(item) setItemText(item,(FXchar*)ptr);
        break;
      case OLDCOMBOBOX_INSERT_BEFORE:
        if(item) addItemBefore(item,(FXchar*)ptr);
        break;
      case OLDCOMBOBOX_INSERT_AFTER:
        if(item) addItemAfter(item,(FXchar*)ptr);
        break;
      case OLDCOMBOBOX_INSERT_FIRST:
        addItemFirst((FXchar*)ptr);
        break;
      case OLDCOMBOBOX_INSERT_LAST:
        addItemLast((FXchar*)ptr);
        break;
      }
    }
  handle(this,MKUINT(0,SEL_COMMAND),ptr);
  return 1;
  }


// Select upper item
long FXOldComboBox::onFocusUp(FXObject*,FXSelector,void*){
  FXOldListItem *item=getCurrentItem();
  if(item && item->prev) item=item->prev;
  if(!item) item=getLastItem();
  if(item){
    setCurrentItem(item);
    handle(this,MKUINT(0,SEL_COMMAND),(void*)item->label.text());
    }
  return 1;
  }


// Select lower item
long FXOldComboBox::onFocusDown(FXObject*,FXSelector,void*){
  FXOldListItem *item=getCurrentItem();
  if(item && item->next) item=item->next;
  if(!item) item=getFirstItem();
  if(item){
    setCurrentItem(item);
    handle(this,MKUINT(0,SEL_COMMAND),(void*)item->label.text());
    }
  return 1;
  }


// Return true if editable
FXbool FXOldComboBox::isEditable() const { 
  return text->isEditable(); 
  }


// Set widget is editable or not
void FXOldComboBox::setEditable(FXbool edit){
  text->setEditable(edit);
  }



// Set text cursor position
void FXOldComboBox::setCursorPos(FXint pos){
  text->setCursorPos(pos);
  }


// Get text cursor position
FXint FXOldComboBox::getCursorPos() const { 
  return text->getCursorPos(); 
  }


// Set anchor pos
void FXOldComboBox::setAnchorPos(FXint pos){
  text->setAnchorPos(pos);
  }


// Get anchor pos
FXint FXOldComboBox::getAnchorPos() const { 
  return text->getAnchorPos(); 
  }


// Set text
void FXOldComboBox::setText(const FXString& txt){
  text->setText(txt);
  }


// Obtain text
FXString FXOldComboBox::getText() const {
  return text->getText(); 
  }


// Set font
void FXOldComboBox::setFont(FXFont* fnt){
  if(!fnt){ fxerror("%s::setFont: NULL font specified.\n",getClassName()); }
  text->setFont(fnt);
  list->setFont(fnt);
  recalc();
  }


// Obtain font
FXFont* FXOldComboBox::getFont() const {
  return text->getFont(); 
  }


// Set number of text columns
void FXOldComboBox::setNumColumns(FXuint cols){
  text->setNumColumns(cols);
  }


// Get number of text columns
FXuint FXOldComboBox::getNumColumns() const {
  return text->getNumColumns(); 
  }


// Get number of items
FXint FXOldComboBox::getNumItems() const {
  return list->getNumItems(); 
  }


// Get first item
FXOldListItem* FXOldComboBox::getFirstItem() const { 
  return list->getFirstItem(); 
  }


// Get last item
FXOldListItem* FXOldComboBox::getLastItem() const { 
  return list->getLastItem(); 
  }


// Get next item
FXOldListItem* FXOldComboBox::getNextItem(const FXOldListItem* item) const { 
  if(!item){ fxerror("%s::getNextItem: item is NULL.\n",getClassName()); } 
  return item->next; 
  }


// Get previous item
FXOldListItem* FXOldComboBox::getPrevItem(const FXOldListItem* item) const { 
  if(!item){ fxerror("%s::getPrevItem: item is NULL.\n",getClassName()); } 
  return item->prev; 
  }


// Add item as first
FXOldListItem* FXOldComboBox::addItemFirst(const FXString& txt,void* ptr){
  FXOldListItem *item=list->addItemFirst(txt,ptr); 
  recalc();
  return item; 
  }


// Add item as last
FXOldListItem* FXOldComboBox::addItemLast(const FXString& txt,void* ptr){ 
  FXOldListItem *item=list->addItemLast(txt,ptr); 
  recalc();
  return item; 
  }


// Add item after another
FXOldListItem* FXOldComboBox::addItemAfter(FXOldListItem* other,const FXString& txt,void* ptr){ 
  FXOldListItem *item=list->addItemAfter(other,txt,ptr);  
  recalc();
  return item; 
  }


// Add item before another
FXOldListItem* FXOldComboBox::addItemBefore(FXOldListItem* other,const FXString& txt,void* ptr){ 
  FXOldListItem *item=list->addItemBefore(other,txt,ptr); 
  recalc();
  return item; 
  }


// Remove given item
void FXOldComboBox::removeItem(FXOldListItem* item){ 
  list->removeItem(item); 
  if(list->getCurrentItem()==NULL) setText("");
  recalc();
  }


// Remove sequence of items
void FXOldComboBox::removeItems(FXOldListItem* fm,FXOldListItem* to){
  list->removeItems(fm,to);
  if(list->getCurrentItem()==NULL) setText("");
  recalc();
  }


// Remove all items
void FXOldComboBox::removeAllItems(){
  setText("");
  list->removeAllItems();
  recalc();
  }


// Is item current
FXbool FXOldComboBox::isItemCurrent(const FXOldListItem* item) const {
  return list->isItemCurrent(item);
  }


// Get index of item
FXint FXOldComboBox::indexOfItem(const FXOldListItem* item) const { 
  return list->indexOfItem(item);
  }


// Get item at index
FXOldListItem* FXOldComboBox::itemAtIndex(FXint index) const { 
  return list->itemAtIndex(index);
  }


// Sort item list
void FXOldComboBox::sortItems(){
  list->sortItems();
  }


// Change current item
void FXOldComboBox::setCurrentItem(FXOldListItem* item){
  list->setCurrentItem(item);
  if(item){
    setText(item->label);
    }
  else{
    setText("");
    }
  }


// Get current item
FXOldListItem* FXOldComboBox::getCurrentItem() const {
  return list->getCurrentItem();
  }


// Set item text
void FXOldComboBox::setItemText(FXOldListItem* item,const FXString& txt){
  if(item==NULL){ fxerror("%s::setItemText: item is NULL\n",getClassName()); }
  if(isItemCurrent(item)) setText(txt);
  item->label=txt;
  recalc();
  }


// Get item text
FXString FXOldComboBox::getItemText(const FXOldListItem* item) const {
  if(item==NULL){ fxerror("%s::getItemText: item is NULL\n",getClassName()); }
  return item->label;
  }


// Set item data
void FXOldComboBox::setItemData(FXOldListItem* item,void* ptr) const {
  if(item==NULL){ fxerror("%s::setItemData: item is NULL\n",getClassName()); }
  item->data=ptr;
  }


// Get item data 
void* FXOldComboBox::getItemData(const FXOldListItem* item) const {
  if(item==NULL){ fxerror("%s::getItemData: item is NULL\n",getClassName()); }
  return item->data;
  }


// Get sort function
FXOldListItemSortFunc FXOldComboBox::getSortFunc() const {
  return list->getSortFunc();
  }


// Change sort function
void FXOldComboBox::setSortFunc(FXOldListItemSortFunc func){
  list->setSortFunc(func);
  }  


// Change combobox style
void FXOldComboBox::setComboStyle(FXuint mode){
  FXuint opts=(options&~OLDCOMBOBOX_MASK)|(mode&OLDCOMBOBOX_MASK);
  if(opts!=options){
    options=opts;
    if(options&OLDCOMBOBOX_STATIC){
      text->setEditable(FALSE);                                 // Non-editable
      list->setScrollStyle(SCROLLERS_TRACK|HSCROLLING_OFF);     // No scrolling
      }
    else{
      text->setEditable(TRUE);                                  // Editable
      list->setScrollStyle(SCROLLERS_TRACK|HSCROLLER_NEVER);    // Scrollable, but no scrollbar
      }
    recalc();
    }
  }
  

// Get combobox style
FXuint FXOldComboBox::getComboStyle() const {
  return (options&OLDCOMBOBOX_MASK);
  }


// Set help text
void FXOldComboBox::setHelpText(const FXString& txt){
  text->setHelpText(txt);
  }
  
// Get help text
FXString FXOldComboBox::getHelpText() const {
  return text->getHelpText();
  }


// Set tip text
void FXOldComboBox::setTipText(const FXString& txt){
  text->setTipText(txt);
  }


// Get tip text
FXString FXOldComboBox::getTipText() const {
  return text->getTipText();
  }


// Save object to stream
void FXOldComboBox::save(FXStream& store) const {
  FXPacker::save(store);
  store << text;
  store << button;
  store << list;
  store << pane;
  }


// Load object from stream
void FXOldComboBox::load(FXStream& store){
  FXPacker::load(store);
  store >> text;
  store >> button;
  store >> list;
  store >> pane;
  }  


// Delete it
FXOldComboBox::~FXOldComboBox(){
  delete pane;
  pane=(FXPopup*)-1;
  text=(FXTextField*)-1;
  button=(FXMenuButton*)-1;
  list=(FXOldList*)-1;
  }

