""" Demonstration of the Pmw ComboBox megawidget.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import string
import Tkinter
import Pmw

colours = ('cornsilk1', 'snow1', 'seashell1', 'antiquewhite1', 'bisque1',
	'peachpuff1', 'navajowhite1', 'lemonchiffon1', 'ivory1', 'honeydew1',
	'lavenderblush1', 'mistyrose1')

class Demo:
    def __init__(self, parent):
	# Create a widget to be coloured.
	self.target = Tkinter.Label(parent, text = 'Colour me',
		relief = 'sunken', padx = 20, pady = 20)
	self.target.pack(expand = 1, fill = 'both', padx = 8, pady = 8)

	# Create and pack the ComboBox.
	self.combobox = Pmw.ComboBox(parent, label_text = 'Colour:',
	        labelpos = 'wn', selectioncommand = self.execute,
		dropdown = 0, scrolledlist_items = colours)
	self.combobox.pack(fill = 'both', expand = 1, padx = 8, pady = 8)

	# Display the first colour.
	firstColour = colours[0]
	self.combobox.selectitem(firstColour)
	self.execute(firstColour)

    def execute(self, colour):
	text = 'Colour me ' + colour
	print text
	self.target.configure(background = colour, text = text)

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Pmw ComboBox demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
